/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.localcache.api;

import com.dtyunxi.huieryun.localcache.api.ILocalCacheService;
import com.dtyunxi.huieryun.localcache.vo.LocalCacheRegistryVo;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractLocalCacheService
implements ILocalCacheService {
    protected String group;
    protected LocalCacheRegistryVo cacheRegistryVo;

    public void init(String group, LocalCacheRegistryVo cacheRegistryVo) {
        this.group = group;
        this.cacheRegistryVo = cacheRegistryVo;
    }

    @Override
    public String getDefaultGroup() {
        return this.group;
    }

    protected String combineKey(String group, String key) {
        if (StringUtils.isNotBlank((CharSequence)group)) {
            return group + ":" + key;
        }
        return key;
    }

    protected Set<String> combineKeys(String group, Set<String> keys) {
        if (StringUtils.isNotBlank((CharSequence)group)) {
            for (String key : keys) {
                key = this.combineKey(group, key);
            }
        }
        return keys;
    }

    protected Map<String, Object> convertMap(String group, Map<String, Object> dataMap) {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>(dataMap.size());
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            map.put(this.combineKey(group, entry.getKey()), entry.getValue());
        }
        return map;
    }
}

