/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log.converter;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SensitiveDataPatternLayout
extends PatternLayout {
    private static final Logger logger = LoggerFactory.getLogger(SensitiveDataPatternLayout.class);
    private Set<String> loggerNames = new LinkedHashSet<String>();
    private Set<String> sensitiveKeys = new LinkedHashSet<String>();

    public void setLoggerNamesProperty(String loggerNamesProperty) {
        if (this.loggerNames.size() == 0 && StringUtils.hasText((String)loggerNamesProperty)) {
            this.loggerNames = new LinkedHashSet<String>(Arrays.asList(loggerNamesProperty.trim().split("\\|")));
        }
    }

    public void setKeysProperty(String keysProperty) {
        if (this.sensitiveKeys.size() == 0 && StringUtils.hasText((String)keysProperty)) {
            this.sensitiveKeys = new LinkedHashSet<String>(Arrays.asList(keysProperty.trim().split("\\|")));
        }
    }

    public String doLayout(ILoggingEvent event) {
        String msg = super.doLayout(event);
        if ((this.loggerNames.size() == 0 || this.loggerNames.contains(event.getLoggerName())) && this.sensitiveKeys.size() > 0) {
            try {
                return this.invokeMsg(msg);
            }
            catch (Exception var4) {
                logger.error("\u8131\u654f\u5f02\u5e38,\u9ed8\u8ba4\u8fd4\u56de\u672a\u8131\u654f\u7684\u65e5\u5fd7\u4fe1\u606f\u3002\u5f02\u5e38\u539f\u56e0 {}", (Object)var4.getMessage());
                return msg;
            }
        }
        return msg;
    }

    public String invokeMsg(String msg) {
        StringBuilder message = new StringBuilder(msg);
        for (String key : this.sensitiveKeys) {
            int index = -1;
            do {
                if ((index = msg.indexOf(key, index + 1)) == -1) continue;
                int valueStart = this.getValueStartIndex(message, index + key.length());
                int valueEnd = this.getValueEndIndex(message, valueStart);
                String maskStr = this.desensitizeString(message.substring(valueStart, valueEnd));
                message.replace(valueStart, valueEnd, maskStr);
            } while (index != -1);
        }
        return message.toString();
    }

    protected int getValueStartIndex(StringBuilder msg, int valueStart) {
        while (valueStart < msg.length()) {
            char ch = msg.charAt(valueStart);
            ++valueStart;
            if (ch != ':' && ch != '=') continue;
            ch = msg.charAt(valueStart);
            if (ch != '\"') break;
            ++valueStart;
            break;
        }
        return valueStart;
    }

    protected int getValueEndIndex(StringBuilder msg, int valueEnd) {
        while (valueEnd != msg.length()) {
            char ch = msg.charAt(valueEnd);
            if (ch == '\"') {
                if (valueEnd + 1 == msg.length()) break;
                char nextCh = msg.charAt(valueEnd + 1);
                if (nextCh == ';' || nextCh == ',') {
                    char preCh;
                    while (valueEnd > 0 && (preCh = msg.charAt(valueEnd - 1)) == '\\') {
                        --valueEnd;
                    }
                    break;
                }
                ++valueEnd;
                continue;
            }
            if (ch == ';' || ch == ',' || ch == '}') break;
            ++valueEnd;
        }
        return valueEnd;
    }

    protected String desensitizeString(String str) {
        if (!StringUtils.hasText((String)str)) {
            return "";
        }
        int leftLength = str.length() / 3;
        int desensitizeLength = (str.length() - leftLength) / 2;
        StringBuilder sb = new StringBuilder(str.substring(0, leftLength));
        for (int i = 0; i < desensitizeLength; ++i) {
            sb.append('*');
        }
        sb.append(str.substring(leftLength + desensitizeLength));
        return sb.toString();
    }
}

