/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.api;

import com.dtyunxi.huieryun.mq.api.AbstractMQService;
import com.dtyunxi.huieryun.mq.api.IMQService;
import com.dtyunxi.huieryun.mq.constant.MessageType;
import com.dtyunxi.huieryun.mq.job.MqErrorMsgJob;
import com.dtyunxi.huieryun.mq.provider.aliyun.AliyunMQ;
import com.dtyunxi.huieryun.mq.provider.base.MqLogConfig;
import com.dtyunxi.huieryun.mq.provider.kafka.KafkaMQ;
import com.dtyunxi.huieryun.mq.provider.rabbit.RabbitMQ;
import com.dtyunxi.huieryun.mq.provider.rocket.RocketMQ;
import com.dtyunxi.huieryun.mq.util.QuartzManager;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import java.util.Properties;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQFactory {
    private static Logger logger = LoggerFactory.getLogger(MQFactory.class);

    public static IMQService createMQ(MessageRegistryVo messageRegistryVo) {
        AbstractMQService mqService = null;
        if (messageRegistryVo != null && messageRegistryVo.getType() != null) {
            String messageType = messageRegistryVo.getType().toLowerCase();
            if (messageType.equals(MessageType.ALIYUN.getName())) {
                mqService = new AliyunMQ();
            } else if (messageType.equals(MessageType.RABBIT.getName())) {
                mqService = new RabbitMQ();
            } else if (messageType.equals(MessageType.KAFKA.getName())) {
                mqService = new KafkaMQ();
            } else if (messageType.equals(MessageType.ROCKET.getName())) {
                mqService = new RocketMQ();
            }
        }
        if (mqService == null) {
            logger.error("\u672a\u6307\u5b9aMQService\u7c7b\u578b");
            throw new IllegalArgumentException("\u672a\u6307\u5b9aMQService\u7c7b\u578b");
        }
        mqService.init(messageRegistryVo);
        if (messageRegistryVo.isJobWork()) {
            MQFactory.addJob(messageRegistryVo.getCronTime());
        }
        MQFactory.addBean(mqService);
        return mqService;
    }

    private static void addBean(AbstractMQService mqService) {
        MqLogConfig.getInstance().addBean("mqService", mqService);
        MqLogConfig.getInstance().addBean("producer", mqService.createProducer());
    }

    private static void addJob(String cronTime) {
        try {
            String jobName = "huieryun_mq_error_message_job";
            Properties props = new Properties();
            props.setProperty("org.quartz.scheduler.instanceName", "MqScheduler");
            props.setProperty("org.quartz.threadPool.threadCount", "5");
            props.setProperty("org.quartz.jobStore.class", RAMJobStore.class.getName());
            StdSchedulerFactory schedFact = new StdSchedulerFactory(props);
            Scheduler sched = schedFact.getScheduler();
            QuartzManager.addJob(sched, jobName, MqErrorMsgJob.class, cronTime);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u65f6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5cronTime\u53c2\u6570\u7684\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\uff1a", (Throwable)e);
        }
    }
}

