/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.das;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEoUtil;
import com.dtyunxi.huieryun.ds.IdGenrator;
import com.dtyunxi.huieryun.mq.eo.MqLogEo;
import com.dtyunxi.huieryun.mq.provider.base.MqLogConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;

@Service(value="mqLogDas")
public class MqLogDas {
    private static final String sqlInsert = "INSERT INTO cmpt_mq_log(id,mq_topic,mq_queue,mq_routing_key,mq_message,mq_send_type,fail_reason,class_name,remark,tenant_id,create_person,update_person,create_time,update_time) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())";
    private static final Logger logger = LoggerFactory.getLogger(MqLogDas.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(MqLogEo mqLogEo) {
        DataSource dataSource = (DataSource)MqLogConfig.getInstance().getBean("dataSource");
        Connection conn = null;
        try {
            if (null != dataSource) {
                conn = dataSource.getConnection();
                PreparedStatement pStatement = conn.prepareStatement(sqlInsert);
                this.setParameters(pStatement, mqLogEo);
                pStatement.execute();
                pStatement.close();
            }
        }
        catch (Exception e) {
            logger.error("MqLogDas::insert", (Throwable)e);
        }
        finally {
            this.closeConnection(conn, dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByIds(List<Long> ids) {
        Connection conn = null;
        DataSource dataSource = (DataSource)MqLogConfig.getInstance().getBean("dataSource");
        try {
            if (null != dataSource) {
                conn = dataSource.getConnection();
                Statement statement = conn.createStatement();
                String updateSql = "update cmpt_mq_log set mq_send_status =1,send_time=NOW() where dr=0 and id in (" + StringUtils.join(ids, (String)",") + ")";
                statement.executeUpdate(updateSql);
            }
        }
        catch (Exception e) {
            logger.error("MqLogDas::queryMqLog", (Throwable)e);
        }
        finally {
            this.closeConnection(conn, dataSource);
        }
    }

    private void setParameters(PreparedStatement pStatement, MqLogEo mqLogEo) throws Exception {
        pStatement.setLong(1, MqLogDas.getId());
        pStatement.setString(2, mqLogEo.getMqTopic());
        pStatement.setString(3, mqLogEo.getMqQueue());
        pStatement.setString(4, mqLogEo.getMqRoutingKey());
        pStatement.setString(5, mqLogEo.getMqMessage());
        pStatement.setInt(6, mqLogEo.getMqSendType());
        pStatement.setString(7, mqLogEo.getFailReason());
        pStatement.setString(8, mqLogEo.getClassName());
        pStatement.setString(9, mqLogEo.getRemark());
        pStatement.setLong(10, 1L);
        pStatement.setString(11, "system");
        pStatement.setString(12, "system");
    }

    private void closeConnection(Connection conn, DataSource dataSource) {
        if (conn != null) {
            try {
                DataSourceUtils.doCloseConnection((Connection)conn, (DataSource)dataSource);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Long getId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantId();
        Long workerId = BaseEoUtil.getWorkerId();
        return IdGenrator.nextId((long)workerId, (long)tenantCode);
    }
}

