/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.job;

import com.dtyunxi.huieryun.mq.api.MQConstants;
import com.dtyunxi.huieryun.mq.apiimpl.MqLogQueryApiImpl;
import com.dtyunxi.huieryun.mq.dao.MqLogQueryDto;
import com.dtyunxi.huieryun.mq.das.MqLogQueryDas;
import com.dtyunxi.huieryun.mq.eo.MqLogEo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqErrorMsgJob
extends MqLogQueryApiImpl
implements Job {
    private static Logger logger = LoggerFactory.getLogger(MqErrorMsgJob.class);

    public void execute(JobExecutionContext jobContext) throws JobExecutionException {
        logger.info("==========\u5f00\u59cb\u6267\u884c\u53d1\u9001\u5931\u8d25\u6d88\u606f\u4efb\u52a1==========");
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        try {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    MqErrorMsgJob.this.sendErrorMsg();
                }
            });
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25,log:{}", (Object)e.getMessage());
        }
        logger.info("==========\u7ed3\u675f\u6267\u884c\u53d1\u9001\u5931\u8d25\u6d88\u606f\u4efb\u52a1==========");
    }

    private void sendErrorMsg() {
        MqLogQueryDas mqLogQueryDas = this.getMqLogQueryDas();
        if (mqLogQueryDas != null) {
            MqLogQueryDto queryDto = new MqLogQueryDto();
            queryDto.setMqSendStatus(MQConstants.MQ_SEDN_STATUS_NO);
            List<MqLogEo> list = mqLogQueryDas.queryMqLog(queryDto);
            List<Long> ids = this.getIds(list);
            this.sendMessage(ids, list);
        }
    }

    private List<Long> getIds(List<MqLogEo> list) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (MqLogEo mqLogEo : list) {
                ids.add(mqLogEo.getId());
            }
        }
        return ids;
    }
}

