/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rabbit;

import com.dtyunxi.huieryun.mq.api.AbstractProducer;
import com.dtyunxi.huieryun.mq.api.MQConstants;
import com.dtyunxi.huieryun.mq.api.SendCallback;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.MessageManager;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.MessageManagerWithTopics;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.RabbitMqManager;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.rabbitmq.client.Channel;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public class RabbitProducer
extends AbstractProducer
implements Serializable {
    private static final long serialVersionUID = -2461014988862137750L;
    private static final RabbitProducer single = new RabbitProducer();
    private static Logger logger = LoggerFactory.getLogger(RabbitProducer.class);
    private RabbitMqManager rabbitMqManager;
    private Channel channel;

    private RabbitProducer() {
    }

    public static RabbitProducer getInstance() {
        return single;
    }

    public void createProducer(MessageRegistryVo messageRegistryVo) {
        logger.info("before createProducer , messageRegistryVo={}", (Object)messageRegistryVo);
        this.rabbitMqManager = super.connectRabbitMqManager(messageRegistryVo);
        this.messageRegistryVo = messageRegistryVo;
        this.channel = this.rabbitMqManager.createChannel();
        logger.info("after createProducer , RabbitProducer={}", (Object)this);
    }

    @Override
    public MessageResponse sendSingleMessage(String topicName, String queueName, Object message, long delayTime) {
        MessageManager messageManager = null;
        try {
            messageManager = this.createMessageManager();
            if (null == this.channel || !this.channel.isOpen()) {
                this.channel = this.rabbitMqManager.createChannel();
            }
            messageManager.exchangeDeclare(topicName);
            String result = messageManager.sendMessage(queueName, topicName, delayTime, message);
            return new MessageResponse(result);
        }
        catch (Exception e) {
            this.saveMqLog(topicName, queueName, queueName, message, MQConstants.MQ_SEDN_TYPE_SINGLE, e.getMessage(), message.getClass().getName(), "sendSingleMessage");
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0cmessageManager{} topicName\uff1a{} queryName:{} message{} delayTime={}", new Object[]{messageManager, topicName, queueName, message, delayTime, e});
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
    }

    @Override
    @Async
    public MessageResponse sendAsyncSingleMessage(String topic, String queueName, Object message, long delayTime, SendCallback callback) {
        return this.sendSingleMessage(topic, queueName, message, delayTime);
    }

    @Override
    public MessageResponse sendMessage(String topicName, String routingKey, Object message, long delayTime) {
        MessageManagerWithTopics messageManagerWithTopics = null;
        try {
            messageManagerWithTopics = this.createMessageManagerWithTopics();
            if (null == this.channel || !this.channel.isOpen()) {
                this.channel = this.rabbitMqManager.createChannel();
            }
            messageManagerWithTopics.exchangeDeclare(topicName);
            messageManagerWithTopics.declareMessageDelayQueue(routingKey, topicName, delayTime);
            String result = messageManagerWithTopics.sendTopicMessage(routingKey, topicName, delayTime, message);
            return new MessageResponse(result);
        }
        catch (Exception e) {
            this.saveMqLog(topicName, null, routingKey, message, MQConstants.MQ_SEDN_TYPE_PUB, e.getMessage(), message.getClass().getName(), "sendMessage");
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0cmessageManager{} topicName\uff1a{} routingKey:{} message{} delayTime={}", new Object[]{messageManagerWithTopics, topicName, routingKey, message, delayTime, e});
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
    }

    @Override
    public MessageResponse sendAsyncMessage(String routingKey, Object message, SendCallback callback) {
        String topicName = this.getTopicName();
        return this.sendAsyncMessage(topicName, routingKey, message, 0L, callback);
    }

    @Override
    public MessageResponse sendAsyncMessage(String routingKey, Object message, long delayTime, SendCallback callback) {
        String topicName = this.getTopicName();
        return this.sendAsyncMessage(topicName, routingKey, message, delayTime, callback);
    }

    @Override
    public MessageResponse sendAsyncMessage(final String topicName, String routingKey, Object message, long delayTime, final SendCallback callback) {
        try {
            MessageManagerWithTopics messageManagerWithTopics = this.createMessageManagerWithTopics();
            messageManagerWithTopics.sendAsyncMessage(routingKey, topicName, delayTime, message, new SendCallback(){

                @Override
                public void onSuccess(String messageId) {
                    logger.info("\u53d1\u9001\u6d88\u606f\u6210\u529f! Topic is {}, msgId is: {}", (Object)topicName, (Object)messageId);
                    callback.onSuccess(messageId);
                }

                @Override
                public void onException(Exception e, String messageId) {
                    logger.error("\u6d88\u8d39\u53d1\u9001\u5931\u8d25! Topic is {}, msgId is: {}", (Object)topicName, (Object)messageId);
                    callback.onException(e, messageId);
                }
            });
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{topicName, routingKey, e});
            throw new BusinessRuntimeException(10001, (Throwable)e);
        }
    }

    public String toString() {
        return "RabbitProducer [" + (this.executor != null ? "executor=" + this.executor + ", " : "") + (this.messageRegistryVo != null ? "messageRegistryVo=" + this.messageRegistryVo + ", " : "") + "durable=" + this.durable + ", prefetchCount=" + this.prefetchCount + ", autoAck=" + this.autoAck + "]";
    }

    private MessageManager createMessageManager() {
        MessageManager messageManager = new MessageManager();
        messageManager.setMessageRegistryVo(this.messageRegistryVo);
        messageManager.setChannel(this.channel);
        return messageManager;
    }

    private MessageManagerWithTopics createMessageManagerWithTopics() {
        MessageManagerWithTopics messageManagerWithTopics = new MessageManagerWithTopics();
        messageManagerWithTopics.setMessageRegistryVo(this.messageRegistryVo);
        messageManagerWithTopics.setChannel(this.channel);
        return messageManagerWithTopics;
    }
}

