/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.autoconfigure;

import com.dtyunxi.huieryun.mq.api.IConsumer;
import com.dtyunxi.huieryun.mq.api.IMQService;
import com.dtyunxi.huieryun.mq.api.IProducer;
import com.dtyunxi.huieryun.mq.api.MQFactory;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.util.SpringBeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;

public class MQAutoConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MQAutoConfiguration.class);

    @Bean
    @Primary
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="dtyunxi.cube.mq.registryvo")
    public MessageRegistryVo messageProperties() {
        return new MessageRegistryVo();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringBeanUtil springBeanUtil() {
        return new SpringBeanUtil();
    }

    @Bean(name={"mqService"})
    @ConditionalOnMissingBean
    public IMQService mqService(MessageRegistryVo messageProperties) {
        return MQFactory.createMQ(messageProperties);
    }

    @Bean
    @ConditionalOnBean(value={IMQService.class})
    @ConditionalOnMissingBean
    @DependsOn(value={"springBeanUtil"})
    @ConditionalOnProperty(name={"huieryun.service.mq.producer.enabled"}, havingValue="true", matchIfMissing=true)
    public IProducer mqProducer(IMQService mqService) {
        return mqService.createProducer();
    }

    @Bean
    @ConditionalOnBean(value={IMQService.class})
    @ConditionalOnMissingBean
    @DependsOn(value={"springBeanUtil"})
    @ConditionalOnProperty(name={"huieryun.service.mq.consumer.enabled"}, havingValue="true", matchIfMissing=true)
    public IConsumer mqConsumer(IMQService mqService) {
        return mqService.createConsumer();
    }

    public void afterPropertiesSet() throws Exception {
        log.info("MQAutoConfiguration \u88c5\u8f7d\u5b8c\u6bd5\uff01");
    }
}

