/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider;

import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;

public class LocalFileStorage
extends AbstractObjectStorageService {
    @Override
    public void init(OssRegistryVo ossRegistryVo) {
        this.ossRegistryVo = ossRegistryVo;
    }

    private String combineKey(String group, String key) {
        return group + "/" + key;
    }

    private File getFilePath(String fileName) {
        if (this.ossRegistryVo.getEndpoint() == null) {
            throw new IllegalArgumentException("No endpoint");
        }
        File fileDir = new File(this.ossRegistryVo.getEndpoint());
        if (!fileDir.exists()) {
            throw new IllegalArgumentException("Dir does not exist: " + fileDir);
        }
        return new File(fileDir, fileName);
    }

    @Override
    public String put(String group, String key, InputStream inputstream) {
        File file = this.getFilePath(this.combineKey(group, key));
        File fileParent = file.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        try {
            Files.copy(inputstream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public void delete(String group, String key) {
        File file = this.getFilePath(this.combineKey(group, key));
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public boolean exists(String group, String key) {
        File file = this.getFilePath(this.combineKey(group, key));
        return file.exists();
    }

    @Override
    public Map<String, String> creatPoliy() {
        return null;
    }

    @Override
    public OutputStream get(String filename) {
        return null;
    }

    @Override
    public String put(String group, String key, String fileUrl) {
        return null;
    }

    @Override
    public Map<String, String> createGetFileSignerHeader(String fileURI) {
        return null;
    }

    @Override
    public String getFileUrlWithQureyParamter(String fileURI, int expiresIn) {
        return null;
    }
}

