/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.enums.ObjectStorageType;
import com.dtyunxi.huieryun.oss.provider.amazonaws.util.HttpUtils;
import com.dtyunxi.huieryun.oss.provider.domain.TempSignCreateParam;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.util.JacksonUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunObjectStorage
extends AbstractObjectStorageService {
    private static final Logger logger = LoggerFactory.getLogger(AliyunObjectStorage.class);
    private OSS ossClient = null;
    private final String policy = "{\"Statement\": [{\"Action\": [\"oss:GetObject\",\"oss:PutObject\",\"oss:DeleteObject\",\"oss:ListParts\",\"oss:AbortMultipartUpload\",\"oss:ListObjects\" ],\"Effect\": \"Allow\",\"Resource\": [\"acs:oss:*:*:{{bucketName}}/*\", \"acs:oss:*:*:{{bucketName}}\"]}],\"Version\": \"1\"}";

    @Deprecated
    public OSSClient getOSSClient() {
        return (OSSClient)this.ossClient;
    }

    public OSS getOssClient() {
        return this.ossClient;
    }

    @Override
    public void init(OssRegistryVo ossRegistryVo) {
        this.ossRegistryVo = ossRegistryVo;
        String endpoint = ossRegistryVo.getEndpoint();
        if (StringUtils.isNotEmpty((CharSequence)ossRegistryVo.getBucketName())) {
            endpoint = endpoint.replaceAll(ossRegistryVo.getBucketName() + ".", "");
        }
        this.ossClient = new OSSClientBuilder().build(endpoint, ossRegistryVo.getAccessKeyId(), ossRegistryVo.getAccessKeySecret());
    }

    @Override
    public String put(String group, String key, byte[] bytes) {
        ByteArrayInputStream inputstream = new ByteArrayInputStream(bytes);
        return this.put(group, key, inputstream);
    }

    @Override
    public String put(String group, String key, InputStream inputstream) {
        PutObjectResult result = this.ossClient.putObject(group, key, inputstream);
        return result.getETag();
    }

    @Override
    public void delete(String group, String key) {
        this.ossClient.deleteObject(group, key);
    }

    @Override
    public boolean exists(String group, String key) {
        Boolean existsBool = this.ossClient.doesObjectExist(group, key);
        return existsBool;
    }

    @Override
    public OutputStream get(String key) {
        OutputStream outputStream = null;
        outputStream = key.indexOf("aliyuncs.com") != -1 ? this.getOutputStreamByUrl(key) : this.getOutputStreamByKey(key);
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream getOutputStreamByUrl(String fileUrl) {
        ByteArrayOutputStream outputStream = null;
        HttpURLConnection connection = null;
        try {
            URL endpointUrl = new URL(fileUrl);
            connection = HttpUtils.createHttpConnection(endpointUrl, "GET", null);
            InputStream is = connection.getInputStream();
            outputStream = this.getByteArrayOutputStream(is);
        }
        catch (Exception e) {
            logger.error("error getOutputStreamByUrl : ", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream getByteArrayOutputStream(InputStream is) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int lenght = 0;
        try {
            while ((lenght = is.read(buffer)) != -1) {
                out.write(buffer, 0, lenght);
            }
            out.flush();
        }
        catch (IOException e) {
            logger.error("Unable to read filename: ", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.warn("Unable to close InputStream :", (Throwable)e);
            }
        }
        return out;
    }

    private OutputStream getOutputStreamByKey(String key) {
        OSSObject ossObject = this.ossClient.getObject(new GetObjectRequest(this.ossRegistryVo.getBucketName(), key));
        return this.getOutputStreamByKey(ossObject);
    }

    private OutputStream getOutputStreamByKey(OSSObject ossObject) {
        ByteArrayOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = ossObject.getObjectContent().read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            LogUtils.logException((String)"Cannot read object content stream: ", (Object)ex);
            throw new com.aliyun.oss.ClientException(OSSUtils.OSS_RESOURCE_MANAGER.getString("CannotReadContentStream"), (Throwable)ex);
        }
        finally {
            IOUtils.safeClose((OutputStream)outputStream);
            IOUtils.safeClose((InputStream)ossObject.getObjectContent());
        }
        return outputStream;
    }

    private OutputStream getOutputStreamByKey(String key, String bucketName) {
        if (StringUtils.isEmpty((CharSequence)bucketName)) {
            bucketName = this.ossRegistryVo.getBucketName();
        }
        OSSObject ossObject = this.ossClient.getObject(new GetObjectRequest(bucketName, key));
        return this.getOutputStreamByKey(ossObject);
    }

    @Override
    public String put(String group, String key, String fileUrl) {
        PutObjectResult result = this.ossClient.putObject(group, key, new File(fileUrl));
        return result.getETag();
    }

    @Override
    public Map<String, String> createGetFileSignerHeader(String fileURI) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff01");
    }

    @Override
    public String getFileUrlWithQureyParamter(String fileURI, int expiresIn) {
        Date expiration = new Date(System.currentTimeMillis() + (long)(expiresIn * 3600));
        URL url = this.ossClient.generatePresignedUrl(this.ossRegistryVo.getBucketName(), fileURI, (java.util.Date)expiration);
        return url.toString();
    }

    @Override
    public Map<String, String> creatPoliy(OssRegistryVo ossRegistryVo, String fileType) {
        String dir = ossRegistryVo.getDir();
        OSS client = new OSSClientBuilder().build(ossRegistryVo.getEndpoint(), ossRegistryVo.getAccessKeyId(), ossRegistryVo.getAccessKeySecret());
        DateTime expireTime = DateTime.now().plusHours(ossRegistryVo.getExpireHour());
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
        try {
            String postPolicy = client.generatePostPolicy(expireTime.toDate(), policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = client.calculatePostSignature(postPolicy);
            LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessid", ossRegistryVo.getAccessKeyId());
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("dir", dir);
            respMap.put("host", ossRegistryVo.getEndpoint());
            respMap.put("expire", String.valueOf(expireTime.getMillis() / 1000L));
            respMap.put("cdnHost", ossRegistryVo.getCdnHost());
            respMap.put("extProperty", ossRegistryVo.getExtProperty() == null ? "" : JacksonUtil.toJson((Object)ossRegistryVo.getExtProperty()));
            LinkedHashMap<String, String> linkedHashMap = respMap;
            return linkedHashMap;
        }
        catch (com.aliyun.oss.ClientException | UnsupportedEncodingException e) {
            logger.error("Compute Signature Failure:", e);
            throw new RuntimeException("Compute Signature Failure:", e);
        }
        finally {
            client.shutdown();
        }
    }

    @Override
    public Map<String, String> createSts(OssRegistryVo registryVo, TempSignCreateParam tempSignCreateParam) {
        AssumeRoleResponse response;
        String roleArn;
        long durationSecond = tempSignCreateParam.getDurationSecond();
        if (durationSecond <= 0L) {
            durationSecond = 60L;
        }
        DefaultProfile.addEndpoint((String)"", (String)"Sts", (String)"sts.aliyuncs.com");
        DefaultProfile profile = DefaultProfile.getProfile((String)"", (String)registryVo.getSubAccessKeyId(), (String)registryVo.getSubAccessKeySecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysProtocol(ProtocolType.HTTPS);
        String string = roleArn = registryVo != null ? registryVo.getRoleArn() : null;
        if (ObjectStorageType.ALIYUNOSS.name().equals(registryVo.getOssType()) && StringUtils.isBlank((CharSequence)roleArn)) {
            logger.error("\u65e0\u6cd5\u8bfb\u53d6stst \u6240\u9700\u7684\u89d2\u8272\u4fe1\u606f roleArn. \u8bf7\u786e\u4fdd\u914d\u7f6e\u5df2\u7ecf\u914d\u7f6e\u4e86\u8be5\u5185\u5bb9.");
        }
        request.setRoleArn(roleArn);
        request.setRoleSessionName("external-username");
        request.setPolicy("{\"Statement\": [{\"Action\": [\"oss:GetObject\",\"oss:PutObject\",\"oss:DeleteObject\",\"oss:ListParts\",\"oss:AbortMultipartUpload\",\"oss:ListObjects\" ],\"Effect\": \"Allow\",\"Resource\": [\"acs:oss:*:*:{{bucketName}}/*\", \"acs:oss:*:*:{{bucketName}}\"]}],\"Version\": \"1\"}".replace("{{bucketName}}", registryVo.getBucketName()));
        request.setDurationSeconds(Long.valueOf(durationSecond));
        try {
            response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
        }
        catch (ClientException e) {
            logger.error("\u6388\u6743\u9519\u8bef,{} ", (Object)e.getMessage(), (Object)e);
            return null;
        }
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
        respMap.put("accessKeyId", response.getCredentials().getAccessKeyId());
        respMap.put("accessKeySecret", response.getCredentials().getAccessKeySecret());
        respMap.put("securityToken", response.getCredentials().getSecurityToken());
        respMap.put("ossFile", registryVo.getDir());
        respMap.put("host", registryVo.getEndpoint());
        respMap.put("endPoint", registryVo.getEndpoint());
        respMap.put("bucketName", registryVo.getBucketName());
        respMap.put("cdnHost", registryVo.getCdnHost());
        respMap.put("extProperty", registryVo.getExtProperty() == null ? "" : JacksonUtil.toJson((Object)registryVo.getExtProperty()));
        return respMap;
    }

    @Override
    public OutputStream get(String key, String bucketName) {
        OutputStream outputStream = null;
        outputStream = key.indexOf("aliyuncs.com") != -1 ? this.getOutputStreamByUrl(key) : this.getOutputStreamByKey(key, bucketName);
        return outputStream;
    }
}

