/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.internal.OSSUtils;
import com.dtyunxi.huieryun.oss.api.AbstractObjectStorageService;
import com.dtyunxi.huieryun.oss.provider.amazonaws.util.HttpUtils;
import com.dtyunxi.huieryun.oss.provider.domain.HuaweiStsResponse;
import com.dtyunxi.huieryun.oss.provider.domain.TempSignCreateParam;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PostSignatureRequest;
import com.obs.services.model.PostSignatureResponse;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiObjectStorage
extends AbstractObjectStorageService {
    private static final Logger logger = LoggerFactory.getLogger(HuaweiObjectStorage.class);
    private ObsClient obsClient;
    private static String STS_URL = "https://iam.myhuaweicloud.com/v3.0/OS-CREDENTIAL/securitytokens/v3.0/OS-CREDENTIAL/securitytokens";
    private static String STS_REQ = "{\n    \"auth\": {\n        \"identity\": {\n            \"methods\": [\n                \"token\"\n            ],\n            \"token\": {\n                \"id\": \"{{token}}\",\n                \"duration-seconds\": {{duration}}\n            }\n        }\n    }\n}";

    @Override
    public String put(String group, String key, byte[] bytes) {
        return this.put(group, key, new ByteArrayInputStream(bytes));
    }

    @Override
    public String put(String group, String key, InputStream inputstream) {
        if (StringUtils.isBlank((CharSequence)group)) {
            group = this.ossRegistryVo.getBucketName();
        }
        PutObjectResult result = this.obsClient.putObject(group, key, inputstream);
        return result.getEtag();
    }

    @Override
    public String put(String group, String key, String fileUrl) {
        try {
            InputStream inputStream = new URL(fileUrl).openStream();
            return this.put(group, key, inputStream);
        }
        catch (IOException e) {
            logger.error("Unable to read filename: ", (Throwable)e);
            throw new RuntimeException("Unable to read filename: " + e.getMessage());
        }
    }

    @Override
    public void delete(String group, String key) {
        if (StringUtils.isBlank((CharSequence)group)) {
            group = this.ossRegistryVo.getBucketName();
        }
        this.obsClient.deleteObject(group, key);
    }

    @Override
    public boolean exists(String group, String key) {
        if (StringUtils.isBlank((CharSequence)group)) {
            group = this.ossRegistryVo.getBucketName();
        }
        return this.obsClient.doesObjectExist(group, key);
    }

    @Override
    public OutputStream get(String fileURI) {
        OutputStream outputStream = null;
        outputStream = fileURI.indexOf("huaweicloud.com") != -1 ? this.getOutputStreamByUrl(fileURI) : this.get(fileURI, this.ossRegistryVo.getBucketName());
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream getOutputStreamByUrl(String fileUrl) {
        ByteArrayOutputStream outputStream = null;
        HttpURLConnection connection = null;
        try {
            URL endpointUrl = new URL(fileUrl);
            connection = HttpUtils.createHttpConnection(endpointUrl, "GET", null);
            InputStream is = connection.getInputStream();
            outputStream = this.getByteArrayOutputStream(is);
        }
        catch (Exception e) {
            logger.error("error getOutputStreamByUrl : ", (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayOutputStream getByteArrayOutputStream(InputStream is) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int lenght = 0;
        try {
            while ((lenght = is.read(buffer)) != -1) {
                out.write(buffer, 0, lenght);
            }
            out.flush();
        }
        catch (IOException e) {
            logger.error("Unable to read filename: ", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.warn("Unable to close InputStream :", (Throwable)e);
            }
        }
        return out;
    }

    @Override
    public Map<String, String> createGetFileSignerHeader(String fileURI) {
        TemporarySignatureRequest req = new TemporarySignatureRequest(HttpMethodEnum.GET, (long)(this.ossRegistryVo.getExpireHour() * 3600));
        req.setBucketName(this.ossRegistryVo.getBucketName());
        req.setObjectKey(fileURI);
        TemporarySignatureResponse res = this.obsClient.createTemporarySignature(req);
        return res.getActualSignedRequestHeaders();
    }

    @Override
    public String getFileUrlWithQureyParamter(String fileURI, int expiresIn) {
        TemporarySignatureRequest req = new TemporarySignatureRequest(HttpMethodEnum.GET, (long)(expiresIn * 3600));
        req.setBucketName(this.ossRegistryVo.getBucketName());
        req.setObjectKey(fileURI);
        TemporarySignatureResponse res = this.obsClient.createTemporarySignature(req);
        return res.getSignedUrl();
    }

    @Override
    public OutputStream get(String key, String bucketName) {
        ObsObject obsObject = this.obsClient.getObject(bucketName, key);
        return this.getOutputStreamByKey(obsObject);
    }

    private OutputStream getOutputStreamByKey(ObsObject ossObject) {
        ByteArrayOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = ossObject.getObjectContent().read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            logger.error("Cannot read object content stream: ", (Throwable)ex);
            throw new RuntimeException(OSSUtils.OSS_RESOURCE_MANAGER.getString("CannotReadContentStream"), ex);
        }
        finally {
            IOUtils.safeClose((OutputStream)outputStream);
            IOUtils.safeClose((InputStream)ossObject.getObjectContent());
        }
        return outputStream;
    }

    @Override
    public Map<String, String> creatPoliy(OssRegistryVo ossRegistryVo, String fileType) {
        ObsClient obsClient = new ObsClient(ossRegistryVo.getAccessKeyId(), ossRegistryVo.getAccessKeySecret(), ossRegistryVo.getEndpoint());
        PostSignatureRequest request = new PostSignatureRequest();
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("x-obs-acl", ossRegistryVo.getAcl());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileType})) {
            formParams.put("content-type", fileType);
        }
        request.setFormParams(formParams);
        request.setExpires((long)(ossRegistryVo.getExpireHour() * 3600));
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
        String formAction = "https://" + ossRegistryVo.getBucketName() + "." + ossRegistryVo.getEndpoint();
        respMap.put("form-action", formAction);
        try {
            PostSignatureResponse response = obsClient.createPostSignature(request);
            respMap.put("x-obs-acl", "public-read");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileType})) {
                respMap.put("content-type", fileType);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ossRegistryVo.getDir()})) {
                respMap.put("key", ossRegistryVo.getDir());
            }
            respMap.put("policy", response.getPolicy());
            respMap.put("AccessKeyId", ossRegistryVo.getAccessKeyId());
            respMap.put("signature", response.getSignature());
        }
        catch (ObsException e1) {
            logger.error("Compute Signature Failure:", (Throwable)e1);
            throw new RuntimeException("Compute Signature Failure:", e1);
        }
        finally {
            try {
                obsClient.close();
            }
            catch (IOException e) {
                logger.info("", (Throwable)e);
            }
        }
        return respMap;
    }

    @Override
    public void init(OssRegistryVo ossRegistryVo) {
        this.ossRegistryVo = ossRegistryVo;
        this.obsClient = new ObsClient(ossRegistryVo.getAccessKeyId(), ossRegistryVo.getAccessKeySecret(), ossRegistryVo.getEndpoint());
    }

    @Override
    public Map<String, String> createSts(OssRegistryVo registryVo, TempSignCreateParam tempSignCreateParam) {
        Long durationSecond = tempSignCreateParam == null || tempSignCreateParam.getDurationSecond() <= 0L ? Long.valueOf(60L) : Long.valueOf(tempSignCreateParam.getDurationSecond());
        String srcToken = tempSignCreateParam.getToken();
        if (StringUtils.isBlank((CharSequence)srcToken)) {
            throw new RuntimeException("tempSignCreateParam.token could not be blank");
        }
        String reqBody = STS_REQ.replace("{{token}}", srcToken).replace("{{duration}}", durationSecond.toString());
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(STS_URL);
        StringEntity entity = null;
        try {
            entity = new StringEntity(reqBody);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (response != null && response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 200) {
            HttpEntity respEntity = response.getEntity();
            if (respEntity != null) {
                try {
                    String responseBody = EntityUtils.toString((HttpEntity)entity);
                    HuaweiStsResponse parse = (HuaweiStsResponse)JSON.parseObject((String)responseBody, HuaweiStsResponse.class);
                    return parse.getCredential();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            throw new RuntimeException("http req fail, url=" + STS_URL);
        }
        try {
            client.close();
        }
        catch (IOException e) {
            logger.info("", (Throwable)e);
        }
        return null;
    }
}

