/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.oss.provider.amazonaws.auth;

import com.dtyunxi.huieryun.oss.provider.amazonaws.auth.AWS4SignerBase;
import com.dtyunxi.huieryun.oss.provider.amazonaws.util.BinaryUtils;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Base64;

public class AWS4SignerForPolicy
extends AWS4SignerBase {
    private static final String X_AMZ_ALGORITHM = "AWS4-HMAC-SHA256";
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String WHITE_SPACE = "";
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String UTF_8 = "UTF-8";
    private static final String BACKSLASH = "/";
    private static final SimpleDateFormat SF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder();
    private static final String POLICY_DOCUMENT_TEMPLET = "{ \"expiration\": \"%s\",\n  \"conditions\": [\n    {\"bucket\": \"%s\"},\n    [\"starts-with\", \"$key\", \"%s\"],\n    {\"acl\": \"%s\"},\n\n    {\"x-amz-credential\": \"%s\"},\n    {\"x-amz-algorithm\": \"%s\"},\n    {\"x-amz-date\": \"%s\"}\n  ]\n}";

    public AWS4SignerForPolicy(String serviceName, String regionName) {
        super(null, null, serviceName, regionName);
    }

    public String getXAmzCredential(long currentTime, String awsAccessKey) {
        return awsAccessKey + BACKSLASH + this.dateStampFormat.format(currentTime) + BACKSLASH + this.regionName + BACKSLASH + this.serviceName + BACKSLASH + "aws4_request";
    }

    public String getPolicy(String bucketName, String dir, String acl, String xAmzCredential, long currentTime) {
        String policyDocument = String.format(POLICY_DOCUMENT_TEMPLET, SF.format(currentTime), bucketName, dir, acl, xAmzCredential, X_AMZ_ALGORITHM, this.dateTimeFormat.format(currentTime));
        try {
            String policy = BASE64_ENCODER.encodeToString(policyDocument.getBytes(UTF_8));
            policy = policy.replaceAll(LF, WHITE_SPACE);
            policy = policy.replaceAll(CR, WHITE_SPACE);
            return policy;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String computeSignature(String awsSecretKey, String policy, long currentTime) {
        return this.computeSignature(awsSecretKey, policy, this.dateStampFormat.format(currentTime));
    }

    private String computeSignature(String awsSecretKey, String stringToSign, String currentDate) {
        byte[] kSecret = ("AWS4" + awsSecretKey).getBytes();
        byte[] kDate = AWS4SignerForPolicy.sign(currentDate, kSecret, HMAC_SHA256);
        byte[] kRegion = AWS4SignerForPolicy.sign(this.regionName, kDate, HMAC_SHA256);
        byte[] kService = AWS4SignerForPolicy.sign(this.serviceName, kRegion, HMAC_SHA256);
        byte[] kSigning = AWS4SignerForPolicy.sign("aws4_request", kService, HMAC_SHA256);
        byte[] signature = AWS4SignerForPolicy.sign(stringToSign, kSigning, HMAC_SHA256);
        return BinaryUtils.toHex(signature);
    }
}

