/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.google.common.base.Joiner;
import com.google.common.io.BaseEncoding;
import io.minio.DateFormat;
import io.minio.PostPolicy;
import io.minio.Signer;
import io.minio.errors.InvalidArgumentException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.joda.time.DateTime;

public class AwsPostPolicy
extends PostPolicy {
    private static final String ALGORITHM = "AWS4-HMAC-SHA256";
    private final String bucketName;
    private final String objectName;
    private final boolean startsWith;
    private final DateTime expirationDate;
    private String contentType;
    private int successActionStatus;
    private String contentEncoding;
    private long contentRangeStart;
    private long contentRangeEnd;
    private String acl = "public-read-write";

    public AwsPostPolicy(String bucketName, String objectName, boolean startsWith, DateTime expirationDate) throws InvalidArgumentException {
        super(bucketName, objectName, startsWith, expirationDate);
        if (bucketName == null) {
            throw new InvalidArgumentException("null bucket name");
        }
        this.bucketName = bucketName;
        if (objectName == null) {
            throw new InvalidArgumentException("null object name or prefix");
        }
        this.objectName = objectName;
        this.startsWith = startsWith;
        if (expirationDate == null) {
            throw new InvalidArgumentException("null expiration date");
        }
        this.expirationDate = expirationDate;
    }

    public AwsPostPolicy(String bucketName, String objectName, DateTime expirationDate) throws InvalidArgumentException {
        this(bucketName, objectName, false, expirationDate);
    }

    private byte[] marshalJson(ArrayList<String[]> conditions) {
        StringBuilder sb = new StringBuilder();
        Joiner joiner = Joiner.on((String)"\",\"");
        sb.append("{");
        if (this.expirationDate != null) {
            sb.append("\"expiration\":\"" + this.expirationDate.toString(DateFormat.EXPIRATION_DATE_FORMAT) + "\"");
        }
        if (!conditions.isEmpty()) {
            sb.append(",\"conditions\":[");
            ListIterator<String[]> iterator = conditions.listIterator();
            while (iterator.hasNext()) {
                sb.append("[\"" + joiner.join((Object[])iterator.next()) + "\"]");
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    protected Map<String, String> makeFormData(String accessKey, String secretKey, String region) throws NoSuchAlgorithmException, InvalidKeyException {
        ArrayList<String[]> conditions = new ArrayList<String[]>();
        HashMap<String, String> formData = new HashMap<String, String>();
        conditions.add(new String[]{"eq", "$bucket", this.bucketName});
        formData.put("bucket", this.bucketName);
        if (this.startsWith) {
            conditions.add(new String[]{"starts-with", "$key", this.objectName});
            formData.put("key", this.objectName);
        } else {
            conditions.add(new String[]{"eq", "$key", this.objectName});
            formData.put("key", this.objectName);
        }
        if (this.acl != null) {
            conditions.add(new String[]{"eq", "$acl", this.acl});
            formData.put("acl", this.acl);
        }
        if (this.contentType != null) {
            if (this.startsWith) {
                conditions.add(new String[]{"starts-with", "$Content-Type", this.contentType});
            } else {
                conditions.add(new String[]{"eq", "$Content-Type", this.contentType});
            }
            formData.put("Content-Type", this.contentType);
        }
        if (this.contentEncoding != null) {
            conditions.add(new String[]{"eq", "$Content-Encoding", this.contentEncoding});
            formData.put("Content-Encoding", this.contentEncoding);
        }
        if (this.successActionStatus > 0) {
            conditions.add(new String[]{"eq", "success_action_status", Integer.toString(this.successActionStatus)});
            formData.put("success_action_status", Integer.toString(this.successActionStatus));
        }
        if (this.contentRangeStart > 0L && this.contentRangeEnd > 0L) {
            conditions.add(new String[]{"content-length-range", Long.toString(this.contentRangeStart), Long.toString(this.contentRangeEnd)});
        }
        conditions.add(new String[]{"eq", "$x-amz-algorithm", ALGORITHM});
        formData.put("x-amz-algorithm", ALGORITHM);
        DateTime date = new DateTime();
        String credential = Signer.credential((String)accessKey, (DateTime)date, (String)region);
        conditions.add(new String[]{"eq", "$x-amz-credential", credential});
        formData.put("x-amz-credential", credential);
        String amzDate = date.toString(DateFormat.AMZ_DATE_FORMAT);
        conditions.add(new String[]{"eq", "$x-amz-date", amzDate});
        formData.put("x-amz-date", amzDate);
        String policybase64 = BaseEncoding.base64().encode(this.marshalJson(conditions));
        String signature = Signer.postPresignV4((String)policybase64, (String)secretKey, (DateTime)date, (String)region);
        formData.put("policy", policybase64);
        formData.put("x-amz-signature", signature);
        return formData;
    }

    public void setContentType(String contentType) throws InvalidArgumentException {
        super.setContentType(contentType);
        this.contentType = contentType;
    }

    public void setSuccessActionStatus(int successActionStatus) throws InvalidArgumentException {
        super.setSuccessActionStatus(successActionStatus);
        this.successActionStatus = successActionStatus;
    }

    public void setContentEncoding(String contentEncoding) throws InvalidArgumentException {
        super.setContentEncoding(contentEncoding);
        this.contentEncoding = contentEncoding;
    }

    public void setContentLength(long contentLength) throws InvalidArgumentException {
        super.setContentLength(contentLength);
        this.setContentRange(contentLength, contentLength);
    }

    public void setContentRange(long startRange, long endRange) throws InvalidArgumentException {
        super.setContentRange(startRange, endRange);
        this.contentRangeStart = startRange;
        this.contentRangeEnd = endRange;
    }

    public void setAcl(String acl) {
        this.acl = acl;
    }
}

