/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.lock.provider.etcd;

import com.coreos.jetcd.EtcdClient;
import com.coreos.jetcd.EtcdClientBuilder;
import com.coreos.jetcd.EtcdKV;
import com.coreos.jetcd.api.TxnResponse;
import com.coreos.jetcd.op.Cmp;
import com.coreos.jetcd.op.CmpTarget;
import com.coreos.jetcd.op.Op;
import com.coreos.jetcd.op.Txn;
import com.coreos.jetcd.options.DeleteOption;
import com.coreos.jetcd.options.GetOption;
import com.coreos.jetcd.options.PutOption;
import com.dtyunxi.huieryun.lock.api.AbstractLockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.registry.vo.LockRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdLockService
extends AbstractLockService {
    private static final Logger logger = LoggerFactory.getLogger(EtcdLockService.class);
    static final Charset STR_CHARSET = Charset.forName("UTF-8");
    private EtcdClient client;
    private EtcdKV kvClient;

    public void init(LockRegistryVo lockVo) {
        super.init(lockVo);
        try {
            this.client = EtcdClientBuilder.newBuilder().endpoints(lockVo.getEndpoints()).build();
            this.kvClient = this.client.getKVClient();
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static ByteString convert(String key) {
        return ByteString.copyFrom((String)key, (Charset)STR_CHARSET);
    }

    public Mutex lock(String tableName, Long primaryKey) {
        return this.lock(tableName, String.valueOf(primaryKey));
    }

    public Mutex lock(String tableName, String primaryKey) {
        String lockKey = Mutex.buildLockKey((String)tableName, (String)primaryKey);
        Mutex mutex = new Mutex(lockKey);
        ByteString keyByteString = EtcdLockService.convert(mutex.getLockKey());
        Cmp cmp = new Cmp(keyByteString, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.version((long)0L));
        Op.PutOp opPut = Op.put((ByteString)keyByteString, (ByteString)EtcdLockService.convert(mutex.getLockAcquirer()), (PutOption)PutOption.DEFAULT);
        Op.GetOp opFailure = Op.get((ByteString)keyByteString, (GetOption)GetOption.DEFAULT);
        Txn txn = Txn.newBuilder().If(new Cmp[]{cmp}).Then(new Op[]{opPut}).Else(new Op[]{opFailure}).build();
        ListenableFuture listenableFuture = this.kvClient.commit(txn);
        try {
            TxnResponse response = (TxnResponse)listenableFuture.get();
            logger.debug(response.toString());
            if (!response.getSucceeded()) {
                mutex = null;
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        return mutex;
    }

    public Mutex lock(String tableName, Long primaryKey, int waitTimeout) {
        throw new BusinessRuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    public Mutex lock(String tableName, String primaryKey, int waitTimeout) {
        throw new BusinessRuntimeException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    public Mutex lock(String tableName, String primaryKey, int waitTimeout, int leaseTime, TimeUnit timeUnit) {
        logger.warn("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff0ctableName={},primaryKey={},waitTimeout={},leaseTime={},timeUnit={}", new Object[]{tableName, primaryKey, waitTimeout, leaseTime, timeUnit});
        return null;
    }

    public boolean isLocked(String tableName, Long primaryKey) {
        return this.getLockAcquirer(tableName, primaryKey) != null;
    }

    public boolean isLocked(String tableName, String primaryKey) {
        return this.getLockAcquirer(tableName, primaryKey) != null;
    }

    public String getLockAcquirer(String tableName, Long primaryKey) {
        return this.getLockAcquirer(tableName, String.valueOf(primaryKey));
    }

    public String getLockAcquirer(String tableName, String primaryKey) {
        String lockKey = Mutex.buildLockKey((String)tableName, (String)primaryKey);
        Mutex mutex = new Mutex(lockKey);
        ByteString keyByteString = EtcdLockService.convert(mutex.getLockKey());
        Cmp cmp = new Cmp(keyByteString, Cmp.Op.GREATER, (CmpTarget)CmpTarget.version((long)0L));
        Op.GetOp op = Op.get((ByteString)keyByteString, (GetOption)GetOption.DEFAULT);
        Txn txn = Txn.newBuilder().If(new Cmp[]{cmp}).Then(new Op[]{op}).Else(new Op[]{op}).build();
        ListenableFuture listenableFuture = this.kvClient.commit(txn);
        try {
            TxnResponse response = (TxnResponse)listenableFuture.get();
            logger.debug(response.toString());
            if (response.getSucceeded()) {
                return this.parseLockAcquirer(response);
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public boolean unlock(Mutex mutex) {
        if (mutex == null) {
            return true;
        }
        boolean unlocked = false;
        ByteString keyByteString = EtcdLockService.convert(mutex.getLockKey());
        Cmp cmp = new Cmp(keyByteString, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.value((ByteString)EtcdLockService.convert(mutex.getLockAcquirer())));
        Op.DeleteOp opDelete = Op.delete((ByteString)keyByteString, (DeleteOption)DeleteOption.DEFAULT);
        Op.GetOp opFailure = Op.get((ByteString)keyByteString, (GetOption)GetOption.DEFAULT);
        Txn txn = Txn.newBuilder().If(new Cmp[]{cmp}).Then(new Op[]{opDelete}).Else(new Op[]{opFailure}).build();
        ListenableFuture listenableFuture = this.kvClient.commit(txn);
        try {
            TxnResponse response = (TxnResponse)listenableFuture.get();
            logger.debug(response.toString());
            if (response.getSucceeded()) {
                unlocked = true;
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage(), (Throwable)e);
        }
        return unlocked;
    }

    private String parseLockAcquirer(TxnResponse response) {
        for (int i = 0; i < response.getResponsesCount(); ++i) {
            ByteString acquirer = response.getResponses(i).getResponseRange().getKvs(0).getValue();
            if (acquirer == null) continue;
            return acquirer.toString(STR_CHARSET);
        }
        return null;
    }
}

