/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.tools;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;

public class ClazzUtils {
    public static List<Class> findAllClassesUsingClassLoader(String packageName) {
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        return reader.lines().filter(line -> line.endsWith(".class")).map(line -> ClazzUtils.getClass(line, packageName)).collect(Collectors.toList());
    }

    private static Class getClass(String className, String packageName) {
        try {
            return Class.forName(packageName + "." + className.substring(0, className.lastIndexOf(46)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

