/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.tools;

import com.dtyunxi.huieryun.xmeta.fodel.FemplateUsage;
import com.dtyunxi.huieryun.xmeta.tools.ClazzUtils;
import com.dtyunxi.huieryun.xmeta.tools.JavaParserUtils;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.Column;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.util.FileUtils;

public class ConvertBean2Yaml {
    private static String BEAN_TYPE_DTO = "dto";
    private static String BEAN_TYPE_BIZ_DTO = "bizDto";
    private static String BEAN_TYPE_EO = "eo";

    public static void main(String[] args) {
    }

    public static void batchConvertToFile(String domain, String domainRemark, DirInfo dirInfos) {
        ConvertBean2Yaml.batchConvertToFile(domain, domainRemark, dirInfos, false);
    }

    public static void batchConvertToFile(String domain, String domainRemark, DirInfo dirInfos, Boolean isOverride) {
        for (DirInfo dirInfo : dirInfos.list()) {
            ConvertBean2Yaml.batchConvertToFile(domainRemark, domainRemark, dirInfo.sourceDir, dirInfo.targetPackage, dirInfo.outputDir, isOverride);
        }
    }

    public static void batchConvertToFile(String domain, String domainRemark, String sourceDir, String targetPackage, String outputDir) {
        ConvertBean2Yaml.batchConvertToFile(domain, domainRemark, sourceDir, targetPackage, outputDir, false);
    }

    public static void batchConvertToFile(String domain, String domainRemark, String sourceDir, String targetPackage, String outputDir, Boolean isOverride) {
        List<Class> clazzs = ClazzUtils.findAllClassesUsingClassLoader(targetPackage);
        for (Class clazz : clazzs) {
            ConvertBean2Yaml.convertToFile(domain, domainRemark, sourceDir, clazz, outputDir, isOverride);
        }
    }

    public static void convertToFile(String domain, String domainRemark, String sourceDir, Class<?> clazz, String outputDir) {
        ConvertBean2Yaml.convertToFile(domain, domainRemark, sourceDir, clazz, outputDir, false);
    }

    public static void convertToFile(String domain, String domainRemark, String sourceDir, Class<?> clazz, String outputDir, Boolean isOverride) {
        try {
            String yaml = ConvertBean2Yaml.convert(domain, domainRemark, sourceDir, clazz);
            String filePath = outputDir.concat(File.separator).concat(clazz.getSimpleName()).concat(".xmeta.yaml");
            File file = new File(filePath);
            if (isOverride.booleanValue()) {
                FileUtils.fileWrite((File)file, (String)yaml);
            } else if (!FileUtils.fileExists((String)filePath)) {
                FileUtils.fileWrite((File)file, (String)yaml);
            } else {
                System.out.println("\u5df2\u5b58\u5728\u8be5\u6587\u4ef6\uff0c\u5982\u9700\u8986\u76d6\u8bf7\u5f00\u59cb\u8986\u76d6\u6a21\u5f0f\uff1a" + filePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void convertAndPrint(String domain, String domainRemark, String sourceDir, Class<?> clazz) {
        try {
            System.out.println(ConvertBean2Yaml.convert(domain, domainRemark, sourceDir, clazz));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(String domain, String domainRemark, String sourceDir, Class<?> clazz) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        String packageName = clazz.getPackage().getName();
        String javaFileName = clazz.getSimpleName();
        Table table = clazz.getAnnotation(Table.class);
        ApiModel apiModel = clazz.getAnnotation(ApiModel.class);
        String tableName = table == null ? "" : table.name();
        String className = clazz.getName();
        String inherit = ConvertBean2Yaml.getSuperClass(clazz);
        String beanType = ConvertBean2Yaml.getBeanType(apiModel, tableName);
        Map<String, String> mapComments = JavaParserUtils.getComments(sourceDir, packageName, javaFileName);
        String classComment = ConvertBean2Yaml.getClassComment(mapComments, clazz);
        List<FieldInfo> fieldInfos = ConvertBean2Yaml.getFieldInfos(mapComments, clazz, beanType);
        if (!StringUtils.isEmpty((CharSequence)classComment)) {
            classComment = apiModel.description();
        }
        TreeMap<String, Object> fltParams = new TreeMap<String, Object>();
        fltParams.put("packageName", packageName);
        fltParams.put("tableName", tableName);
        fltParams.put("beanType", beanType);
        fltParams.put("className", className);
        fltParams.put("classComment", classComment);
        fltParams.put("fieldInfos", fieldInfos);
        fltParams.put("domain", domain);
        fltParams.put("domainRemark", domainRemark);
        fltParams.put("inherit", inherit);
        StringWriter sw = new StringWriter();
        try {
            Configuration configuration = FemplateUsage.getInstance().getTemplateConfiguraion();
            configuration.setClassForTemplateLoading(ConvertBean2Yaml.class, "ftl");
            Template template = configuration.getTemplate("Bean.xmeta.yaml.ftl");
            template.process(fltParams, (Writer)sw);
        }
        finally {
            sw.flush();
            sw.close();
        }
        return sw.toString();
    }

    private static String getSuperClass(Class<?> clazz) {
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null && !"java.lang.Object".equals(superClazz.getName())) {
            return superClazz.getName();
        }
        return null;
    }

    private static String getBeanType(ApiModel apiModel, String tableName) {
        String beanType = StringUtils.isNotEmpty((CharSequence)tableName) ? BEAN_TYPE_EO : (apiModel != null ? BEAN_TYPE_DTO : BEAN_TYPE_BIZ_DTO);
        return beanType;
    }

    private static List<FieldInfo> getFieldInfos(Map<String, String> mapComments, Class<?> clazz, String beanType) {
        Field[] fields;
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            FieldInfo fieldInfo = new FieldInfo();
            String comment = mapComments.get(field.getName());
            Type genericType = field.getGenericType();
            Class<?> type = field.getType();
            ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
            Column column = field.getAnnotation(Column.class);
            fieldInfo.code = field.getName();
            ConvertBean2Yaml.setNameAndRemark(beanType, fieldInfo, comment, apiModelProperty);
            if (apiModelProperty != null) {
                fieldInfo.allowEmpty = String.valueOf(apiModelProperty.allowEmptyValue());
            }
            if (column != null) {
                fieldInfo.column = column.name();
            }
            fieldInfo.type = ConvertBean2Yaml.isBaseType(type) ? type.getSimpleName() : type.getName();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Class typeClazz = (Class)pt.getActualTypeArguments()[0];
                fieldInfo.clazz = ConvertBean2Yaml.isBaseType(typeClazz) ? typeClazz.getSimpleName() : pt.getActualTypeArguments()[0].getTypeName();
            }
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    private static void setNameAndRemark(String beanType, FieldInfo fieldInfo, String comment, ApiModelProperty apiModelProperty) {
        if (BEAN_TYPE_EO.equals(beanType)) {
            ConvertBean2Yaml.setNameAndRemark(fieldInfo, comment);
        } else if (apiModelProperty != null) {
            fieldInfo.name = apiModelProperty.value();
            fieldInfo.remark = apiModelProperty.notes();
        } else {
            ConvertBean2Yaml.setNameAndRemark(fieldInfo, comment);
        }
    }

    private static void setNameAndRemark(FieldInfo fieldInfo, String comment) {
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            int index = (comment = comment.trim()).indexOf(" ");
            if (index > -1) {
                fieldInfo.name = comment.substring(0, index);
                fieldInfo.remark = comment.substring(index, comment.length());
            } else {
                fieldInfo.name = comment;
            }
        }
    }

    private static String getClassComment(Map<String, String> mapComments, Class<?> clazz) {
        int index;
        String typeComment = mapComments.get(clazz.getCanonicalName());
        if (typeComment != null && (index = typeComment.indexOf("\n")) > 0) {
            typeComment = typeComment.substring(0, index).trim();
        }
        return typeComment;
    }

    public static boolean isBaseType(Class<?> clazz) {
        return ConvertBean2Yaml.isCommonDataType(clazz) || ConvertBean2Yaml.isWrapClass(clazz) || ConvertBean2Yaml.isCollection(clazz) || ConvertBean2Yaml.isDbCommonType(clazz);
    }

    public static boolean isCommonDataType(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public static boolean isWrapClass(Class<?> clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    public static boolean isDbCommonType(Class<?> clazz) {
        return BigDecimal.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz);
    }

    public static DirInfo dir() {
        return new DirInfo();
    }

    public static class FieldInfo {
        String name;
        String remark;
        String code;
        String type;
        String clazz;
        String allowEmpty;
        String column;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getClazz() {
            return this.clazz;
        }

        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        public String getAllowEmpty() {
            return this.allowEmpty;
        }

        public void setAllowEmpty(String allowEmpty) {
            this.allowEmpty = allowEmpty;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }
    }

    public static class DirInfo {
        String sourceDir;
        String targetPackage;
        String outputDir;
        private List<DirInfo> dirInfos = new ArrayList<DirInfo>();

        public DirInfo() {
        }

        public DirInfo(String sourceDir, String targetPackage, String outputDir) {
            this.sourceDir = sourceDir;
            this.targetPackage = targetPackage;
            this.outputDir = outputDir;
        }

        public DirInfo add(DirInfo dirInfo) {
            this.dirInfos.add(dirInfo);
            return this;
        }

        public List<DirInfo> list() {
            return this.dirInfos;
        }
    }
}

