/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.tools;

import com.dtyunxi.huieryun.xmeta.tools.ClazzUtils;
import com.dtyunxi.huieryun.xmeta.tools.JavaParserUtils;
import com.dtyunxi.huieryun.xmeta.yaml.MetaYaml;
import com.dtyunxi.huieryun.xmeta.yaml.TypeDefYaml;
import com.github.javaparser.utils.CodeGenerationUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Table;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public class ConvertEo2Yaml {
    private String sourceDir;
    private String packageName;

    private Map<String, String> getComments(String javaFileName) {
        return JavaParserUtils.getComments(this.sourceDir, this.packageName, javaFileName);
    }

    private MetaYaml parsePackage() {
        MetaYaml metaYaml = new MetaYaml();
        metaYaml.setApiVersion("0.0.1");
        metaYaml.setDomain("");
        metaYaml.setRemark("");
        metaYaml.setApiDtos(new ArrayList());
        metaYaml.setBizDtos(new ArrayList());
        ArrayList<TypeDefYaml> eos = new ArrayList<TypeDefYaml>();
        metaYaml.setEos(eos);
        List<Class> setClazz = ClazzUtils.findAllClassesUsingClassLoader(this.packageName);
        for (Class clazz : setClazz) {
            if (!clazz.isAnnotationPresent(Table.class)) continue;
            Field[] fields = clazz.getDeclaredFields();
            ArrayList attrs = new ArrayList();
            Map<String, String> mapComments = this.getComments(clazz.getSimpleName());
            if (fields != null) {
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(Column.class)) continue;
                    HashMap<String, String> mapAttr = new HashMap<String, String>();
                    Column columnA = field.getAnnotation(Column.class);
                    String columnName = columnA.name();
                    String fieldType = field.getType().getSimpleName();
                    String fieldName = field.getName();
                    String fieldComment = mapComments.get(fieldName);
                    mapAttr.put("code", fieldName);
                    if (fieldComment != null) {
                        mapAttr.put("name", fieldComment);
                    }
                    mapAttr.put("type", fieldType);
                    mapAttr.put("column", columnName);
                    attrs.add(mapAttr);
                }
            }
            if (attrs.size() <= 0) continue;
            Table tableA = clazz.getAnnotation(Table.class);
            String tableName = tableA.name();
            TypeDefYaml typeDefYaml = new TypeDefYaml();
            typeDefYaml.setClazz(clazz.getName());
            if (!clazz.getSuperclass().getCanonicalName().equals("java.lang.Object")) {
                typeDefYaml.setInherit(clazz.getSuperclass().getCanonicalName());
            } else {
                typeDefYaml.setInherit("");
            }
            typeDefYaml.setTable(tableName);
            typeDefYaml.setAttrs(attrs);
            String typeComment = mapComments.get(clazz.getCanonicalName());
            if (typeComment != null) {
                int index = typeComment.indexOf("\n");
                if (index > 0) {
                    typeComment = typeComment.substring(0, index).trim();
                }
                typeDefYaml.setRemark(typeComment);
            }
            eos.add(typeDefYaml);
        }
        return metaYaml;
    }

    public String parsePackageAsString(String sourceDir, String packageName) {
        this.sourceDir = sourceDir;
        this.packageName = packageName;
        MetaYaml metaYaml = this.parsePackage();
        Representer representer = new Representer();
        HashMap<String, Object> dumpMap = new HashMap<String, Object>();
        dumpMap.put("apiVersion", metaYaml.getApiVersion());
        dumpMap.put("domain", metaYaml.getDomain());
        dumpMap.put("remark", metaYaml.getRemark());
        dumpMap.put("eos", metaYaml.getEos());
        Yaml yaml = new Yaml(representer);
        String strMetaYaml = yaml.dumpAsMap(dumpMap);
        return strMetaYaml;
    }

    public static void main(String[] args) {
        String sourceDir = CodeGenerationUtils.mavenModuleRoot(ConvertEo2Yaml.class).resolve("src/main/java").toFile().getAbsolutePath();
        String packageName = "com.dtyunxi.yundt.bundle.base.center.item.dao.eo";
        ConvertEo2Yaml convertEo2Yaml = new ConvertEo2Yaml();
        String strYaml = convertEo2Yaml.parsePackageAsString(sourceDir, packageName);
        System.out.println(strYaml);
    }
}

