/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.xmeta.tools.db;

import com.dtyunxi.huieryun.xmeta.tools.db.Java2SqlTypeResolver;
import com.dtyunxi.huieryun.xmeta.tools.db.enums.DataBaseEnum;
import com.dtyunxi.huieryun.xmeta.tools.db.enums.Java2Db2TypeResolverEnum;
import com.dtyunxi.huieryun.xmeta.tools.db.enums.Java2MsSqlServerTypeResolverEnum;
import com.dtyunxi.huieryun.xmeta.tools.db.enums.Java2MysqlTypeResolverEnum;
import com.dtyunxi.huieryun.xmeta.tools.db.enums.Java2OracleTypeResolverEnum;
import com.dtyunxi.huieryun.xmeta.tools.db.enums.Java2OtherDbTypeResolverEnum;
import com.dtyunxi.huieryun.xmeta.tools.db.enums.Java2SybaseTypeResolverEnum;

public class JavaType2SqlTypeUtil {
    public static Java2SqlTypeResolver[] resolvers(String dataBase) {
        DataBaseEnum dataBaseEnum = DataBaseEnum.dataBase(dataBase);
        if (dataBaseEnum == null) {
            return Java2MysqlTypeResolverEnum.values();
        }
        switch (dataBaseEnum) {
            case ORACLE: {
                return Java2OracleTypeResolverEnum.values();
            }
            case SQLSERVER: {
                return Java2MsSqlServerTypeResolverEnum.values();
            }
            case SYBASE: {
                return Java2SybaseTypeResolverEnum.values();
            }
            case DB2: {
                return Java2Db2TypeResolverEnum.values();
            }
            case OTHER: {
                return Java2OtherDbTypeResolverEnum.values();
            }
        }
        return Java2MysqlTypeResolverEnum.values();
    }

    public static String sqlType(Class<?> javaType, String dataBaseType) {
        Java2SqlTypeResolver[] resolvers = JavaType2SqlTypeUtil.resolvers(dataBaseType);
        if (resolvers == null) {
            return null;
        }
        for (Java2SqlTypeResolver resolver : resolvers) {
            if (resolver.javaType() != javaType) continue;
            return resolver.sqlType();
        }
        return null;
    }

    public static Class<?> javaType(String sqlType, String dataBaseType) {
        Java2SqlTypeResolver[] resolvers = JavaType2SqlTypeUtil.resolvers(dataBaseType);
        if (resolvers == null) {
            return null;
        }
        for (Java2SqlTypeResolver resolver : resolvers) {
            if (!resolver.sqlType().equals(sqlType)) continue;
            return resolver.javaType();
        }
        return null;
    }
}

