/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.maven.plugins.CubeAbstractMojo;
import com.dtyunxi.huieryun.maven.plugins.definition.ExtensionDefinition;
import com.dtyunxi.huieryun.maven.plugins.filter.GenJavaArtifactFilter;
import com.dtyunxi.huieryun.maven.plugins.generation.GenerationResult;
import com.dtyunxi.huieryun.maven.plugins.resolve.DefinitionMapCollector;
import com.dtyunxi.huieryun.maven.plugins.util.ClassScanUtils;
import com.dtyunxi.huieryun.maven.plugins.util.Util;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.springframework.util.FileCopyUtils;

@Mojo(name="gen-extension-java", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenExtensionJavaSrcMojo
extends CubeAbstractMojo {
    private Template template;
    @Parameter(property="group.prefix")
    private List<String> groupPrefixs;
    @Parameter(property="group.pattern")
    private String groupPattern;
    @Parameter(property="inner.class.enabled", defaultValue="true")
    private boolean innerClassEnabled;
    @Parameter(property="extension.tpl.path")
    private String extensionTplPath = String.format("%sdtyunxi%stemplate", File.separator, File.separator);
    @Parameter(property="extension.tpl.name", defaultValue="ExtensionJava.ftl")
    private String extensionTplName;
    private List<String> dependencyFilePath = new ArrayList<String>();
    @Parameter(defaultValue="${project}")
    public MavenProject project;
    @Parameter(property="keepSrc4view")
    public Boolean keepSrc4view;
    @Component
    protected PluginDescriptor descriptor;

    public void writeTemplate(Template template) {
        this.template = template;
    }

    @Override
    protected void executeInner() throws IOException, DependencyResolutionRequiredException, TemplateException {
        Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        configuration.setClassForTemplateLoading(((Object)((Object)this)).getClass(), this.extensionTplPath);
        configuration.setDefaultEncoding(StandardCharsets.UTF_8.name());
        configuration.setEncoding(Locale.CHINESE, configuration.getDefaultEncoding());
        this.template = configuration.getTemplate(this.extensionTplName);
        URLClassLoader projectClassLoader = this.getProjectClassLoader();
        Set<Class<?>> classSet = ClassScanUtils.getJarClass(this.dependencyFilePath, projectClassLoader);
        DefinitionMapCollector definitionMapCollector = new DefinitionMapCollector(this.innerClassEnabled, this.getSourceDir());
        Map<String, ExtensionDefinition> finalExtensionDefinitionMap = definitionMapCollector.collect(classSet);
        Collection<ExtensionDefinition> defList = finalExtensionDefinitionMap.values();
        for (ExtensionDefinition extensionDefinition : defList) {
            this.generateJavaSource(extensionDefinition);
        }
        File generationFile = new File(this.getOutputDirectory() + this.generationJavaResult);
        File parentFile = generationFile.getParentFile();
        if (parentFile.exists() || parentFile.mkdirs()) {
            FileCopyUtils.copy((byte[])Objects.requireNonNull(JSONObject.toJSONString((Object)GenerationResult.getInstance())).getBytes(StandardCharsets.UTF_8), (File)generationFile);
            this.getLog().info((CharSequence)("\u751f\u6210" + this.generationJavaResult + "\u6587\u4ef6\u6210\u529f"));
        }
    }

    private void generateJavaSource(ExtensionDefinition def) throws IOException, TemplateException {
        this.generateJavaSource(def, () -> this.getSourceDir(), () -> this.isToYxGen());
    }

    public void generateJavaSource(ExtensionDefinition def, Supplier<File> sourceDirSupplier, Supplier<Boolean> isToYxGen) throws IOException, TemplateException {
        boolean toYxGenDir;
        File sourceDir = sourceDirSupplier.get();
        if (this.keepSrc4view != null) {
            toYxGenDir = this.keepSrc4view;
        } else {
            toYxGenDir = false;
            if (isToYxGen.get().booleanValue()) {
                toYxGenDir = true;
            }
        }
        String objectFilePath = Util.combineFilePathWith(def.getName(), def.getPkg(), sourceDir.getAbsolutePath(), toYxGenDir);
        this.generateJavaSource0(def, objectFilePath, toYxGenDir);
    }

    private boolean isToYxGen() {
        String artifactId = this.getMavenProject().getArtifact().getArtifactId();
        return artifactId.endsWith("api") || artifactId.endsWith("dao") || artifactId.endsWith("eo");
    }

    private void generateJavaSource0(ExtensionDefinition def, String javaFilePath, boolean toYxGenDir) throws IOException, TemplateException {
        boolean createSucc;
        File docFile = new File(javaFilePath);
        File parentFolder = docFile.getParentFile();
        parentFolder.mkdirs();
        this.getLog().info((CharSequence)("\u751f\u6210\u7684java\u6e90\u6587\u4ef6\u6240\u5728\u76ee\u5f55\uff1a" + parentFolder.getAbsolutePath()));
        if (!docFile.exists() && !(createSucc = docFile.createNewFile())) {
            throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u5931\u8d25:" + javaFilePath);
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(docFile), "UTF-8"));
        this.template.process((Object)def, (Writer)out);
        if (toYxGenDir) {
            GenerationResult.appendYxGenFilePath(javaFilePath);
        } else {
            GenerationResult.appendDeleteFilePath(javaFilePath);
        }
        this.getLog().info((CharSequence)("\u751f\u6210\u6587\u4ef6:" + javaFilePath));
    }

    private URLClassLoader getProjectClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        List runtimeClasspathElements = this.getMavenProject().getRuntimeClasspathElements();
        ArrayList<URL> runtimeUrlList = new ArrayList<URL>();
        for (Object runtimeClasspathElement : runtimeClasspathElements) {
            runtimeUrlList.add(new File((String)runtimeClasspathElement).toURI().toURL());
        }
        this.project.setArtifacts(null);
        this.project.setArtifactFilter((ArtifactFilter)new GenJavaArtifactFilter(this.groupPattern, this.groupPrefixs));
        Set artifacts = this.project.getArtifacts();
        for (Artifact dependencyArtifact : artifacts) {
            if (dependencyArtifact == null || dependencyArtifact.getFile() == null) continue;
            File file = dependencyArtifact.getFile();
            runtimeUrlList.add(file.toURI().toURL());
            this.dependencyFilePath.add(file.getAbsolutePath());
        }
        URL[] runtimeUrls = runtimeUrlList.toArray(new URL[0]);
        ClassRealm realm = this.descriptor.getClassRealm();
        for (URL url : runtimeUrls) {
            realm.addURL(url);
        }
        return new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
    }
}

