/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.maven.plugins.CubeAbstractMojo;
import com.dtyunxi.huieryun.maven.plugins.generation.GenerationResult;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="rm-extension-java", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class RmExtensionJavaSrcMojo
extends CubeAbstractMojo {
    private final String JAVA_PATH = "java";
    @Parameter(property="keepClasses")
    public Boolean keepClasses;

    @Override
    public void execute() throws MojoExecutionException {
        try {
            this.executeInner();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
    }

    @Override
    protected void executeInner() throws IOException {
        File sourceDir = this.getSourceDir();
        File generationFile = new File(this.getOutputDirectory() + this.generationJavaResult);
        StringBuilder json = new StringBuilder();
        for (String readLine : IOUtils.readLines((Reader)new FileReader(generationFile))) {
            json.append(readLine);
        }
        boolean rmGenClasses = this.keepClasses == null ? !this.isExecutableTarget() : this.keepClasses == false;
        GenerationResult generationResult = (GenerationResult)JSONObject.parseObject((String)json.toString(), GenerationResult.class);
        HashSet<String> parentDirs = new HashSet<String>();
        for (String javaFilePath : generationResult.getDeleteJavaFilePaths()) {
            String classFilePath;
            File classFile;
            File migrationFile = new File(javaFilePath);
            parentDirs.add(migrationFile.getParentFile().getAbsolutePath());
            String javaPath = sourceDir.getParent() + File.separator + "java";
            String yxGenDirPath = sourceDir.getParent() + File.separator + "yx_gen";
            File finalFile = new File(migrationFile.getAbsolutePath().replace(javaPath, yxGenDirPath));
            finalFile.getParentFile().mkdirs();
            boolean migrationRs = migrationFile.renameTo(finalFile);
            this.getLog().info((CharSequence)("\u8fc1\u79fb\u6269\u5c55\u5c5e\u6027\u7684java\u6587\u4ef6\uff0c\u6e90\u8def\u5f84\uff1a" + javaFilePath + ",\u76ee\u6807\u8def\u5f84\uff1a" + finalFile.getAbsolutePath() + ",\u64cd\u4f5c\u7ed3\u679c\uff1a" + migrationRs));
            if (migrationFile.exists()) {
                this.getLog().info((CharSequence)("\u5220\u9664\u5df2\u8fc1\u79fb\u7684java\u6587\u4ef6:" + migrationFile.getAbsolutePath() + "\uff0c\u7ed3\u679c\uff1a" + migrationFile.delete()));
            }
            if (!rmGenClasses || !(classFile = new File(classFilePath = migrationFile.getAbsolutePath().replace(javaPath, this.getOutputDirectory()).replace(".java", ".class"))).exists()) continue;
            classFile.delete();
            this.getLog().info((CharSequence)("\u79fb\u9664\u751f\u6210\u7684class:" + classFilePath));
        }
        if (!rmGenClasses) {
            this.getLog().info((CharSequence)"\u4e0d\u9700\u79fb\u9664\u751f\u6210\u7684class");
        }
        this.recursionDeleteEmptyDir(parentDirs);
    }

    private void recursionDeleteEmptyDir(Set<String> parentDirs) {
        if (parentDirs == null || parentDirs.isEmpty()) {
            return;
        }
        HashSet<String> newParentDirs = new HashSet<String>();
        for (String parentDirPath : parentDirs) {
            File parentDir = new File(parentDirPath);
            if (!parentDir.isDirectory() || parentDir.list().length != 0) continue;
            if (parentDir.getAbsolutePath().endsWith(String.format("%ssrc%smain%sjava", File.separator, File.separator, File.separator))) {
                return;
            }
            boolean deleteRs = false;
            if (parentDir.exists()) {
                deleteRs = parentDir.delete();
            }
            this.getLog().info((CharSequence)("\u79fb\u9664\u7a7a\u7684\u76ee\u5f55\uff1a" + parentDir.getAbsolutePath() + ",\u64cd\u4f5c\u7ed3\u679c\uff1a" + deleteRs));
            newParentDirs.add(parentDir.getParentFile().getAbsolutePath());
        }
        this.recursionDeleteEmptyDir(newParentDirs);
    }
}

