/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins.definition;

import com.dtyunxi.huieryun.maven.plugins.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationDefinition.class);
    private String name;
    private Map<String, Value> memberValues;

    public String getName() {
        return this.name;
    }

    public AnnotationDefinition setName(String name) {
        this.name = name;
        return this;
    }

    public Map<String, Value> getMemberValues() {
        return this.memberValues;
    }

    public AnnotationDefinition setMemberValues(Map<String, Object> memberValues) {
        this.memberValues = new HashMap<String, Value>();
        Set<Map.Entry<String, Object>> entries = memberValues.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            Object value = entry.getValue();
            if (this.accept(value)) {
                if (value instanceof Boolean) {
                    this.memberValues.put(entry.getKey(), new Value(null, (Boolean)value));
                    continue;
                }
                if (value instanceof String || value instanceof StringBuilder || value instanceof StringBuffer) {
                    this.memberValues.put(entry.getKey(), new Value("\"" + StringUtil.escape(String.valueOf(value)) + "\"", false));
                    continue;
                }
                if (value instanceof Character) {
                    this.memberValues.put(entry.getKey(), new Value("'" + StringUtil.escape(((Character)value).charValue()) + "'", false));
                    continue;
                }
                this.memberValues.put(entry.getKey(), new Value(value, false));
                continue;
            }
            LOGGER.warn("\u6682\u65f6\u4e0d\u652f\u6301\u8be5\u7c7b\u578b[{}]\u503c\u7684\u6ce8\u89e3\u9879[{}]", entry.getValue(), (Object)entry.getKey());
        }
        return this;
    }

    public boolean accept(Object value) {
        if (value instanceof String || value instanceof StringBuilder || value instanceof StringBuffer) {
            return true;
        }
        if (value instanceof Long) {
            return true;
        }
        if (value instanceof Double) {
            return true;
        }
        if (value instanceof Float) {
            return true;
        }
        if (value instanceof Character) {
            return true;
        }
        return value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof Boolean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationDefinition that = (AnnotationDefinition)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Value {
        Object value;
        boolean myBoolean;

        public Value() {
        }

        public Value(Object value, boolean myBoolean) {
            this.value = value;
            this.myBoolean = myBoolean;
        }

        public Object getValue() {
            return this.value;
        }

        public Value setValue(Object value) {
            this.value = value;
            return this;
        }

        public boolean isMyBoolean() {
            return this.myBoolean;
        }

        public Value setMyBoolean(boolean myBoolean) {
            this.myBoolean = myBoolean;
            return this;
        }
    }
}

