/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

public abstract class AbstractArtifactFilter
implements ArtifactFilter {
    private String groupPatternText;
    private List<String> groupPrefixs;
    private Pattern groupPattern = null;
    private Pattern groupDefaultFilterPattern = Pattern.compile("(com\\.dtyunxi)\\S*");

    public AbstractArtifactFilter(String groupPatternText, List<String> groupPrefixs) {
        this.groupPrefixs = new ArrayList<String>();
        this.groupPrefixs.add("com.dtyunxi");
        this.groupPrefixs.add("com.baomidou.mybatisplus");
        this.groupPrefixs.add("org.springframework.jdbc.datasource");
        this.groupPrefixs.add("org.hibernate.javax.persistence");
        this.groupPrefixs.add("io.swagger");
        this.groupPrefixs.addAll(groupPrefixs);
        if (groupPatternText != null && !groupPatternText.isEmpty()) {
            this.groupPatternText = groupPatternText;
            this.groupPattern = Pattern.compile(groupPatternText);
        }
    }

    public boolean include(Artifact artifact) {
        return this.groupIdMatch(artifact);
    }

    private boolean groupIdMatch(Artifact artifact) {
        if (this.groupPattern == null) {
            for (String groupPrefix : this.groupPrefixs) {
                if (!artifact.getGroupId().startsWith(groupPrefix)) continue;
                return true;
            }
            return this.groupDefaultFilterPattern.matcher(artifact.getGroupId()).matches();
        }
        return this.groupPattern.matcher(artifact.getGroupId()).matches();
    }
}

