/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins.filter;

import com.dtyunxi.huieryun.maven.plugins.filter.AbstractArtifactFilter;
import com.dtyunxi.huieryun.maven.plugins.util.ClassScanUtils;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiClassMigrationArtifactFilter
extends AbstractArtifactFilter {
    private String artifactPatternText;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassScanUtils.class);
    private Pattern artifactPattern = Pattern.compile("bundle(-|_)\\S+api");

    public ApiClassMigrationArtifactFilter(String groupPatternText, String artifactPatternText, List<String> groupPrefixs) {
        super(groupPatternText, groupPrefixs);
        if (artifactPatternText != null && !artifactPatternText.isEmpty()) {
            this.artifactPatternText = artifactPatternText;
            this.artifactPattern = Pattern.compile(artifactPatternText);
        }
    }

    @Override
    public boolean include(Artifact artifact) {
        boolean accept = super.include(artifact) ? this.artifactIdMatch(artifact) : false;
        return accept;
    }

    private boolean artifactIdMatch(Artifact artifact) {
        return this.artifactPattern.matcher(artifact.getArtifactId()).matches();
    }
}

