/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins.resolve;

import cn.hutool.core.util.ReflectUtil;
import com.dtyunxi.huieryun.maven.plugins.definition.AnnotationDefinition;
import com.dtyunxi.huieryun.maven.plugins.definition.ExtensionDefinition;
import com.dtyunxi.huieryun.maven.plugins.definition.MethodDefinition;
import com.dtyunxi.huieryun.maven.plugins.definition.PropertyDefinition;
import com.dtyunxi.huieryun.maven.plugins.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassExtendResolver {
    private static Logger logger = LoggerFactory.getLogger(ClassExtendResolver.class);

    public ExtensionDefinition extendOriginJava(Set<PropertyDefinition> extensionProperties, Class<?> originalClass) {
        ExtensionDefinition extensionDefinition = new ExtensionDefinition();
        extensionDefinition.setFqn(originalClass.getName());
        for (Method declaredMethod : originalClass.getDeclaredMethods()) {
            if (declaredMethod.getName().equals("newInstance")) {
                if (declaredMethod.getParameters().length == 0) {
                    extensionDefinition.setNewInstance0(true);
                } else {
                    extensionDefinition.setNewInstance1(true);
                }
            }
            if (declaredMethod.getName().equals("newInstance") || declaredMethod.getName().startsWith("get") || declaredMethod.getName().startsWith("set") || declaredMethod.getName().startsWith("is") || declaredMethod.getName().equals("main")) continue;
            logger.warn("\u7c7b\u5305\u542b\u4e86\u9664newInstance\u3001setter/getter/isXx\u4e4b\u5916\u7684\u65b9\u6cd5\uff0c\u4e0d\u652f\u6301\u8be5\u7c7b\u7684\u5c5e\u6027\u6269\u5c55");
            return null;
        }
        extensionDefinition.setModifier(Modifier.toString(originalClass.getModifiers()));
        extensionDefinition.setName(originalClass.getSimpleName());
        extensionDefinition.setPkg(originalClass.getName().replace("." + extensionDefinition.getName(), ""));
        extensionDefinition.setParent(originalClass.getSuperclass().getName());
        Class<?>[] interfaceClasses = originalClass.getInterfaces();
        HashSet<String> interfaces = new HashSet<String>();
        for (Class<?> anInterface : interfaceClasses) {
            interfaces.add(anInterface.getName());
        }
        extensionDefinition.setInterfaces(interfaces);
        extensionDefinition.setAnnotations(this.convert2AnnotationDefinition(originalClass.getDeclaredAnnotations()));
        Set<PropertyDefinition> originalProperties = this.resolvePropertyDefinition(originalClass, false);
        this.mergePropertyDefinition(extensionProperties, originalProperties);
        this.mergeInheritProOfOriginal(extensionProperties, originalClass);
        extensionDefinition.setProperties(extensionProperties);
        return extensionDefinition;
    }

    private void mergeInheritProOfOriginal(Set<PropertyDefinition> extensionProperties, Class<?> originalClass) {
        Field[] fields = ReflectUtil.getFields(originalClass);
        Field[] declaredFields = originalClass.getDeclaredFields();
        HashMap<String, Boolean> declaredFieldMap = new HashMap<String, Boolean>();
        for (Field declaredField : declaredFields) {
            declaredFieldMap.putIfAbsent(declaredField.getName(), true);
        }
        Map extensionProMap = null;
        for (Field field : fields) {
            PropertyDefinition extendDefinition;
            Annotation[] annotations;
            if (declaredFieldMap.containsKey(field.getName())) continue;
            PropertyDefinition definition = new PropertyDefinition();
            definition.setName(field.getName());
            if (!extensionProperties.contains(definition) || (annotations = field.getAnnotations()) == null) continue;
            Set<AnnotationDefinition> annotationDefinitions = this.convert2AnnotationDefinition(annotations);
            if (extensionProMap == null) {
                extensionProMap = extensionProperties.stream().collect(Collectors.toMap(PropertyDefinition::getName, Function.identity(), (o1, o2) -> o1));
            }
            if ((extendDefinition = (PropertyDefinition)extensionProMap.get(field.getName())).getAnnotations() != null) {
                annotationDefinitions.addAll(extendDefinition.getAnnotations());
            }
            extendDefinition.setAnnotations(annotationDefinitions);
            extendDefinition.setInherit(true);
        }
    }

    private void mergePropertyDefinition(Set<PropertyDefinition> extensionProperties, Set<PropertyDefinition> originalProperties) {
        Map extensionProMap = null;
        for (PropertyDefinition originalProperty : originalProperties) {
            if (extensionProperties.contains(originalProperty)) {
                if (extensionProMap == null) {
                    extensionProMap = extensionProperties.stream().collect(Collectors.toMap(PropertyDefinition::getName, Function.identity(), (o1, o2) -> o1));
                }
                PropertyDefinition extensionProDef = (PropertyDefinition)extensionProMap.get(originalProperty.getName());
                extensionProperties.remove(extensionProDef);
                extensionProperties.add(originalProperty);
                if (originalProperty.getAnnotations() == null) {
                    originalProperty.setAnnotations(extensionProDef.getAnnotations());
                } else if (extensionProDef.getAnnotations() != null) {
                    originalProperty.getAnnotations().addAll(extensionProDef.getAnnotations());
                }
                if (originalProperty.getExtSourceClz() != null) {
                    originalProperty.setExtSourceClzName(originalProperty.getExtSourceClz().getCanonicalName());
                }
                if (extensionProDef.getExtSourceClz() == null) {
                    originalProperty.setExtSourceClzName(originalProperty.getExtSourceClzName() + ";" + extensionProDef.getExtSourceClzName());
                    continue;
                }
                originalProperty.setExtSourceClzName(originalProperty.getExtSourceClzName() + ";" + extensionProDef.getExtSourceClz().getName());
                continue;
            }
            extensionProperties.add(originalProperty);
        }
    }

    private Set<AnnotationDefinition> convert2AnnotationDefinition(Annotation[] annotations) {
        HashSet<AnnotationDefinition> annotationDefinitions = new HashSet<AnnotationDefinition>();
        for (Annotation annotation : annotations) {
            AnnotationDefinition annotationDefinition = new AnnotationDefinition();
            annotationDefinition.setName(annotation.annotationType().getName());
            Method[] declaredMethods = annotation.annotationType().getDeclaredMethods();
            HashMap<String, Object> methodDefaultValueMap = new HashMap<String, Object>();
            for (Method declaredMethod : declaredMethods) {
                methodDefaultValueMap.put(declaredMethod.getName(), declaredMethod.getDefaultValue());
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
            try {
                Field memberValuesField = invocationHandler.getClass().getDeclaredField("memberValues");
                memberValuesField.setAccessible(true);
                Map memberValues = (Map)memberValuesField.get(invocationHandler);
                HashMap<String, Object> newMemberValues = new HashMap<String, Object>();
                memberValues.forEach((key, value) -> {
                    Object defaultValue = methodDefaultValueMap.get(key);
                    if (defaultValue == null || !defaultValue.equals(value)) {
                        newMemberValues.put((String)key, value);
                    }
                });
                annotationDefinition.setMemberValues(newMemberValues);
                annotationDefinitions.add(annotationDefinition);
            }
            catch (NoSuchFieldException e) {
                logger.error("\u6ce8\u89e3\u83b7\u53d6\u6210\u5458\u503c\u6620\u5c04\u96c6\u5f02\u5e38\uff1a", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("\u975e\u6cd5\u8bbf\u95ee\u6ce8\u89e3\u6210\u5458\u503c\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return annotationDefinitions;
    }

    public Set<PropertyDefinition> resolvePropertyDefinition(Class<?> clz, boolean extend) {
        Method[] declaredMethods;
        Field[] declaredFields = clz.getDeclaredFields();
        Map<String, String> booleanFieldMap = this.collectBooleanFieldMap(declaredFields);
        HashMap<String, MethodDefinition> getterMap = new HashMap<String, MethodDefinition>();
        HashMap<String, MethodDefinition> setterMap = new HashMap<String, MethodDefinition>();
        for (Method declaredMethod : declaredMethods = clz.getDeclaredMethods()) {
            String alias;
            MethodDefinition methodDefinition = new MethodDefinition();
            methodDefinition.setName(declaredMethod.getName());
            methodDefinition.setReturnType(declaredMethod.getGenericReturnType().getTypeName());
            methodDefinition.setAnnotations(this.convert2AnnotationDefinition(declaredMethod.getDeclaredAnnotations()));
            Parameter[] parameters = declaredMethod.getParameters();
            StringBuilder parameterChain = new StringBuilder();
            for (Parameter parameter : parameters) {
                parameterChain.append(parameter.getParameterizedType().getTypeName()).append(" ").append(parameter.getName()).append(",");
            }
            if (parameterChain.length() > 0) {
                parameterChain.deleteCharAt(parameterChain.length() - 1);
            }
            methodDefinition.setParameterChain(parameterChain.toString());
            int OFFSET = methodDefinition.getName().startsWith("is") ? 2 : 3;
            StringBuilder name = StringUtil.firstLetterLower(methodDefinition.getName().toCharArray(), OFFSET);
            if (name == null) continue;
            String finalName = name.toString();
            if (methodDefinition.getName().startsWith("get") || methodDefinition.getName().startsWith("is")) {
                alias = booleanFieldMap.get(finalName);
                if (alias != null) {
                    getterMap.put(alias, methodDefinition);
                }
                getterMap.put(finalName, methodDefinition);
                continue;
            }
            if (!methodDefinition.getName().startsWith("set")) continue;
            setterMap.put(finalName, methodDefinition);
            alias = booleanFieldMap.get(finalName);
            if (alias == null) continue;
            setterMap.put(alias, methodDefinition);
        }
        Object object = this.instObject(clz);
        return this.collectProperties(clz, extend, declaredFields, getterMap, setterMap, object);
    }

    private Map<String, String> collectBooleanFieldMap(Field[] declaredFields) {
        HashMap<String, String> booleanFieldMap = new HashMap<String, String>();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (Field declaredField : declaredFields) {
            if (declaredField.getType().isAssignableFrom(Boolean.class) || declaredField.getType().isAssignableFrom(Boolean.TYPE)) {
                booleanFieldMap.put(declaredField.getName(), declaredField.getName());
            }
            fieldMap.put(declaredField.getName(), declaredField.getName());
        }
        HashMap appendBooleanFieldMap = new HashMap();
        booleanFieldMap.forEach((k, v) -> {
            String name;
            String withoutIs;
            StringBuilder stringBuilder;
            if (k.startsWith("is") && (stringBuilder = StringUtil.firstLetterLower((withoutIs = k.substring(2)).toCharArray(), 0)) != null && !fieldMap.containsKey(name = stringBuilder.toString())) {
                appendBooleanFieldMap.put(name, v);
            }
        });
        booleanFieldMap.putAll(appendBooleanFieldMap);
        return booleanFieldMap;
    }

    private Object instObject(Class<?> clz) {
        Object object = null;
        if (!Modifier.isAbstract(clz.getModifiers())) {
            try {
                object = clz.newInstance();
            }
            catch (InstantiationException e) {
                logger.error("\u521d\u59cb\u5316\u5bf9\u8c61\u5f02\u5e38\uff1a", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("\u975e\u6cd5\u8bbf\u95ee\uff1a", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("[{}]\u5b9e\u4f8b\u5316\u5f02\u5e38\uff1a", (Object)clz.getName(), (Object)e);
            }
        }
        return object;
    }

    private Set<PropertyDefinition> collectProperties(Class<?> clz, boolean extend, Field[] declaredFields, Map<String, MethodDefinition> getterMap, Map<String, MethodDefinition> setterMap, Object object) {
        HashSet<PropertyDefinition> properties = new HashSet<PropertyDefinition>();
        for (Field field : declaredFields) {
            MethodDefinition setter;
            PropertyDefinition propertyDefinition = new PropertyDefinition();
            if (extend) {
                propertyDefinition.setModifier(" private");
            } else {
                propertyDefinition.setModifier(Modifier.toString(field.getModifiers()));
            }
            propertyDefinition.setName(field.getName());
            propertyDefinition.setType(field.getGenericType().getTypeName());
            MethodDefinition getter = getterMap.get(field.getName());
            if (getter != null) {
                propertyDefinition.setGetter(getter);
            }
            if ((setter = setterMap.get(field.getName())) != null) {
                propertyDefinition.setSetter(setter);
            }
            try {
                Object value;
                field.setAccessible(true);
                Object object2 = value = object == null ? null : field.get(object);
                if (value != null) {
                    propertyDefinition.setDefaultValue(ClassExtendResolver.readDefaultValueString(value));
                }
            }
            catch (IllegalAccessException e) {
                logger.error("\u5c5e\u6027\u9ed8\u8ba4\u503c\u975e\u6cd5\u8bbf\u95ee\uff1a", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6[{}]\u5c5e\u6027\u503c\u5f02\u5e38\uff1a", (Object)field.getName(), (Object)e);
            }
            propertyDefinition.setAnnotations(this.convert2AnnotationDefinition(field.getDeclaredAnnotations()));
            propertyDefinition.setExtSourceClz(clz);
            properties.add(propertyDefinition);
        }
        return properties;
    }

    public static <T> String readDefaultValueString(T defaultValue) {
        if (defaultValue instanceof String || defaultValue instanceof StringBuilder || defaultValue instanceof StringBuffer) {
            return "\"" + StringUtil.escape(String.valueOf(defaultValue)) + "\"";
        }
        if (defaultValue instanceof Long) {
            return defaultValue + "L";
        }
        if (defaultValue instanceof Double) {
            return defaultValue + "D";
        }
        if (defaultValue instanceof Float) {
            return defaultValue + "F";
        }
        if (defaultValue instanceof Character) {
            return "'" + StringUtil.escape(((Character)defaultValue).charValue()) + "'";
        }
        if (defaultValue instanceof Integer || defaultValue instanceof Short || defaultValue instanceof Byte || defaultValue instanceof Boolean) {
            return defaultValue + "";
        }
        if (defaultValue instanceof BigDecimal) {
            return "new " + defaultValue.getClass().getTypeName() + "(" + defaultValue + ")";
        }
        if (defaultValue instanceof BigInteger) {
            return "new " + defaultValue.getClass().getTypeName() + "(\"" + defaultValue + "\")";
        }
        return "new " + defaultValue.getClass().getTypeName() + "()";
    }
}

