/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins.resolve;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Pair;
import com.dtyunxi.huieryun.maven.plugins.annotations.CubePropertyExtension;
import com.dtyunxi.huieryun.maven.plugins.definition.AnnotationDefinition;
import com.dtyunxi.huieryun.maven.plugins.definition.BaseExtensionDefinition;
import com.dtyunxi.huieryun.maven.plugins.definition.ExtensionDefinition;
import com.dtyunxi.huieryun.maven.plugins.definition.InnerExtensionDefinition;
import com.dtyunxi.huieryun.maven.plugins.definition.PropertyDefinition;
import com.dtyunxi.huieryun.maven.plugins.resolve.ClassExtendResolver;
import com.dtyunxi.huieryun.maven.plugins.resolve.JavaFileParser;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionMapCollector {
    private static Logger logger = LoggerFactory.getLogger(DefinitionMapCollector.class);
    ClassExtendResolver classExtendResolver = new ClassExtendResolver();
    boolean innerClassEnabled;
    File sourceDir;

    public DefinitionMapCollector(boolean innerClassEnabled, File sourceDir) {
        this.innerClassEnabled = innerClassEnabled;
        this.sourceDir = sourceDir;
    }

    public Map<String, ExtensionDefinition> collect(Set<Class<?>> classSet) {
        Pair<TreeMap<String, ExtensionDefinition>, TreeMap<String, Class<?>>> pair = this.collectClass(classSet);
        TreeMap finalExtensionDefinitionMap = (TreeMap)pair.getKey();
        new JavaFileParser(this.sourceDir, (originClassInfo, stringExtensionDefinitionMap) -> {
            this.resolveOriginClass(originClassInfo.getOriginalClass(), finalExtensionDefinitionMap, originClassInfo.getExtensionProperties(), originClassInfo.getExtensionImports());
            return null;
        }).process(finalExtensionDefinitionMap, classSet);
        if (this.innerClassEnabled) {
            return this.resolveInnerClass(finalExtensionDefinitionMap, (TreeMap)pair.getValue());
        }
        return finalExtensionDefinitionMap;
    }

    private Pair<TreeMap<String, ExtensionDefinition>, TreeMap<String, Class<?>>> collectClass(Set<Class<?>> classSet) {
        TreeMap<String, ExtensionDefinition> extensionDefinitionMap = new TreeMap<String, ExtensionDefinition>();
        TreeMap classMap = new TreeMap();
        for (Class<?> jarClass : classSet) {
            classMap.put(jarClass.getName(), jarClass);
            try {
                CubePropertyExtension cubePropertyExtension = jarClass.getDeclaredAnnotation(CubePropertyExtension.class);
                if (cubePropertyExtension == null) continue;
                Set<PropertyDefinition> extensionProperties = this.classExtendResolver.resolvePropertyDefinition(jarClass, true);
                for (Class originClass : cubePropertyExtension.original()) {
                    this.resolveOriginClass(originClass, extensionDefinitionMap, extensionProperties, null);
                }
            }
            catch (Exception e) {
                logger.warn("\u7c7b\u52a0\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return Pair.of(extensionDefinitionMap, classMap);
    }

    private void resolveOriginClass(Class<?> originalClass, Map<String, ExtensionDefinition> extensionDefinitionMap, Set<PropertyDefinition> extensionProperties, Set<String> extensionImports) {
        String original = originalClass.getName();
        ExtensionDefinition extensionDefinition = extensionDefinitionMap.get(original);
        if (extensionDefinition == null) {
            extensionDefinition = this.classExtendResolver.extendOriginJava(extensionProperties, originalClass);
            if (extensionDefinition != null) {
                extensionDefinitionMap.put(original, extensionDefinition);
                extensionDefinition.setImports(extensionImports);
            }
        } else {
            if (extensionImports != null) {
                if (extensionDefinition.getImports() == null) {
                    extensionDefinition.setImports(new HashSet<String>());
                } else {
                    extensionDefinition.getImports().addAll(extensionImports);
                }
            }
            if (extensionProperties != null) {
                if (extensionDefinition.getProperties() == null) {
                    extensionDefinition.setProperties(new HashSet<PropertyDefinition>());
                } else {
                    extensionDefinition.getProperties().addAll(extensionProperties);
                }
            }
        }
    }

    private InnerExtensionDefinition acquireInnerDefinition(Map<String, Class<?>> classMap, String fqn, Map<String, ExtensionDefinition> extensionDefinitionDirectMap) {
        ExtensionDefinition extensionDefinition = this.acquireExtensionDefinition(classMap, fqn, extensionDefinitionDirectMap);
        InnerExtensionDefinition innerExtensionDefinition = new InnerExtensionDefinition();
        BeanUtil.copyProperties((Object)extensionDefinition, (Object)innerExtensionDefinition, (String[])new String[0]);
        return innerExtensionDefinition;
    }

    private ExtensionDefinition acquireExtensionDefinition(Map<String, Class<?>> classMap, String fqn, Map<String, ExtensionDefinition> extensionDefinitionDirectMap) {
        ExtensionDefinition extensionDefinition = extensionDefinitionDirectMap.get(fqn);
        if (extensionDefinition == null) {
            Class<?> aClass = classMap.get(fqn);
            if (aClass == null) {
                throw new RuntimeException("\u7c7b\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u8be5\u7c7b\u6240\u5728\u7684jar\u5305\u5185\u5305\u542b\u5728\u5904\u7406\u8303\u56f4\u5185\u3002\uff08\u53c2\u8003\u94fe\u63a5\uff1ahttps://dtyunxi.yuque.com/dfleet-doc/design/yb75v8#YPPV3\uff09");
            }
            extensionDefinition = this.classExtendResolver.extendOriginJava(new HashSet<PropertyDefinition>(), aClass);
        }
        return extensionDefinition;
    }

    private TreeMap<String, ExtensionDefinition> resolveInnerClass(TreeMap<String, ExtensionDefinition> extensionDefinitionDirectMap, TreeMap<String, Class<?>> classMap) {
        TreeMap<String, ExtensionDefinition> extensionRelatedMap = new TreeMap<String, ExtensionDefinition>();
        for (Map.Entry<String, ExtensionDefinition> entry : extensionDefinitionDirectMap.entrySet()) {
            this.traceOuterClassDefinition(extensionDefinitionDirectMap, classMap, extensionRelatedMap, entry.getKey(), entry.getValue());
        }
        return this.relink(classMap, extensionRelatedMap, new TreeMap<String, ExtensionDefinition>());
    }

    private void traceOuterClassDefinition(Map<String, ExtensionDefinition> extensionDefinitionDirectMap, Map<String, Class<?>> classMap, Map<String, ExtensionDefinition> finalGenerationDefinitionMap, String fqn, ExtensionDefinition definition) {
        String flag = "$" + definition.getName();
        if (fqn.endsWith(flag)) {
            String outerClassFqn = fqn.substring(0, fqn.length() - flag.length());
            ExtensionDefinition outerClassDefinition = finalGenerationDefinitionMap.get(outerClassFqn);
            if (outerClassDefinition == null) {
                outerClassDefinition = extensionDefinitionDirectMap.get(outerClassFqn);
            }
            if (outerClassDefinition == null) {
                Class<?> aClass = classMap.get(outerClassFqn);
                if (aClass == null) {
                    throw new RuntimeException("\u5185\u90e8\u7c7b\u6240\u4f9d\u6258\u7684\u5916\u90e8\u7c7b\u52a0\u8f7d\u4e0d\u5230\uff0c\u8bf7\u786e\u4fdd\u8be5\u5916\u90e8\u7c7b\u6240\u5728\u7684jar\u5305\u5185\u5305\u542b\u5728\u5904\u7406\u8303\u56f4\u5185\u3002\uff08\u53c2\u8003\u94fe\u63a5\uff1ahttps://dtyunxi.yuque.com/dfleet-doc/design/yb75v8#YPPV3\uff09");
                }
                outerClassDefinition = this.classExtendResolver.extendOriginJava(new HashSet<PropertyDefinition>(), aClass);
                if (outerClassDefinition == null) {
                    return;
                }
            }
            if (outerClassDefinition.getImports() == null) {
                outerClassDefinition.setImports(new HashSet<String>());
            }
            if (outerClassDefinition.getInnerClassExtensionDefinitions() == null) {
                outerClassDefinition.setInnerClassExtensionDefinitions(new HashSet<InnerExtensionDefinition>());
            }
            if (definition.getImports() != null) {
                outerClassDefinition.getImports().addAll(definition.getImports());
            }
            InnerExtensionDefinition innerExtensionDefinition = new InnerExtensionDefinition();
            BeanUtil.copyProperties((Object)definition, (Object)innerExtensionDefinition, (String[])new String[0]);
            innerExtensionDefinition.setOuterClassFqn(outerClassFqn);
            outerClassDefinition.appendInnerClassExtensionDefinition(innerExtensionDefinition);
            if (!finalGenerationDefinitionMap.containsKey(outerClassFqn)) {
                finalGenerationDefinitionMap.put(outerClassFqn, outerClassDefinition);
            }
            this.traceOuterClassDefinition(extensionDefinitionDirectMap, classMap, finalGenerationDefinitionMap, outerClassFqn, outerClassDefinition);
        } else {
            finalGenerationDefinitionMap.put(fqn, definition);
        }
    }

    private void relinkInnerToReliedDefinition(TreeMap<String, ExtensionDefinition> tmp, TreeMap<String, ExtensionDefinition> extensionRelatedMap, TreeMap<String, Class<?>> classMap) {
        TreeMap newClassMap = new TreeMap();
        classMap.forEach(newClassMap::put);
        classMap.forEach((fqn, aClass) -> {
            String name = aClass.getName();
            newClassMap.remove(name);
            for (String validInnerClassName : extensionRelatedMap.keySet()) {
                Class outerClass;
                if (!name.startsWith(validInnerClassName + "$")) continue;
                String[] split = name.split("\\$");
                String simpleName = split[split.length - 1];
                String flag = "$" + simpleName;
                if (!name.endsWith(flag)) continue;
                String outerClassFqn = name.substring(0, name.length() - flag.length());
                newClassMap.remove(outerClassFqn);
                ExtensionDefinition outerClassDefinition = (ExtensionDefinition)tmp.get(outerClassFqn);
                if (outerClassDefinition == null && (outerClass = (Class)classMap.get(outerClassFqn)) != null) {
                    outerClassDefinition = this.classExtendResolver.extendOriginJava(new HashSet<PropertyDefinition>(), outerClass);
                    if (outerClassDefinition == null) continue;
                    tmp.put(outerClassFqn, outerClassDefinition);
                    this.relinkInnerToReliedDefinition(tmp, extensionRelatedMap, newClassMap);
                }
                if (outerClassDefinition == null) continue;
                if (outerClassDefinition.getImports() == null) {
                    outerClassDefinition.setImports(new HashSet<String>());
                }
                if (outerClassDefinition.getInnerClassExtensionDefinitions() == null) {
                    outerClassDefinition.setInnerClassExtensionDefinitions(new HashSet<InnerExtensionDefinition>());
                }
                InnerExtensionDefinition innerExtensionDefinition = new InnerExtensionDefinition();
                ExtensionDefinition extensionDefinition = (ExtensionDefinition)tmp.get(name);
                if (extensionDefinition == null) {
                    extensionDefinition = this.classExtendResolver.extendOriginJava((Set<PropertyDefinition>)new HashSet<PropertyDefinition>(), (Class<?>)aClass);
                    if (extensionDefinition == null) continue;
                    BeanUtil.copyProperties((Object)extensionDefinition, (Object)innerExtensionDefinition, (String[])new String[0]);
                } else {
                    if (extensionDefinition.getImports() != null) {
                        outerClassDefinition.getImports().addAll(extensionDefinition.getImports());
                    }
                    BeanUtil.copyProperties((Object)extensionDefinition, (Object)innerExtensionDefinition, (String[])new String[0]);
                    tmp.remove(name);
                }
                innerExtensionDefinition.setOuterClassFqn(outerClassFqn);
                outerClassDefinition.appendInnerClassExtensionDefinition(innerExtensionDefinition);
            }
        });
        tmp.forEach((fqn, definition) -> {
            ExtensionDefinition extensionDefinition = (ExtensionDefinition)extensionRelatedMap.get(fqn);
            if (extensionDefinition != null) {
                if (extensionDefinition.getInnerClassExtensionDefinitions() == null) {
                    extensionDefinition.setInnerClassExtensionDefinitions(new HashSet<InnerExtensionDefinition>());
                }
                extensionDefinition.appendInnerClassExtensionDefinitions(definition.getInnerClassExtensionDefinitions());
            }
        });
    }

    private TreeMap<String, ExtensionDefinition> relink(TreeMap<String, Class<?>> classMap, TreeMap<String, ExtensionDefinition> extensionRelatedMap, TreeMap<String, ExtensionDefinition> tmp) {
        this.relinkInnerToReliedDefinition(tmp, extensionRelatedMap, classMap);
        TreeMap<String, ExtensionDefinition> extension4FileGenerationMap = new TreeMap<String, ExtensionDefinition>();
        extensionRelatedMap.forEach((fqn, definition) -> {
            if (fqn.indexOf("$") > 0) {
                String outerFqn = fqn.substring(0, fqn.lastIndexOf("$"));
                ExtensionDefinition outerDefinition = (ExtensionDefinition)extensionRelatedMap.get(outerFqn);
                if (outerDefinition != null) {
                    InnerExtensionDefinition innerExtensionDefinition = new InnerExtensionDefinition();
                    BeanUtil.copyProperties((Object)definition, (Object)innerExtensionDefinition, (String[])new String[0]);
                    innerExtensionDefinition.setOuterClassFqn(outerFqn);
                    this.mergerInnerClassDefinition(outerDefinition, innerExtensionDefinition);
                }
            } else {
                extension4FileGenerationMap.put((String)fqn, (ExtensionDefinition)definition);
            }
        });
        this.ensureLinkInner2Outer(classMap, extension4FileGenerationMap);
        return extension4FileGenerationMap;
    }

    public static void main(String[] args) {
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put("A$B$S", true);
        treeMap.put("A$B$S$D", true);
        treeMap.put("A", true);
        treeMap.put("A$B", true);
        treeMap.forEach((k, v) -> System.out.println((String)k));
    }

    private void ensureLinkInner2Outer(TreeMap<String, Class<?>> classMap, TreeMap<String, ExtensionDefinition> extension4FileGenerationMap) {
        classMap.forEach((fqn, clz) -> extension4FileGenerationMap.forEach((definitionFqn, definition) -> {
            if (fqn.startsWith(definitionFqn + "$")) {
                String[] $split = fqn.split("\\$");
                for (int i = $split.length - 1; i >= 0; --i) {
                    String prefixFqn = definitionFqn + "$";
                    if (fqn.equals(prefixFqn + $split[i])) {
                        InnerExtensionDefinition innerExtensionDefinition = this.acquireInnerDefinition((Map<String, Class<?>>)classMap, (String)fqn, (Map<String, ExtensionDefinition>)extension4FileGenerationMap);
                        this.mergerInnerClassDefinition((BaseExtensionDefinition)definition, innerExtensionDefinition);
                        break;
                    }
                    if (definition.getInnerClassExtensionDefinitions() == null) {
                        logger.warn("{}\u548c{}\u65e0\u6cd5\u94fe\u63a5\u8d77\u6765", fqn, definitionFqn);
                        this.makeUpInner(classMap, extension4FileGenerationMap, (String)fqn, (String)definitionFqn, (BaseExtensionDefinition)definition, prefixFqn);
                    }
                    if (this.matchAndLink((String)fqn, (String)definitionFqn, definition.getInnerClassExtensionDefinitions(), classMap, extension4FileGenerationMap)) break;
                }
            }
        }));
    }

    private void makeUpInner(TreeMap<String, Class<?>> classMap, TreeMap<String, ExtensionDefinition> extension4FileGenerationMap, String fqn, String definitionFqn, BaseExtensionDefinition definition, String prefixFqn) {
        definition.setInnerClassExtensionDefinitions(new HashSet<InnerExtensionDefinition>());
        String postFqn = fqn.replace(prefixFqn, "");
        String[] $postFqns = postFqn.split("\\$");
        BaseExtensionDefinition baseExtensionDefinition = definition;
        String curPrefixFqn = definitionFqn;
        for (int i1 = 0; i1 < $postFqns.length; ++i1) {
            String nextFqn;
            curPrefixFqn = nextFqn = curPrefixFqn + "$" + $postFqns[i1];
            InnerExtensionDefinition innerExtensionDefinition = this.acquireInnerDefinition(classMap, nextFqn, extension4FileGenerationMap);
            this.mergerInnerClassDefinition(baseExtensionDefinition, innerExtensionDefinition);
            logger.debug("\u8865\u9f50{}\u548c\u7684{}\u7684\u8fde\u63a5", (Object)curPrefixFqn, (Object)nextFqn);
            baseExtensionDefinition = innerExtensionDefinition;
        }
    }

    private boolean matchAndLink(String innerFqn, String assumptionUpperFqn, Set<InnerExtensionDefinition> assumptionUpperOfInnerList, TreeMap<String, Class<?>> classMap, TreeMap<String, ExtensionDefinition> extension4FileGenerationMap) {
        InnerExtensionDefinition innerExtensionDefinition = this.acquireInnerDefinition(classMap, innerFqn, extension4FileGenerationMap);
        innerExtensionDefinition.setFqn(innerFqn);
        for (InnerExtensionDefinition assumptionUpperOfInner : assumptionUpperOfInnerList) {
            if (assumptionUpperOfInner.directInner(innerExtensionDefinition)) {
                logger.debug("{}\u662f{}\u7684\u5916\u90e8\u7c7b", (Object)assumptionUpperOfInner.getFqn(), (Object)innerExtensionDefinition.getFqn());
                this.mergerInnerClassDefinition(assumptionUpperOfInner, innerExtensionDefinition);
                return true;
            }
            if (!innerFqn.startsWith(assumptionUpperOfInner.getFqn() + "$")) continue;
            logger.debug("'{}'\u4ee5'{}$'\u5f00\u5934\uff0c\u8868\u660e\u4e3a'{}'\u4e3a'{}'\u7684\u4e0b\u7ea7\u7c7b,\u6267\u884c\u94fe\u63a5\u68c0\u6d4b", new Object[]{innerFqn, assumptionUpperOfInner.getFqn(), innerFqn, assumptionUpperOfInner.getFqn()});
            if (assumptionUpperOfInner.getInnerClassExtensionDefinitions() == null) {
                logger.warn("{}\u548c{}\u65e0\u6cd5\u94fe\u63a5\u8d77\u6765", (Object)innerFqn, (Object)assumptionUpperFqn);
                String prefixFqn = assumptionUpperFqn + "$";
                this.makeUpInner(classMap, extension4FileGenerationMap, innerFqn, assumptionUpperFqn, assumptionUpperOfInner, prefixFqn);
                continue;
            }
            return this.matchAndLink(innerFqn, assumptionUpperFqn, assumptionUpperOfInner.getInnerClassExtensionDefinitions(), classMap, extension4FileGenerationMap);
        }
        return false;
    }

    private void mergerInnerClassDefinition(BaseExtensionDefinition outerDefinition, InnerExtensionDefinition innerExtensionDefinition) {
        if (outerDefinition.getInnerClassExtensionDefinitions() == null) {
            outerDefinition.setInnerClassExtensionDefinitions(new HashSet<InnerExtensionDefinition>());
        }
        innerExtensionDefinition.setOuterClassFqn(outerDefinition.getFqn());
        if (outerDefinition.getInnerClassExtensionDefinitions().contains(innerExtensionDefinition)) {
            for (InnerExtensionDefinition innerClassExtensionDefinition : outerDefinition.getInnerClassExtensionDefinitions()) {
                if (!innerClassExtensionDefinition.equals(innerExtensionDefinition)) continue;
                if (innerExtensionDefinition.getInnerClassExtensionDefinitions() != null) {
                    if (innerClassExtensionDefinition.getInnerClassExtensionDefinitions() == null) {
                        innerClassExtensionDefinition.setInnerClassExtensionDefinitions(new HashSet<InnerExtensionDefinition>());
                    }
                    innerClassExtensionDefinition.appendInnerClassExtensionDefinitions(innerExtensionDefinition.getInnerClassExtensionDefinitions());
                }
                if (innerExtensionDefinition.getProperties() != null) {
                    if (innerClassExtensionDefinition.getProperties() == null) {
                        innerClassExtensionDefinition.setProperties(new HashSet<PropertyDefinition>());
                    }
                    innerClassExtensionDefinition.getProperties().addAll(innerExtensionDefinition.getProperties());
                }
                if (innerExtensionDefinition.getInterfaces() != null) {
                    if (innerClassExtensionDefinition.getInterfaces() == null) {
                        innerClassExtensionDefinition.setInterfaces(new HashSet<String>());
                    }
                    innerClassExtensionDefinition.getInterfaces().addAll(innerExtensionDefinition.getInterfaces());
                }
                if (innerExtensionDefinition.getAnnotations() != null) {
                    if (innerClassExtensionDefinition.getAnnotations() == null) {
                        innerClassExtensionDefinition.setAnnotations(new HashSet<AnnotationDefinition>());
                    }
                    innerClassExtensionDefinition.getAnnotations().addAll(innerExtensionDefinition.getAnnotations());
                }
                if (innerExtensionDefinition.getStringAnnotations() != null) {
                    if (innerClassExtensionDefinition.getStringAnnotations() == null) {
                        innerClassExtensionDefinition.setStringAnnotations(new HashSet<String>());
                    }
                    innerClassExtensionDefinition.getStringAnnotations().addAll(innerExtensionDefinition.getStringAnnotations());
                }
                break;
            }
        } else {
            outerDefinition.appendInnerClassExtensionDefinition(innerExtensionDefinition);
        }
    }
}

