/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins.resolve;

import com.dtyunxi.huieryun.maven.plugins.annotations.CubePropertyExtension;
import com.dtyunxi.huieryun.maven.plugins.definition.AnnotationDefinition;
import com.dtyunxi.huieryun.maven.plugins.definition.ExtensionDefinition;
import com.dtyunxi.huieryun.maven.plugins.definition.PropertyDefinition;
import com.dtyunxi.huieryun.maven.plugins.resolve.OriginClassInfo;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFileParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaFileParser.class);
    private File sourceDir;
    private BiFunction<OriginClassInfo, Map<String, ExtensionDefinition>, Void> resolveOriginClass;

    public JavaFileParser(File sourceDir, BiFunction<OriginClassInfo, Map<String, ExtensionDefinition>, Void> resolveOriginClass) {
        this.sourceDir = sourceDir;
        this.resolveOriginClass = resolveOriginClass;
    }

    public void process(Map<String, ExtensionDefinition> extensionDefinitionMap, Set<Class<?>> jarClassSet) {
        try {
            HashMap jarClassMap = new HashMap();
            for (Class<?> jarClass : jarClassSet) {
                if (jarClass == null) continue;
                jarClassMap.put(jarClass.getName(), jarClass);
            }
            this.recursionFile(jarClassMap, extensionDefinitionMap, this.sourceDir);
        }
        catch (Exception exception) {
            LOGGER.error("\u8bfb\u53d6\u6e90\u7801\u4fe1\u606f\u5f02\u5e38", (Throwable)exception);
        }
    }

    public static CompilationUnit parser(File javaFile) throws FileNotFoundException {
        CombinedTypeSolver typeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        JavaSymbolSolver symbolSolver = new JavaSymbolSolver((TypeSolver)typeSolver);
        JavaParser.getStaticConfiguration().setSymbolResolver((SymbolResolver)symbolSolver);
        return JavaParser.parse((File)javaFile);
    }

    private void recursionFile(Map<String, Class<?>> jarClassMap, Map<String, ExtensionDefinition> extensionDefinitionMap, File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File child : files) {
                this.recursionFile(jarClassMap, extensionDefinitionMap, child);
            }
        } else {
            this.resolveJavaFile(jarClassMap, extensionDefinitionMap, file);
        }
    }

    private void resolveJavaFile(Map<String, Class<?>> jarClassMap, Map<String, ExtensionDefinition> extensionDefinitionMap, File file) throws IOException {
        CompilationUnit compilationUnit = JavaFileParser.parser(file);
        NodeList imports = compilationUnit.getImports();
        HashSet<String> importList = new HashSet<String>();
        Map<String, String> className2PackageName = this.readImportList((NodeList<ImportDeclaration>)imports, importList);
        for (Node childNode : compilationUnit.getChildNodes()) {
            ClassOrInterfaceDeclaration classOrInterfaceDeclaration;
            Optional annotationByClass;
            if (!(childNode instanceof ClassOrInterfaceDeclaration) || (annotationByClass = (classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)childNode).getAnnotationByClass(CubePropertyExtension.class)) == null || !annotationByClass.isPresent()) continue;
            HashSet<PropertyDefinition> properties = new HashSet<PropertyDefinition>();
            this.readFields(compilationUnit, classOrInterfaceDeclaration, properties);
            this.readOriginalClass(jarClassMap, extensionDefinitionMap, importList, className2PackageName, annotationByClass, properties);
        }
    }

    private void readOriginalClass(Map<String, Class<?>> jarClassMap, Map<String, ExtensionDefinition> extensionDefinitionMap, Set<String> importList, Map<String, String> className2PackageName, Optional<AnnotationExpr> annotationByClass, Set<PropertyDefinition> properties) {
        AnnotationExpr annotationExpr = annotationByClass.get();
        for (Node node : annotationExpr.getChildNodes()) {
            if (!(node instanceof MemberValuePair)) continue;
            MemberValuePair memberValuePair = (MemberValuePair)node;
            Expression value = memberValuePair.getValue();
            if (value instanceof ArrayInitializerExpr) {
                ArrayInitializerExpr arrayInitializerExpr = (ArrayInitializerExpr)value;
                for (Expression arrayInitializerExprValue : arrayInitializerExpr.getValues()) {
                    ClassExpr classExpr = (ClassExpr)arrayInitializerExprValue;
                    this.singleResolve(jarClassMap, extensionDefinitionMap, importList, className2PackageName, properties, classExpr);
                }
                continue;
            }
            if (!(value instanceof ClassExpr)) continue;
            ClassExpr classExpr = (ClassExpr)value;
            this.singleResolve(jarClassMap, extensionDefinitionMap, importList, className2PackageName, properties, classExpr);
        }
    }

    private void singleResolve(Map<String, Class<?>> jarClassMap, Map<String, ExtensionDefinition> extensionDefinitionMap, Set<String> importList, Map<String, String> className2PackageName, Set<PropertyDefinition> properties, ClassExpr classExpr) {
        ClassOrInterfaceType type = (ClassOrInterfaceType)classExpr.getType();
        ExtensionDefinition extensionDefinition = new ExtensionDefinition();
        extensionDefinition.setProperties(new HashSet<PropertyDefinition>());
        if (properties != null) {
            for (PropertyDefinition property : properties) {
                extensionDefinition.getProperties().add(property);
            }
        }
        extensionDefinition.setImports(importList);
        String name = type.toString().replace(".", "$");
        String toFetchPkgTypeName = type.toString().split("\\.")[0];
        extensionDefinition.setName(name);
        String pkgName = className2PackageName.get(toFetchPkgTypeName);
        extensionDefinition.setPkg(pkgName);
        String original = pkgName + "." + name;
        Class<?> originalClass = jarClassMap.get(original);
        if (originalClass == null) {
            LOGGER.error("\u539f\u59cb\u7c7b\u52a0\u8f7d\u5931\u8d25:" + original);
        } else {
            this.resolveOriginClass.apply(new OriginClassInfo(originalClass, extensionDefinition.getImports(), extensionDefinition.getProperties()), extensionDefinitionMap);
        }
    }

    private void readFields(CompilationUnit compilationUnit, ClassOrInterfaceDeclaration classOrInterfaceDeclaration, Set<PropertyDefinition> properties) {
        for (BodyDeclaration member : classOrInterfaceDeclaration.getMembers()) {
            if (!(member instanceof FieldDeclaration)) continue;
            PropertyDefinition propertyDefinition = new PropertyDefinition();
            HashSet<AnnotationDefinition> propertyAnnotations = new HashSet<AnnotationDefinition>();
            FieldDeclaration fieldDeclaration = (FieldDeclaration)member;
            VariableDeclarator variableDeclarator = (VariableDeclarator)fieldDeclaration.getVariables().get(0);
            String propertyName = variableDeclarator.getName().getIdentifier();
            propertyDefinition.setName(propertyName);
            propertyDefinition.setType(variableDeclarator.getType().toString());
            if (variableDeclarator.getInitializer().isPresent()) {
                propertyDefinition.setDefaultValue(((Expression)variableDeclarator.getInitializer().get()).toString());
            }
            propertyDefinition.setExtSourceClzName(((PackageDeclaration)compilationUnit.getPackageDeclaration().get()).getNameAsString() + "." + ((TypeDeclaration)compilationUnit.getTypes().get(0)).getName());
            NodeList annotations = fieldDeclaration.getAnnotations();
            this.readAnnotations4Field(propertyAnnotations, (NodeList<AnnotationExpr>)annotations);
            propertyDefinition.setAnnotations(propertyAnnotations);
            properties.add(propertyDefinition);
        }
    }

    private void readAnnotations4Field(Set<AnnotationDefinition> propertyAnnotations, NodeList<AnnotationExpr> annotations) {
        for (AnnotationExpr annotation : annotations) {
            if (!(annotation instanceof NormalAnnotationExpr)) continue;
            NormalAnnotationExpr normalAnnotationExpr = (NormalAnnotationExpr)annotation;
            AnnotationDefinition annotationDefinition = new AnnotationDefinition();
            annotationDefinition.setName(normalAnnotationExpr.getNameAsString());
            HashMap<String, Object> memberValues = new HashMap<String, Object>();
            NodeList pairs = normalAnnotationExpr.getPairs();
            for (MemberValuePair pair : pairs) {
                Expression value = pair.getValue();
                if (value instanceof StringLiteralExpr) {
                    memberValues.put(pair.getNameAsString(), ((StringLiteralExpr)value).getValue());
                    continue;
                }
                if (value instanceof IntegerLiteralExpr) {
                    memberValues.put(pair.getNameAsString(), ((IntegerLiteralExpr)value).asInt());
                    continue;
                }
                if (value instanceof DoubleLiteralExpr) {
                    memberValues.put(pair.getNameAsString(), ((DoubleLiteralExpr)value).asDouble());
                    continue;
                }
                if (value instanceof CharLiteralExpr) {
                    memberValues.put(pair.getNameAsString(), Character.valueOf(((CharLiteralExpr)value).asChar()));
                    continue;
                }
                if (value instanceof LongLiteralExpr) {
                    memberValues.put(pair.getNameAsString(), ((LongLiteralExpr)value).asLong());
                    continue;
                }
                if (!(value instanceof BooleanLiteralExpr)) continue;
                memberValues.put(pair.getNameAsString(), ((BooleanLiteralExpr)value).getValue());
            }
            annotationDefinition.setMemberValues(memberValues);
            propertyAnnotations.add(annotationDefinition);
        }
    }

    private Map<String, String> readImportList(NodeList<ImportDeclaration> imports, Set<String> importList) {
        HashMap<String, String> className2PackageName = new HashMap<String, String>();
        for (ImportDeclaration importItem : imports) {
            String nameAsString = importItem.getNameAsString();
            String[] split = nameAsString.split("\\.");
            StringBuilder packageName = new StringBuilder();
            String className = split[split.length - 1];
            packageName.append(split[0]);
            for (int i = 1; i < split.length - 1; ++i) {
                packageName.append(".").append(split[i]);
            }
            className2PackageName.put(className, packageName.toString());
            importList.add("import " + nameAsString + ";");
        }
        return className2PackageName;
    }
}

