/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins.util;

import com.dtyunxi.huieryun.maven.plugins.vo.ClassInfoVo;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassScanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassScanUtils.class);

    public static Set<Class<?>> getJarClass(List<String> compileClasspathElements, ClassLoader classLoader) {
        HashMap<String, ClassInfoVo> classInfoVoMap = new HashMap<String, ClassInfoVo>();
        for (String jarPath : compileClasspathElements) {
            try {
                if (jarPath.toLowerCase().endsWith(".jar")) {
                    LOGGER.debug("\u4ecejar\u5305\u76ee\u5f55\u52a0\u8f7d");
                    ClassScanUtils.addJarClasses(classLoader, classInfoVoMap, jarPath);
                    continue;
                }
                if (!jarPath.endsWith(File.separator + "classes")) continue;
                LOGGER.debug("\u4ece\u4e3b\u5de5\u7a0b\u7684classes\u76ee\u5f55\u52a0\u8f7d");
                ClassScanUtils.addFolderClasses(classLoader, classInfoVoMap, jarPath);
            }
            catch (Exception e) {
                LOGGER.error("\u4ece{}\u83b7\u53d6jar\u5305\u4e0b\u7684\u7c7b\u5f02\u5e38", (Object)jarPath, (Object)e);
            }
        }
        return classInfoVoMap.values().stream().map(ClassInfoVo::getClz).collect(Collectors.toSet());
    }

    private static void addFolderClasses(ClassLoader classLoader, Map<String, ClassInfoVo> classInfoVoSet, String baseFolderPath) {
        File file = new File(baseFolderPath);
        if (file != null && file.exists() && file.isDirectory()) {
            ClassScanUtils.addFileClassesUnderFolder(classLoader, classInfoVoSet, file, baseFolderPath);
        }
    }

    private static void addFileClassesUnderFolder(ClassLoader classLoader, Map<String, ClassInfoVo> classInfoVoMap, File folder, String baseFolderPath) {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ClassScanUtils.addFileClassesUnderFolder(classLoader, classInfoVoMap, file, baseFolderPath);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String absolutePath = file.getAbsolutePath();
            try {
                String className = absolutePath.substring(baseFolderPath.length() + 1, absolutePath.lastIndexOf(".")).replace(File.separator, ".");
                ClassScanUtils.load0(classLoader, classInfoVoMap, baseFolderPath, className);
            }
            catch (Throwable e) {
                LOGGER.warn("could not load class {}, reason: Class not found {}", (Object)absolutePath, (Object)e.getMessage());
            }
        }
    }

    private static void load0(ClassLoader classLoader, Map<String, ClassInfoVo> classInfoVoMap, String baseFolderPath, String className) throws ClassNotFoundException {
        if (classInfoVoMap.containsKey(className)) {
            ClassInfoVo classInfoVo = classInfoVoMap.get(className);
            LOGGER.warn("{}\u7c7b\u5df2\u4ece\u8def\u5f84{}\u52a0\u8f7d\u8fc7\uff0c\u4e0d\u91cd\u65b0\u52a0\u8f7d", (Object)className, (Object)classInfoVo.getSourcePath());
        } else {
            LOGGER.debug("\u52a0\u8f7d\u8def\u5f84{}\u7c7b:{}", (Object)baseFolderPath, (Object)className);
            Class<?> myClass = classLoader.loadClass(className);
            classInfoVoMap.put(className, new ClassInfoVo(className, baseFolderPath, myClass));
        }
    }

    private static void addJarClasses(ClassLoader classLoader, Map<String, ClassInfoVo> classInfoVoMap, String jarPath) throws IOException {
        JarFile jarFile = new JarFile(jarPath);
        Enumeration<JarEntry> enu = jarFile.entries();
        while (enu.hasMoreElements()) {
            String name;
            JarEntry jarEntry = enu.nextElement();
            if (jarEntry == null || !(name = jarEntry.getName()).endsWith(".class")) continue;
            try {
                String className = name.substring(0, name.lastIndexOf(".")).replace("/", ".");
                ClassScanUtils.load0(classLoader, classInfoVoMap, jarPath, className);
            }
            catch (Throwable e) {
                LOGGER.warn("could not load class {}, reason: Class not found {}", (Object)name, (Object)e.getMessage());
            }
        }
    }
}

