/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.maven.plugins.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    public static void mkdirParentDirectory(File file) {
        if (file.exists()) {
            return;
        }
        FileUtils.mkdirParentDirectory(file.getParentFile());
        LOGGER.debug("\u521b\u5efa\u76ee\u5f55:{}", (Object)file.getAbsolutePath());
        file.mkdir();
    }

    public static void unzip(File jarFile, String destDirPath, Function<ZipEntry, Boolean> directoryFunction, Function<ZipEntry, Boolean> fileFunction) {
        try {
            ZipFile zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                LOGGER.debug("jar\u5305\u5143\u7d20\uff1a{}", (Object)entry.getName());
                if (!directoryFunction.apply(entry).booleanValue()) continue;
                LOGGER.debug("\u89e3\u538bjar\u5305\u5143\u7d20\uff1a{}", (Object)entry.getName());
                if (entry.isDirectory()) {
                    String dirPath = destDirPath + "/" + entry.getName();
                    File dir = new File(dirPath);
                    dir.mkdirs();
                    continue;
                }
                if (!fileFunction.apply(entry).booleanValue()) continue;
                File targetFile = new File(destDirPath + "/" + entry.getName());
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                targetFile.createNewFile();
                try {
                    InputStream is = zipFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        FileOutputStream fos = new FileOutputStream(targetFile);
                        Throwable throwable2 = null;
                        try {
                            int len;
                            byte[] buf = new byte[1024];
                            while ((len = is.read(buf)) != -1) {
                                fos.write(buf, 0, len);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (fos == null) continue;
                            if (throwable2 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            fos.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (IOException ioException) {
                    LOGGER.error("\u8bfb\u53d6jar\u5305\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)ioException);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("\u6253\u5f00jar\u5305\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

