/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.marketing.biz.condition;

import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.module.bitem.api.IBitemService;
import com.dtyunxi.yundt.module.bitem.api.dto.ItemChangeApplyDetailDto;
import com.dtyunxi.yundt.module.marketing.api.common.BaseActivityTobDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.GroupActivityItemDto;
import com.dtyunxi.yundt.module.marketing.api.dto.request.group.GroupActivityItemSkuDto;
import com.dtyunxi.yundt.module.marketing.biz.condition.ConditionTemplate;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractBaseTemplate
implements ConditionTemplate {
    public ConditionReqDto getConditionReqDto() {
        ConditionReqDto conditionReqDto = new ConditionReqDto();
        conditionReqDto.setConditionTemplateId(Long.valueOf(this.getConditionTemplateId()));
        conditionReqDto.setConditionParams("{}");
        return conditionReqDto;
    }

    @Override
    public <T extends BaseActivityTobDto> void parseCondition(List<ConditionRespDto> conditionRespDtos, T t) {
        conditionRespDtos.stream().filter(conditionRespDto -> conditionRespDto.getConditionTemplateId().equals(this.getConditionTemplateId())).findFirst().ifPresent(conditionRespDto -> this.parse((ConditionRespDto)conditionRespDto, t));
    }

    protected abstract <T extends BaseActivityTobDto> void parse(ConditionRespDto var1, T var2);

    protected List<GroupActivityItemDto> getGroupActivityItems(Long id) {
        IActivityItemQueryApi activityItemQueryApi = (IActivityItemQueryApi)SpringBeanUtil.getBean(IActivityItemQueryApi.class);
        IBitemService itemService = (IBitemService)SpringBeanUtil.getBean(IBitemService.class);
        IShopQueryApi shopQueryApi = (IShopQueryApi)SpringBeanUtil.getBean(IShopQueryApi.class);
        ActivityItemQueryReqDto activityItemQueryReqDto = new ActivityItemQueryReqDto();
        activityItemQueryReqDto.setActivityId(id);
        List items = (List)activityItemQueryApi.queryAll(activityItemQueryReqDto).getData();
        Map<String, List<ActivityItemRespDto>> group = items.stream().collect(Collectors.groupingBy(activityItem -> activityItem.getShopId() + activityItem.getItemId().toString()));
        ArrayList groupActivityItemDtos = Lists.newArrayList();
        group.forEach((shopItemKey, itemDtos) -> {
            Long itemId = ((ActivityItemRespDto)itemDtos.get(0)).getItemId();
            Long shopId = ((ActivityItemRespDto)itemDtos.get(0)).getShopId();
            ItemChangeApplyDetailDto itemDetail = itemService.getDetailByItemId(shopId, itemId, ItemBusTypeEnum.ORDINARY.getType());
            if (null == itemDetail) {
                return;
            }
            GroupActivityItemDto groupActivityItemDto = new GroupActivityItemDto();
            groupActivityItemDto.setItemId(itemId);
            groupActivityItemDto.setItemCode(itemDetail.getItemCode());
            groupActivityItemDto.setItemName(itemDetail.getItemName());
            groupActivityItemDto.setShopId(shopId);
            if (null != shopId) {
                ShopBaseDto shopDto = (ShopBaseDto)shopQueryApi.queryBaseById(shopId).getData();
                groupActivityItemDto.setShopName(shopDto == null ? null : shopDto.getName());
            }
            Long totalStock = 0L;
            ArrayList skus = Lists.newArrayList();
            BigDecimal minPrice = BigDecimal.ZERO;
            for (ActivityItemRespDto skuDto : itemDtos) {
                GroupActivityItemSkuDto sku = new GroupActivityItemSkuDto();
                sku.setActivityStock(skuDto.getOriginalStock());
                sku.setGroupPrice(skuDto.getActivityPrice());
                sku.setItemId(skuDto.getItemId());
                sku.setSkuId(skuDto.getSkuId());
                itemDetail.getSkuList().stream().filter(skuRespDto -> skuRespDto.getId().equals(skuDto.getSkuId())).findFirst().ifPresent(itemSku -> {
                    if (null != itemSku.getAttrMap()) {
                        String skuName = StringUtils.join(itemSku.getAttrMap().values(), (String)" ");
                        sku.setSkuName(skuName);
                    }
                });
                BigDecimal price = itemService.queryItemPrice(shopId, skuDto.getItemId(), skuDto.getSkuId());
                if (null != price && price.compareTo(minPrice) == -1) {
                    minPrice = price;
                }
                sku.setSellPrice(price);
                Long stock = itemService.queryVirStorage(shopId, null, skuDto.getSkuId());
                sku.setStock(stock);
                totalStock = totalStock + stock;
                skus.add(sku);
            }
            groupActivityItemDto.setSkus((List)skus);
            groupActivityItemDto.setTotalStock(totalStock);
            groupActivityItemDto.setSellPrice(minPrice);
            groupActivityItemDtos.add(groupActivityItemDto);
        });
        return groupActivityItemDtos;
    }
}

