/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.customer.api.dto.response.BrandDirRespDto;
import com.dtyunxi.yundt.module.customer.api.dto.response.ItemDirRespDto;
import com.dtyunxi.yundt.module.customer.api.enums.SrcTypeEnum;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u5546\u7ec4\u4ef6\uff1a\u5546\u54c1\u76f8\u5173\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/item"})
public class ItemRestV1 {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContext context;
    @Resource
    private IBrandQueryApi iBrandQueryApi;
    @Resource
    private IDirectoryQueryApi iDirectoryQueryApi;
    @Value(value="${item.rootId:1230318625350978670}")
    private Long frontRootId;
    @Value(value="${item.back.rootId:1230317884640037892}")
    private Long backRootId;

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u54c1\u724c", notes="\u83b7\u53d6\u6240\u6709\u54c1\u724c")
    @GetMapping(value={"/list/brand"})
    public RestResponse queryBrandList() {
        JSONObject filter = new JSONObject();
        filter.put("tenantId", (Object)this.context.tenantId());
        filter.put("instanceId", (Object)this.context.instanceId());
        filter.put("status", (Object)1);
        RestResponse pageInfoRestResponse = this.iBrandQueryApi.queryByPage(filter.toJSONString(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        return pageInfoRestResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u54c1\u724c\u6811", notes="\u83b7\u53d6\u6240\u6709\u54c1\u724c\u6811")
    @GetMapping(value={"/list/brand/tree"})
    public RestResponse queryBrandTree() {
        JSONObject filter = new JSONObject();
        filter.put("tenantId", (Object)this.context.tenantId());
        filter.put("instanceId", (Object)this.context.instanceId());
        filter.put("status", (Object)1);
        RestResponse pageInfoRestResponse = this.iBrandQueryApi.queryByPage(filter.toJSONString(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        BrandDirRespDto brandDirRespDto = new BrandDirRespDto();
        brandDirRespDto.setBrandId(Long.valueOf(999999999999L));
        brandDirRespDto.setLabel("\u6240\u6709\u54c1\u724c");
        brandDirRespDto.setValue("999999999999");
        if (pageInfoRestResponse == null || pageInfoRestResponse.getData() == null || ((PageInfo)pageInfoRestResponse.getData()).getList() == null) {
            return new RestResponse((Object)brandDirRespDto);
        }
        brandDirRespDto.setChildren(this.getBrandDirRespDtos(((PageInfo)pageInfoRestResponse.getData()).getList()));
        return new RestResponse((Object)brandDirRespDto);
    }

    @NotNull
    private List<BrandDirRespDto> getBrandDirRespDtos(List<BrandRespDto> list) {
        ArrayList<BrandDirRespDto> brandRespDtos = new ArrayList<BrandDirRespDto>();
        for (BrandRespDto brandRespDto : list) {
            BrandDirRespDto newBrand = new BrandDirRespDto();
            newBrand.setValue(brandRespDto.getId().toString());
            newBrand.setLabel(brandRespDto.getName());
            newBrand.setBrandId(brandRespDto.getId());
            brandRespDtos.add(newBrand);
        }
        return brandRespDtos;
    }

    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u6811", notes="\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u6811,root\u9ed8\u8ba4id:1230051610462451788(\u8fd4\u56de\u7279\u5b9a\u7684\u683c\u5f0f)")
    @GetMapping(value={"/list/dir"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="dirType", value="\u7c7b\u76ee\u7c7b\u578b\uff1a1 \u540e\u53f0\u7c7b\u76ee,2 \u524d\u53f0\u7c7b\u76ee,\u9ed8\u8ba4\u662f2\u524d\u53f0\u7c7b\u76ee", dataType="Int", paramType="query")})
    public RestResponse queryAreaList(@RequestParam(value="dirType", required=false) Integer dirType) {
        this.logger.info("\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u6811rootId[{}]", (Object)this.frontRootId);
        Long rootId = this.frontRootId;
        if (SrcTypeEnum.CUSTOMER.getCode().equals(dirType)) {
            rootId = this.backRootId;
        }
        JSONObject filter = new JSONObject();
        filter.put("status", (Object)1);
        RestResponse treeDtoRestResponse = this.iDirectoryQueryApi.queryDirectoryTree(rootId, filter.toJSONString());
        TreeDto child = (TreeDto)treeDtoRestResponse.getData();
        if (null == child || child.getNode() == null) {
            return new RestResponse();
        }
        ItemDirRespDto itemDirRespDto = new ItemDirRespDto();
        this.buildNode(itemDirRespDto, (DirectoryItemRespDto)child.getNode());
        if (CollectionUtils.isNotEmpty((Collection)child.getChildren())) {
            itemDirRespDto.setChildren(this.buildChildren(child.getChildren()));
        }
        return new RestResponse((Object)itemDirRespDto);
    }

    private List<ItemDirRespDto> buildChildren(List<TreeDto<DirectoryItemRespDto>> children) {
        ArrayList<ItemDirRespDto> itemDirRespDtos = new ArrayList<ItemDirRespDto>(children.size());
        for (TreeDto<DirectoryItemRespDto> child : children) {
            ItemDirRespDto itemDirRespDto = new ItemDirRespDto();
            DirectoryItemRespDto node = (DirectoryItemRespDto)child.getNode();
            this.buildNode(itemDirRespDto, node);
            if (CollectionUtils.isNotEmpty((Collection)child.getChildren())) {
                itemDirRespDto.setChildren(this.buildChildren(child.getChildren()));
            }
            itemDirRespDtos.add(itemDirRespDto);
        }
        return itemDirRespDtos;
    }

    private void buildNode(ItemDirRespDto itemDirRespDto, DirectoryItemRespDto node) {
        itemDirRespDto.setLabel(node.getName());
        itemDirRespDto.setValue(node.getId().toString());
    }
}

