/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.customer.rest.user;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.module.customer.api.user.IOauth2Login;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7528\u6237\u7ec4\u4ef6\uff1a\u7b2c\u4e09\u65b9\u767b\u5f55\u670d\u52a1\uff08\u76ee\u524d\u4ec5\u652f\u6301\u5fae\u4fe1\uff09"})
@RestController
@RequestMapping(value={"/v1/user/oauth2"})
public class Oauth2LoginRest {
    private static final Logger logger = LoggerFactory.getLogger(Oauth2LoginRest.class);
    @Resource
    private IOauth2Login oauth2Login;
    @Resource
    private ICacheService cacheService;

    @ApiOperation(value="\u7b2c\u4e00\u6b65\uff1a\u83b7\u53d6\u767b\u5f55\u6388\u6743\u5730\u5740", notes="\u7b2c\u4e09\u65b9\u7c7b\u578b\uff081\uff1a\u5fae\u4fe1\uff0c2\uff1aQQ\uff0c3\uff1aSina\u5fae\u535a\uff09")
    @GetMapping(value={"/uri"})
    public RestResponse<String> getAuthUri(AuthLoginReqDto authLoginReqDto) {
        return new RestResponse((Object)this.oauth2Login.getAuthUri(authLoginReqDto));
    }

    @GetMapping(value={"/code"})
    @ApiOperation(value="\u63a5\u53d7\u5fae\u4fe1\u7f51\u9875\u6388\u6743code,\u91cd\u5b9a\u5411\u5230redirectUri", notes="\u56e0\u4e3a\u524d\u7aefredirectUri\u4e2d\u5e26\u6709#\u53f7\uff0c\u5fae\u4fe1\u91cd\u5b9a\u5411\u4f1a\u4e22\u5931\uff0c\u6240\u4ee5\u540e\u7aef\u670d\u52a1\u91cd\u5b9a\u5411")
    public void redirectUri(String code, String uriKey, HttpServletResponse httpServletResponse) {
        logger.info("\u5fae\u4fe1\u7f51\u9875\u6388\u6743code={}, uri={}", (Object)code, (Object)uriKey);
        String redirectUri = (String)this.cacheService.getCache(uriKey, String.class);
        if (StringUtils.isBlank((CharSequence)redirectUri)) {
            throw new BizException("\u7f3a\u5c11redirectUri\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!");
        }
        int index = redirectUri.indexOf("?");
        String codeStr = null;
        codeStr = index > 0 ? "&code=" + code : "?code=" + code;
        redirectUri = redirectUri + codeStr;
        try {
            httpServletResponse.sendRedirect(redirectUri);
        }
        catch (IOException e) {
            logger.error("\u5ffd\u7565\u91cd\u5b9a\u5411\u5f02\u5e38");
        }
    }

    @ApiOperation(value="\u7b2c\u4e8c\u6b65\uff1a\u901a\u8fc7\u7b2c\u4e09\u65b9\u6388\u6743\u7801code\u7533\u8bf7\u8ba4\u8bc1\u4e2d\u5fc3token\u4ee4\u724c", notes="\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\u7801\uff0c\u9700\u8981\u7b2c\u4e09\u6b65\u7ed1\u5b9a\u624b\u673a\u53f7\u7801")
    @PostMapping(value={"/token"})
    public RestResponse<ThirdLoginRespDto> getAuthToken(@Valid @RequestBody AuthLoginTokenReqDto authLoginTokenReqDto) {
        return new RestResponse((Object)this.oauth2Login.getAuthToken(authLoginTokenReqDto));
    }

    @ApiOperation(value="\u7b2c\u4e09\u6b65\uff1aopenId\u7ed1\u5b9a\u624b\u673a\u53f7,\u5e76\u751f\u6210\u8ba4\u8bc1\u4e2d\u5fc3token\u4ee4\u724c")
    @PostMapping(value={"/bind"})
    public RestResponse<TokenRespDto> bind(@RequestBody UserBindLoginThirdDto userBindLoginThirdDto) {
        return new RestResponse((Object)this.oauth2Login.bind(userBindLoginThirdDto));
    }
}

