/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.message.service.impl;

import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosAlert;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.comm.vo.admin.MessageTemplateVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.pearlriver.constants.MessageApplicationEnum;
import com.dtyunxi.pearlriver.message.service.JiGuangSendService;
import com.dtyunxi.pearlriver.utils.StringFormatUtil;
import com.dtyunxi.pearlriver.vo.JPushClientService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class JiGuangSendServiceImpl
implements JiGuangSendService {
    private static Logger logger = LoggerFactory.getLogger(JiGuangSendServiceImpl.class);
    private static final String IOS_SOUND_CAF = "sound.caf";
    @Autowired
    private JPushClientService jPushClientService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    public void send(final MessageApplicationEnum messageApplicationEnum, final MessageTemplateVo templateVo, final String content, final String ... targets) {
        this.threadPoolTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("-------\u53d1\u9001\u7ed9\u6307\u5b9a\u7528\u6237--------" + JSONObject.toJSONString((Object)templateVo));
                    PushPayload pushPayload = JiGuangSendServiceImpl.this.getPushPayload(templateVo, content, targets);
                    logger.info("-------pushPayload--------" + pushPayload);
                    logger.info("messageApplicationEnum: " + (Object)((Object)messageApplicationEnum));
                    PushResult pushResult = JiGuangSendServiceImpl.this.getJPushClient(messageApplicationEnum).sendPush(pushPayload);
                    logger.info("\u53d1\u9001\u7ed9\u6240\u6709\u7528\u6237,pushResult{}", (Object)pushResult);
                }
                catch (APIRequestException e) {
                    logger.error(e.getErrorMessage() + " " + e.getErrorCode());
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u7ed9\u6240\u6709\u7528\u6237\u5931\u8d25", (Throwable)e);
                    throw new BusinessRuntimeException("\u53d1\u9001\u7ed9\u6240\u6709\u7528\u6237\u5931\u8d25");
                }
            }
        });
    }

    private JPushClient getJPushClient(MessageApplicationEnum messageApplicationEnum) {
        logger.info("jPushClientService: " + this.jPushClientService);
        Map<String, JPushClient> map = this.jPushClientService.getjPushClient();
        logger.info("map: " + JSONObject.toJSONString(map));
        return map.get(messageApplicationEnum.getCode());
    }

    private PushPayload getPushPayload(MessageTemplateVo templateVo, String content, String ... targets) {
        AndroidNotification androidNotification = ((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert((Object)content).setTitle(templateVo.getTitle()).addExtras(StringFormatUtil.changeExtrasParam(templateVo.getExtrasParam()))).build();
        IosAlert iosAlert = IosAlert.newBuilder().setTitleAndBody(templateVo.getTitle(), null, content).build();
        IosNotification iosNotification = ((IosNotification.Builder)IosNotification.newBuilder().setAlert((Object)iosAlert).setSound(IOS_SOUND_CAF).addExtras(StringFormatUtil.changeExtrasParam(templateVo.getExtrasParam()))).build();
        Notification notification = Notification.newBuilder().setAlert((Object)templateVo.getTitle()).addPlatformNotification((PlatformNotification)androidNotification).addPlatformNotification((PlatformNotification)iosNotification).build();
        Message message = Message.newBuilder().setTitle(templateVo.getTitle()).setMsgContent(content).build();
        Audience audience = null == targets || targets.length == 0 ? Audience.all() : Audience.alias((String[])targets);
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(audience).setNotification(notification).setMessage(message).build();
    }
}

