/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.comm.api.IMessageManagerService;
import com.dtyunxi.huieryun.comm.api.IMessageSender;
import com.dtyunxi.huieryun.comm.vo.MessageVo;
import com.dtyunxi.huieryun.comm.vo.admin.MessageTemplateVo;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.pearlriver.constants.AwardMessageContants;
import com.dtyunxi.pearlriver.constants.MessageApplicationEnum;
import com.dtyunxi.pearlriver.constants.UserTypeEnum;
import com.dtyunxi.pearlriver.mall.mgmt.api.MailMessageApi;
import com.dtyunxi.pearlriver.mall.mgmt.api.query.MessageTemplateExtendQueryApi;
import com.dtyunxi.pearlriver.mall.mgmt.dto.MailMessageDto;
import com.dtyunxi.pearlriver.mall.mgmt.dto.MessageTemplateExtendDto;
import com.dtyunxi.pearlriver.message.service.JiGuangSendService;
import com.dtyunxi.pearlriver.message.service.MessageSendService;
import com.dtyunxi.pearlriver.utils.ResponseDataUtil;
import com.dtyunxi.pearlriver.utils.StringFormatUtil;
import com.dtyunxi.pearlriver.vo.AppVos;
import com.dtyunxi.pearlriver.vo.MessageDto;
import com.dtyunxi.pearlriver.vo.MessagePushDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class MessageSendServiceImpl
implements MessageSendService {
    private static Logger logger = LoggerFactory.getLogger(MessageSendServiceImpl.class);
    @Autowired
    private IMessageSender messageSender;
    @Resource
    private IMessageManagerService messageManagerService;
    @Autowired
    private MessageTemplateExtendQueryApi templateExtendQueryApi;
    @Autowired
    private JiGuangSendService jiGuangSendService;
    @Autowired
    private MailMessageApi mailMessageApi;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private AppVos appVos;

    @Override
    public void sendMessage(MessageApplicationEnum messageApplicationEnum, UserTypeEnum userTypeEnum, MessageDto dto, Map<String, String> mapValue, String messageCode) {
        StringBuilder sbd = new StringBuilder();
        sbd.append(JSONObject.toJSONString((Object)dto));
        sbd.append(";");
        sbd.append(JSONObject.toJSONString(mapValue));
        sbd.append(";");
        sbd.append(messageCode);
        logger.info("\u5165\u53c2:" + sbd.toString());
        if (null == dto || StringUtils.isBlank((CharSequence)messageCode)) {
            logger.error("\u5165\u53c2\u6709\u95ee\u9898\uff0c\u7528\u6237\u4fe1\u606f\u53camessageCode\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        try {
            MessageTemplateExtendDto templateExtendDto;
            if (StringUtils.isNotBlank((CharSequence)messageCode) && null != (templateExtendDto = (MessageTemplateExtendDto)ResponseDataUtil.checkResponse(this.templateExtendQueryApi.queryTemplate(messageCode)))) {
                MessageTemplateVo vo = this.getMessageTemplateVo(templateExtendDto.getMessageTemplateId());
                if (null == vo) {
                    logger.info("\u83b7\u53d6\u4e0d\u5230\u6a21\u677f\u4fe1\u606f");
                    return;
                }
                vo.setContent(templateExtendDto.getTemplateContent());
                String content = StringFormatUtil.getContentByHold(vo.getContent(), mapValue);
                if (Objects.equals(templateExtendDto.getSmsIsOpen(), 1) && StringUtils.isNotBlank((CharSequence)dto.getPhoneCode())) {
                    this.sendSms(dto, mapValue, vo);
                }
                if (Objects.equals(templateExtendDto.getAppIsOpen(), 1)) {
                    String targets = null;
                    if (null != dto.getUserId()) {
                        targets = dto.getUserId() + "";
                    }
                    if (StringUtils.isNotBlank(targets) && StringUtils.isNotBlank((CharSequence)this.appVos.getEnvironment())) {
                        targets = this.appVos.getEnvironment() + "_" + targets;
                    }
                    if (null != dto.getMessagePushDto()) {
                        MessagePushDto messagePushDto = dto.getMessagePushDto();
                        String url = messagePushDto.getMessagePushEnum().getUrl();
                        String parameter = messagePushDto.getMessagePushEnum().getParameter();
                        parameter = url + "?" + parameter + "=" + messagePushDto.getValue();
                        HashMap<String, String> map = new HashMap<String, String>(10);
                        map.put("action", parameter);
                        vo.setExtrasParam(JSONObject.toJSONString(map));
                    }
                    this.jiGuangSendService.send(messageApplicationEnum, vo, content, targets);
                }
                if (Objects.equals(templateExtendDto.getMailIsOpen(), 1) && null != dto.getUserId()) {
                    this.sendMailMessage(messageApplicationEnum, userTypeEnum, dto, content, vo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Object)e.getMessage());
        }
    }

    @Override
    public void senAwardMessage(MessageDto dto, String content) {
        MessageTemplateVo vo = new MessageTemplateVo();
        vo.setTitle(AwardMessageContants.TITLE);
        vo.setExtrasParam(AwardMessageContants.APP_URL);
        String targets = null;
        if (null != dto.getUserId()) {
            targets = dto.getUserId() + "";
        }
        this.jiGuangSendService.send(MessageApplicationEnum.DIGITAL_AWARD, vo, content, targets);
    }

    @Override
    public void senAwardMessage(List<Long> userIds, String content) {
        ArrayList userIdstr = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(userIds)) {
            try {
                for (Long userId : userIds) {
                    String targets = String.valueOf(userId);
                    if (StringUtils.isNotBlank((CharSequence)this.appVos.getEnvironment())) {
                        targets = this.appVos.getEnvironment() + "_" + targets;
                    }
                    userIdstr.add(targets);
                }
                MessageTemplateVo vo = new MessageTemplateVo();
                vo.setTitle(AwardMessageContants.TITLE);
                vo.setExtrasParam(AwardMessageContants.APP_URL);
                String[] strings = new String[userIdstr.size()];
                userIdstr.toArray(strings);
                this.jiGuangSendService.send(MessageApplicationEnum.DIGITAL_AWARD, vo, content, strings);
            }
            catch (Exception e) {
                logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Object)e.getMessage());
            }
        }
    }

    @Override
    public void sendSms(List<String> phoneCodes, Map<String, String> mapValue, String messageCode) {
        MessageTemplateExtendDto templateExtendDto;
        if (CollectionUtils.isNotEmpty(phoneCodes) && null != (templateExtendDto = (MessageTemplateExtendDto)ResponseDataUtil.checkResponse(this.templateExtendQueryApi.queryTemplate(messageCode)))) {
            MessageTemplateVo vo = this.getMessageTemplateVo(templateExtendDto.getMessageTemplateId());
            if (null == vo) {
                logger.info("\u83b7\u53d6\u4e0d\u5230\u6a21\u677f\u4fe1\u606f");
                return;
            }
            for (String phoneCode : phoneCodes) {
                MessageDto dto = new MessageDto();
                dto.setPhoneCode(phoneCode);
                this.sendSms(dto, mapValue, vo);
            }
        }
    }

    private void sendMailMessage(final MessageApplicationEnum messageApplicationEnum, final UserTypeEnum userTypeEnum, final MessageDto dto, final String content, final MessageTemplateVo vo) {
        this.threadPoolTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MailMessageDto messageDto = new MailMessageDto();
                if (messageApplicationEnum.equals((Object)MessageApplicationEnum.B2B)) {
                    messageDto.setApplicationType(Integer.valueOf(1));
                } else if (messageApplicationEnum.equals((Object)MessageApplicationEnum.DIGITAL_AWARD)) {
                    messageDto.setApplicationType(Integer.valueOf(2));
                } else {
                    messageDto.setApplicationType(Integer.valueOf(3));
                }
                messageDto.setContent(content);
                messageDto.setUserType(userTypeEnum.getCode());
                messageDto.setUserId(dto.getUserId());
                messageDto.setIsRead(Integer.valueOf(0));
                messageDto.setTitle(vo.getTitle());
                MessageSendServiceImpl.this.mailMessageApi.save(messageDto);
            }
        });
    }

    private void sendSms(final MessageDto dto, final Map<String, String> mapValue, final MessageTemplateVo vo) {
        logger.info("\u624b\u673a\u53f7\uff1a" + dto.getPhoneCode().trim() + "\u7684\u6821\u9a8c\u7ed3\u679c\u4e3a\uff0c" + StringFormatUtil.isPhoneCode(dto.getPhoneCode().trim()));
        if (StringFormatUtil.isPhoneCode(dto.getPhoneCode().trim())) {
            logger.info("\u8c03\u7528\u57fa\u7840\u4e2d\u53f0\u53d1\u9001\u77ed\u4fe1\u5f00\u59cb\uff1a" + String.valueOf(System.currentTimeMillis()));
            this.threadPoolTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MessageVo messageVo = new MessageVo();
                    messageVo.setTaget(dto.getPhoneCode());
                    messageVo.setMapValue(mapValue);
                    MessageSendServiceImpl.this.messageSender.sendByEventCode(messageVo, vo.getTemplateCode());
                }
            });
        }
    }

    private MessageTemplateVo getMessageTemplateVo(Long templateId) {
        MessageTemplateVo messageTemplateVo = new MessageTemplateVo();
        messageTemplateVo.setId(templateId);
        return (MessageTemplateVo)this.messageManagerService.getInfoById((Object)messageTemplateVo);
    }
}

