/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PearlriverHttpUtils {
    private static Logger logger = LoggerFactory.getLogger(PearlriverHttpUtils.class);
    public static Map<String, String> mimeType = new HashMap<String, String>();

    public static String getFileMimeType(String fileName) {
        int index = fileName.lastIndexOf(".");
        String type = fileName.substring(index + 1, fileName.length());
        String mimeType = PearlriverHttpUtils.mimeType.get(type);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    public static String sendPostToOA(String url, JSONObject obj, String token) throws IOException {
        String line;
        HttpPost post = null;
        SSLContext sslcontext = PearlriverHttpUtils.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        post = new HttpPost(url);
        post.setHeader("token", token);
        StringEntity entity = new StringEntity(obj.toString(), Charset.forName("UTF-8"));
        entity.setContentType("application/json");
        post.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
        int statusCode = response.getStatusLine().getStatusCode();
        System.out.println(statusCode);
        HttpEntity entity2 = response.getEntity();
        InputStream is = entity2.getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder result = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            result.append(line);
        }
        is.close();
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String oaUploadFile(InputStream inputStream, String url, String token, String fileName) throws IOException {
        StringBuilder result = new StringBuilder();
        URL preUrl = null;
        URLConnection uc = null;
        BufferedInputStream input = null;
        FilterOutputStream dos = null;
        try {
            url = url + "&token=" + token;
            preUrl = new URL(url);
            uc = preUrl.openConnection();
            HttpURLConnection hc = (HttpURLConnection)uc;
            hc.setDoOutput(true);
            hc.setDoInput(true);
            hc.setUseCaches(false);
            hc.setRequestProperty("contentType", "charset=utf-8");
            hc.setRequestMethod("POST");
            input = new BufferedInputStream(inputStream);
            String BOUNDARY = "---------------------------7d4a6d158c9";
            StringBuffer sb = new StringBuffer();
            sb.append("--");
            sb.append(BOUNDARY);
            sb.append("\r\n");
            sb.append("Content-Disposition: form-data; name=\"1\"; filename=" + fileName + "\r\n");
            String minType = PearlriverHttpUtils.getFileMimeType(fileName);
            logger.info("minType : " + minType);
            sb.append("Content-Type: " + minType + "\r\n\r\n");
            hc.setRequestProperty("Content-Type", "multipart/form-data;boundary=---------------------------7d4a6d158c9");
            byte[] end_data = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
            dos = new DataOutputStream(hc.getOutputStream());
            dos.write(sb.toString().getBytes("utf-8"));
            byte[] cc = new byte[input.available()];
            while (input.read(cc) != -1) {
                dos.write(cc);
            }
            dos.write(end_data);
            ((DataOutputStream)dos).flush();
            dos.close();
            input.close();
            InputStream isResult = hc.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(isResult));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            logger.info("\u4e0a\u4f20OA\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (dos != null) {
                dos.close();
            }
        }
        return result.toString();
    }

    public static SSLContext createIgnoreVerifySSL() {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
            return sslcontext;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        mimeType.put("doc", "application/msword");
        mimeType.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        mimeType.put("xls", "application/vnd.ms-excel");
        mimeType.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        mimeType.put("ppt", "application/vnd.ms-powerpoint");
        mimeType.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        mimeType.put("rtf", "application/msword");
        mimeType.put("pdf", "application/pdf");
        mimeType.put("doc", "application/msword");
    }
}

