/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.utils;

import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.imageio.ImageIO;

public class QrCode {
    @Resource
    private IObjectStorageService objectStorageService;
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    private QrCode() {
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public static void writeToFile(String content, String format, File file, int width, int height) throws IOException, WriterException {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 1);
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage image = QrCode.toBufferedImage(bitMatrix);
        if (!ImageIO.write((RenderedImage)image, format, file)) {
            throw new IOException("Could not write an image of format " + format + " to " + file);
        }
    }

    public static void pressText(String pressText, File targetImg, int fontStyle, Color color, int fontSize, int width, int height) {
        int startX = (width - fontSize * pressText.length()) / 2;
        int startY = height - (height - width) / 2;
        try {
            BufferedImage src = ImageIO.read(targetImg);
            int imageW = ((Image)src).getWidth(null);
            int imageH = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(imageW, imageH, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, imageW, imageH, null);
            g.setColor(color);
            g.setFont(new Font(null, fontStyle, fontSize));
            ((Graphics)g).drawString(pressText, startX, startY);
            g.dispose();
            FileOutputStream out = new FileOutputStream(targetImg);
            ImageIO.write((RenderedImage)image, "JPEG", out);
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void zipFiles(File[] srcfile, File zipfile) {
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));
            for (int i = 0; i < srcfile.length; ++i) {
                int len;
                FileInputStream in = new FileInputStream(srcfile[i]);
                out.putNextEntry(new ZipEntry(srcfile[i].getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
            System.out.println("\u538b\u7f29\u5b8c\u6210.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

