/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.utils.poi;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoiReadExcelUtil {
    private static final Logger logger = LoggerFactory.getLogger(PoiReadExcelUtil.class);
    static LinkedList[] result = null;
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public static LinkedList[] readExcelTitle(InputStream inputStream, int startRowTitle) {
        try {
            int rowTitle;
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet = workbook.getSheetAt(0);
            int rowNum = sheet.getLastRowNum() + 1;
            int n = rowTitle = startRowTitle > 0 ? startRowTitle : 1;
            if (rowNum >= rowTitle) {
                result = new LinkedList[1];
                int i = rowTitle - 1;
                Row row = sheet.getRow(i);
                PoiReadExcelUtil.result[0] = new LinkedList();
                if (row != null) {
                    for (int j = 0; j < row.getLastCellNum(); ++j) {
                        Object str;
                        Cell cell = row.getCell(j);
                        Object object = str = cell != null ? PoiReadExcelUtil.getCellValue(cell) : "";
                        if (j == row.getLastCellNum() - 1 && "".equals(str)) continue;
                        result[0].add(str);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6Excel\u8868\u5934\u6570\u636e\u65f6\u5f02\u5e38,msg:{}", (Object)e.getMessage());
            throw new RuntimeException("\u8bfb\u53d6Excel\u8868\u5934\u6570\u636e\u65f6\u5f02\u5e38", e);
        }
        return result;
    }

    public static LinkedList[] readExcelData(InputStream inputStream, int startRowData) {
        return PoiReadExcelUtil.readExcelData(inputStream, startRowData, 0);
    }

    public static LinkedList[] readExcelData(InputStream inputStream, int startRowData, int columnNum) {
        try {
            result = null;
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet = workbook.getSheetAt(0);
            int rowNum = sheet.getLastRowNum() + 1;
            if (rowNum >= startRowData) {
                Object columnValue;
                rowNum = rowNum - startRowData + 1;
                --startRowData;
                HashMap temMap = new HashMap();
                ArrayList<Object> temColumnValues = null;
                boolean verifyBool = false;
                for (int i = 0; i < rowNum; ++i) {
                    Row row = sheet.getRow(startRowData + i);
                    if (row == null) continue;
                    if (columnNum < 1) {
                        columnNum = row.getLastCellNum();
                    }
                    temColumnValues = new ArrayList<Object>();
                    for (int j = 0; j < columnNum; ++j) {
                        columnValue = PoiReadExcelUtil.getMergedRegionValue(sheet, row, startRowData + i, j);
                        temColumnValues.add(columnValue != null ? columnValue : "");
                        if (columnValue == null || "".equals(columnValue)) continue;
                        verifyBool = true;
                    }
                    if (!verifyBool) continue;
                    temMap.put(i, temColumnValues);
                    verifyBool = false;
                }
                result = new LinkedList[temMap.size()];
                int n = 0;
                for (Map.Entry map : temMap.entrySet()) {
                    columnValue = (List)map.getValue();
                    PoiReadExcelUtil.result[n] = new LinkedList();
                    Iterator iterator = columnValue.iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        result[n].add(obj);
                    }
                    ++n;
                }
                temMap = null;
                temColumnValues = null;
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u8868\u683c\u6570\u636e\u65f6\u5f02\u5e38,msg:{}", (Object)e.getMessage());
            throw new RuntimeException("\u8bfb\u53d6\u8868\u683c\u6570\u636e\u65f6\u5f02\u5e38", e);
        }
        return result;
    }

    public static Object getMergedRegionValue(Sheet sheet, Row row, int indexRow, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (indexRow < firstRow || indexRow > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return PoiReadExcelUtil.getCellValue(fCell);
        }
        Cell cell = row.getCell(column);
        return PoiReadExcelUtil.getCellValue(cell);
    }

    private static Object getCellValue(Cell cell) {
        String cellValue;
        block5: {
            try {
                if (cell == null) {
                    return "";
                }
                cellValue = cell.getStringCellValue();
            }
            catch (Exception e) {
                DecimalFormat df;
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = sdf.format(cell.getDateCellValue());
                }
                double numericCellValue = cell.getNumericCellValue();
                cellValue = String.valueOf(numericCellValue);
                if (cellValue.indexOf("E") > 0) {
                    df = new DecimalFormat("0");
                    cellValue = df.format(numericCellValue);
                }
                if (!cellValue.endsWith(".0")) break block5;
                df = new DecimalFormat("0");
                cellValue = df.format(numericCellValue);
            }
        }
        return cellValue.trim().replaceAll("\n", "");
    }
}

