/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.api.dto.request.RelationDealReqDto;
import com.dtyunxi.tcbj.biz.enums.ProviceCityConstant;
import com.dtyunxi.tcbj.biz.service.IRelationDealService;
import com.dtyunxi.tcbj.biz.utils.StringMatchUtils;
import com.dtyunxi.tcbj.dao.das.ReCompareCusStoreRealDas;
import com.dtyunxi.tcbj.dao.eo.ReCompareCusStoreRealEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RalationDealServiceImpl
implements IRelationDealService {
    private static final Logger logger = LoggerFactory.getLogger(RalationDealServiceImpl.class);
    @Resource
    private ReCompareCusStoreRealDas compareCusStoreRealDas;

    @Override
    public String genCusStoreCompRela(RelationDealReqDto reqDto) {
        int numThreads = 4;
        ExecutorService threadPool = RalationDealServiceImpl.createThreadPool(numThreads);
        ReCompareCusStoreRealEo realSearchEo = new ReCompareCusStoreRealEo();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrgIdList())) {
            ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
            filters.add(SqlFilter.in((String)"merchant_id", (Object)reqDto.getOrgIdList()));
            realSearchEo.setSqlFilters(filters);
        }
        int i = 1;
        while (i <= numThreads) {
            int finalI = i++;
            threadPool.execute(() -> {
                Integer pageNum = finalI;
                List<ReCompareCusStoreRealEo> realEoList = this.getList(realSearchEo, pageNum);
                ArrayList upEoList = new ArrayList();
                ReCompareCusStoreRealEo upEo = null;
                String storeNameDeal = null;
                String customrNameDeal = null;
                while (CollectionUtils.isNotEmpty(realEoList)) {
                    pageNum = pageNum + numThreads;
                    for (ReCompareCusStoreRealEo eo : realEoList) {
                        try {
                            storeNameDeal = RalationDealServiceImpl.remove(eo.getStoreName(), reqDto);
                            customrNameDeal = RalationDealServiceImpl.remove(eo.getCustomerName(), reqDto);
                            upEo = new ReCompareCusStoreRealEo();
                            upEo.setId(eo.getId());
                            upEo.setNameMatchRate(Math.round(100.0 * StringMatchUtils.pickAlgorithm(storeNameDeal, customrNameDeal, null)) + "%");
                            ProviceCityConstant.compareArea(eo, upEo);
                            upEo.setStoreNameDeal(storeNameDeal);
                            upEo.setCustomerNameDeal(customrNameDeal);
                            this.compareCusStoreRealDas.updateSelective((BaseEo)upEo);
                        }
                        catch (Exception e) {
                            logger.error("\u3010\u5b57\u7b26\u4e32\u5339\u914d\u3011\u7b97\u6cd5\u8ba1\u7b97\u5f02\u5e38");
                            e.printStackTrace();
                        }
                    }
                    realEoList = this.getList(realSearchEo, pageNum);
                }
            });
        }
        threadPool.shutdown();
        return "\u66f4\u65b0\u8fdb\u884c\u4e2d\uff0c\u8bf7\u67e5\u770b\u6570\u636e\u5e93\u975e\u7a7a\u8868\u793a\u6267\u884c\u5b8c\u6bd5";
    }

    private List<ReCompareCusStoreRealEo> getList(ReCompareCusStoreRealEo realSearchEo, Integer pageNum) {
        return this.compareCusStoreRealDas.selectLimitSizeWithColumn((BaseEo)realSearchEo, pageNum, Integer.valueOf(2000), new String[]{"id", "store_name", "store_province", "store_city", "store_county", "customer_name", "customer_province", "customer_city", "customer_county"});
    }

    public static String remove(String str, RelationDealReqDto reqDto) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (!(str.contains("(") || str.contains(")") || str.contains("\uff08") || str.contains("\uff09"))) {
            return ProviceCityConstant.replaceAreaHeader(str, reqDto);
        }
        StringBuilder sb = new StringBuilder();
        int count1 = 0;
        for (char c : str.toCharArray()) {
            if (c == '(' || c == '\uff08') {
                ++count1;
                continue;
            }
            if (c == ')' || c == '\uff09') {
                --count1;
                continue;
            }
            if (count1 != 0) continue;
            sb.append(c);
        }
        return ProviceCityConstant.replaceAreaHeader(sb.toString(), reqDto);
    }

    public static ExecutorService createThreadPool(int numThreads) {
        return new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }
}

