/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogStatusEnum;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ImportLogQueryReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.response.ImportLogRespDto;
import com.dtyunxi.tcbj.module.export.dao.das.ImportLogDas;
import com.dtyunxi.tcbj.module.export.dao.eo.ImportLogEo;
import com.dtyunxi.tcbj.module.export.dao.mapper.ImportLogMapper;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ImportLogService {
    private static final Logger logger = LoggerFactory.getLogger(ImportLogService.class);
    @Resource
    private IContext context;
    @Resource
    private ImportLogDas importLogDas;
    @Resource
    private ImportLogMapper importLogMapper;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private HttpServletRequest request;

    private Long getHeader() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            return null;
        }
        return Long.parseLong(organizationId);
    }

    public RestResponse<PageInfo<ImportLogRespDto>> queryPage(ImportLogQueryReqDto queryDto) {
        logger.info("\u83b7\u53d6\u5bfc\u5165\u5217\u8868-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)((Object)queryDto)));
        if (CollectionUtils.isEmpty(queryDto.getOrganizationIdList()) && Objects.nonNull(this.getHeader())) {
            queryDto.setOrganizationIdList(Collections.singletonList(this.getHeader()));
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getFileName())) {
            wrapper.eq((Object)"file_name", (Object)queryDto.getFileName());
        }
        if (queryDto.getStatus() != null) {
            wrapper.eq((Object)"status", (Object)queryDto.getStatus());
        }
        if (queryDto.getImportType() != null) {
            wrapper.eq((Object)"import_type", (Object)queryDto.getImportType());
        }
        if (CollectionUtils.isNotEmpty(queryDto.getSellerIdList())) {
            wrapper.in((Object)"seller_id", queryDto.getSellerIdList());
        }
        if (CollectionUtils.isNotEmpty(queryDto.getOrganizationIdList())) {
            wrapper.in((Object)"organization_id", queryDto.getOrganizationIdList());
        }
        wrapper.orderByDesc((Object)"create_time");
        Integer pageNum = queryDto.getPageNum() == null ? 1 : queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize() == null ? 10 : queryDto.getPageSize();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.importLogMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse("0", "success", (Object)new PageInfo());
        }
        Map<Object, Object> sellerMap = new HashMap();
        List sellerIdList = list.stream().filter(eo -> Objects.nonNull(eo.getSellerId())).map(ImportLogEo::getSellerId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sellerIdList)) {
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setIdList(sellerIdList);
            List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryListByFeign(sellerQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)sellerRespDtos)) {
                sellerMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getId, Function.identity(), (k1, k2) -> k1));
            }
        }
        PageInfo info = new PageInfo(list);
        HashMap finalSellerMap = sellerMap;
        List rList = list.stream().map(t -> {
            ImportLogRespDto dto = new ImportLogRespDto();
            BeanUtils.copyProperties((Object)t, (Object)((Object)dto));
            if (!finalSellerMap.isEmpty() && finalSellerMap.containsKey(dto.getSellerId())) {
                SellerRespDto sellerRespDto = (SellerRespDto)finalSellerMap.get(dto.getSellerId());
                dto.setSellerName(sellerRespDto.getName());
            }
            return dto;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo(rList);
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(rList);
        logger.info("\u83b7\u53d6\u5bfc\u5165\u5217\u8868-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
        return new RestResponse("0", "success", (Object)result);
    }

    public Long init(ImportLogEo eo) {
        eo.setImportTime(new Date());
        eo.setStatus(ImportLogStatusEnum.RUNNING.getCode());
        eo.setImportPerson(this.context.userName());
        this.importLogDas.insert((BaseEo)eo);
        return eo.getId();
    }

    public void success(Long id, ImportLogStatusEnum statusEnum, Integer successNum, String failReason, String failFileUrl, Integer failNum) {
        ImportLogEo importLogEo = (ImportLogEo)this.importLogDas.selectByPrimaryKey(id);
        if (Objects.nonNull(importLogEo)) {
            importLogEo.setFailFileUrl(failFileUrl);
            importLogEo.setCompleteTime(Calendar.getInstance().getTime());
            importLogEo.setStatus(statusEnum.getCode());
            importLogEo.setSuccessNum(successNum);
            importLogEo.setFailNum(failNum);
            importLogEo.setFailReason(failReason);
            this.update(importLogEo);
        }
    }

    public void fail(Long id, String failReason, String failFileUrl, Integer failNum) {
        ImportLogEo importLogEo = (ImportLogEo)this.importLogDas.selectByPrimaryKey(id);
        if (Objects.nonNull(importLogEo)) {
            importLogEo.setStatus(ImportLogStatusEnum.FAIL.getCode());
            importLogEo.setFailReason(failReason);
            importLogEo.setCompleteTime(Calendar.getInstance().getTime());
            importLogEo.setFailFileUrl(failFileUrl);
            importLogEo.setFailNum(failNum);
            importLogEo.setSuccessNum(Integer.valueOf(0));
            this.update(importLogEo);
        }
    }

    public void update(ImportLogEo record) {
        this.importLogDas.update((BaseEo)record);
    }
}

