/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogStatusEnum;
import com.dtyunxi.tcbj.module.export.biz.constant.ImportLogTypeEnum;
import com.dtyunxi.tcbj.module.export.biz.utils.EasyPoiDynamicHeaderUtil;
import com.dtyunxi.tcbj.module.export.biz.utils.OssFileUtil;
import com.dtyunxi.tcbj.module.export.biz.vo.ExcelSheetVo;
import com.dtyunxi.tcbj.module.export.biz.vo.customer.ItemAuthExcelVo;
import com.dtyunxi.tcbj.module.export.dao.das.ImportLogDas;
import com.dtyunxi.tcbj.module.export.dao.eo.ImportLogEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemSkuStatusEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.IItemSycnExtApi;
import com.yx.tcbj.center.api.dto.request.ItemAuthExtQueryReqDto;
import com.yx.tcbj.center.api.query.IItemAuthExpandQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="itemAuthImportService")
public class ItemAuthImportService {
    private final Logger logger = LoggerFactory.getLogger(ItemAuthImportService.class);
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IItemAuthExpandQueryApi itemAuthExpandQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ImportLogDas importLogDas;
    @Resource
    private OssFileUtil ossFileUtil;
    @Resource
    private IItemSycnExtApi itemSycnExtApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    private static final String ALLOW_AUTH_STATUS = "\u542f\u552e";
    private static final String NONALLOW_AUTH_STATUS = "\u7981\u552e";
    private static final String EXPORT_FILE_NAME = "\u6279\u91cf\u5bfc\u5165\u5546\u54c1\u6388\u6743\u9519\u8bef\u6587\u4ef6";
    private static final String VAILD_MESSAGE_FORMAT = "%s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42";
    private static final String CLICENT_ERROR_MSG = "\u5ba2\u6237\u7f16\u53f7\u65e0\u6cd5\u627e\u5230\u6216\u65e0\u6743\u9650";
    private static final String ITEM_ERROR_MSG = "\u5546\u54c1\u7f16\u53f7\u65e0\u6cd5\u627e\u5230\u6216\u65e0\u6743\u9650";

    public Long tenantId() {
        Long tenantId = this.context.tenantId();
        this.logger.info("tenantId >>> {}", (Object)tenantId);
        if (null == tenantId) {
            tenantId = 1L;
        }
        return tenantId;
    }

    public Long instanceId() {
        Long instanceId = this.context.instanceId();
        this.logger.info("instanceId >>> {}", (Object)instanceId);
        if (null == instanceId) {
            instanceId = 1254039287584232622L;
        }
        return instanceId;
    }

    public void asyncItemAuthImport(String importFileUrl, String importFileName, String organizationId, Long sellerId) {
        ConcurrentHashMap<String, List<ItemAuthExcelVo>> map = new ConcurrentHashMap<String, List<ItemAuthExcelVo>>();
        try {
            this.ossFileUtil.buildSheetMap(map, importFileUrl, "0");
            this.ossFileUtil.buildSheetMap(map, importFileUrl, "1");
        }
        catch (Exception e) {
            this.logger.info("\u8bfb\u53d6\u5bfc\u5165\u7684excel\u6587\u4ef6\u51fa\u9519{}", (Throwable)e);
            throw new BizException("\u8bfb\u53d6\u5bfc\u5165\u7684excel\u6587\u4ef6\u51fa\u9519");
        }
        if (Objects.nonNull(sellerId)) {
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setIdList(Collections.singletonList(sellerId));
            List sellerDtoList = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryListByFeign(sellerQueryReqDto));
            if (CollectionUtils.isEmpty((Collection)sellerDtoList)) {
                throw new BizException("\u5bfc\u5165\u5546\u5bb6\u5546\u54c1\u6388\u6743\u89e3\u6790\u5931\u8d25:\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            organizationId = ((SellerRespDto)sellerDtoList.get(0)).getOrganizationId().toString();
        }
        Date now = Calendar.getInstance().getTime();
        try {
            ImportLogEo importLogEo = this.initImportLog(now, organizationId, importFileName, importFileUrl, sellerId);
            String finalOrganizationId = organizationId;
            CompletableFuture.runAsync(() -> this.innerMethod(map, finalOrganizationId, importLogEo));
        }
        catch (Exception e) {
            throw new BizException(e.getMessage());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void innerMethod(Map<String, List<ItemAuthExcelVo>> map, String organizationId, ImportLogEo importLogEo) {
        Date now = importLogEo.getCreateTime();
        Integer totalNum = 0;
        Integer successNum = 0;
        Integer failNum = 0;
        Integer customerFailNum = 0;
        Integer itemFailNum = 0;
        List<Object> customerSuccessVos = new ArrayList();
        List<Object> customerFailVos = new ArrayList();
        List<Object> itemSuccessVos = new ArrayList();
        List<Object> itemFailVos = new ArrayList();
        try {
            List<ItemAuthExcelVo> customerVos = map.get("0");
            this.logger.info("\u5bfc\u5165\u7684\u5ba2\u6237sheet\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(customerVos));
            this.checkExcelInfo(customerVos, "0");
            List successCustomerVos = customerVos.stream().filter(c -> StringUtils.isEmpty((CharSequence)c.getCustomerErrorMsg())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(successCustomerVos)) {
                throw new BizException(String.format(VAILD_MESSAGE_FORMAT, "\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            List<ItemAuthExcelVo> itemVos = map.get("1");
            this.logger.info("\u5bfc\u5165\u7684\u5546\u54c1sheet\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(itemVos));
            this.checkExcelInfo(itemVos, "1");
            List successItemrVos = itemVos.stream().filter(c -> StringUtils.isEmpty((CharSequence)c.getItemErrorMsg())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(successItemrVos)) {
                throw new BizException(String.format(VAILD_MESSAGE_FORMAT, "\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            Integer importCustomerNum = customerVos.size();
            Integer importItemNum = itemVos.size();
            totalNum = importCustomerNum * importItemNum;
            this.logger.info("\u4e0a\u4f20\u5bfc\u5165\u7684\u5ba2\u6237\u539f\u59cb\u6570\u636e\u8bb0\u5f55\u6570\uff1a{}\uff0c\u4e0a\u4f20\u5bfc\u5165\u7684\u5546\u54c1\u539f\u59cb\u6570\u636e\u8bb0\u5f55\u6570\uff1a{}\uff0c\u5bfc\u5165\u603b\u6761\u6570(\u5ba2\u6237\u6570*\u5546\u54c1\u6570)\uff1a{}", new Object[]{importCustomerNum, importItemNum, totalNum});
            List customerCodeList = successCustomerVos.stream().map(ItemAuthExcelVo::getClientCode).collect(Collectors.toList());
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(customerCodeList));
            List itemCodeList = successItemrVos.stream().map(ItemAuthExcelVo::getItemCode).collect(Collectors.toList());
            ItemAuthExtQueryReqDto skuInfoReqDto = new ItemAuthExtQueryReqDto();
            skuInfoReqDto.setOrganizationId(Long.valueOf(Long.parseLong(organizationId)));
            skuInfoReqDto.setItemCodeList(itemCodeList);
            skuInfoReqDto.setTenantId(importLogEo.getTenantId());
            skuInfoReqDto.setInstanceId(importLogEo.getInstanceId());
            List skuInfoRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemAuthExpandQueryApi.queryShellItemList(skuInfoReqDto));
            boolean isCustomerCheckPass = this.checkCustomer(customerVos, customerRespDtos, importLogEo);
            boolean isItemCheckPass = this.checkItem(itemVos, skuInfoRespDtos, importLogEo);
            if (!isCustomerCheckPass || !isItemCheckPass) {
                List<ExcelSheetVo> ossFileObjects = this.buildOssFileObjects(customerVos, itemVos, CLICENT_ERROR_MSG, ITEM_ERROR_MSG);
                String fileUrl = this.ossFileUtil.buildOssFileUrl(ossFileObjects, now, EXPORT_FILE_NAME, ItemAuthExcelVo.class);
                this.uploadImportLog(importLogEo.getId(), ImportLogStatusEnum.FAIL, "", fileUrl, totalNum, totalNum, 0);
                return;
            }
            customerFailVos = customerVos.stream().filter(c -> StringUtils.isNotEmpty((CharSequence)c.getCustomerErrorMsg())).collect(Collectors.toList());
            customerFailNum = CollectionUtil.isEmpty(customerFailVos) ? 0 : customerFailVos.size();
            itemFailVos = itemVos.stream().filter(c -> StringUtils.isNotEmpty((CharSequence)c.getItemErrorMsg())).collect(Collectors.toList());
            itemFailNum = CollectionUtil.isEmpty(itemFailVos) ? 0 : itemFailVos.size();
            failNum = customerFailNum == 0 && itemFailNum == 0 ? Integer.valueOf(0) : (customerFailNum != 0 && itemFailNum == 0 ? Integer.valueOf(customerFailNum * importItemNum) : (customerFailNum == 0 && itemFailNum != 0 ? Integer.valueOf(importCustomerNum * itemFailNum) : Integer.valueOf(customerFailNum * itemFailNum)));
            successNum = totalNum - failNum;
            this.logger.info("\u8ba1\u7b97\u5bfc\u5165\u6761\u6570\uff1atotalNum={}\uff0cfailNum={}\uff0csuccessNum={}", new Object[]{totalNum, failNum, successNum});
            customerSuccessVos = customerVos.stream().filter(c -> StringUtils.isEmpty((CharSequence)c.getCustomerErrorMsg())).collect(Collectors.toList());
            itemSuccessVos = itemVos.stream().filter(c -> StringUtils.isEmpty((CharSequence)c.getItemErrorMsg())).collect(Collectors.toList());
            ArrayList itemAuthTotalDtos = Lists.newArrayList();
            if (CollectionUtil.isNotEmpty(customerSuccessVos) && CollectionUtil.isNotEmpty(itemSuccessVos)) {
                for (ItemAuthExcelVo itemAuthExcelVo : customerSuccessVos) {
                    for (ItemAuthExcelVo itemAuthExcelVo2 : itemSuccessVos) {
                        ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
                        itemAuthReqDto.setTargetType(ItemAuthEnum.TargetType.CUSTOMER.getCode());
                        itemAuthReqDto.setBusinessType(ItemAuthEnum.BusinessType.SKU.getCode());
                        itemAuthReqDto.setBusinessId(itemAuthExcelVo2.getSkuId());
                        itemAuthReqDto.setTargetId(itemAuthExcelVo.getCustomerId());
                        Integer status = Objects.equals(itemAuthExcelVo2.getStatus(), ItemAuthEnum.Status.ENABLE.getCode()) ? 1 : 0;
                        itemAuthReqDto.setStatus(status);
                        itemAuthReqDto.setInstanceId(importLogEo.getInstanceId());
                        itemAuthReqDto.setTenantId(importLogEo.getTenantId());
                        itemAuthTotalDtos.add(itemAuthReqDto);
                    }
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)itemAuthTotalDtos)) {
                try {
                    RestResponseHelper.extractData((RestResponse)this.itemSycnExtApi.updateOrInsertItemAuth((List)itemAuthTotalDtos));
                }
                catch (Exception e) {
                    this.logger.error("\u5bfc\u5165\u5546\u54c1\u6388\u6743\u66f4\u65b0\u5931\u8d25:{}", (Throwable)e);
                    String string = "\u5bfc\u5165\u5546\u54c1\u6388\u6743\u8c03\u7528\u66f4\u65b0\u63a5\u53e3\u5931\u8d25," + e.getMessage();
                    this.uploadImportLog(importLogEo.getId(), ImportLogStatusEnum.FAIL, string, "", totalNum, totalNum, 0);
                    return;
                }
            }
            List<ExcelSheetVo> excelSheetVos = this.buildOssFileObjects(customerFailVos, itemFailVos, CLICENT_ERROR_MSG, ITEM_ERROR_MSG);
            String string = this.ossFileUtil.buildOssFileUrl(excelSheetVos, now, EXPORT_FILE_NAME, ItemAuthExcelVo.class);
            if (failNum == 0 && successNum != 0) {
                this.logger.info("\u5168\u90e8\u6210\u529f\uff1atotalNum={}\uff0cfailNum={}\uff0csuccessNum={}", new Object[]{totalNum, failNum, successNum});
                this.uploadImportLog(importLogEo.getId(), ImportLogStatusEnum.SUCCEED, "", "", totalNum, failNum, successNum);
            } else if (failNum != 0 && failNum < totalNum) {
                this.logger.info("\u90e8\u5206\u6210\u529f\uff1atotalNum={}\uff0cfailNum={}\uff0csuccessNum={}", new Object[]{totalNum, failNum, successNum});
                this.uploadImportLog(importLogEo.getId(), ImportLogStatusEnum.PART_SUCCESS, "", string, totalNum, failNum, successNum);
            } else if (failNum == 0 && successNum == 0) {
                this.logger.info("\u5931\u8d25\uff1atotalNum={}\uff0cfailNum={}\uff0csuccessNum={}", new Object[]{totalNum, failNum, successNum});
                this.uploadImportLog(importLogEo.getId(), ImportLogStatusEnum.FAIL, "", string, totalNum, failNum, successNum);
            } else {
                this.logger.info("\u5176\u4ed6\u60c5\u51b5\uff1atotalNum={}\uff0cfailNum={}\uff0csuccessNum={}", new Object[]{totalNum, failNum, successNum});
                this.uploadImportLog(importLogEo.getId(), ImportLogStatusEnum.SUCCEED, "", "", totalNum, failNum, successNum);
            }
        }
        catch (Exception e) {
            this.logger.info("\u5bfc\u5165\u5931\u8d25:{}", (Throwable)e);
            String errorMsg = "\u5bfc\u5165\u5931\u8d25,\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9:" + e.getMessage();
            this.uploadImportLog(importLogEo.getId(), ImportLogStatusEnum.FAIL, errorMsg, "", totalNum, failNum, successNum);
        }
    }

    private boolean checkCustomer(List<ItemAuthExcelVo> customerVos, List<CustomerRespDto> customerRespDtos, ImportLogEo importLogEo) {
        boolean flag = false;
        Map<Object, Object> customerMap = new HashMap();
        if (CollectionUtil.isNotEmpty(customerRespDtos)) {
            customerMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        Long organizationId = importLogEo.getOrganizationId();
        for (ItemAuthExcelVo customerVo : customerVos) {
            if (StringUtils.isNotEmpty((CharSequence)customerVo.getCustomerErrorMsg())) continue;
            if (customerMap.isEmpty() || !customerMap.containsKey(customerVo.getClientCode())) {
                customerVo.setCustomerErrorMsg("\u5ba2\u6237\u7f16\u53f7\u672a\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728");
                continue;
            }
            CustomerRespDto customerRespDto = (CustomerRespDto)customerMap.get(customerVo.getClientCode());
            if (!Objects.equals(customerRespDto.getMerchantId(), organizationId)) {
                customerVo.setCustomerErrorMsg("\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5339\u914d");
                continue;
            }
            customerVo.setCustomerId(customerRespDto.getId());
            flag = true;
        }
        return flag;
    }

    private boolean checkItem(List<ItemAuthExcelVo> itemVos, List<ItemAuthQueryRespDto> skuInfoRespDtos, ImportLogEo importLogEo) {
        boolean flag = false;
        Map<Object, Object> skuInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(skuInfoRespDtos)) {
            skuInfoMap = skuInfoRespDtos.stream().collect(Collectors.toMap(ItemAuthQueryRespDto::getItemCode, Function.identity(), (k1, k2) -> k1));
        }
        for (ItemAuthExcelVo itemVo : itemVos) {
            if (StringUtils.isNotEmpty((CharSequence)itemVo.getItemErrorMsg())) continue;
            if (skuInfoMap.isEmpty() || !skuInfoMap.containsKey(itemVo.getItemCode())) {
                itemVo.setItemErrorMsg("\u5546\u54c1\u7f16\u53f7\u672a\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u6216\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5339\u914d");
                continue;
            }
            ItemAuthQueryRespDto skuInfo = (ItemAuthQueryRespDto)skuInfoMap.get(itemVo.getItemCode());
            if (!Objects.equals(ItemSkuStatusEnum.ONSHELF.getStatus(), skuInfo.getStatus())) {
                itemVo.setItemErrorMsg("\u5546\u54c1\u5df2\u4e0b\u67b6");
                continue;
            }
            flag = true;
            itemVo.setSkuId(skuInfo.getBusinessId());
        }
        return flag;
    }

    private void checkExcelInfo(List<ItemAuthExcelVo> vos, String sheet) {
        block9: {
            block8: {
                if (!"0".equals(sheet)) break block8;
                if (CollectionUtil.isEmpty(vos)) {
                    throw new BizException(String.format(VAILD_MESSAGE_FORMAT, "\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                for (ItemAuthExcelVo vo : vos) {
                    if (!StringUtils.isEmpty((CharSequence)vo.getClientCode())) continue;
                    vo.setCustomerErrorMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                }
                break block9;
            }
            if (!"1".equals(sheet)) break block9;
            if (CollectionUtil.isEmpty(vos)) {
                throw new BizException(String.format(VAILD_MESSAGE_FORMAT, "\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            for (ItemAuthExcelVo vo : vos) {
                StringBuffer errorMsg = new StringBuffer();
                if (StringUtil.isBlank((CharSequence)vo.getItemCode())) {
                    errorMsg.append("\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;");
                }
                if (StringUtil.isBlank((CharSequence)vo.getStatus())) {
                    errorMsg.append("\u5546\u54c1\u542f\u552e\u7981\u552e\u4e0d\u80fd\u4e3a\u7a7a;");
                } else if (!ALLOW_AUTH_STATUS.equals(vo.getStatus()) && !NONALLOW_AUTH_STATUS.equals(vo.getStatus())) {
                    errorMsg.append("\u5546\u54c1\u542f\u552e\u7981\u552e\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e;");
                }
                vo.setItemErrorMsg(errorMsg.toString());
            }
        }
    }

    private ImportLogEo initImportLog(Date now, String orgId, String fileName, String importFileUrl, Long sellerId) {
        ImportLogEo eo = new ImportLogEo();
        eo.setOrganizationId(Long.valueOf(Long.parseLong(orgId)));
        eo.setSellerId(sellerId);
        eo.setFileName(fileName);
        eo.setImportTime(now);
        eo.setImportType(ImportLogTypeEnum.ITEM_AUTHORIZE.getCode());
        eo.setImportFileUrl(importFileUrl);
        eo.setStatus(ImportLogStatusEnum.RUNNING.getCode());
        eo.setImportPerson(this.context.userName());
        eo.setUpdatePerson(this.context.userName());
        eo.setUpdateTime(now);
        eo.setInstanceId(this.instanceId());
        eo.setTenantId(this.tenantId());
        this.importLogDas.insert((BaseEo)eo);
        return eo;
    }

    private void uploadImportLog(Long id, ImportLogStatusEnum logStatusEnum, String failReason, String failFileUrl, Integer totalNum, Integer failNum, Integer successNum) {
        ImportLogEo importLogEo = (ImportLogEo)this.importLogDas.selectByPrimaryKey(id);
        if (Objects.nonNull(importLogEo) && Objects.nonNull(importLogEo.getId())) {
            importLogEo.setCompleteTime(Calendar.getInstance().getTime());
            importLogEo.setStatus(logStatusEnum.getCode());
            importLogEo.setFailReason(failReason);
            importLogEo.setFailFileUrl(failFileUrl);
            importLogEo.setTotalNum(totalNum);
            importLogEo.setFailNum(failNum);
            importLogEo.setSuccessNum(successNum);
            importLogEo.setUpdatePerson(this.context.userName());
            importLogEo.setUpdateTime(Calendar.getInstance().getTime());
            this.importLogDas.updateSelective((BaseEo)importLogEo);
        }
    }

    private List<ExcelSheetVo> buildOssFileObjects(List<ItemAuthExcelVo> customerVos, List<ItemAuthExcelVo> itemVos, String clientErrorMsg, String itemErrorMsg) {
        ArrayList<ExcelSheetVo> objectList = new ArrayList<ExcelSheetVo>();
        if (CollectionUtil.isNotEmpty(customerVos)) {
            this.dynamicHeader(customerVos, "0");
            ExcelSheetVo customerSheetVo = new ExcelSheetVo();
            customerSheetVo.setSheetObject(customerVos);
            customerSheetVo.setSheetName("\u5ba2\u6237\uff08\u5fc5\u586b\uff09");
            objectList.add(customerSheetVo);
        }
        if (CollectionUtil.isNotEmpty(itemVos)) {
            this.dynamicHeader(itemVos, "1");
            ExcelSheetVo itemSheetVo = new ExcelSheetVo();
            itemSheetVo.setSheetObject(itemVos);
            itemSheetVo.setSheetName("\u5546\u54c1\uff08\u5fc5\u586b\uff09");
            objectList.add(itemSheetVo);
        }
        return objectList;
    }

    private void dynamicHeader(List<ItemAuthExcelVo> vos, String type) {
        block9: {
            block8: {
                if (CollectionUtil.isEmpty(vos)) {
                    return;
                }
                if (StringUtil.isBlank((CharSequence)type)) {
                    return;
                }
                if (!"0".equals(type)) break block8;
                for (ItemAuthExcelVo vo : vos) {
                    EasyPoiDynamicHeaderUtil dynamicHeaderUtil = new EasyPoiDynamicHeaderUtil();
                    dynamicHeaderUtil.t = vo;
                    try {
                        dynamicHeaderUtil.hihdColumn("itemCode", true);
                        dynamicHeaderUtil.hihdColumn("itemName", true);
                        dynamicHeaderUtil.hihdColumn("status", true);
                        dynamicHeaderUtil.hihdColumn("itemErrorMsg", true);
                    }
                    catch (Exception e) {
                        this.logger.error("\u5217\u9690\u85cf\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                        throw new BizException("\u5217\u9690\u85cf\u8f6c\u6362\u5931\u8d25");
                    }
                }
                break block9;
            }
            if (!"1".equals(type)) break block9;
            for (ItemAuthExcelVo vo : vos) {
                EasyPoiDynamicHeaderUtil dynamicHeaderUtil = new EasyPoiDynamicHeaderUtil();
                dynamicHeaderUtil.t = vo;
                try {
                    dynamicHeaderUtil.hihdColumn("clientCode", true);
                    dynamicHeaderUtil.hihdColumn("clientName", true);
                    dynamicHeaderUtil.hihdColumn("customerErrorMsg", true);
                }
                catch (Exception e) {
                    this.logger.error("\u5217\u9690\u85cf\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    throw new BizException("\u5217\u9690\u85cf\u8f6c\u6362\u5931\u8d25");
                }
            }
        }
    }
}

