/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.dto.request.CustomerAuthItemExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ItemAuthCustomerExportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ItemExportService;
import com.dtyunxi.tcbj.module.export.biz.impl.operation.CustomerAuthItemService;
import com.dtyunxi.tcbj.module.export.biz.impl.operation.ItemAuthCustomerService;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.CustomerAuthItemVo;
import com.dtyunxi.tcbj.module.export.biz.vo.operation.ItemAuthCustomerVo;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.api.dto.request.ItemExportQueryReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bfc\u51fa\u7ec4\u4ef6\uff1a\u8fd4\u5229\u5bfc\u51fa\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/export/item"})
public class ItemExportRest {
    private static final Logger logger = LoggerFactory.getLogger(ItemExportRest.class);
    @Resource
    private ItemExportService itemExportService;
    @Resource
    private HttpServletRequest request;
    @Autowired
    private ItemAuthCustomerService itemAuthCustomerService;
    @Autowired
    private CustomerAuthItemService customerAuthItemService;

    @PostMapping(value={"/auth/customer"})
    @ApiOperation(value="\u5bfc\u51fa\u5546\u54c1\u5df2\u6388\u6743\u5ba2\u6237", notes="\u5bfc\u51fa\u5546\u54c1\u5df2\u6388\u6743\u5ba2\u6237")
    public RestResponse<Object> exprotItemAuthCustomer(@RequestBody @Valid ItemAuthCustomerExportReqDto itemAuthCustomerExportReqDto) {
        return this.itemAuthCustomerService.execute((PageInfo)itemAuthCustomerExportReqDto, ItemAuthCustomerVo.class);
    }

    @PostMapping(value={"/customer/auth/item"})
    @ApiOperation(value="\u5bfc\u51fa\u5ba2\u6237\u5df2\u6388\u6743\u5546\u54c1", notes="\u5bfc\u51fa\u5ba2\u6237\u5df2\u6388\u6743\u5546\u54c1")
    public RestResponse<Object> exprotItemAuthCustomer(@RequestBody @Valid CustomerAuthItemExportReqDto customerAuthItemExportReqDto) {
        return this.customerAuthItemService.execute((PageInfo)customerAuthItemExportReqDto, CustomerAuthItemVo.class);
    }

    @PostMapping(value={"/export"}, produces={"application/json"})
    @ApiOperation(value="\u5546\u54c1\u4fe1\u606f\u5bfc\u51fa\u670d\u52a1", notes="\u5546\u54c1\u4fe1\u606f\u5bfc\u51fa\u670d\u52a1")
    RestResponse<Object> exportItem(@RequestBody ItemExportQueryReqDto reqDto) {
        reqDto.setOrganizationId(this.getHeader());
        return new RestResponse((Object)this.itemExportService.exportItem(reqDto));
    }

    private Long getHeader() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            return null;
        }
        return Long.parseLong(organizationId);
    }
}

