/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.mj.biz.commons.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.settlement.api.ISettlementApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.LaunchSettlementReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.query.ITradeSettlementFlowQueryApi;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.RefundOrderReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.service.RefundOrderService;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RefundOrderServiceImpl
implements RefundOrderService {
    private Logger logger = LoggerFactory.getLogger(RefundOrderServiceImpl.class);
    @Resource
    private ISettlementApi settlementApi;
    @Resource
    private ITradeSettlementFlowQueryApi tradeSettlementFlowQueryApi;

    @Override
    public RestResponse<Void> refundOrder(RefundOrderReqDto dto) {
        this.logger.info("\u53d1\u8d77\u9000\u6b3e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        Boolean ifNextRefund = (Boolean)RestResponseHelper.extractData(this.checkIfNextRefund(dto.getOrderNo()));
        this.logger.info("\u6821\u9a8c\u662f\u5426\u4e3a\u9694\u5929\u9000\u6b3e\uff1a{}", (Object)ifNextRefund);
        LaunchSettlementReqDto reqDto = new LaunchSettlementReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)dto, (String[])new String[0]);
        reqDto.setIfNextRefund(ifNextRefund);
        TradeSettlementFlowRespDto refundTradeFlow = (TradeSettlementFlowRespDto)RestResponseHelper.extractData((RestResponse)this.settlementApi.refundOfBacktrack(reqDto));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> checkIfNextRefund(String orderNo) {
        String now;
        this.logger.info("\u6821\u9a8c\u8ba2\u5355\u662f\u662f\u5426\u5f53\u5929\u652f\u4ed8\uff1a{}", (Object)orderNo);
        TradeSettlementFlowReqDto reqDto = new TradeSettlementFlowReqDto();
        reqDto.setOptTradeNo(orderNo);
        reqDto.setTradeType(SettlementFlowTradeTypeEnum.PAY.getCode());
        reqDto.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        List list = (List)RestResponseHelper.extractData((RestResponse)this.tradeSettlementFlowQueryApi.queryList(reqDto));
        if (CollectionUtil.isEmpty((Collection)list) || list.size() <= 0) {
            return new RestResponse((Object)false);
        }
        TradeSettlementFlowRespDto flowRespDto = (TradeSettlementFlowRespDto)list.get(0);
        if (flowRespDto.getTradePayType().equals(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode())) {
            return new RestResponse((Object)false);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String finish = simpleDateFormat.format(flowRespDto.getTradePayFinishTime().getTime());
        if (!finish.equals(now = simpleDateFormat.format(new Date()))) {
            return new RestResponse((Object)true);
        }
        return new RestResponse((Object)false);
    }
}

