/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.settlement.api.IVerifyTaskApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyTaskStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.VerifyBalanceDetailReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.VerifyTradeResultReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SelectValueRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.VerifyBalanceDetailRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.VerifyFailCountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.VerifyTaskRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.VerifyTradeResultRespDto;
import com.dtyunxi.tcbj.center.settlement.api.query.IVerifyBalanceDetailQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.query.IVerifyTaskQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.query.IVerifyTradeResultQueryApi;
import com.dtyunxi.tcbj.module.settlement.biz.service.VerifyTradeService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class VerifyTradeServiceImpl
implements VerifyTradeService {
    private static final Logger logger = LoggerFactory.getLogger(VerifyTradeServiceImpl.class);
    @Resource
    private IVerifyTaskQueryApi taskQueryApi;
    @Resource
    private IVerifyTradeResultQueryApi tradeResultQueryApi;
    @Resource
    private IVerifyBalanceDetailQueryApi balanceDetailQueryApi;
    @Resource
    private IVerifyTaskApi verifyTaskApi;

    @Override
    public RestResponse<VerifyFailCountRespDto> queryVerifyFailCount() {
        return this.taskQueryApi.queryVerifyFailCount();
    }

    @Override
    public RestResponse<PageInfo<VerifyTaskRespDto>> queryTaskByPage(@RequestParam(value="filter") String filter, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.taskQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    @Override
    public RestResponse<PageInfo<VerifyTradeResultRespDto>> queryFlowByPage(@RequestParam(value="filter") String filter, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        VerifyTradeResultReqDto verifyTradeResultReqDto = (VerifyTradeResultReqDto)JSON.parseObject((String)filter, VerifyTradeResultReqDto.class);
        if (VerifyTaskStatusEnum.WAIT_DOING.getCode().equals(verifyTradeResultReqDto.getTaskStatus())) {
            return this.tradeResultQueryApi.queryWaitVerifyByPage(filter, pageNum, pageSize);
        }
        return this.tradeResultQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    @Override
    public RestResponse<PageInfo<VerifyBalanceDetailRespDto>> queryDjbQianbaoByPage(@RequestParam(value="filter") String filter, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        VerifyBalanceDetailReqDto balanceDetailReqDto = new VerifyBalanceDetailReqDto();
        if (VerifyTaskStatusEnum.WAIT_DOING.getCode().equals(balanceDetailReqDto.getTaskStatus())) {
            return this.balanceDetailQueryApi.queryWaitVerifyByPage(filter, pageNum, pageSize);
        }
        return this.balanceDetailQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    @Override
    public RestResponse<List<SelectValueRespDto>> querySelectValue(@RequestParam(value="type", required=false) String type) {
        return this.taskQueryApi.querySelectValue(type);
    }

    @Override
    public RestResponse<String> invokeVerify(Integer verifyTaskType, String verifyDateBegin, String verifyDateEnd) {
        return this.verifyTaskApi.invokeVerify(verifyTaskType, verifyDateBegin, verifyDateEnd);
    }
}

