/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.engine.action.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountUpdateQuotaReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayPlansReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditTermModelRuleReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.OccupyConfigReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountRecordUseDetailRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditTermModelInfoRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.AccountOccupyInfo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.AccountQuotaRecordUpdateReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.CreditPlanDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.EngineOrderReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.EngineResult;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.HitCreditAccountOrderReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.OrderSkuInfo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.ReturnMoneyDetailOrderReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.ReturnMoneyOrderReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.third.dto.ReverseOrderReq;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.BeginDateTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.BooleanEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditAccountStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditAccountUpdateTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditOrderBillStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRepayPlanStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditTermTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageRecordType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.DelayUnitEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.EntityStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.GeneralRuleCodeType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.OrderNodeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.OverdueAmountType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.ReceiveType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.RelevanceType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.SuccessEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.YesOrNoStatus;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.DateTimeUtils;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.engine.action.IAccountQuotaAction;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.engine.dto.OccupyConfigDto;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditOccupyConfigService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditRecordService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditTermModelService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.GenerateCode;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDetailDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditNodeDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditOccupyConfigDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditOrderBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRepayPlanDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditTermModelDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditTermModelRuleDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditUsageRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.PolicyDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.PolicyRuleDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.RefCreditDimPropDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditEntityEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditNodeEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditOccupyConfigEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditOrderBillEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRepayPlanEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditTermModelEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditUsageRecordEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.PolicyEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.PolicyRuleEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditEntityDetailEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditRepayPlanEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class AccountQuotaActionImpl
implements IAccountQuotaAction {
    private static final Logger logger = LoggerFactory.getLogger(AccountQuotaActionImpl.class);
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private CreditTermModelDas creditTermModelDas;
    @Resource
    private CreditRepayPlanDas creditRepayPlanDas;
    @Resource
    private IContext iContext;
    @Resource
    private IAccountQuotaAction accountQuotaAction;
    @Resource
    private CreditOrderBillDas creditOrderBillDas;
    @Resource
    private CreditAccountDas creditAccountDas;
    @Resource
    private ICreditRecordService iCreditRecordService;
    @Resource
    private ICreditOccupyConfigService iCreditOccupyConfigService;
    @Resource
    private CreditEntityDetailDas creditEntityDetailDas;
    @Resource
    private CreditEntityDas creditEntityDas;
    @Resource
    private CreditUsageRecordDas creditUsageRecordDas;
    @Resource
    private CreditTermModelRuleDas creditTermModelRuleDas;
    @Resource
    private GenerateCode generateCode;
    @Resource
    private ICreditTermModelService creditTermModelService;
    @Resource
    private CreditRecordDas creditRecordDas;
    @Resource
    private CreditOccupyConfigDas creditOccupyConfigDas;
    @Resource
    private CreditNodeDas creditNodeDas;
    @Resource
    private ICreditOccupyConfigService creditOccupyConfigService;
    @Resource
    private PolicyRuleDas policyRuleDas;
    @Resource
    private PolicyDas policyDas;
    @Resource
    private ICreditAccountService iCreditAccountService;
    @Resource
    private RefCreditDimPropDas refCreditDimPropDas;
    @Resource
    private ICreditAccountService creditAccountService;

    @Override
    public void validParams(EngineResult engineResult, EngineOrderReq engineOrderReq) {
        engineResult.setIsCreditPay(BooleanEnum.YES.getCode());
        CreditOrderBillEo selectItemCreditOrderBill = new CreditOrderBillEo();
        selectItemCreditOrderBill.setFormCode(engineOrderReq.getOrderNo());
        CreditOrderBillEo creditOrderBillEo = selectItemCreditOrderBill = StringUtils.isNotBlank((CharSequence)engineOrderReq.getOrderNo()) ? (CreditOrderBillEo)this.creditOrderBillDas.selectOne((BaseEo)selectItemCreditOrderBill) : null;
        if (selectItemCreditOrderBill != null) {
            engineOrderReq.setCreditAccountId(selectItemCreditOrderBill.getCreditAccountId());
            engineOrderReq.setCustomerId(selectItemCreditOrderBill.getCreditEntityId());
            engineOrderReq.setTotalAmount(selectItemCreditOrderBill.getAccountUsedQuota());
            engineResult.setCreditOrderBillCode(selectItemCreditOrderBill.getCreditOrderBillCode());
        }
        if (!OrderNodeEnum.SUBMIT_ORDER.getType().equals(engineOrderReq.getOrderNode()) && selectItemCreditOrderBill == null) {
            throw new BizException("\u975e\u8ba2\u5355\u9636\u6bb5\u6ca1\u6709\u5197\u4f59\u8ba2\u5355\u6570\u636e,\u63d0\u793a\u5f02\u5e38,\u8ba2\u5355\u7f16\u7801:" + engineOrderReq.getOrderNo());
        }
        if (null == engineOrderReq.getCustomerId()) {
            logger.info("\u5ba2\u6237\u4fe1\u606f\u7f3a\u5931");
            return;
        }
        if (null == engineOrderReq.getOrderNode()) {
            logger.info("\u8282\u70b9\u4fe1\u606f\u7f3a\u5931");
            return;
        }
        OrderNodeEnum node = OrderNodeEnum.getType((String)engineOrderReq.getOrderNode());
        if (null == node) {
            logger.info("\u8282\u70b9\u4fe1\u606f\u9519\u8bef");
            return;
        }
        CreditEntityEo creditEntityEo = (CreditEntityEo)this.creditEntityDas.selectByPrimaryKey(engineOrderReq.getCustomerId());
        if (creditEntityEo == null || !EntityStatusEnum.ENABLED.getCode().equals(creditEntityEo.getEntityStatus())) {
            logger.info("\u5f53\u524d\u7c7b=AccountQuotaActionImpl.validParams()" + JSON.toJSONString((Object)creditEntityEo));
            throw new BizException("\u7528\u6237\u72b6\u6001\u5f02\u5e38");
        }
        if (null != engineOrderReq.getCreditAccountId()) {
            CreditAccountEo selectItemCreditAccount = new CreditAccountEo();
            selectItemCreditAccount.setId(engineOrderReq.getCreditAccountId());
            CreditAccountEo creditAccountEo = (CreditAccountEo)this.creditAccountDas.selectOne((BaseEo)selectItemCreditAccount);
            if (null == creditAccountEo || null == creditAccountEo.getId()) {
                throw new BizException("\u6307\u5b9a\u7684\u4fe1\u7528\u8d26\u6237\u4e0d\u5b58\u5728");
            }
        }
    }

    @Override
    public Boolean judgeDoAction(EngineOrderReq engineOrderReq) {
        if (null == engineOrderReq.getCreditAccountId()) {
            return false;
        }
        List usageRecordEoList = this.creditUsageRecordDas.queryByFromCode(engineOrderReq.getOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)usageRecordEoList)) {
            for (CreditUsageRecordEo creditUsageRecordEo : usageRecordEoList) {
                if (!CreditUsageTypeEnum.REMIND.getType().equals(creditUsageRecordEo.getUsageType())) continue;
                engineOrderReq.setIsReleaseMoney(BooleanEnum.YES.getCode());
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public EngineResult hitAccount(EngineOrderReq engineOrderReq) {
        EngineResult result = new EngineResult();
        List<CreditAccountEo> accountEoList = this.getAvailableAccount(engineOrderReq.getCustomerId(), result);
        if (CollectionUtils.isEmpty(accountEoList)) {
            return result;
        }
        ArrayList accountOccupyInfoList = Lists.newArrayList();
        BigDecimal totalAmount = engineOrderReq.getTotalAmount();
        AccountOccupyInfo accountOccupyInfo = new AccountOccupyInfo();
        accountOccupyInfo.setAccountId(accountEoList.get(0).getId());
        accountOccupyInfo.setDim1Id(accountEoList.get(0).getDim1Id());
        accountOccupyInfo.setDim2Id(accountEoList.get(0).getDim2Id());
        accountOccupyInfo.setDim3Id(accountEoList.get(0).getDim3Id());
        accountOccupyInfo.setOverdueStrategyId(accountEoList.get(0).getOverdueStrategyId());
        accountOccupyInfo.setQuotaStrategyId(accountEoList.get(0).getQuotaStrategyId());
        accountOccupyInfo.setCreditTermModelId(accountEoList.get(0).getCreditTermModelId());
        accountOccupyInfo.setAccountCode(accountEoList.get(0).getCreditAccountCode());
        accountOccupyInfo.setCreditAccountStatus(accountEoList.get(0).getCreditAccountStatus());
        accountOccupyInfo.setAvailableCredit(accountEoList.get(0).getAccountQuota().subtract(accountEoList.get(0).getAccountUsedQuota()));
        accountOccupyInfo.setOccupyQuota(totalAmount);
        accountOccupyInfoList.add(accountOccupyInfo);
        result.setCode(ExceptionCode.SUCCESS.getCode());
        result.setAccountOccupyInfoList((List)accountOccupyInfoList);
        result.setDesc(ExceptionCode.SUCCESS.getMsg());
        return result;
    }

    @Override
    public EngineResult hitPointAccount(EngineOrderReq engineOrderReq) {
        EngineResult result = new EngineResult();
        List<CreditAccountEo> accountEoList = this.getPointAccount(engineOrderReq.getCreditAccountId(), result);
        if (CollectionUtils.isEmpty(accountEoList)) {
            return result;
        }
        ArrayList accountOccupyInfoList = Lists.newArrayList();
        BigDecimal totalAmount = engineOrderReq.getTotalAmount();
        AccountOccupyInfo accountOccupyInfo = new AccountOccupyInfo();
        accountOccupyInfo.setAccountId(accountEoList.get(0).getId());
        accountOccupyInfo.setAccountCode(accountEoList.get(0).getCreditAccountCode());
        accountOccupyInfo.setAvailableCredit(accountEoList.get(0).getAccountQuota().subtract(accountEoList.get(0).getAccountUsedQuota()));
        accountOccupyInfo.setOccupyQuota(totalAmount);
        accountOccupyInfoList.add(accountOccupyInfo);
        result.setCode(ExceptionCode.SUCCESS.getCode());
        result.setAccountOccupyInfoList((List)accountOccupyInfoList);
        result.setDesc(ExceptionCode.SUCCESS.getMsg());
        return result;
    }

    @Override
    public EngineResult queryAccountConfig(EngineOrderReq engineOrderReq) {
        logger.info("------------------------------------------------\u83b7\u53d6\u652f\u4ed8\u8d26\u53f7\u914d\u7f6e------------------------------------------------");
        if (engineOrderReq.getCreditAccountId() == null) {
            throw new BizException("\u8bf7\u6307\u5b9a\u4fe1\u7528\u8d26\u6237\u8fdb\u884c\u652f\u4ed8");
        }
        CreditAccountEo creditAccountEo = new CreditAccountEo();
        creditAccountEo.setId(engineOrderReq.getCreditAccountId());
        creditAccountEo = (CreditAccountEo)this.creditAccountDas.selectOne((BaseEo)creditAccountEo);
        Assert.notNull((Object)creditAccountEo, (String)" \u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info("------------------------------------------------\u83b7\u53d6\u6307\u5b9a\u8d26\u53f7\u540d\u79f0[{}]", (Object)creditAccountEo.getCreditEntityName());
        AccountOccupyInfo accountOccupyInfo = new AccountOccupyInfo();
        accountOccupyInfo.setAccountCode(creditAccountEo.getCreditAccountCode());
        accountOccupyInfo.setCreditAccountStatus(creditAccountEo.getCreditAccountStatus());
        CreditOrderBillEo creditOrderBillEo = this.creditOrderBillDas.selectByOrderNo(engineOrderReq.getOrderNo());
        if (creditOrderBillEo == null) {
            OccupyConfigReqDto effectConfig = this.creditOccupyConfigService.getOccupyConfigByOrgId(creditAccountEo.getOrgInfoId());
            accountOccupyInfo.setAccountId(creditAccountEo.getId());
            accountOccupyInfo.setDim1Id(creditAccountEo.getDim1Id());
            accountOccupyInfo.setDim2Id(creditAccountEo.getDim2Id());
            accountOccupyInfo.setDim3Id(creditAccountEo.getDim3Id());
            accountOccupyInfo.setOverdueStrategyId(creditAccountEo.getOverdueStrategyId());
            accountOccupyInfo.setQuotaStrategyId(creditAccountEo.getQuotaStrategyId());
            accountOccupyInfo.setCreditTermModelId(creditAccountEo.getCreditTermModelId());
            accountOccupyInfo.setCreditOccupyConfigId(effectConfig.getId());
            logger.info("------------------------------------------------\u83b7\u53d6\u4fe1\u7528\u8d26\u6237\u914d\u7f6e:\u6ca1\u6709\u8d26\u5355\u8bb0\u5f55->\u7b2c\u4e00\u6b21\u4e0b\u5355" + JSON.toJSONString((Object)creditOrderBillEo));
        } else {
            accountOccupyInfo.setAccountId(creditOrderBillEo.getCreditAccountId());
            accountOccupyInfo.setDim1Id(creditOrderBillEo.getDim1Id());
            accountOccupyInfo.setDim2Id(creditOrderBillEo.getDim2Id());
            accountOccupyInfo.setDim3Id(creditOrderBillEo.getDim3Id());
            accountOccupyInfo.setOverdueStrategyId(creditOrderBillEo.getOverdueStrategyId());
            accountOccupyInfo.setQuotaStrategyId(creditOrderBillEo.getQuotaStrategyId());
            accountOccupyInfo.setCreditTermModelId(creditOrderBillEo.getCreditTermModelId());
            accountOccupyInfo.setCreditOccupyConfigId(creditOrderBillEo.getCreditOccupyConfigId());
            logger.info("------------------------------------------------\u83b7\u53d6\u4fe1\u7528\u8d26\u6237\u914d\u7f6e->\u975e\u7b2c\u4e00\u6b21\u4e0b\u5355" + JSON.toJSONString((Object)creditOrderBillEo));
        }
        if (creditOrderBillEo != null && StringUtils.isBlank((CharSequence)creditOrderBillEo.getFormCode()) && engineOrderReq.getIsReleaseMoney() == 2) {
            accountOccupyInfo.setOccupyQuota(creditOrderBillEo.getAccountUsedQuota());
            accountOccupyInfo.setAccountQuota(creditOrderBillEo.getAccountQuota());
            accountOccupyInfo.setAvailableCredit(creditOrderBillEo.getAccountQuota().subtract(creditOrderBillEo.getAccountUsedQuota()));
            logger.info("------------------------------------------------\u6709\u8d26\u5355\u8bb0\u5f55/\u5df2\u652f\u4ed8\u8fc7/\u672a\u91ca\u653e->\u83b7\u53d6\u65e7\u8d26\u5355\u53ef\u7528\u91d1\u989d" + JSON.toJSONString((Object)accountOccupyInfo.getAvailableCredit()));
        } else {
            accountOccupyInfo.setAvailableCredit(creditAccountEo.getAccountQuota().subtract(creditAccountEo.getAccountUsedQuota()).subtract(engineOrderReq.getTotalAmount()));
            accountOccupyInfo.setOccupyQuota(engineOrderReq.getTotalAmount());
            accountOccupyInfo.setAccountQuota(creditAccountEo.getAccountQuota().subtract(engineOrderReq.getTotalAmount()).subtract(creditAccountEo.getAccountUsedQuota()));
            logger.info("------------------------------------------------\u7b26\u5408\u65e0\u8d26\u5355\u8bb0\u5f55||\u6709\u8d26\u5355\u8bb0\u5f55\u4e14\u5360\u7528\u5df2\u91ca\u653e||\u6709\u8d26\u5355\u8bb0\u5f55\u672a\u5360\u7528-> \u91cd\u65b0\u62c9\u53d6\u8d26\u6237\u53ef\u7528\u91d1\u989d{}" + JSON.toJSONString((Object)accountOccupyInfo.getAvailableCredit()));
        }
        EngineResult result = new EngineResult();
        result.setAccountOccupyInfoList(Collections.singletonList(accountOccupyInfo));
        result.setCode(ExceptionCode.SUCCESS.getCode());
        CreditNodeEo creditNodeEo = this.checkNode(((AccountOccupyInfo)result.getAccountOccupyInfoList().get(0)).getCreditOccupyConfigId());
        result.setOccupyNodeName(creditNodeEo == null ? "" : creditNodeEo.getName());
        result.setOccupyCode(creditNodeEo == null ? "" : creditNodeEo.getCode());
        logger.info("------------------------------------------------\u83b7\u53d6\u4fe1\u7528\u8d26\u6237\u6570\u636e\u7ed3\u675f:{}", (Object)JSON.toJSONString((Object)accountOccupyInfo));
        logger.info("------------------------------------------------\u83b7\u53d6\u4fe1\u7528\u8d26\u6237\u6570\u636e\u7ed3\u675fresult:{}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    @Override
    public void validPolicy(EngineResult engineResult, EngineOrderReq engineOrderReq) {
        String node = engineOrderReq.getOrderNode();
        if (OrderNodeEnum.getType((String)node) == null) {
            throw new BizException("\u8282\u70b9\u5f02\u5e38,\u8bf7\u68c0\u67e5" + node);
        }
        CreditOrderBillEo selectItemCreditOrderBill = new CreditOrderBillEo();
        selectItemCreditOrderBill.setFormCode(engineOrderReq.getOrderNo());
        CreditOrderBillEo creditOrderBillEo = selectItemCreditOrderBill = StringUtils.isNotBlank((CharSequence)engineOrderReq.getOrderNo()) ? (CreditOrderBillEo)this.creditOrderBillDas.selectOne((BaseEo)selectItemCreditOrderBill) : null;
        if (!CreditAccountStatusEnum.GOOD.getCode().equals(((AccountOccupyInfo)engineResult.getAccountOccupyInfoList().get(0)).getCreditAccountStatus())) {
            logger.info("------------------------------------------------\u8d26\u53f7\u72b6\u6001\u5f02\u5e38/\u76f4\u63a5\u8fd4\u56de\u7ed9\u524d\u7aef:engineResult:" + JSON.toJSONString((Object)engineResult));
            engineResult.setDesc("\u8d26\u6237\u6821\u9a8c\u5931\u8d25:\u5ba2\u6237\u6240\u9009\u4fe1\u7528\u8d26\u6237\u5df2\u51bb\u7ed3\u6216\u8005\u5df2\u6ce8\u9500,\u652f\u4ed8\u5931\u8d25");
            engineResult.setPassQuotaStrategyRemind(BooleanEnum.NO.getCode());
            engineResult.setAccountState(BooleanEnum.NO.getCode());
            engineResult.setThisOrderSubmitState(BooleanEnum.NO.getCode());
            engineResult.setThisCreditQuotaState(BooleanEnum.NO.getCode());
            return;
        }
        List<Long> overdueStrategyIds = selectItemCreditOrderBill == null ? engineResult.getAccountOccupyInfoList().stream().map(AccountOccupyInfo::getOverdueStrategyId).distinct().collect(Collectors.toList()) : Collections.singletonList(selectItemCreditOrderBill.getOverdueStrategyId());
        this.validOverduePolicy(engineResult, engineOrderReq, overdueStrategyIds);
        if (engineResult.getOverdueStrategyRemind() != null) {
            logger.info("------------------------------------------------\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c:\u7b26\u5408\u903e\u671f\u6821\u9a8c\u8282\u70b9/\u53d7\u6b64\u7ba1\u63a7\u6216\u63d0\u9192,\u76f4\u63a5\u8fd4\u56de\u7ed9\u524d\u7aef");
            engineResult.setDesc("\u903e\u671f\u6821\u9a8c\u5931\u8d25:\u5ba2\u6237\u6240\u9009\u4fe1\u7528\u8d26\u6237\u6821\u9a8c\u4e0d\u901a\u8fc7");
            engineResult.setThisCreditQuotaState(BooleanEnum.NO.getCode());
            engineResult.setThisOrderSubmitState(BooleanEnum.NO.getCode());
            return;
        }
        boolean isAmountIsEnough = this.getNoEnoughCreditAccountEos(engineResult);
        boolean occupyState = engineResult.getOccupyCode() != null && engineResult.getOccupyCode().equals(engineOrderReq.getOrderNode()) || engineOrderReq.getCombinationPay() == 1;
        logger.info("------------------------------------------------\u5224\u65ad\u5f53\u524d\u8282\u70b9[{}]\u662f\u5426\u7b26\u5408\u5360\u7528\u8282\u70b9[{}]\u662f\u5426\u7b26\u5408\u5360\u7528[{}],\u7ed3\u679c[{}]", new Object[]{engineOrderReq.getOrderNode(), engineResult.getOccupyCode(), engineOrderReq.getCombinationPay() == 1 ? "\u7ec4\u5408\u652f\u4ed8" : "", occupyState ? "\u7b26\u5408" : "\u4e0d\u7b26\u5408"});
        engineResult.setOccupyState(Integer.valueOf(occupyState ? 1 : 2));
        if (occupyState && isAmountIsEnough) {
            logger.info("------------------------------------------------\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c:\u7b26\u5408\u989d\u5ea6\u5360\u7528/\u989d\u5ea6\u591f->\u652f\u4ed8\u6210\u529f,\u6539\u4e3a\u5f85\u53d1\u8d27:engineResult:[{}]", (Object)JSON.toJSONString((Object)engineResult));
            engineResult.setDesc("\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c:\u7b26\u5408\u989d\u5ea6\u5360\u7528/\u989d\u5ea6\u591f->\u652f\u4ed8\u6210\u529f,\u6539\u4e3a\u5f85\u53d1\u8d27");
            engineResult.setThisOrderSubmitState(BooleanEnum.YES.getCode());
            engineResult.setThisCreditQuotaState(BooleanEnum.YES.getCode());
            return;
        }
        if (occupyState && !isAmountIsEnough) {
            logger.info("------------------------------------------------\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c:\u7b26\u5408\u989d\u5ea6\u5360\u7528/\u989d\u5ea6\u4e0d\u591f->\u524d\u7aef\u63d0\u793a\u4f59\u989d\u4e0d\u8db3,\u4e0d\u4e88\u4e0b\u5355:engineResult:[{}]", (Object)JSON.toJSONString((Object)engineResult));
            engineResult.setDesc("\u989d\u5ea6\u5360\u7528\u5931\u8d25:\u5ba2\u6237\u6240\u9009\u4fe1\u7528\u8d26\u6237\u53ef\u7528\u4f59\u989d\u4e0d\u8db3,\u652f\u4ed8\u5931\u8d25");
            engineResult.setPassQuotaStrategyRemind(BooleanEnum.NO.getCode());
            engineResult.setThisCreditQuotaState(BooleanEnum.NO.getCode());
            engineResult.setThisOrderSubmitState(BooleanEnum.NO.getCode());
            return;
        }
        if (isAmountIsEnough) {
            logger.info("------------------------------------------------\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c:\u672a\u5230\u5360\u7528\u8282\u70b9/\u989d\u5ea6\u5145\u8db3->\u5141\u8bb8\u9a6c\u4e0a\u63d0\u4ea4\u8ba2\u5355\u5e76\u8bbe\u4e3a\u5f85\u652f\u4ed8:engineResult:[{}]", (Object)JSON.toJSONString((Object)engineResult));
            engineResult.setDesc("\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c:\u672a\u5230\u5360\u7528\u8282\u70b9/\u989d\u5ea6\u5145\u8db3->\u5141\u8bb8\u9a6c\u4e0a\u63d0\u4ea4\u8ba2\u5355\u5e76\u8bbe\u4e3a\u5f85\u652f\u4ed8");
            engineResult.setThisCreditQuotaState(BooleanEnum.NO.getCode());
            engineResult.setThisOrderSubmitState(BooleanEnum.YES.getCode());
            return;
        }
        this.dealEdu(engineResult, engineOrderReq, node);
        if (engineResult.getPassQuotaStrategyRemind() == null) {
            logger.info("------------------------------------------------\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c::\u672a\u5230\u5360\u7528\u8282\u70b9/\u4e0d\u5339\u914d\u989d\u5ea6\u6821\u9a8c\u7b56\u7565->\u5141\u8bb8\u9a6c\u4e0a\u63d0\u4ea4\u8ba2\u5355\u5e76\u8bbe\u4e3a\u5f85\u652f\u4ed8:engineResult:" + JSON.toJSONString((Object)engineResult));
            engineResult.setDesc("\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c::\u672a\u5230\u5360\u7528\u8282\u70b9/\u4e0d\u5339\u914d\u989d\u5ea6\u6821\u9a8c\u7b56\u7565->\u5141\u8bb8\u9a6c\u4e0a\u63d0\u4ea4\u8ba2\u5355\u5e76\u8bbe\u4e3a\u5f85\u652f\u4ed8");
            engineResult.setThisCreditQuotaState(BooleanEnum.NO.getCode());
            engineResult.setThisOrderSubmitState(BooleanEnum.YES.getCode());
            return;
        }
        if (BooleanEnum.NO.getCode().equals(engineResult.getPassQuotaStrategyRemind())) {
            logger.info("------------------------------------------------\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c::\u672a\u5230\u5360\u7528\u8282\u70b9/\u989d\u5ea6\u4e0d\u591f/\u4e14\u989d\u5ea6\u6821\u9a8c\u88ab\u8981\u6c42\u7ba1\u63a7->\u524d\u7aef\u63d0\u793a\u4f59\u989d\u4e0d\u8db3,\u4e0d\u4e88\u4e0b\u5355:engineResult:" + JSON.toJSONString((Object)engineResult));
            engineResult.setDesc("\u989d\u5ea6\u6821\u9a8c\u5931\u8d25:\u5ba2\u6237\u6240\u9009\u4fe1\u7528\u8d26\u6237\u53ef\u7528\u4f59\u989d\u4e0d\u8db3,\u652f\u4ed8\u5931\u8d25");
            engineResult.setThisCreditQuotaState(BooleanEnum.NO.getCode());
            engineResult.setThisOrderSubmitState(BooleanEnum.NO.getCode());
            return;
        }
        if (BooleanEnum.YES.getCode().equals(engineResult.getPassQuotaStrategyRemind())) {
            logger.info("------------------------------------------------\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c::\u672a\u5230\u5360\u7528\u8282\u70b9/\u989d\u5ea6\u4e0d\u591f/\u4e14\u989d\u5ea6\u6821\u9a8c\u88ab\u8981\u6c42\u63d0\u9192->\u524d\u7aef\u63d0\u793a\u4f59\u989d\u4e0d\u8db3,\u8981\u6c42\u786e\u8ba4\u540e\u4e0b\u5355:engineResult:" + JSON.toJSONString((Object)engineResult));
            engineResult.setDesc("\u672a\u5230\u5360\u7528\u8282\u70b9/\u989d\u5ea6\u4e0d\u591f/\u4e14\u989d\u5ea6\u6821\u9a8c\u88ab\u8981\u6c42\u63d0\u9192->\u524d\u7aef\u63d0\u793a\u4f59\u989d\u4e0d\u8db3,\u8981\u6c42\u786e\u8ba4\u540e\u4e0b\u5355");
            engineResult.setThisCreditQuotaState(BooleanEnum.NO.getCode());
            engineResult.setThisOrderSubmitState(BooleanEnum.NO.getCode());
            return;
        }
        logger.info("------------------------------------------------\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c::\u6821\u9a8c\u901a\u8fc7,\u8ba4\u5b9a\u5360\u7528\u989d\u5ea6\u5e76\u63d0\u4ea4\u8ba2\u5355:engineResult:" + JSON.toJSONString((Object)engineResult));
        engineResult.setDesc("\u672c\u6b21\u989d\u5ea6\u5360\u7528\u7ed3\u679c::\u6821\u9a8c\u901a\u8fc7,\u8ba4\u5b9a\u5360\u7528\u989d\u5ea6\u5e76\u63d0\u4ea4\u8ba2\u5355");
        engineResult.setThisCreditQuotaState(BooleanEnum.YES.getCode());
        engineResult.setThisOrderSubmitState(BooleanEnum.YES.getCode());
    }

    private void dealEdu(EngineResult engineResult, EngineOrderReq engineOrderReq, String node) {
        List quotaStrategyIds = engineResult.getAccountOccupyInfoList().stream().map(AccountOccupyInfo::getQuotaStrategyId).collect(Collectors.toList());
        List policyRuleEos = this.policyRuleDas.queryByNode(quotaStrategyIds, node);
        for (PolicyRuleEo policyRuleEo : policyRuleEos) {
            if (CreditType.REMIND.getType().equals(policyRuleEo.getCreditType()) && !BooleanEnum.YES.getCode().equals(engineOrderReq.getIsPassQuotaStrategyRemind())) {
                logger.info("------------------------------------------------\u67e5\u8be2\u989d\u5ea6\u6821\u9a8c\u7b56\u7565,\u547d\u4e2d\u7b56\u7565id{},\u7ed3\u679c\u4e3a\u989d\u5ea6\u63d0\u9192", (Object)policyRuleEo.getId());
                engineResult.setPassQuotaStrategyRemind(BooleanEnum.YES.getCode());
            }
            if (!CreditType.CONTROL.getType().equals(policyRuleEo.getCreditType())) continue;
            logger.info("------------------------------------------------\u67e5\u8be2\u989d\u5ea6\u6821\u9a8c\u7b56\u7565,\u547d\u4e2d\u7b56\u7565id{},\u7ed3\u679c\u4e3a\u989d\u5ea6\u7ba1\u63a7", (Object)policyRuleEo.getId());
            engineResult.setPassQuotaStrategyRemind(BooleanEnum.NO.getCode());
        }
    }

    private boolean getNoEnoughCreditAccountEos(EngineResult engineResult) {
        ArrayList noEnoughCreditAccountEoList = Lists.newArrayList();
        for (AccountOccupyInfo accountOccupyInfo : engineResult.getAccountOccupyInfoList()) {
            if (accountOccupyInfo.getAvailableCredit().compareTo(BigDecimal.valueOf(0L)) >= 0) continue;
            noEnoughCreditAccountEoList.add(accountOccupyInfo);
        }
        return noEnoughCreditAccountEoList.size() == 0;
    }

    private void validOverduePolicy(EngineResult engineResult, EngineOrderReq engineOrderReq, List<Long> overdueStrategyIds) {
        Date date = new Date();
        logger.info("------------------------------------------------\u8fdb\u5165\u903e\u671f\u6821\u9a8c,\u83b7\u53d6\u903e\u671f\u7b56\u7565id:{}", (Object)overdueStrategyIds.get(0).toString());
        logger.info("------------------------------------------------\u524d\u7aef\u8981\u6c42\u9047\u5230\u63d0\u9192\u65f6[{}]", (Object)(engineOrderReq.getIsPassOverdueStrategyRemind() != null && engineOrderReq.getIsPassOverdueStrategyRemind() == 1 ? "\u8df3\u8fc7\u63d0\u9192" : "\u4e0d\u8df3\u8fc7\u63d0\u9192"));
        List policyRuleEos = this.policyRuleDas.queryByNode(overdueStrategyIds, engineOrderReq.getOrderNode());
        if (CollectionUtils.isEmpty((Collection)policyRuleEos)) {
            logger.info("------------------------------------------------\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u7684\u903e\u671f\u7684\u7b56\u7565,\u6570\u91cf\u4e3a0,\u5df2\u9000\u51fa");
            return;
        }
        List policyEos = this.policyDas.queryByIds(overdueStrategyIds);
        if (CollectionUtils.isEmpty((Collection)policyRuleEos)) {
            throw new BizException("\u627e\u4e0d\u5230\u7b56\u7565,overdueStrategyIds[{}]", overdueStrategyIds.get(0).toString());
        }
        PolicyEo policyEo = (PolicyEo)policyEos.get(0);
        PolicyRuleEo policyRuleEo = (PolicyRuleEo)policyRuleEos.get(0);
        List listNoRefundPlans = this.creditRepayPlanDas.queryNotRefundRecord(engineOrderReq.getCustomerId(), DateUtil.getCurrenDate());
        if (CollectionUtils.isEmpty((Collection)listNoRefundPlans)) {
            logger.info("------------------------------------------------\u627e\u5230\u903e\u671f\u7684\u672a\u8fd8\u8d26\u5355,\u6570\u91cf:{},\u5df2\u9000\u51fa\u903e\u671f\u6821\u9a8c", (Object)listNoRefundPlans.size());
            return;
        }
        List listSortMaxAmountPlans = listNoRefundPlans.stream().sorted(Comparator.comparing(StdCreditRepayPlanEo::getEndDate)).collect(Collectors.toList());
        int maxOverdueDayNum = DateTimeUtils.betweenDays((Date)((CreditRepayPlanEo)listSortMaxAmountPlans.get(0)).getEndDate(), (Date)date);
        logger.info("------------------------------------------------\u67e5\u8be2\u5ba2\u6237\u672a\u8fd8\u6b3e\u5df2\u903e\u671f\u7684\u8d26\u5355\u6570\u91cf[{}],\u6700\u65e9\u903e\u671f\u65e5\u671f\u4e3a[{}]\u5176\u903e\u671f\u5929\u6570\u4e3a[{}]\u5929,", new Object[]{listNoRefundPlans.size(), DateTimeUtils.convertDateToAllString((Date)((CreditRepayPlanEo)listSortMaxAmountPlans.get(0)).getEndDate()), maxOverdueDayNum});
        if (maxOverdueDayNum > policyEo.getOverdueDaysLimit()) {
            logger.info("------------------------------------------------\u6309\u903e\u671f\u6821\u9a8c\u6700\u5927\u903e\u671f\u5929\u6570\u5224\u65ad,\u8981\u6c42\u4e3a\u6700\u5927\u903e\u671f\u5929\u6570\u4e0d\u5f97\u8d85\u8fc7[{}]\u5929", (Object)policyEo.getOverdueDaysLimit());
            if (this.dealOverdueLimit(engineResult, policyRuleEo.getCreditType(), engineOrderReq.getIsPassOverdueStrategyRemind())) {
                logger.info("------------------------------------------------\u4e0d\u6ee1\u8db3\u903e\u671f\u6821\u9a8c\u57fa\u7840\u6761\u4ef6,\u8981\u6c42\u4e3a\u6700\u5927\u903e\u671f\u5929\u6570\u4e0d\u5f97\u8d85\u8fc7[{}]\u5929,\u4e14[{}],\u524d\u7aef\u8981\u6c42[{}]", new Object[]{policyEo.getOverdueDaysLimit(), engineResult.getOverdueStrategyRemind() != null && engineResult.getOverdueStrategyRemind() == 1 ? "\u9700\u63d0\u9192\u7528\u6237" : "\u7ba1\u63a7\u63d0\u4ea4\u8ba2\u5355", engineOrderReq.getIsPassOverdueStrategyRemind() != null && engineOrderReq.getIsPassOverdueStrategyRemind() == 1 ? "\u8df3\u8fc7\u63d0\u9192,\u7ee7\u7eed\u68c0\u9a8c" : "\u4e0d\u8df3\u8fc7\u63d0\u9192,\u5df2\u9000\u51fa\u903e\u671f\u6821\u9a8c"});
                logger.info("------------------------------------------------\u903e\u671f\u6821\u9a8c\u6700\u5927\u903e\u671f\u5929\u6570\u5224\u5b9a\u7ed3\u679c:[{}]", (Object)(engineResult.getOverdueStrategyRemind() != null && engineResult.getOverdueStrategyRemind() == 1 ? "\u9700\u63d0\u9192\u7528\u6237" : "\u7ba1\u63a7\u63d0\u4ea4\u8ba2\u5355"));
                return;
            }
        }
        if (OverdueAmountType.NOT_CONDITION.getType().equals(policyEo.getOverdueAmountType())) {
            logger.info("------------------------------------------------\u67e5\u8be2\u5ba2\u6237\u903e\u671f\u5224\u65ad,\u6ca1\u6709\u5176\u4ed6\u6761\u4ef6,->\u8fd4\u56de");
            return;
        }
        Integer pointOverdueDayNum = policyEo.getOverdueAmountDays();
        List listOverMaxDayPlans = listSortMaxAmountPlans.stream().filter(item -> DateTimeUtils.betweenDays((Date)item.getEndDate(), (Date)date) >= pointOverdueDayNum).collect(Collectors.toList());
        if (OverdueAmountType.RATE_TYPE.getType().equals(policyEo.getOverdueAmountType())) {
            BigDecimal listNoRefundPlansAmount = listNoRefundPlans.stream().map(item -> item.getOccupyQuota().subtract(item.getReceivedAmount()).subtract(item.getRefundAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal listOverMaxDayPlansAmount = listOverMaxDayPlans.stream().map(item -> item.getOccupyQuota().subtract(item.getReceivedAmount()).subtract(item.getRefundAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal overdueAmountRate = new BigDecimal(policyEo.getOverdueAmountRate() + "");
            BigDecimal divide = listOverMaxDayPlansAmount.divide(listNoRefundPlansAmount, 2, 4).multiply(new BigDecimal("100"));
            boolean filter = listNoRefundPlansAmount.compareTo(BigDecimal.ZERO) != 0 && divide.compareTo(overdueAmountRate) > 0;
            logger.info("------------------------------------------------\u6309\u903e\u671f\u7387\u5224\u65ad->\u5df2\u903e\u671f[{}]\u5929\u7684\u8d26\u5355\u5e94\u6536\u603b\u989d[{}],\u672a\u8fd8\u8d26\u5355\u5e94\u6536\u603b\u989d[{}],\u903e\u671f\u7387[{}],\u8981\u6c42\u662f\u5c0f\u4e8e\u7b49\u4e8e[{}]", new Object[]{pointOverdueDayNum, listOverMaxDayPlansAmount, listNoRefundPlansAmount, divide, policyEo.getOverdueAmountRate()});
            if (filter && this.dealOverdueLimit(engineResult, policyRuleEo.getCreditType(), engineOrderReq.getIsPassOverdueStrategyRemind())) {
                logger.info("------------------------------------------------\u6309\u903e\u671f\u7387\u5224\u65ad->\u903e\u671f\u6821\u9a8c\u4e0d\u901a\u8fc7,\u5df2\u9000\u51fa\u903e\u671f\u6821\u9a8c[{}]", (Object)(engineResult.getOverdueStrategyRemind() != null && engineResult.getOverdueStrategyRemind() == 1 ? "\u9700\u63d0\u9192\u7528\u6237" : "\u7ba1\u63a7\u63d0\u4ea4\u8ba2\u5355"));
                return;
            }
        }
        if (OverdueAmountType.AMOUNT_TYPE.getType().equals(policyEo.getOverdueAmountType())) {
            BigDecimal listOverMaxDayPlansAmount = listOverMaxDayPlans.stream().map(item -> item.getOccupyQuota().subtract(item.getReceivedAmount()).subtract(item.getRefundAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal overdueAmount = new BigDecimal(policyEo.getOverdueAmount() + "");
            logger.info("------------------------------------------------\u6309\u903e\u671f\u603b\u91d1\u989d\u5224\u65ad->\u5df2\u903e\u671f[{}]\u5929\u7684\u8d26\u5355\u5e94\u6536\u603b\u989d[{}],\u8981\u6c42\u5c0f\u4e8e\u7b49\u4e8e\u91d1\u989d[{}],[{}]!", new Object[]{pointOverdueDayNum, listOverMaxDayPlansAmount, policyEo.getOverdueAmount(), engineOrderReq.getIsPassOverdueStrategyRemind() != null && engineOrderReq.getIsPassOverdueStrategyRemind() == 1 ? "\u8df3\u8fc7\u63d0\u9192" : "\u4e0d\u8df3\u8fc7\u63d0\u9192"});
            if (listOverMaxDayPlansAmount.compareTo(overdueAmount) > 0 && this.dealOverdueLimit(engineResult, policyRuleEo.getCreditType(), engineOrderReq.getIsPassOverdueStrategyRemind())) {
                logger.info("------------------------------------------------\u6309\u903e\u671f\u603b\u91d1\u989d\u5224\u65ad->\u627e\u5230\u8d26\u5355\u903e\u671f\u5929\u6570\u8d85\u8fc7\u8d26\u5355[{}]\u5929\u7684\u8d26\u5355[{}]\u4e2a,\u9000\u51fa!", (Object)pointOverdueDayNum, (Object)listOverMaxDayPlans.size());
                logger.info("------------------------------------------------\u6309\u903e\u671f\u603b\u91d1\u989d\u5224\u65ad\u4e0b\u4e00\u6b65->[{}]------------------------------------------------", (Object)(engineResult.getOverdueStrategyRemind() != null && engineResult.getOverdueStrategyRemind() == 1 ? "\u63d0\u9192\u7528\u6237" : "\u7ba1\u63a7\u63d0\u4ea4\u8ba2\u5355"));
                return;
            }
        }
        logger.info("------------------------------------------------\u903e\u671f\u6821\u9a8c\u6b63\u5e38\u901a\u8fc7------------------------------------------------");
    }

    private boolean dealOverdueLimit(EngineResult engineResult, Integer creditType, Integer isPassOverdueStrategyRemind) {
        Assert.notNull((Object)creditType, (String)"\u4fe1\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (CreditType.REMIND.getType().equals(creditType) && isPassOverdueStrategyRemind != null && 1 == isPassOverdueStrategyRemind) {
            return false;
        }
        if (CreditType.REMIND.getType().equals(creditType)) {
            engineResult.setOverdueStrategyRemind(BooleanEnum.YES.getCode());
            return true;
        }
        if (CreditType.CONTROL.getType().equals(creditType)) {
            engineResult.setOverdueStrategyRemind(BooleanEnum.NO.getCode());
            return true;
        }
        return true;
    }

    private OccupyConfigDto queryNode() {
        OccupyConfigDto occupyConfigDto = new OccupyConfigDto();
        List occupyConfigEoList = this.creditOccupyConfigDas.selectAll();
        if (CollectionUtils.isNotEmpty((Collection)occupyConfigEoList)) {
            CreditOccupyConfigEo occupyConfigEo = (CreditOccupyConfigEo)occupyConfigEoList.get(0);
            List<Long> idsList = Arrays.stream(occupyConfigEo.getReleaseCreditNode().split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            idsList.add(occupyConfigDto.getCreditNode());
            List creditNodeEos = this.creditNodeDas.queryNodeListByIds(idsList);
            ArrayList releaseNames = Lists.newArrayList();
            for (CreditNodeEo creditNodeEo : creditNodeEos) {
                if (creditNodeEo.getId().equals(occupyConfigDto.getCreditNode())) {
                    occupyConfigDto.setCode(creditNodeEo.getCode());
                    continue;
                }
                releaseNames.add(creditNodeEo.getName());
            }
            occupyConfigDto.setReleaseCreditNodeNames(releaseNames);
            occupyConfigDto.setCreditNode(Long.valueOf(occupyConfigEo.getCreditNode()));
            occupyConfigDto.setReleaseCreditNodeIds(idsList);
        }
        return occupyConfigDto;
    }

    private CreditNodeEo checkNode(Long configId) {
        CreditOccupyConfigEo creditOccupyConfigEo = configId == null ? this.creditOccupyConfigDas.findEffectConfig() : (CreditOccupyConfigEo)this.creditOccupyConfigDas.selectByPrimaryKey(configId);
        if (creditOccupyConfigEo == null) {
            return null;
        }
        CreditNodeEo creditNodeEo = (CreditNodeEo)this.creditNodeDas.selectByPrimaryKey(Long.valueOf(creditOccupyConfigEo.getCreditNode()));
        return creditNodeEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String occupyQuota(EngineOrderReq engineOrderReq, EngineResult engineResult) {
        String usageRecordNo = "";
        if (!CollectionUtils.isEmpty((Collection)engineResult.getAccountOccupyInfoList())) {
            for (AccountOccupyInfo accountOccupyInfo : engineResult.getAccountOccupyInfoList()) {
                CreditAccountUpdateQuotaReqDto creditAccountUpdateQuotaReqDto = new CreditAccountUpdateQuotaReqDto();
                creditAccountUpdateQuotaReqDto.setCreditAccountId(engineOrderReq.getCreditAccountId());
                creditAccountUpdateQuotaReqDto.setCreditEntityId(engineOrderReq.getCustomerId());
                creditAccountUpdateQuotaReqDto.setFormCode(engineOrderReq.getOrderNo());
                creditAccountUpdateQuotaReqDto.setGrantQuota(accountOccupyInfo.getOccupyQuota());
                creditAccountUpdateQuotaReqDto.setRemark(CreditUsageRecordType.PRE_SUBMIT_ORDER.getDesc());
                creditAccountUpdateQuotaReqDto.setCreditAccountUpdateTypeEnum(CreditAccountUpdateTypeEnum.SUB);
                creditAccountUpdateQuotaReqDto.setCreditUsageStatus(CreditUsageStatusEnum.WAIT.getCode());
                creditAccountUpdateQuotaReqDto.setOrgInfoId(engineOrderReq.getOrgId());
                usageRecordNo = this.iCreditAccountService.useAndReleaseQuota(creditAccountUpdateQuotaReqDto);
            }
        }
        return usageRecordNo;
    }

    @Override
    public List<CreditRepayPlanEo> buildPlan(CreditPlanDto engineOrderReq) {
        logger.info("\u5f53\u524d\u7c7b=AccountQuotaActionImpl.buildPlan()-\u83b7\u53d6\u8ba1\u5212\u5f00\u59cb" + JSON.toJSONString((Object)engineOrderReq));
        Date now = new Date();
        CreditRepayPlanEo creditRepayPlanEo = new CreditRepayPlanEo();
        ArrayList<CreditRepayPlanEo> creditRepayPlanEos = new ArrayList<CreditRepayPlanEo>();
        CreditAccountEo creditAccountEoParam = new CreditAccountEo();
        creditAccountEoParam.setCreditAccountCode(engineOrderReq.getCreditAccountCode());
        CreditAccountEo creditAccountEo = (CreditAccountEo)this.creditAccountDas.selectOne((BaseEo)creditAccountEoParam);
        CreditTermModelInfoRespDto detail = engineOrderReq.getCreditTermModelId() == null ? (CreditTermModelInfoRespDto)this.creditTermModelService.getDetail(creditAccountEo.getCreditTermModelId()) : (CreditTermModelInfoRespDto)this.creditTermModelService.getDetail(engineOrderReq.getCreditTermModelId());
        CreditTermTypeEnum type = CreditTermTypeEnum.getType((Integer)detail.getType());
        if (null == type) {
            return null;
        }
        Long orgId = creditAccountEo.getOrgInfoId();
        switch (type) {
            case GENERAL: {
                creditRepayPlanEo = this.getCreditRepayPlanEo(orgId, engineOrderReq, creditAccountEo, detail);
                logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u4e00\u822c\u8d26\u671f\u3011");
                Calendar cl = Calendar.getInstance();
                cl.setTime(new Date());
                Integer delayNumber = ((CreditTermModelRuleReqDto)detail.getTermModelRuleReqDtoList().get(0)).getAfterDays();
                cl.add(5, delayNumber);
                Date time1 = cl.getTime();
                String normalDate = DateTimeUtils.convertDateTimeToString((Date)time1);
                normalDate = this.extracted(normalDate);
                try {
                    creditRepayPlanEo.setEndDate(DateTimeUtils.convertStringToDateTime((String)normalDate));
                }
                catch (ParseException e) {
                    logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u4e00\u822c\u8d26\u671f\u3011:\u65e5\u671f\u8f6c\u5316\u5f02\u5e38");
                    e.printStackTrace();
                }
                creditRepayPlanEos.add(creditRepayPlanEo);
                break;
            }
            case WEEK: {
                creditRepayPlanEo = this.getCreditRepayPlanEo(orgId, engineOrderReq, creditAccountEo, detail);
                logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u5468\u7ed3\u65e5\u3011");
                Calendar c2 = Calendar.getInstance();
                c2.setTime(new Date());
                int day = c2.get(5);
                Iterator iterator = detail.getTermModelRuleReqDtoList().iterator();
                if (!iterator.hasNext()) break;
                CreditTermModelRuleReqDto ruleReqDto = (CreditTermModelRuleReqDto)iterator.next();
                Date date = null;
                if (day >= ruleReqDto.getDateRangeStart() && day <= ruleReqDto.getDateRangeEnd()) {
                    if (ruleReqDto.getDelayUnit().equals(DelayUnitEnum.DAY.getCode())) {
                        c2.add(5, ruleReqDto.getDelayNumber());
                    } else {
                        c2.add(2, ruleReqDto.getDelayNumber());
                    }
                    Date pointDayOfThisWeek = DateTimeUtils.getPointDayOfThisWeek((Date)now, (int)Integer.parseInt(ruleReqDto.getWeek()));
                    if (DateTimeUtils.getDayStartTime((Date)pointDayOfThisWeek).before(DateTimeUtils.getDayStartTime((Date)c2.getTime()))) {
                        pointDayOfThisWeek = DateTimeUtils.addDay((Date)pointDayOfThisWeek, (int)7);
                    }
                    int featureDay = Math.max(ruleReqDto.getWeekNumber() - 1, 0) * 7;
                    date = DateTimeUtils.addDay((Date)pointDayOfThisWeek, (int)featureDay);
                    String normalDate1 = DateTimeUtils.convertDateTimeToString((Date)date);
                    normalDate1 = this.extracted(normalDate1);
                    try {
                        creditRepayPlanEo.setEndDate(DateTimeUtils.getDayEndTime((Date)DateTimeUtils.convertStringToDateTime((String)normalDate1)));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u5468\u7ed3\u65e5\u3011,\u8fd8\u6b3e\u65f6\u95f4\u5f02\u5e38{}", (Object)normalDate1);
                    }
                    logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u5468\u7ed3\u65e5\u3011,\u65f6\u95f4\uff1a{}", (Object)DateUtil.format((Date)c2.getTime()));
                }
                creditRepayPlanEos.add(creditRepayPlanEo);
                break;
            }
            case MONTH: {
                creditRepayPlanEo = this.getCreditRepayPlanEo(orgId, engineOrderReq, creditAccountEo, detail);
                logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u6708\u7ed3\u65e5\u3011");
                Calendar c22 = Calendar.getInstance();
                c22.setTime(new Date());
                int dayy = c22.get(5);
                for (CreditTermModelRuleReqDto ruleReqDto : detail.getTermModelRuleReqDtoList()) {
                    if (dayy < ruleReqDto.getDateRangeStart() || dayy > ruleReqDto.getDateRangeEnd()) continue;
                    c22.add(2, ruleReqDto.getDelayNumber());
                    c22.set(5, ruleReqDto.getDateNumber());
                    Date time = c22.getTime();
                    String s = DateTimeUtils.convertDateTimeToString((Date)time);
                    s = this.extracted(s);
                    try {
                        creditRepayPlanEo.setEndDate(DateTimeUtils.convertStringToDateTime((String)s));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u6708\u7ed3\u65e5\u3011,\u8fd8\u6b3e\u65e5\u8f6c\u5316\u5f02\u5e38\uff1a{}", (Object)DateUtil.format((Date)c22.getTime()));
                    }
                    logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u6708\u7ed3\u65e5\u3011,\u65f6\u95f4\uff1a{}", (Object)DateUtil.format((Date)c22.getTime()));
                    break;
                }
                creditRepayPlanEos.add(creditRepayPlanEo);
                break;
            }
            case INSTALLMENT: {
                logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u5206\u671f\u4ed8\u6b3e\u3011");
                int cycleNum = 1;
                int size = detail.getTermModelRuleReqDtoList().size();
                for (CreditTermModelRuleReqDto creditTermModelRuleReqDto : detail.getTermModelRuleReqDtoList()) {
                    creditRepayPlanEo = this.getCreditRepayPlanEo(orgId, engineOrderReq, creditAccountEo, detail);
                    Date date = DateTimeUtils.addDay((Date)now, (int)creditTermModelRuleReqDto.getAfterDays());
                    creditRepayPlanEo.setEndDate(date);
                    creditRepayPlanEo.setOccupyQuota(engineOrderReq.getOccupyQuota().multiply(creditTermModelRuleReqDto.getPayRate()).divide(new BigDecimal("100"), 2));
                    creditRepayPlanEo.setCycleNum(Integer.valueOf(cycleNum));
                    creditRepayPlanEo.setCycleTotalNum(Integer.valueOf(size));
                    creditRepayPlanEos.add(creditRepayPlanEo);
                    ++cycleNum;
                }
                break;
            }
            case SURE_DAY: {
                logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u8fd8\u6b3e\u65e5\u4e3a\u6307\u5b9a\u65e5\u671f\u3011");
                creditRepayPlanEo = this.getCreditRepayPlanEo(orgId, engineOrderReq, creditAccountEo, detail);
                for (CreditTermModelRuleReqDto ruleReqDto : detail.getTermModelRuleReqDtoList()) {
                    Date beginStartDay = ruleReqDto.getBeginStartDay();
                    Date beginEndDay = ruleReqDto.getBeginEndDay();
                    logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u8fd8\u6b3e\u65e5\u3011,\u65f6\u95f4\uff1a\u4f20\u53c2{}", (Object)JSON.toJSONString((Object)ruleReqDto));
                    Date beginStartDayToYear = DateTimeUtils.getDayStartTime((int)DateTimeUtils.getYearOfDay((Date)now), (int)DateTimeUtils.getMonth((Date)beginStartDay), (int)DateTimeUtils.getDay((Date)beginStartDay));
                    Date beginEndDayToYear = DateTimeUtils.getDayEndTime((int)DateTimeUtils.getYearOfDay((Date)now), (int)DateTimeUtils.getMonth((Date)beginEndDay), (int)DateTimeUtils.getDay((Date)beginEndDay));
                    if (!now.after(beginStartDayToYear) || !now.before(beginEndDayToYear)) continue;
                    Date sureEndDay = ruleReqDto.getSureEndDay();
                    String toYearReFundTime = DateTimeUtils.getYearOfDay((Date)now) + "-" + DateTimeUtils.getMonth((Date)sureEndDay) + "-" + DateTimeUtils.getDay((Date)sureEndDay) + " 00:00:00";
                    toYearReFundTime = this.extracted(toYearReFundTime);
                    Date finalDay = now;
                    try {
                        finalDay = DateTimeUtils.convertStringToDateTime((String)toYearReFundTime);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u8fd8\u6b3e\u65e5\u3011,\u65f6\u95f4\uff1a{}\u8f6c\u5316\u5f02\u5e38", (Object)DateTimeUtils.convertDateTimeToString((Date)creditRepayPlanEo.getEndDate()));
                    }
                    if (finalDay.before(now)) {
                        finalDay = DateTimeUtils.addYear((Date)finalDay, (int)1);
                    }
                    creditRepayPlanEo.setEndDate(finalDay);
                    logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u8fd8\u6b3e\u65e5\u3011,\u65f6\u95f4\uff1a{}\u6700\u7ec8\u65f6\u95f4", (Object)DateTimeUtils.convertDateTimeToString((Date)finalDay));
                    break;
                }
                logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u3010\u56fa\u5b9a\u8fd8\u6b3e\u65e5\u3011,\u65f6\u95f4\uff1a{}", (Object)DateTimeUtils.convertDateTimeToString((Date)creditRepayPlanEo.getEndDate()));
                creditRepayPlanEos.add(creditRepayPlanEo);
                break;
            }
            default: {
                logger.info("--\u751f\u6210\u8d26\u671f\uff0c\u72b6\u6001\u4e0d\u9700\u5904\u7406");
            }
        }
        logger.info("\u5f53\u524d\u7c7b=AccountQuotaActionImpl.updateQuotaRecord()-\u83b7\u53d6\u8ba1\u5212\u7ed3\u675f" + JSON.toJSONString(creditRepayPlanEos));
        return creditRepayPlanEos;
    }

    private String extracted(String toYearReFundTime) {
        while (!DateTimeUtils.verifyDateLegal((String)toYearReFundTime)) {
            String[] split = toYearReFundTime.split("-");
            String[] splitByBlankSpace = split[2].split("\\s+");
            String dayNum = splitByBlankSpace[0];
            int day = Integer.parseInt(dayNum);
            split[2] = --day + " 00:00:00";
            toYearReFundTime = split[0] + "-" + split[1] + "-" + split[2];
        }
        return toYearReFundTime;
    }

    @Override
    @Transactional
    public Integer savePlan(List<CreditRepayPlanEo> creditRepayPlans) {
        return this.creditRepayPlanDas.insertBatch(creditRepayPlans);
    }

    private CreditRepayPlanEo getCreditRepayPlanEo(Long orgId, CreditPlanDto engineOrderReq, CreditAccountEo creditAccountEo, CreditTermModelInfoRespDto detail) {
        CreditRepayPlanEo creditRepayPlanEo = new CreditRepayPlanEo();
        CreditNodeEo selectItemCreditNode = new CreditNodeEo();
        selectItemCreditNode.setCode(BeginDateTypeEnum.QUOTA_OCCUPY_BEGIN_DAY.getCode());
        List creditNodeEos = this.creditNodeDas.selectList((BaseEo)selectItemCreditNode);
        if (CollectionUtils.isEmpty((Collection)creditNodeEos)) {
            throw new BizException("QUOTA_OCCUPY_BEGIN_DAY \u8282\u70b9\u6570\u636e\u7f3a\u5931,\u8bf7\u68c0\u67e5\u8865\u4e01");
        }
        creditRepayPlanEo.setCycleNum(Integer.valueOf(1));
        creditRepayPlanEo.setAuditStatus("NONE");
        creditRepayPlanEo.setCycleTotalNum(Integer.valueOf(1));
        DtoHelper.dto2Eo((BaseVo)engineOrderReq, (BaseEo)creditRepayPlanEo);
        creditRepayPlanEo.setIsHolidayDelay(detail.getIsHolidayDelay());
        creditRepayPlanEo.setStartDate(new Date());
        creditRepayPlanEo.setCreditRepayPlanStatus(CreditRepayPlanStatusEnum.WAT_EFFECT.getCode());
        creditRepayPlanEo.setCreditTermModelId(creditAccountEo.getCreditTermModelId());
        creditRepayPlanEo.setCreditTermType(detail.getType());
        creditRepayPlanEo.setRepayPlanNo(this.generateCode.createCode(GeneralRuleCodeType.PLAN_RECORD));
        creditRepayPlanEo.setPaidAmount(engineOrderReq.getOccupyQuota());
        creditRepayPlanEo.setRefundAmount(BigDecimal.ZERO);
        creditRepayPlanEo.setReceivedAmount(BigDecimal.valueOf(0L));
        creditRepayPlanEo.setOccupyQuota(engineOrderReq.getOccupyQuota());
        creditRepayPlanEo.setCustomerId(creditAccountEo.getCreditEntityId());
        creditRepayPlanEo.setFormCode(engineOrderReq.getOrderNo());
        creditRepayPlanEo.setCreditAccountId(engineOrderReq.getCreditAccountId());
        creditRepayPlanEo.setOrgInfoId(orgId);
        return creditRepayPlanEo;
    }

    @Override
    public EngineResult doAction(EngineOrderReq engineOrderReq) {
        logger.info("------------------------------------------------\u4fe1\u7528\u652f\u4ed8\u5f00\u59cb");
        logger.info("------------------------------------------------\u4fe1\u7528\u652f\u4ed8\u5f00\u59cb");
        logger.info("\u989d\u5ea6\u5360\u7528,\u989d\u5ea6\u6821\u9a8c\u4fe1\u7528\u4e2d\u5fc3\u5165\u53e3----:" + JSONObject.toJSONString((Object)engineOrderReq));
        EngineResult result = new EngineResult();
        this.validParams(result, engineOrderReq);
        Boolean aBoolean = this.judgeDoAction(engineOrderReq);
        if (!aBoolean.booleanValue()) {
            logger.info("------------------------------------------------\u63d0\u4ea4\u4fe1\u7528\u652f\u4ed8:\u5224\u65ad\u662f\u5426\u5df2\u5360\u7528\u989d\u5ea6[{}],", (Object)(aBoolean == false ? "\u662f" : "\u5426"));
            logger.info("------------------------------------------------\u63d0\u4ea4\u4fe1\u7528\u652f\u4ed8:\u662f\u5426\u76f4\u63a5\u9000\u51fa\u4fe1\u7528\u4e2d\u5fc3[{}],", (Object)(aBoolean == false ? "\u662f" : "\u5426"));
            result.setCode(ExceptionCode.SUCCESS.getCode());
            result.setDesc(ExceptionCode.SUCCESS.getMsg());
            result.setThisOrderSubmitState(BooleanEnum.YES.getCode());
            result.setThisCreditQuotaState(BooleanEnum.NO.getCode());
            return result;
        }
        result = this.queryAccountConfig(engineOrderReq);
        if (!ExceptionCode.SUCCESS.getCode().equals(result.getCode())) {
            return result;
        }
        this.validPolicy(result, engineOrderReq);
        if (StringUtils.isBlank((CharSequence)result.getCreditOrderBillCode()) && BooleanEnum.YES.getCode().equals(result.getThisOrderSubmitState())) {
            String creditOrderBillCode = this.addCreditOrderBill(result, engineOrderReq, "");
            result.setCreditOrderBillCode(creditOrderBillCode);
        }
        if (!BooleanEnum.YES.getCode().equals(result.getThisCreditQuotaState())) {
            return result;
        }
        String usageRecordNo = this.occupyQuota(engineOrderReq, result);
        if (!StringUtils.isBlank((CharSequence)usageRecordNo)) {
            this.creditOrderBillDas.updateUsageRecordNo(result.getCreditOrderBillCode(), usageRecordNo);
        }
        return result;
    }

    @Override
    @Transactional
    public void changeRePayPlan(String orderNo) {
        logger.info("\u53d1\u8d27\u89e6\u53d1\u8d26\u5355\u63a5\u53e3,\u8ba2\u5355\u53f7----:[{}]", (Object)JSONObject.toJSONString((Object)orderNo));
        CreditRepayPlanEo selectItemCreditRepayPlan = new CreditRepayPlanEo();
        Date date = new Date();
        selectItemCreditRepayPlan.setFormCode(orderNo);
        selectItemCreditRepayPlan.setCreditRepayPlanStatus(CreditRepayPlanStatusEnum.WAT_EFFECT.getCode());
        List creditRepayPlanEos = this.creditRepayPlanDas.selectList((BaseEo)selectItemCreditRepayPlan);
        if (CollectionUtils.isEmpty((Collection)creditRepayPlanEos)) {
            logger.info("\u53d1\u8d27\u89e6\u53d1\u8d26\u5355\u63a5\u53e3,\u8ba2\u5355\u53f7----:[{}],\u6570\u636e\u4e3a\u7a7a\u9000\u51fa", (Object)JSONObject.toJSONString((Object)orderNo));
            return;
        }
        CreditTermModelEo creditTermModelEo = (CreditTermModelEo)this.creditTermModelDas.selectByPrimaryKey(((CreditRepayPlanEo)creditRepayPlanEos.get(0)).getCreditTermModelId());
        logger.info("\u53d1\u8d27\u89e6\u53d1\u8d26\u5355\u63a5\u53e3,\u8ba2\u5355\u53f7----:[{}],\u83b7\u53d6\u4e0b\u5355\u5197\u4f59\u7684\u8d26\u671f:[{}]", (Object)orderNo, (Object)JSONObject.toJSONString((Object)creditTermModelEo));
        for (CreditRepayPlanEo creditRepayPlanEo : creditRepayPlanEos) {
            int afterDays = creditTermModelEo.getAfterDays() != null ? creditTermModelEo.getAfterDays() : 0;
            creditRepayPlanEo.setBeginDateType("\u53d1\u8d27\u65e5" + (afterDays > 0 ? "+" + afterDays : ""));
            Date trueStartDate = DateTimeUtils.addDay((Date)date, (int)afterDays);
            int i = DateTimeUtils.betweenDays((Date)creditRepayPlanEo.getStartDate(), (Date)trueStartDate);
            creditRepayPlanEo.setStartDate(DateTimeUtils.addDay((Date)creditRepayPlanEo.getStartDate(), (int)i));
            creditRepayPlanEo.setEndDate(DateTimeUtils.addDay((Date)creditRepayPlanEo.getEndDate(), (int)i));
            creditRepayPlanEo.setCreditRepayPlanStatus(CreditRepayPlanStatusEnum.NOT_RECEIVABLE.getCode());
            this.creditRepayPlanDas.updateSelective((BaseEo)creditRepayPlanEo);
        }
    }

    @Override
    public Long preOccupyQuota(EngineOrderReq engineOrderReq) {
        if (null == engineOrderReq.getCustomerId()) {
            throw new BizException("\u5ba2\u6237\u4fe1\u606f\u7f3a\u5931");
        }
        if (null == engineOrderReq.getTotalAmount()) {
            throw new BizException("\u91d1\u989dTotalAmount\u4fe1\u606f\u7f3a\u5931");
        }
        OrderNodeEnum node = OrderNodeEnum.getType((String)engineOrderReq.getOrderNode());
        if (null == node) {
            throw new BizException("\u8282\u70b9NodeCode\u4fe1\u606f\u9519\u8bef");
        }
        CreditAccountUpdateQuotaReqDto creditAccountUpdateQuotaReqDto = new CreditAccountUpdateQuotaReqDto();
        creditAccountUpdateQuotaReqDto.setCreditAccountId(engineOrderReq.getCreditAccountId());
        creditAccountUpdateQuotaReqDto.setCreditEntityId(engineOrderReq.getCustomerId());
        creditAccountUpdateQuotaReqDto.setFormCode(engineOrderReq.getOrderNo());
        creditAccountUpdateQuotaReqDto.setGrantQuota(engineOrderReq.getTotalAmount());
        creditAccountUpdateQuotaReqDto.setRemark(CreditUsageRecordType.PRE_SUBMIT_ORDER.getDesc());
        Long recordId = this.iCreditAccountService.preUseQuota(creditAccountUpdateQuotaReqDto);
        return recordId;
    }

    @Override
    public boolean validParams(ReverseOrderReq reverseOrderReq) {
        if (null == reverseOrderReq.getNodeCode()) {
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u8282\u70b9\u4fe1\u606f\u7f3a\u5931,\u8ba2\u5355\u7f16\u7801:" + reverseOrderReq.getOrderNo());
            return false;
        }
        OrderNodeEnum node = OrderNodeEnum.getType((String)(reverseOrderReq.getNodeCode() + ""));
        if (null == node) {
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u8282\u70b9\u4fe1\u606f\u9519\u8bef,\u8ba2\u5355\u7f16\u7801:" + reverseOrderReq.getOrderNo());
            return false;
        }
        if (reverseOrderReq.getIsRefund() == 1 && null == reverseOrderReq.getReceivedAmount()) {
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u975e\u6574\u5355\u8fd8\u6b3e,\u9700\u586b\u5199\u8fd8\u6b3e\u91d1\u989d,\u8ba2\u5355\u7f16\u7801:" + reverseOrderReq.getOrderNo());
            return false;
        }
        CreditOrderBillEo selectItemCreditOrderBill = new CreditOrderBillEo();
        selectItemCreditOrderBill.setFormCode(reverseOrderReq.getOrderNo());
        CreditOrderBillEo creditOrderBillEo = StringUtils.isNotBlank((CharSequence)reverseOrderReq.getOrderNo()) ? (CreditOrderBillEo)this.creditOrderBillDas.selectOne((BaseEo)selectItemCreditOrderBill) : null;
        Long orgId = 0L;
        if (creditOrderBillEo != null) {
            reverseOrderReq.setCustomerId(creditOrderBillEo.getCreditEntityId());
            orgId = creditOrderBillEo.getOrgInfoId();
        }
        if (node.equals((Object)OrderNodeEnum.COLLECTION) || node.equals((Object)OrderNodeEnum.REFUND)) {
            if (null == reverseOrderReq.getReceivedAmount() || reverseOrderReq.getReceivedAmount().compareTo(BigDecimal.valueOf(0L)) < 1) {
                logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u56de\u6b3e/\u9000\u6b3e\u989d\u5ea6\u9700\u5927\u4e8e0,\u8ba2\u5355\u7f16\u7801:" + reverseOrderReq.getOrderNo());
                return false;
            }
        } else {
            if (StringUtils.isEmpty((CharSequence)reverseOrderReq.getOrderNo())) {
                logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u8ba2\u5355\u4fe1\u606f\u7f3a\u5931,\u8ba2\u5355\u7f16\u7801:" + reverseOrderReq.getOrderNo());
                return false;
            }
            reverseOrderReq.setIsRefund(YesOrNoStatus.YES_STATUS.getStatus());
            reverseOrderReq.setReceiveType(ReceiveType.CONTROL.getType());
        }
        OccupyConfigReqDto configReqDto = this.creditOccupyConfigService.getOccupyConfigByOrgId(orgId);
        List nodeEoList = this.creditNodeDas.queryNodeListByName(node.getDesc(), RelevanceType.QUOTA_RELEASE.getType());
        if (CollectionUtils.isEmpty((Collection)nodeEoList) || CollectionUtils.isEmpty((Collection)configReqDto.getReleaseCreditNodeIds())) {
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u5f53\u524d\u8282\u70b9\u975e\u91ca\u653e\u989d\u5ea6\u8282\u70b9,\u8ba2\u5355\u7f16\u7801:" + reverseOrderReq.getOrderNo());
            return false;
        }
        boolean isExist = false;
        for (Long releaseCreditNodeId : configReqDto.getReleaseCreditNodeIds()) {
            if (!releaseCreditNodeId.equals(((CreditNodeEo)nodeEoList.get(0)).getId())) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u5f53\u524d\u8282\u70b9\u975e\u91ca\u653e\u989d\u5ea6\u8282\u70b9,\u8ba2\u5355\u7f16\u7801:" + reverseOrderReq.getOrderNo());
            return false;
        }
        logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u901a\u8fc7\u6821\u9a8c,\u8ba2\u5355\u7f16\u7801:" + reverseOrderReq.getOrderNo());
        return true;
    }

    @Override
    public Boolean judgeReverse(ReverseOrderReq reverseOrderReq) {
        List<CreditRepayPlanEo> repayPlanEoList = this.getCreditRepayPlanList(reverseOrderReq);
        if (CollectionUtils.isNotEmpty(repayPlanEoList)) {
            BigDecimal amount = BigDecimal.valueOf(0L);
            for (CreditRepayPlanEo repayPlanEo : repayPlanEoList) {
                BigDecimal getOccupyQuota = repayPlanEo.getOccupyQuota() == null ? BigDecimal.ZERO : repayPlanEo.getOccupyQuota();
                BigDecimal getReceivedAmount = repayPlanEo.getReceivedAmount() == null ? BigDecimal.ZERO : repayPlanEo.getReceivedAmount();
                BigDecimal getRefundAmount = repayPlanEo.getRefundAmount() == null ? BigDecimal.ZERO : repayPlanEo.getRefundAmount();
                amount = amount.add(getOccupyQuota.subtract(getReceivedAmount).subtract(getRefundAmount));
            }
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d[{}]:", (Object)amount);
            if (reverseOrderReq.getReceivedAmount().compareTo(amount) > 0) {
                logger.info("------------------------------------------------\u8fd8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u8fd8\u6b3e\u91d1\u989d,\u9ed8\u8ba4\u6309\u7167\u6240\u9700\u8fd8\u6b3e\u91d1\u989d\u8fdb\u884c\u8fd8\u6b3e,\u4e0d\u518d\u7d2f\u8ba1\u6ea2\u5b58\u6b3e,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d[{}]:", (Object)amount);
                reverseOrderReq.setReceivedAmount(amount);
            }
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u5df2\u7ecf\u5168\u90e8\u8fd8\u6210\u529f,\u4e0d\u9700\u8981\u518d\u8fd8\u6b3e,\u76f4\u63a5\u9000\u51fa:");
                Date date = new Date();
                for (CreditRepayPlanEo creditRepayPlanEo : repayPlanEoList) {
                    CreditRepayPlanEo newCreditRepayPlanEo = new CreditRepayPlanEo();
                    newCreditRepayPlanEo.setCreditRepayPlanStatus(CreditRepayPlanStatusEnum.RECEIVABLE.getCode());
                    newCreditRepayPlanEo.setId(creditRepayPlanEo.getId());
                    newCreditRepayPlanEo.setAuditStatus("NONE");
                    newCreditRepayPlanEo.setFinalRefundDate(date);
                    int i = DateTimeUtils.betweenDays((Date)DateTimeUtils.getDayEndTime((Date)creditRepayPlanEo.getEndDate()), (Date)date);
                    newCreditRepayPlanEo.setFinalOverdueDateNum(Integer.valueOf(Math.max(i, 0)));
                    logger.info("------------------------------------------------\u8ba1\u7b97\u6700\u540e\u8fd8\u6b3e\u65f6\u95f4,\u6700\u540e\u8fd8\u6b3e\u65f6\u95f4[{}],\u5f53\u524d\u65f6\u95f4[{}],\u6700\u540e\u8fd8\u6b3e\u5929\u6570[{}]", new Object[]{DateTimeUtils.convertDateTimeToString((Date)DateTimeUtils.getDayEndTime((Date)creditRepayPlanEo.getEndDate())), DateTimeUtils.getDayEndTime((Date)date), Math.max(i, 0)});
                    this.creditRepayPlanDas.updateSelective((BaseEo)newCreditRepayPlanEo);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private List<CreditRepayPlanEo> getCreditRepayPlanList(ReverseOrderReq reverseOrderReq) {
        CreditRepayPlanEo creditRepayPlanEo = new CreditRepayPlanEo();
        creditRepayPlanEo.setCustomerId(reverseOrderReq.getCustomerId());
        if (StringUtils.isNotBlank((CharSequence)reverseOrderReq.getOrderNo())) {
            creditRepayPlanEo.setFormCode(reverseOrderReq.getOrderNo());
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u83b7\u53d6\u9700\u8fd8\u6b3e\u7684\u8d26\u5355,\u67e5\u8be2\u6307\u5b9a\u8ba2\u5355[{}]", (Object)reverseOrderReq.getOrderNo());
        }
        List<Integer> status = Arrays.asList(CreditRepayPlanStatusEnum.WAT_EFFECT.getCode(), CreditRepayPlanStatusEnum.NOT_RECEIVABLE.getCode(), CreditRepayPlanStatusEnum.PART_RECEIVABLE.getCode());
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty(status)) {
            sqlFilterList.add(SqlFilter.in((String)"credit_repay_plan_status", status));
        }
        if (!CollectionUtils.isEmpty((Collection)reverseOrderReq.getCreditRepayPlanIds())) {
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)reverseOrderReq.getCreditRepayPlanIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reverseOrderReq.getCreditRepayPlan())) {
            List collect = reverseOrderReq.getCreditRepayPlan().stream().map(CreditRepayPlansReqDto::getId).collect(Collectors.toList());
            sqlFilterList.add(SqlFilter.in((String)"id", collect));
        }
        creditRepayPlanEo.setSqlFilters(sqlFilterList);
        creditRepayPlanEo.setOrderBy("create_time");
        PageInfo creditRepayPlanEoPageInfo = this.creditRepayPlanDas.selectPage((BaseEo)creditRepayPlanEo, Integer.valueOf(1), Integer.valueOf(5000));
        logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u83b7\u53d6\u9700\u8fd8\u6b3e\u7684\u8d26\u5355,\u6570\u91cf[{}]:", (Object)creditRepayPlanEoPageInfo.getList().size());
        logger.info(" [\u83b7\u53d6\u8fd8\u6b3e\u8d26\u5355\u660e\u7ec6]\uff1a{}", (Object)JSON.toJSONString((Object)creditRepayPlanEoPageInfo.getList()));
        return creditRepayPlanEoPageInfo.getList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public EngineResult releaseQuota(ReverseOrderReq reverseOrderReq) {
        List<CreditRepayPlanEo> repayPlanEoList = this.getCreditRepayPlanList(reverseOrderReq);
        HashMap<Long, BigDecimal> accountMap = new HashMap<Long, BigDecimal>(repayPlanEoList.size());
        BigDecimal receivedAmount = null == reverseOrderReq.getReceivedAmount() ? BigDecimal.valueOf(0L) : reverseOrderReq.getReceivedAmount();
        this.updateRepayPlan(reverseOrderReq, repayPlanEoList, accountMap, receivedAmount);
        for (Long accountId : accountMap.keySet()) {
            CreditAccountUpdateQuotaReqDto creditAccountUpdateQuotaReqDto = new CreditAccountUpdateQuotaReqDto();
            creditAccountUpdateQuotaReqDto.setCreditAccountId(accountId);
            creditAccountUpdateQuotaReqDto.setCreditEntityId(reverseOrderReq.getCustomerId());
            creditAccountUpdateQuotaReqDto.setFormCode(StringUtils.isNotBlank((CharSequence)reverseOrderReq.getOrderNo()) ? reverseOrderReq.getOrderNo() : reverseOrderReq.getFormCode());
            creditAccountUpdateQuotaReqDto.setCreditUsageStatus(CreditUsageStatusEnum.GOOD.getCode());
            creditAccountUpdateQuotaReqDto.setGrantQuota((BigDecimal)accountMap.get(accountId));
            creditAccountUpdateQuotaReqDto.setRemark(StringUtils.isBlank((CharSequence)reverseOrderReq.getRemark()) ? CreditUsageRecordType.RELEASE_OVERDUE_NORMAL.getDesc() : reverseOrderReq.getRemark());
            creditAccountUpdateQuotaReqDto.setOrgInfoId(repayPlanEoList.get(0).getOrgInfoId());
            creditAccountUpdateQuotaReqDto.setCreditAccountUpdateTypeEnum(CreditAccountUpdateTypeEnum.RELEASE);
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u751f\u6210\u6d41\u6c34,\u8d26\u53f7id[{}],\u8ba2\u5355\u7f16\u7801[{}],\u53d8\u52a8\u91d1\u989d[{}]", new Object[]{accountId, reverseOrderReq.getOrderNo(), accountMap.get(accountId)});
            logger.info(" [* \u6d88\u8d39/\u6062\u590d\u8d26\u53f7\u989d\u5ea6(\u5728\u5206\u5e03\u5f0f\u9501\u4e0b\u751f\u6210\u6d41\u6c34)]\uff1a{}", (Object)JSON.toJSONString((Object)creditAccountUpdateQuotaReqDto));
            this.iCreditAccountService.useAndReleaseQuota(creditAccountUpdateQuotaReqDto);
        }
        EngineResult result = new EngineResult();
        result.setCode(ExceptionCode.SUCCESS.getCode());
        result.setDesc("\u989d\u5ea6\u91ca\u653e\u6210\u529f\uff01");
        return result;
    }

    private void updateRepayPlan(ReverseOrderReq reverseOrderReq, List<CreditRepayPlanEo> repayPlanEoList, Map<Long, BigDecimal> accountMap, BigDecimal totalWaitReturnAmount) {
        Date date = new Date();
        Map<Object, Object> pointRefundAmount = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)reverseOrderReq.getCreditRepayPlan())) {
            pointRefundAmount = reverseOrderReq.getCreditRepayPlan().stream().collect(Collectors.groupingBy(CreditRepayPlansReqDto::getId, Collectors.toList()));
        }
        logger.info(" [\u66f4\u65b0\u6307\u5b9a\u8d26\u5355\u6307\u5b9a\u91d1\u989d]\uff1a{}", (Object)JSON.toJSONString(pointRefundAmount));
        for (CreditRepayPlanEo creditRepayPlanEo : repayPlanEoList) {
            BigDecimal amount;
            if (YesOrNoStatus.YES_STATUS.getStatus().equals(reverseOrderReq.getIsRefund())) {
                if (ReceiveType.REMIND.getType().equals(reverseOrderReq.getReceiveType())) {
                    amount = creditRepayPlanEo.getOccupyQuota().subtract(creditRepayPlanEo.getReceivedAmount());
                    creditRepayPlanEo.setReceivedAmount(creditRepayPlanEo.getOccupyQuota());
                } else {
                    amount = creditRepayPlanEo.getOccupyQuota();
                    creditRepayPlanEo.setRefundAmount(amount);
                }
                creditRepayPlanEo.setCreditRepayPlanStatus(CreditRepayPlanStatusEnum.RECEIVABLE.getCode());
                creditRepayPlanEo.setFinalRefundDate(new Date());
            } else {
                BigDecimal reFund;
                if (!CollectionUtils.isEmpty((Collection)((Collection)pointRefundAmount.get(creditRepayPlanEo.getId())))) {
                    totalWaitReturnAmount = ((CreditRepayPlansReqDto)((List)pointRefundAmount.get(creditRepayPlanEo.getId())).get(0)).getThisRefundAmount();
                }
                logger.info(" [\u672c\u6b21\u6307\u5b9a\u8d26\u5355\u6307\u5b9a\u91d1\u989d]\uff1a{}", (Object)JSON.toJSONString((Object)totalWaitReturnAmount));
                if (totalWaitReturnAmount.compareTo(BigDecimal.valueOf(0L)) < 1) continue;
                BigDecimal waitAmount = creditRepayPlanEo.getOccupyQuota().subtract(creditRepayPlanEo.getReceivedAmount()).subtract(creditRepayPlanEo.getRefundAmount());
                amount = waitAmount.min(totalWaitReturnAmount);
                totalWaitReturnAmount = totalWaitReturnAmount.subtract(amount);
                if (ReceiveType.REMIND.getType().equals(reverseOrderReq.getReceiveType())) {
                    reFund = creditRepayPlanEo.getReceivedAmount() == null ? BigDecimal.ZERO : creditRepayPlanEo.getReceivedAmount();
                    creditRepayPlanEo.setReceivedAmount(reFund.add(amount));
                } else {
                    reFund = creditRepayPlanEo.getRefundAmount() == null ? BigDecimal.ZERO : creditRepayPlanEo.getRefundAmount();
                    creditRepayPlanEo.setRefundAmount(reFund.add(amount));
                }
                BigDecimal need = creditRepayPlanEo.getOccupyQuota().subtract(creditRepayPlanEo.getRefundAmount()).subtract(creditRepayPlanEo.getReceivedAmount());
                creditRepayPlanEo.setCreditRepayPlanStatus(need.compareTo(BigDecimal.ZERO) == 0 ? CreditRepayPlanStatusEnum.RECEIVABLE.getCode() : CreditRepayPlanStatusEnum.PART_RECEIVABLE.getCode());
            }
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d,\u5f53\u524d\u662f\u8fd8\u6b3e\u8ba1\u5212\u7f16\u7801[{}],[{}][{}],\u8ba1\u5212\u91d1\u989d[{}],\u5b9e\u9645\u53d8\u52a8\u91d1\u989d[{}],\u9488\u5bf9\u8be5\u8fd8\u6b3e\u8ba1\u5212\u6c47\u603b\u5982\u4e0b:\u6700\u7ec8\u603b\u9000\u6b3e\u91d1\u989d[{}],\u6700\u7ec8\u8fd8\u6b3e\u91d1\u989d[{}],\u8d26\u6237\u72b6\u6001[{}]:", new Object[]{creditRepayPlanEo.getRepayPlanNo(), YesOrNoStatus.YES_STATUS.getStatus().equals(reverseOrderReq.getIsRefund()) ? "\u6574\u5355" : "\u90e8\u5206", ReceiveType.REMIND.getType().equals(reverseOrderReq.getReceiveType()) ? "\u8fd8\u6b3e" : "\u9000\u6b3e", reverseOrderReq.getReceivedAmount(), amount, creditRepayPlanEo.getRefundAmount(), creditRepayPlanEo.getReceivedAmount(), CreditRepayPlanStatusEnum.toName((Integer)creditRepayPlanEo.getCreditRepayPlanStatus())});
            if (DateTimeUtils.getDayEndTime((Date)creditRepayPlanEo.getEndDate()).compareTo(date) < 0 && CreditRepayPlanStatusEnum.RECEIVABLE.getCode().equals(creditRepayPlanEo.getCreditRepayPlanStatus())) {
                creditRepayPlanEo.setFinalRefundDate(date);
                int i = DateTimeUtils.betweenDays((Date)DateTimeUtils.getDayEndTime((Date)creditRepayPlanEo.getEndDate()), (Date)date);
                logger.info("------------------------------------------------\u8ba1\u7b97\u6700\u540e\u8fd8\u6b3e\u65f6\u95f4,\u6700\u540e\u8fd8\u6b3e\u65f6\u95f4[{}],\u5f53\u524d\u65f6\u95f4[{}],\u6700\u540e\u8fd8\u6b3e\u5929\u6570[{}]", new Object[]{DateTimeUtils.convertDateTimeToString((Date)DateTimeUtils.getDayEndTime((Date)creditRepayPlanEo.getEndDate())), DateTimeUtils.getDayEndTime((Date)date), Math.max(i, 0)});
                creditRepayPlanEo.setFinalOverdueDateNum(Integer.valueOf(Math.max(i, 0)));
            }
            creditRepayPlanEo.setAuditStatus("NONE");
            this.creditRepayPlanDas.updateSelective((BaseEo)creditRepayPlanEo);
            accountMap.merge(creditRepayPlanEo.getCreditAccountId(), amount, BigDecimal::add);
        }
        logger.info("\u83b7\u53d6\u6bcf\u4e2a\u4fe1\u7528\u8d26\u6237\uff0c\u56de\u6b3e/\u9000\u6b3e\u91d1\u989d,accountMap----:" + JSONObject.toJSONString(accountMap));
    }

    @Override
    public EngineResult doReleaseAction(ReverseOrderReq reverseOrderReq) {
        EngineResult engineResult = new EngineResult();
        boolean isNeedRelease = this.validParams(reverseOrderReq);
        if (!isNeedRelease) {
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d/\u4e0d\u9700\u8981\u91ca\u653e\u989d\u5ea6.\u9000\u51fa,\u8ba2\u5355\u7f16\u7801:" + reverseOrderReq.getOrderNo());
            return engineResult;
        }
        Boolean aBoolean = this.judgeReverse(reverseOrderReq);
        if (!aBoolean.booleanValue()) {
            logger.info("\u5ba2\u6237\u6ca1\u6709\u6709\u5f85\u56de\u6b3e\u8ba2\u5355");
            logger.info("------------------------------------------------\u786e\u8ba4\u9000\u8d27/\u8fd8\u6b3e\u9000\u5360\u7528\u989d\u5ea6,\u7d2f\u8ba1\u5f85\u8fd8\u91d1\u989d/\u5ba2\u6237\u6ca1\u6709\u6709\u5f85\u56de\u6b3e\u8ba2\u5355\u8ba2\u5355\u7f16\u7801[{}].\u9000\u51fa!:", (Object)reverseOrderReq.getOrderNo());
            return engineResult;
        }
        engineResult = this.releaseQuota(reverseOrderReq);
        return engineResult;
    }

    @Override
    public EngineResult returnMoneyAction(ReturnMoneyDetailOrderReq returnMoneyDetailOrderReq) {
        ReturnMoneyOrderReq returnMoneyOrderReq = new ReturnMoneyOrderReq();
        BeanUtils.copyProperties((Object)returnMoneyDetailOrderReq, (Object)returnMoneyOrderReq);
        EngineResult engineResult = new EngineResult();
        ReverseOrderReq reverseOrderReq = new ReverseOrderReq();
        BeanUtils.copyProperties((Object)returnMoneyOrderReq, (Object)reverseOrderReq);
        reverseOrderReq.setCustomerId(returnMoneyDetailOrderReq.getCustomerId());
        reverseOrderReq.setIsRefund(returnMoneyDetailOrderReq.getIsRefund());
        reverseOrderReq.setOrderNo(returnMoneyDetailOrderReq.getOrderNo());
        reverseOrderReq.setFormCode(returnMoneyDetailOrderReq.getFormCode());
        reverseOrderReq.setReceivedAmount(returnMoneyDetailOrderReq.getReceivedAmount());
        reverseOrderReq.setReceiveType(Integer.valueOf(1));
        reverseOrderReq.setRemark(returnMoneyDetailOrderReq.getRemark());
        reverseOrderReq.setCreditRepayPlanIds(returnMoneyDetailOrderReq.getCreditRepayPlanIds());
        Boolean aBoolean = this.judgeReverse(reverseOrderReq);
        if (!aBoolean.booleanValue()) {
            logger.info("\u5ba2\u6237\u6ca1\u6709\u6709\u5f85\u56de\u6b3e\u8ba2\u5355");
            throw new BizException("\u5ba2\u6237\u6ca1\u6709\u6709\u5f85\u56de\u6b3e\u8ba2\u5355");
        }
        engineResult = this.releaseQuota(reverseOrderReq);
        return engineResult;
    }

    @Override
    public EngineResult hitCreditAccounts(HitCreditAccountOrderReq hitCreditAccountOrderReq) {
        List organizationLineIds;
        Map organizationMap;
        EngineResult result2;
        EngineResult result = new EngineResult();
        if (StringUtils.isEmpty((CharSequence)hitCreditAccountOrderReq.getOrderId())) {
            throw new BizException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)hitCreditAccountOrderReq.getOrderInfoList())) {
            throw new BizException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == hitCreditAccountOrderReq.getCustomerId()) {
            throw new BizException("\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<CreditAccountEo> availableAccount = this.getAvailableAccount(hitCreditAccountOrderReq.getCustomerId(), result);
        if (CollectionUtils.isEmpty(availableAccount)) {
            return result;
        }
        List<Object> dirIds = Lists.newArrayList();
        List<Object> organizationIds = Lists.newArrayList();
        for (OrderSkuInfo orderSkuInfo : hitCreditAccountOrderReq.getOrderInfoList()) {
            dirIds.add(orderSkuInfo.getDirId());
            organizationIds.add(orderSkuInfo.getOrganizationId());
        }
        dirIds = dirIds.stream().distinct().filter(obj -> StringUtils.isNotEmpty((CharSequence)obj)).collect(Collectors.toList());
        organizationIds = organizationIds.stream().distinct().filter(obj -> StringUtils.isNotEmpty((CharSequence)obj)).collect(Collectors.toList());
        List productLineIds = availableAccount.stream().map(StdCreditAccountEo::getDim2Id).distinct().collect(Collectors.toList());
        Map productMap = this.refCreditDimPropDas.queryDimPropInfo(productLineIds);
        EngineResult result1 = this.hitAccountProduct(result, availableAccount, dirIds, productMap);
        if (result1 != null) {
            return result1;
        }
        if (CollectionUtils.isNotEmpty((Collection)organizationIds) && (result2 = this.hitAccountOrganization(result, availableAccount, organizationIds, organizationMap = this.refCreditDimPropDas.queryDimPropInfo(organizationLineIds = availableAccount.stream().map(StdCreditAccountEo::getDim1Id).distinct().collect(Collectors.toList())))) != null) {
            return result2;
        }
        ArrayList accountOccupyInfoList = Lists.newArrayList();
        for (CreditAccountEo creditAccountEo : availableAccount) {
            AccountOccupyInfo accountOccupyInfo = new AccountOccupyInfo();
            accountOccupyInfo.setAccountId(creditAccountEo.getId());
            accountOccupyInfo.setAccountCode(creditAccountEo.getCreditAccountCode());
            accountOccupyInfo.setAvailableCredit(creditAccountEo.getAccountQuota().subtract(creditAccountEo.getAccountUsedQuota()));
            accountOccupyInfoList.add(accountOccupyInfo);
        }
        result.setAccountOccupyInfoList((List)accountOccupyInfoList);
        return result;
    }

    @Override
    @Transactional
    public void updateQuotaRecord(AccountQuotaRecordUpdateReq accountQuotaRecordUpdateReq) {
        CreditUsageRecordEo sourceRecordEo;
        BigDecimal totalAmount;
        logger.info("------------------------------------------------\u8fdb\u5165\u4e8c\u6b21\u63d0\u4ea4,\u83b7\u53d6\u53c2\u6570:" + JSON.toJSONString((Object)accountQuotaRecordUpdateReq));
        if (StringUtils.isBlank((CharSequence)accountQuotaRecordUpdateReq.getCreditOrderBillCode())) {
            logger.info("------------------------------------------------\u6ca1\u6709\u4fe1\u7528\u8d26\u5355\u4fe1\u606f,\u9000\u51fa");
            return;
        }
        CreditOrderBillEo selectItemCreditOrderBill = new CreditOrderBillEo();
        selectItemCreditOrderBill.setCreditOrderBillCode(accountQuotaRecordUpdateReq.getCreditOrderBillCode());
        selectItemCreditOrderBill.setDr(0);
        CreditOrderBillEo creditOrderBillEo = (CreditOrderBillEo)this.creditOrderBillDas.selectOne((BaseEo)selectItemCreditOrderBill);
        Assert.notNull((Object)creditOrderBillEo, (String)("\u627e\u4e0d\u5230\u4fe1\u7528\u8ba2\u5355,\u8ba2\u5355\u7f16\u7801:" + accountQuotaRecordUpdateReq.getOrderNo()));
        String orderNo = StringUtils.isNotBlank((CharSequence)accountQuotaRecordUpdateReq.getOrderNo()) ? accountQuotaRecordUpdateReq.getOrderNo() : creditOrderBillEo.getFormCode();
        BigDecimal bigDecimal = totalAmount = accountQuotaRecordUpdateReq.getTotalAmount() != null ? accountQuotaRecordUpdateReq.getTotalAmount() : creditOrderBillEo.getAccountUsedQuota();
        if (StringUtils.isNotBlank((CharSequence)orderNo)) {
            CreditOrderBillEo newCreditOrderBillEo;
            newCreditOrderBillEo.setFormCode(StringUtils.isBlank((CharSequence)(newCreditOrderBillEo = new CreditOrderBillEo()).getFormCode()) ? accountQuotaRecordUpdateReq.getOrderNo() : newCreditOrderBillEo.getFormCode());
            newCreditOrderBillEo.setId(creditOrderBillEo.getId());
            newCreditOrderBillEo.setCreditOrderBillStatus(accountQuotaRecordUpdateReq.getSubmitState().equals(SuccessEnum.SUCCESS.getCode()) ? CreditOrderBillStatusEnum.GOOD.getCode() : CreditOrderBillStatusEnum.BAD.getCode());
            this.creditOrderBillDas.updateSelective((BaseEo)newCreditOrderBillEo);
            logger.info("------------------------------------------------\u66f4\u65b0\u4fe1\u7528\u8d26\u5355\u72b6\u6001" + CreditOrderBillStatusEnum.toName((Integer)newCreditOrderBillEo.getCreditOrderBillStatus()));
        }
        CreditUsageRecordEo creditUsageRecordEo = new CreditUsageRecordEo();
        creditUsageRecordEo.setUsageRecordNo(creditOrderBillEo.getUsageRecordNo());
        creditUsageRecordEo.setDr(0);
        CreditUsageRecordEo creditUsageRecordEo2 = sourceRecordEo = StringUtils.isBlank((CharSequence)creditOrderBillEo.getUsageRecordNo()) ? null : (CreditUsageRecordEo)this.creditUsageRecordDas.selectOne((BaseEo)creditUsageRecordEo);
        if (sourceRecordEo == null) {
            logger.info("------------------------------------------------\u4e8c\u6b21\u63d0\u4ea4:\u6ca1\u6709\u751f\u6210\u4fe1\u7528\u8d26\u6237\u4f7f\u7528\u8bb0\u5f55\u6216\u627e\u4e0d\u5230\u8bb0\u5f55,\u9000\u51faUsageRecordNo:" + creditOrderBillEo.getUsageRecordNo());
            return;
        }
        CreditUsageRecordEo newCreditUsageRecordEo = new CreditUsageRecordEo();
        newCreditUsageRecordEo.setId(sourceRecordEo.getId());
        newCreditUsageRecordEo.setCreditUsageStatus(CreditUsageStatusEnum.GOOD.getCode());
        newCreditUsageRecordEo.setRemark(accountQuotaRecordUpdateReq.getRemark());
        newCreditUsageRecordEo.setFormCode(accountQuotaRecordUpdateReq.getOrderNo());
        this.creditUsageRecordDas.updateSelective((BaseEo)newCreditUsageRecordEo);
        if (accountQuotaRecordUpdateReq.getSubmitState().equals(SuccessEnum.SUCCESS.getCode())) {
            logger.info("------------------------------------------------\u8ba2\u5355\u63d0\u4ea4\u6210\u529f,\u4e14\u5df2\u5b8c\u6210\u6263\u6b3e,\u5f00\u59cb\u8fdb\u884c\u751f\u6210\u8fd8\u6b3e\u8ba1\u5212,\u8ba2\u5355\u7f16\u7801:" + creditOrderBillEo.getUsageRecordNo());
            CreditAccountEo creditAccountEo = (CreditAccountEo)this.creditAccountDas.selectByPrimaryKey(creditOrderBillEo.getCreditAccountId());
            CreditPlanDto creditPlanDto = new CreditPlanDto();
            creditPlanDto.setCreditAccountId(creditOrderBillEo.getCreditAccountId());
            creditPlanDto.setCreditAccountCode(creditAccountEo.getCreditAccountCode());
            creditPlanDto.setCustomerId(selectItemCreditOrderBill.getCreditEntityId());
            creditPlanDto.setNodeCode(accountQuotaRecordUpdateReq.getOrderNode());
            creditPlanDto.setOccupyQuota(totalAmount);
            creditPlanDto.setCreditTermModelId(creditOrderBillEo.getCreditTermModelId());
            creditPlanDto.setOrderNo(accountQuotaRecordUpdateReq.getOrderNo());
            List<CreditRepayPlanEo> creditRepayPlanEo = this.accountQuotaAction.buildPlan(creditPlanDto);
            this.accountQuotaAction.savePlan(creditRepayPlanEo);
        } else {
            logger.info("\u63d0\u4ea4\u5931\u8d25\u521b\u5efa\u9000\u4fe1\u7528\u989d\u5ea6\u8bb0\u5f55\u56de\u9000\u4f59\u989d/\u65e7\u8bb0\u5f55\u6539\u4e3a\u6b63\u5e38\u72b6\u6001\u5e76\u65b0\u589e\u9006\u5411\u8bb0\u5f55,\u8ba2\u5355\u7f16\u7801:" + creditOrderBillEo.getUsageRecordNo());
            CreditAccountUpdateQuotaReqDto creditAccountUpdateQuotaReqDto = new CreditAccountUpdateQuotaReqDto();
            creditAccountUpdateQuotaReqDto.setCreditAccountId(creditOrderBillEo.getCreditAccountId());
            creditAccountUpdateQuotaReqDto.setCreditEntityId(sourceRecordEo.getCustomerId());
            creditAccountUpdateQuotaReqDto.setFormCode(accountQuotaRecordUpdateReq.getOrderNo());
            creditAccountUpdateQuotaReqDto.setCreditUsageStatus(CreditUsageStatusEnum.GOOD.getCode());
            creditAccountUpdateQuotaReqDto.setGrantQuota(creditOrderBillEo.getAccountUsedQuota());
            creditAccountUpdateQuotaReqDto.setRemark(CreditUsageRecordType.SUBMIT_ORDER_FAIL.getDesc());
            creditAccountUpdateQuotaReqDto.setCreditAccountUpdateTypeEnum(CreditAccountUpdateTypeEnum.RELEASE);
            creditAccountUpdateQuotaReqDto.setOrgInfoId(sourceRecordEo.getOrgInfoId());
            this.iCreditAccountService.useAndReleaseQuota(creditAccountUpdateQuotaReqDto);
        }
    }

    private String addCreditOrderBill(EngineResult result, EngineOrderReq accountQuotaRecordUpdateReq, String usageRecordNo) {
        String creditOrderBillCode;
        AccountOccupyInfo accountOccupyInfo = (AccountOccupyInfo)result.getAccountOccupyInfoList().get(0);
        CreditOrderBillEo selectItemCreditOrderBill = new CreditOrderBillEo();
        selectItemCreditOrderBill.setFormCode(accountQuotaRecordUpdateReq.getOrderNo());
        CreditOrderBillEo sourceCreditOrderBillEos = StringUtils.isNotBlank((CharSequence)accountQuotaRecordUpdateReq.getOrderNo()) ? (CreditOrderBillEo)this.creditOrderBillDas.selectOne((BaseEo)selectItemCreditOrderBill) : null;
        Long id = sourceCreditOrderBillEos == null ? null : sourceCreditOrderBillEos.getId();
        String string = creditOrderBillCode = sourceCreditOrderBillEos == null ? null : sourceCreditOrderBillEos.getCreditOrderBillCode();
        if (sourceCreditOrderBillEos == null) {
            CreditAccountEo creditAccountEoParam = new CreditAccountEo();
            creditAccountEoParam.setId(accountQuotaRecordUpdateReq.getCreditAccountId());
            CreditAccountEo creditAccountEo = (CreditAccountEo)this.creditAccountDas.selectOne((BaseEo)creditAccountEoParam);
            OccupyConfigReqDto occupyConfigReqDto = this.iCreditOccupyConfigService.getOccupyConfigByOrgId(creditAccountEo.getOrgInfoId());
            sourceCreditOrderBillEos = CreditOrderBillEo.newInstance();
            sourceCreditOrderBillEos.setAccountQuota(accountOccupyInfo.getAccountQuota());
            sourceCreditOrderBillEos.setAccountUsedQuota(accountQuotaRecordUpdateReq.getTotalAmount());
            sourceCreditOrderBillEos.setCreditAccountId(accountQuotaRecordUpdateReq.getCreditAccountId());
            sourceCreditOrderBillEos.setCreditEntityId(accountQuotaRecordUpdateReq.getCustomerId());
            creditOrderBillCode = this.generateCode.createCode(GeneralRuleCodeType.XYDD);
            sourceCreditOrderBillEos.setCreditOrderBillCode(creditOrderBillCode);
            sourceCreditOrderBillEos.setCreditOrderBillStatus(CreditOrderBillStatusEnum.GOOD.getCode());
            sourceCreditOrderBillEos.setCreditTermModelId(accountOccupyInfo.getCreditTermModelId());
            sourceCreditOrderBillEos.setDim1Id(accountOccupyInfo.getDim1Id());
            sourceCreditOrderBillEos.setDim1Value(creditAccountEo.getDim1Value());
            sourceCreditOrderBillEos.setDim2Id(accountOccupyInfo.getDim2Id());
            sourceCreditOrderBillEos.setDim2Value(creditAccountEo.getDim2Value());
            sourceCreditOrderBillEos.setDim3Id(accountOccupyInfo.getDim3Id());
            sourceCreditOrderBillEos.setDim3Value(creditAccountEo.getDim3Value());
            sourceCreditOrderBillEos.setCreditOccupyConfigId(occupyConfigReqDto.getId());
            sourceCreditOrderBillEos.setFormCode(accountQuotaRecordUpdateReq.getOrderNo());
            sourceCreditOrderBillEos.setOverdueStrategyId(accountOccupyInfo.getOverdueStrategyId());
            sourceCreditOrderBillEos.setQuotaStrategyId(accountOccupyInfo.getQuotaStrategyId());
            sourceCreditOrderBillEos.setUsageRecordNo(usageRecordNo);
            sourceCreditOrderBillEos.setOrgInfoId(creditAccountEo.getOrgInfoId());
            this.creditOrderBillDas.insert((BaseEo)sourceCreditOrderBillEos);
        }
        if (StringUtils.isNotBlank((CharSequence)usageRecordNo)) {
            sourceCreditOrderBillEos = CreditOrderBillEo.newInstance();
            sourceCreditOrderBillEos.setId(id);
            sourceCreditOrderBillEos.setUsageRecordNo(usageRecordNo);
            this.creditOrderBillDas.updateSelective((BaseEo)sourceCreditOrderBillEos);
        }
        return creditOrderBillCode;
    }

    private void splitCreditUsageRecord(String orderNo, CreditUsageRecordEo sourceCreditUsageRecord, List<CreditAccountRecordUseDetailRespDto> creditAccountRecordUseDetailRespDtos) {
        LinkedList<CreditUsageRecordEo> listSplitByCreditUsageRecord = new LinkedList<CreditUsageRecordEo>();
        BigDecimal beforeQuota = sourceCreditUsageRecord.getRemainingQuota().add(sourceCreditUsageRecord.getQuota());
        for (CreditAccountRecordUseDetailRespDto creditAccountRecordUseDetailRespDto : creditAccountRecordUseDetailRespDtos) {
            BigDecimal thisUserQuota = creditAccountRecordUseDetailRespDto.getThisUserQuota();
            beforeQuota = beforeQuota.subtract(thisUserQuota);
            CreditUsageRecordEo creditUsageRecordForSplit = new CreditUsageRecordEo();
            creditUsageRecordForSplit.setQuota(creditAccountRecordUseDetailRespDto.getThisUserQuota());
            creditUsageRecordForSplit.setRemainingQuota(beforeQuota);
            creditUsageRecordForSplit.setCreditAccountId(creditAccountRecordUseDetailRespDto.getCreditAccountId());
            creditUsageRecordForSplit.setCreditDetailId(creditAccountRecordUseDetailRespDto.getCreditAccountId());
            creditUsageRecordForSplit.setCustomerId(sourceCreditUsageRecord.getCustomerId());
            creditUsageRecordForSplit.setExtension(sourceCreditUsageRecord.getExtension());
            creditUsageRecordForSplit.setUsageRecordNo(sourceCreditUsageRecord.getUsageRecordNo());
            creditUsageRecordForSplit.setUsageType(sourceCreditUsageRecord.getUsageType());
            creditUsageRecordForSplit.setCreditUsageStatus(CreditUsageStatusEnum.GOOD.getCode());
            creditUsageRecordForSplit.setCreateTime(sourceCreditUsageRecord.getCreateTime());
            creditUsageRecordForSplit.setFormCode(orderNo);
            listSplitByCreditUsageRecord.add(creditUsageRecordForSplit);
        }
        this.creditUsageRecordDas.insertBatch(listSplitByCreditUsageRecord);
    }

    private EngineResult hitAccountOrganization(EngineResult result, List<CreditAccountEo> availableAccount, List<String> organizationIds, Map<Long, List<String>> organizationMap) {
        ArrayList accountIds = availableAccount.stream().map(StdCreditAccountEo::getDim1Id).filter(obj -> null == obj).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(accountIds)) {
            accountIds = Lists.newArrayList();
        }
        for (Long dimValueId : organizationMap.keySet()) {
            List<String> refCreditDimPropList = organizationMap.get(dimValueId);
            List reduce = organizationIds.stream().filter(item -> !refCreditDimPropList.contains(item)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(reduce)) continue;
            for (CreditAccountEo creditAccountEo : availableAccount) {
                if (!dimValueId.equals(creditAccountEo.getDim1Id())) continue;
                accountIds.add(creditAccountEo.getId());
            }
        }
        if (CollectionUtils.isEmpty((Collection)accountIds)) {
            result.setCode(ExceptionCode.SUCCESS.getCode());
            result.setDesc("\u6ca1\u6709\u53ef\u7528\u4fe1\u7528\u8d26\u6237\u5bf9\u8be5\u8ba2\u5355\u505a\u6263\u51cf");
            return result;
        }
        Map<Long, Long> accountMap = accountIds.stream().collect(Collectors.toMap(obj -> obj, obj -> obj));
        Iterator<CreditAccountEo> iterator = availableAccount.iterator();
        while (iterator.hasNext()) {
            CreditAccountEo creditAccountEo = iterator.next();
            if (null != accountMap.get(creditAccountEo.getId())) continue;
            iterator.remove();
        }
        return null;
    }

    private EngineResult hitAccountProduct(EngineResult result, List<CreditAccountEo> availableAccount, List<String> dirIds, Map<Long, List<String>> productMap) {
        ArrayList accountIds = availableAccount.stream().map(StdCreditAccountEo::getDim2Id).filter(obj -> null == obj).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(accountIds)) {
            accountIds = Lists.newArrayList();
        }
        for (Long dimValueId : productMap.keySet()) {
            List<String> refCreditDimPropList = productMap.get(dimValueId);
            List reduce = dirIds.stream().filter(item -> !refCreditDimPropList.contains(item)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(reduce)) continue;
            for (CreditAccountEo creditAccountEo : availableAccount) {
                if (!dimValueId.equals(creditAccountEo.getDim2Id())) continue;
                accountIds.add(creditAccountEo.getId());
            }
        }
        if (CollectionUtils.isEmpty((Collection)accountIds)) {
            result.setCode(ExceptionCode.SUCCESS.getCode());
            result.setDesc("\u6ca1\u6709\u53ef\u7528\u4fe1\u7528\u8d26\u6237\u5bf9\u8be5\u8ba2\u5355\u505a\u6263\u51cf");
            return result;
        }
        Map<Long, Long> accountMap = accountIds.stream().collect(Collectors.toMap(obj -> obj, obj -> obj));
        Iterator<CreditAccountEo> iterator = availableAccount.iterator();
        while (iterator.hasNext()) {
            CreditAccountEo creditAccountEo = iterator.next();
            if (null != accountMap.get(creditAccountEo.getId())) continue;
            iterator.remove();
        }
        return null;
    }

    private List<CreditAccountEo> getAvailableAccount(Long customerId, EngineResult result) {
        List accountEoList = Lists.newArrayList();
        List entityDetailEoList = this.creditEntityDetailDas.queryByCustomerId(customerId);
        if (CollectionUtils.isEmpty((Collection)entityDetailEoList)) {
            result.setCode(ExceptionCode.FAIL.getCode());
            result.setDesc("\u5ba2\u6237\u672a\u6388\u4fe1,\u6ca1\u6709\u53ef\u7528\u4fe1\u7528\u8d26\u6237");
            return accountEoList;
        }
        List entityIds = entityDetailEoList.stream().map(StdCreditEntityDetailEo::getCreditEntityId).collect(Collectors.toList());
        accountEoList = this.creditAccountDas.queryUseAccountByEntityIds(entityIds);
        if (CollectionUtils.isEmpty((Collection)accountEoList)) {
            result.setCode(ExceptionCode.FAIL.getCode());
            result.setDesc("\u6ca1\u6709\u53ef\u7528\u4fe1\u7528\u8d26\u6237");
            return accountEoList;
        }
        result.setCode(ExceptionCode.SUCCESS.getCode());
        result.setDesc(ExceptionCode.SUCCESS.getMsg());
        return accountEoList;
    }

    private List<CreditAccountEo> getPointAccount(Long creditAccountId, EngineResult result) {
        List accountEoList = this.creditAccountDas.queryById(creditAccountId);
        if (CollectionUtils.isEmpty((Collection)accountEoList)) {
            result.setCode(ExceptionCode.FAIL.getCode());
            result.setDesc("\u6ca1\u6709\u53ef\u7528\u4fe1\u7528\u8d26\u6237");
            return accountEoList;
        }
        result.setCode(ExceptionCode.SUCCESS.getCode());
        result.setDesc(ExceptionCode.SUCCESS.getMsg());
        return accountEoList;
    }
}

