/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.AttachmentReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.IAttachmentService;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.AttachmentDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.AttachmentEo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="attachment")
public class AttachmentServiceImpl
implements IAttachmentService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private AttachmentDas attachmentDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAttachment(Long bizNo, RelateTypeEnum attachmentType, List<AttachmentReqDto> attachmentReqs) {
        if (CollectionUtils.isEmpty(attachmentReqs)) {
            return;
        }
        ArrayList<AttachmentEo> list = new ArrayList<AttachmentEo>();
        for (AttachmentReqDto attachmentReq : attachmentReqs) {
            AttachmentEo attachmentEo = new AttachmentEo();
            attachmentReq.setBizType(attachmentType.getCode());
            DtoHelper.dto2Eo((BaseVo)attachmentReq, (BaseEo)attachmentEo, (String[])new String[]{"id"});
            attachmentEo.setBizNo(bizNo);
            list.add(attachmentEo);
        }
        this.attachmentDas.insertBatch(list);
    }

    @Override
    @Transactional
    public void updateAttachment(Long bizNo, RelateTypeEnum attachmentType, List<AttachmentReqDto> attachmentReqs) {
        if (CollectionUtils.isEmpty(attachmentReqs)) {
            return;
        }
        AttachmentEo attachmenteo = new AttachmentEo();
        attachmenteo.setBizNo(bizNo);
        this.attachmentDas.delete((BaseEo)attachmenteo);
        this.saveAttachment(bizNo, attachmentType, attachmentReqs);
    }
}

