/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.ConfigAccountSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.ConfigBindAccountReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountUpdateDataReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountUpdateQuotaReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyQuotaItemSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditApplyQuotaSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditCustomerAccountItemReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditCustomerAccountReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountBaseRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountItemRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountRecordDetailRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditCustomerAccountDetailRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditCustomerAccountItemRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditCustomerAccountRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditCustomerAccountTotalRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityCustomerPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.AllowAddEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.ConfigType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditAccountStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditAccountUpdateTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditApplyTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRecordStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageRecordType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.EntityStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.GeneralRuleCodeType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.QuotaTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.YesOrNoStatus;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.CreditNoUtil;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.DateTimeUtils;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.RestResponseCreditHelper;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditApplyService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditEntityService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditRecordService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditTermModelService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.GenerateCode;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.Helmsman;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditApplyDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditApplyDetailDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditDimValueDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDetailDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRepayPlanDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditTermModelDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditUsageRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.PolicyDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.RefCreditDimPropDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditApplyDetailEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditDimValueEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditEntityEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRecordEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditTermModelEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditUsageRecordEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.PolicyEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.RefCreditDimPropEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditRecordEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdRefCreditDimPropEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="creditAccount")
public class CreditAccountServiceImpl
implements ICreditAccountService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private IContext iContext;
    @Autowired
    private CreditApplyDetailDas creditApplyDetailDas;
    @Resource
    private CreditAccountDas creditAccountDas;
    @Resource
    private CreditRecordDas creditRecordDas;
    @Resource
    private CreditRepayPlanDas creditRepayPlanDas;
    @Resource
    private RefCreditDimPropDas refCreditDimPropDas;
    @Resource
    private GenerateCode generateCode;
    @Resource
    private CreditEntityDetailDas creditEntityDetailDas;
    @Resource
    private PolicyDas policyDas;
    @Resource
    private CreditEntityDas creditEntityDas;
    @Resource
    private CreditUsageRecordDas creditUsageRecordDas;
    @Resource
    private ILockService lockService;
    @Resource
    private CreditTermModelDas creditTermModelDas;
    @Resource
    private ICreditApplyService iCreditApplyService;
    @Resource
    private CreditApplyDas creditApplyDas;
    @Resource
    private CreditDimValueDas creditDimValueDas;
    @Resource
    private ICreditAccountService creditAccountService;
    @Resource
    private ICreditRecordService iCreditRecordService;
    @Autowired
    private ICreditTermModelService icreditTermModelService;
    @Autowired
    private ICreditEntityService iCreditEntityService;

    @Override
    public PageInfo<CreditAccountPageRespDto> queryByPage(CreditAccountSearchReqDto creditAccountSearchReqDto, Integer pageNum, Integer pageSize) {
        Long orgId = this.queryOrgIdByUserId();
        creditAccountSearchReqDto.setOrgInfoId(orgId);
        PageInfo creditAccountEoPageInfo = this.creditAccountDas.queryByPage(creditAccountSearchReqDto, pageNum, pageSize);
        if (CollectionUtils.isEmpty((Collection)creditAccountEoPageInfo.getList())) {
            return new PageInfo();
        }
        List<Long> entityIds = creditAccountEoPageInfo.getList().stream().map(StdCreditAccountEo::getCreditEntityId).filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> accountIds = creditAccountEoPageInfo.getList().stream().map(BaseEo::getId).collect(Collectors.toList());
        List creditTermModelIds = creditAccountEoPageInfo.getList().stream().map(StdCreditAccountEo::getCreditTermModelId).collect(Collectors.toList());
        List overdueStrategyId = creditAccountEoPageInfo.getList().stream().map(StdCreditAccountEo::getOverdueStrategyId).collect(Collectors.toList());
        List quotaStrategyId = creditAccountEoPageInfo.getList().stream().map(StdCreditAccountEo::getQuotaStrategyId).collect(Collectors.toList());
        List dim1Ids = creditAccountEoPageInfo.getList().stream().map(StdCreditAccountEo::getDim1Id).collect(Collectors.toList());
        List dim2Ids = creditAccountEoPageInfo.getList().stream().map(StdCreditAccountEo::getDim2Id).collect(Collectors.toList());
        ArrayList dimIds = Lists.newArrayList(dim1Ids);
        dimIds.addAll(dim2Ids);
        HashSet policyIds = new HashSet();
        policyIds.addAll(overdueStrategyId);
        policyIds.addAll(quotaStrategyId);
        Map<Long, List<CreditRecordEo>> creditRecordGroup = this.getCreditRecordEos(creditAccountSearchReqDto.getApplyId(), accountIds);
        Map creditTermModelEosGroup = this.creditTermModelDas.getCreditTermMode(creditTermModelIds);
        Map<Long, String> policyNameMap = this.getPolicyNameMap(new ArrayList<Long>(policyIds));
        Map<Long, String> dimNameMap = this.getDimNameMap(new ArrayList<Long>(dimIds));
        List<CreditEntityCustomerPageRespDto> codesByIds = this.iCreditEntityService.findBaseInfosByIds(entityIds);
        Map entityGroup = codesByIds.stream().collect(Collectors.groupingBy(CreditEntityCustomerPageRespDto::getId, Collectors.toList()));
        ArrayList<CreditAccountPageRespDto> list = new ArrayList<CreditAccountPageRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)creditAccountEoPageInfo.getList())) {
            for (CreditAccountEo source : creditAccountEoPageInfo.getList()) {
                List<Object> creditRecordEos;
                CreditAccountPageRespDto creditAccountPageRespDto = new CreditAccountPageRespDto();
                creditAccountPageRespDto.setCreditAccountCode(source.getCreditAccountCode());
                BigDecimal accountQuota = source.getAccountQuota() == null ? BigDecimal.ZERO : source.getAccountQuota();
                BigDecimal accountUsedQuota = source.getAccountUsedQuota() == null ? BigDecimal.ZERO : source.getAccountUsedQuota();
                BigDecimal validCreditQuota = source.getCreditAccountStatus() == 1 ? accountQuota.subtract(accountUsedQuota).max(BigDecimal.ZERO) : BigDecimal.ZERO;
                DtoHelper.eo2Dto((BaseEo)source, (BaseVo)creditAccountPageRespDto);
                creditAccountPageRespDto.setValidCreditQuota(validCreditQuota);
                creditAccountPageRespDto.setAccountQuota(source.getCreditAccountStatus() == 1 ? accountQuota : BigDecimal.ZERO);
                CreditEntityCustomerPageRespDto creditEntityCustomerPageRespDto = entityGroup.get(creditAccountPageRespDto.getCreditEntityId()) == null ? new CreditEntityCustomerPageRespDto() : (CreditEntityCustomerPageRespDto)entityGroup.get(creditAccountPageRespDto.getCreditEntityId()).get(0);
                creditAccountPageRespDto.setCreditEntityCode(creditEntityCustomerPageRespDto.getCode());
                creditAccountPageRespDto.setType(creditEntityCustomerPageRespDto.getType());
                creditAccountPageRespDto.setDim1Desc(StringUtils.isBlank((CharSequence)dimNameMap.get(source.getDim1Id())) ? dimNameMap.get(source.getDim1Id()) : "\u4e0d\u9650");
                creditAccountPageRespDto.setDim2Desc(StringUtils.isBlank((CharSequence)dimNameMap.get(source.getDim2Id())) ? dimNameMap.get(source.getDim2Id()) : "\u4e0d\u9650");
                List<CreditRecordEo> list2 = creditRecordEos = CollectionUtils.isEmpty((Collection)creditRecordGroup.get(source.getId())) ? new ArrayList<CreditRecordEo>() : creditRecordGroup.get(source.getId());
                if (creditAccountSearchReqDto.getApplyId() != null) {
                    creditRecordEos = creditRecordEos.stream().filter(creditRecordEo -> creditAccountSearchReqDto.getApplyId().equals(creditRecordEo.getCreditApplyId())).collect(Collectors.toList());
                }
                if (creditAccountSearchReqDto.getApplyId() != null) {
                    List supplierReturnList = creditRecordEos.stream().map(this::buildCreditAccountItemRespDto).collect(Collectors.toList());
                    creditAccountPageRespDto.setAccountApplyRecords(supplierReturnList);
                }
                this.buildAccountValid(creditAccountPageRespDto, creditRecordEos);
                CreditTermModelEo creditTermModelEo = CollectionUtils.isEmpty((Collection)((Collection)creditTermModelEosGroup.get(source.getCreditTermModelId()))) ? new CreditTermModelEo() : (CreditTermModelEo)((List)creditTermModelEosGroup.get(source.getCreditTermModelId())).get(0);
                creditAccountPageRespDto.setCreditTermModelName(null != creditTermModelEo ? creditTermModelEo.getName() : null);
                creditAccountPageRespDto.setQuotaStrategyName(policyNameMap.get(source.getQuotaStrategyId()));
                creditAccountPageRespDto.setOverdueStrategyName(policyNameMap.get(source.getOverdueStrategyId()));
                creditAccountPageRespDto.setCreditAccountStatusName(CreditAccountStatusEnum.toName((Integer)creditAccountPageRespDto.getCreditAccountStatus()));
                list.add(creditAccountPageRespDto);
            }
        }
        PageInfo creditAccountPageRespDtoPageInfo = EoUtil.eoPageToDtoPage((PageInfo)creditAccountEoPageInfo, list);
        return creditAccountPageRespDtoPageInfo;
    }

    @Override
    public Long queryOrgIdByUserId() {
        return (Long)this.iCustomerExtQueryApi.queryOrgIdByUserId(this.iContext.userId()).getData();
    }

    private Map<Long, String> getPolicyNameMap(List<Long> policyIds) {
        if (CollectionUtils.isEmpty(policyIds)) {
            return new HashMap<Long, String>();
        }
        return this.policyDas.queryNameByIds(policyIds);
    }

    private Map<Long, String> getDimNameMap(List<Long> dimIds) {
        if (CollectionUtils.isEmpty(dimIds)) {
            return new HashMap<Long, String>();
        }
        return this.creditDimValueDas.queryNameByIds(dimIds);
    }

    private void buildAccountValid(CreditAccountPageRespDto creditAccountPageRespDto, List<CreditRecordEo> creditRecordEos) {
        List supplierReturnList = creditRecordEos.stream().map(this::buildCreditAccountItemRespDto).collect(Collectors.toList());
        List small = supplierReturnList.stream().sorted(Comparator.comparing(CreditAccountItemRespDto::getStartDate)).collect(Collectors.toList());
        List big = supplierReturnList.stream().sorted(Comparator.comparing(CreditAccountItemRespDto::getEndDate).reversed()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(small) && CollectionUtils.isNotEmpty(big)) {
            creditAccountPageRespDto.setDateTime(((CreditAccountItemRespDto)small.get(0)).getStartDate() + " ~ " + ((CreditAccountItemRespDto)big.get(0)).getEndDate());
        }
        creditAccountPageRespDto.setAccountItems(supplierReturnList);
    }

    private Map<Long, List<PolicyEo>> getPolicyEo(List<Long> creditTermModelId) {
        PolicyEo policyEo = new PolicyEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", creditTermModelId));
        policyEo.setSqlFilters(sqlFilterList);
        List select = this.policyDas.select((BaseEo)policyEo);
        return select.stream().collect(Collectors.groupingBy(BaseEo::getId, Collectors.toList()));
    }

    private CreditAccountItemRespDto buildCreditAccountItemRespDto(CreditRecordEo recordEo) {
        CreditAccountItemRespDto creditAccountItemRespDto = new CreditAccountItemRespDto();
        creditAccountItemRespDto.setDateTime(DateTimeUtils.convertDateToString((Date)recordEo.getStartDate()) + "~" + DateTimeUtils.convertDateToString((Date)recordEo.getEndDate()));
        creditAccountItemRespDto.setStartDate(DateTimeUtils.convertDateToString((Date)recordEo.getStartDate()));
        creditAccountItemRespDto.setEndDate(DateTimeUtils.convertDateToString((Date)recordEo.getEndDate()));
        BigDecimal grantQuota = recordEo.getGrantQuota().setScale(2, RoundingMode.HALF_UP);
        creditAccountItemRespDto.setAccountQuota(grantQuota.toString());
        creditAccountItemRespDto.setQuotaType(recordEo.getQuotaType());
        if (CreditRecordStatusEnum.fromCode((Integer)recordEo.getCreditRecordStatus()) == CreditRecordStatusEnum.GOOD && DateTimeUtils.getDayEndTime((Date)recordEo.getEndDate()).before(new Date())) {
            creditAccountItemRespDto.setCreditRecordStatus(CreditRecordStatusEnum.OVER_DUE.getCode());
        } else {
            creditAccountItemRespDto.setCreditRecordStatus(recordEo.getCreditRecordStatus());
        }
        creditAccountItemRespDto.setCreditRecordCode(recordEo.getCreditRecordCode());
        creditAccountItemRespDto.setQuotaTypeName(QuotaTypeEnum.toName((Integer)recordEo.getQuotaType()));
        creditAccountItemRespDto.setId(recordEo.getId());
        creditAccountItemRespDto.setRemark(recordEo.getRemark());
        return creditAccountItemRespDto;
    }

    private Map<Long, List<CreditRecordEo>> getCreditRecordEos(Long applyId, List<Long> accountIds) {
        CreditRecordEo creditRecordEo = new CreditRecordEo();
        if (applyId != null) {
            creditRecordEo.setCreditApplyId(applyId);
        }
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"credit_account_id", accountIds));
        creditRecordEo.setSqlFilters(sqlFilterList);
        List creditRecordEos = this.creditRecordDas.select((BaseEo)creditRecordEo);
        Date date = new Date();
        for (CreditRecordEo o : creditRecordEos) {
            o.setCreditRecordStatus(CreditRecordStatusEnum.GOOD.getCode());
            if (DateTimeUtils.getDayEndTime((Date)o.getEndDate()).before(date)) {
                o.setCreditRecordStatus(CreditRecordStatusEnum.OVER_DUE.getCode());
            }
            if (!o.getStartDate().after(date)) continue;
            o.setCreditRecordStatus(CreditRecordStatusEnum.NOT_EFFECT.getCode());
        }
        Map<Long, List<CreditRecordEo>> CreditRecordGroup = creditRecordEos.stream().collect(Collectors.groupingBy(StdCreditRecordEo::getCreditAccountId, Collectors.toList()));
        return CreditRecordGroup;
    }

    @Override
    public PageInfo<CreditAccountBaseRespDto> queryConfigByPage(ConfigAccountSearchReqDto searchReqDto) {
        PageInfo pageInfo = new PageInfo();
        ConfigType type = ConfigType.getType((Integer)searchReqDto.getType());
        if (null == type) {
            throw new BizException("\u67e5\u8be2\u7684\u914d\u7f6e\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (null == searchReqDto.getId()) {
            throw new BizException("\u9700\u6307\u5b9a\u914d\u7f6eid");
        }
        searchReqDto.setIsBind(YesOrNoStatus.YES_STATUS.getStatus().equals(searchReqDto.getIsBind()) ? YesOrNoStatus.YES_STATUS.getStatus() : YesOrNoStatus.NO_STATUS.getStatus());
        List configIds = null;
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        searchReqDto.setOrgId(orgId);
        if (StringUtils.isNotEmpty((CharSequence)searchReqDto.getConfigName())) {
            switch (type) {
                case CREDIT_TERM: {
                    configIds = this.creditTermModelDas.queryDimName(searchReqDto.getConfigName());
                    break;
                }
                case LIMIT: {
                    configIds = this.policyDas.queryDimName(searchReqDto.getConfigName());
                    break;
                }
                case OVERDUE: {
                    configIds = this.policyDas.queryDimName(searchReqDto.getConfigName());
                    break;
                }
                case DIM1: {
                    configIds = this.creditDimValueDas.queryDimName(searchReqDto.getConfigName());
                    break;
                }
                case DIM2: {
                    configIds = this.creditDimValueDas.queryDimName(searchReqDto.getConfigName());
                    break;
                }
                case DIM3: {
                    configIds = this.creditDimValueDas.queryDimName(searchReqDto.getConfigName());
                }
            }
            if (CollectionUtils.isEmpty(configIds)) {
                return pageInfo;
            }
        }
        PageHelper.startPage((int)searchReqDto.getPageNum(), (int)searchReqDto.getPageSize());
        PageInfo select = new PageInfo(this.creditAccountDas.queryConfigAccount(searchReqDto, type.getCode(), configIds));
        if (CollectionUtils.isNotEmpty((Collection)select.getList())) {
            BeanUtils.copyProperties((Object)select, (Object)pageInfo, (String[])new String[]{"list"});
            ArrayList list = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)list, (Collection)select.getList(), CreditAccountBaseRespDto.class);
            if (YesOrNoStatus.YES_STATUS.getStatus().equals(searchReqDto.getIsBind())) {
                switch (type) {
                    case CREDIT_TERM: {
                        List ids = select.getList().stream().map(StdCreditAccountEo::getCreditTermModelId).collect(Collectors.toList());
                        Map map = this.creditTermModelDas.queryNameByIds(ids);
                        for (CreditAccountBaseRespDto creditAccountBaseRespDto : list) {
                            creditAccountBaseRespDto.setConfigName((String)map.get(creditAccountBaseRespDto.getCreditTermModelId()));
                        }
                        break;
                    }
                    case LIMIT: {
                        List ids1 = select.getList().stream().map(StdCreditAccountEo::getQuotaStrategyId).collect(Collectors.toList());
                        Map map = this.policyDas.queryNameByIds(ids1);
                        for (CreditAccountBaseRespDto creditAccountBaseRespDto : list) {
                            creditAccountBaseRespDto.setConfigName((String)map.get(creditAccountBaseRespDto.getQuotaStrategyId()));
                        }
                        break;
                    }
                    case OVERDUE: {
                        List ids2 = select.getList().stream().map(StdCreditAccountEo::getOverdueStrategyId).collect(Collectors.toList());
                        Map map = this.policyDas.queryNameByIds(ids2);
                        for (CreditAccountBaseRespDto creditAccountBaseRespDto : list) {
                            creditAccountBaseRespDto.setConfigName((String)map.get(creditAccountBaseRespDto.getOverdueStrategyId()));
                        }
                        break;
                    }
                }
            }
            pageInfo.setList((List)list);
        }
        return pageInfo;
    }

    @Override
    public void batchBindConfig(ConfigBindAccountReqDto configBindAccountReqDto) {
        ConfigType type = this.validConfig(configBindAccountReqDto);
        String value = null;
        if (ConfigType.DIM1.getType().equals(configBindAccountReqDto.getType()) || ConfigType.DIM2.getType().equals(configBindAccountReqDto.getType()) || ConfigType.DIM3.getType().equals(configBindAccountReqDto.getType())) {
            CreditDimValueEo creditDimValueEo = (CreditDimValueEo)this.creditDimValueDas.selectByPrimaryKey(configBindAccountReqDto.getConfigId());
            value = null == creditDimValueEo ? null : creditDimValueEo.getValueDesc();
        }
        this.creditAccountDas.updateAccountConfig(configBindAccountReqDto.getIds(), type.getCode(), value, configBindAccountReqDto.getConfigId());
    }

    @Override
    public void batchRemoveBindConfig(ConfigBindAccountReqDto configBindAccountReqDto) {
        ConfigType type = this.validConfig(configBindAccountReqDto);
        this.creditAccountDas.updateAccountRemoveConfig(configBindAccountReqDto.getIds(), type.getCode(), configBindAccountReqDto.getConfigId());
    }

    private ConfigType validConfig(ConfigBindAccountReqDto configBindAccountReqDto) {
        if (null == configBindAccountReqDto.getConfigId()) {
            throw new BizException("\u9700\u6307\u5b9a\u914d\u7f6eid");
        }
        if (CollectionUtils.isEmpty((Collection)configBindAccountReqDto.getIds())) {
            throw new BizException("\u9700\u6307\u5b9a\u4fe1\u7528\u8d26\u6237");
        }
        ConfigType type = ConfigType.getType((Integer)configBindAccountReqDto.getType());
        if (null == type) {
            throw new BizException("\u67e5\u8be2\u7684\u914d\u7f6e\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        switch (type) {
            case CREDIT_TERM: {
                CreditTermModelEo termModelEo = (CreditTermModelEo)this.creditTermModelDas.selectByPrimaryKey(configBindAccountReqDto.getConfigId());
                if (null != termModelEo) break;
                throw new BizException("\u914d\u7f6eid\u4e0d\u5b58\u5728");
            }
            case LIMIT: {
                PolicyEo policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(configBindAccountReqDto.getConfigId());
                if (null != policyEo) break;
                throw new BizException("\u914d\u7f6eid\u4e0d\u5b58\u5728");
            }
            case OVERDUE: {
                PolicyEo policyEo1 = (PolicyEo)this.policyDas.selectByPrimaryKey(configBindAccountReqDto.getConfigId());
                if (null != policyEo1) break;
                throw new BizException("\u914d\u7f6eid\u4e0d\u5b58\u5728");
            }
            case DIM1: {
                CreditDimValueEo creditDimValueEo = (CreditDimValueEo)this.creditDimValueDas.selectByPrimaryKey(configBindAccountReqDto.getConfigId());
                if (null != creditDimValueEo) break;
                throw new BizException("\u914d\u7f6eid\u4e0d\u5b58\u5728");
            }
            case DIM2: {
                CreditDimValueEo creditDimValueEo1 = (CreditDimValueEo)this.creditDimValueDas.selectByPrimaryKey(configBindAccountReqDto.getConfigId());
                if (null != creditDimValueEo1) break;
                throw new BizException("\u914d\u7f6eid\u4e0d\u5b58\u5728");
            }
            case DIM3: {
                CreditDimValueEo creditDimValueEo2 = (CreditDimValueEo)this.creditDimValueDas.selectByPrimaryKey(configBindAccountReqDto.getConfigId());
                if (null != creditDimValueEo2) break;
                throw new BizException("\u914d\u7f6eid\u4e0d\u5b58\u5728");
            }
        }
        return type;
    }

    @Override
    public Long addAccount(CreditApplyQuotaSaveReqDto creditApplyQuotaSaveReqDto) {
        if (creditApplyQuotaSaveReqDto.getOrgInfoId() == null) {
            Long orgId = this.creditAccountService.queryOrgIdByUserId();
            creditApplyQuotaSaveReqDto.setOrgInfoId(orgId);
        }
        for (CreditApplyQuotaItemSaveReqDto applyQuotaItem : creditApplyQuotaSaveReqDto.getApplyAccounts()) {
            applyQuotaItem.setQuotaType(creditApplyQuotaSaveReqDto.getQuotaType());
            CreditEntityEo creditEntityEo = this.creditEntityDas.findByEntityId(applyQuotaItem.getCreditEntityId());
            Assert.notNull((Object)creditEntityEo, (String)("\u7eed\u8d39\u4e3b\u4f53\u4e3a\u7a7a,code:" + applyQuotaItem.getCreditEntityCode()));
            CreditApplyDetailEo byApplyIdAndEntityCode = this.creditApplyDetailDas.findByApplyIdAndEntityCode(creditApplyQuotaSaveReqDto.getApplyId(), applyQuotaItem.getCreditEntityCode());
            Assert.notNull((Object)byApplyIdAndEntityCode, (String)("\u7eed\u8d39\u8be6\u60c5\u4e3a\u7a7a,code:" + applyQuotaItem.getCreditEntityCode()));
            this.checkDim(applyQuotaItem);
            Date date = new Date();
            CreditAccountEo creditAccountEo = this.buildAccount(applyQuotaItem, creditEntityEo);
            CreditRecordEo creditRecordEo = new CreditRecordEo();
            int creditRecordStatus = CreditRecordStatusEnum.GOOD.getCode();
            if (DateTimeUtils.getDayEndTime((Date)applyQuotaItem.getEndDay()).before(date)) {
                creditRecordStatus = CreditRecordStatusEnum.OVER_DUE.getCode();
                creditAccountEo.setAccountQuota(BigDecimal.ZERO);
            }
            if (applyQuotaItem.getStartDay().after(date)) {
                creditAccountEo.setAccountQuota(BigDecimal.ZERO);
                creditRecordStatus = CreditRecordStatusEnum.NOT_EFFECT.getCode();
            }
            creditAccountEo.setOrgInfoId(creditApplyQuotaSaveReqDto.getOrgInfoId());
            this.creditAccountDas.insert((BaseEo)creditAccountEo);
            this.addUseRecord(creditEntityEo, creditAccountEo);
            this.addAccountRecord(creditApplyQuotaSaveReqDto, applyQuotaItem, byApplyIdAndEntityCode, creditAccountEo, creditRecordEo, creditRecordStatus);
        }
        return creditApplyQuotaSaveReqDto.getApplyId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dealWithQuota(CreditAccountUpdateQuotaReqDto creditAccountUpdateQuotaReqDto) {
        Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), String.valueOf(creditAccountUpdateQuotaReqDto.getCreditAccountId()), 1000, 1000, TimeUnit.MILLISECONDS);
        CreditUsageRecordEo creditUsageRecordEo = new CreditUsageRecordEo();
        try {
            Assert.notNull((Object)creditAccountUpdateQuotaReqDto.getCreditAccountId(), (String)" \u8d26\u53f7id\u4e0d\u80fd\u4e3a\u7a7a");
            CreditAccountEo selectItemCreditAccount = new CreditAccountEo();
            selectItemCreditAccount.setId(creditAccountUpdateQuotaReqDto.getCreditAccountId());
            CreditAccountEo creditAccountEo = (CreditAccountEo)this.creditAccountDas.selectOne((BaseEo)selectItemCreditAccount);
            Assert.notNull((Object)creditAccountEo, (String)(" \u4fe1\u7528\u8d26\u53f7\u627e\u4e0d\u5230,id" + creditAccountUpdateQuotaReqDto.getCreditAccountId()));
            BigDecimal grantQuota = creditAccountUpdateQuotaReqDto.getGrantQuota();
            grantQuota = BigDecimal.ZERO.compareTo(grantQuota) > 0 ? BigDecimal.ZERO.subtract(grantQuota) : grantQuota;
            creditUsageRecordEo.setCreatePerson(creditAccountEo.getCreatePerson());
            creditUsageRecordEo.setUpdatePerson(creditAccountEo.getCreatePerson());
            creditUsageRecordEo.setTenantId(creditAccountEo.getTenantId());
            creditUsageRecordEo.setInstanceId(creditAccountEo.getInstanceId());
            if (creditAccountUpdateQuotaReqDto.getCreditAccountUpdateTypeEnum().getCode() == 1) {
                this.creditAccountDas.addQuota(creditAccountUpdateQuotaReqDto.getCreditAccountId(), grantQuota);
                String pointRemark = "";
                creditUsageRecordEo.setRemark(org.springframework.util.StringUtils.isEmpty((Object)creditAccountUpdateQuotaReqDto.getRemark()) ? "\u91ca\u653e\u989d\u5ea6-\u8c03\u6574\u989d\u5ea6" : creditAccountUpdateQuotaReqDto.getRemark());
                creditUsageRecordEo.setRemainingQuota(creditAccountEo.getAccountQuota().add(creditAccountUpdateQuotaReqDto.getGrantQuota()));
                creditUsageRecordEo.setUsageType(CreditUsageTypeEnum.REMIND.getType());
            }
            if (creditAccountUpdateQuotaReqDto.getCreditAccountUpdateTypeEnum().getCode() == 2) {
                this.creditAccountDas.addQuota(creditAccountUpdateQuotaReqDto.getCreditAccountId(), BigDecimal.ZERO.subtract(grantQuota));
                creditUsageRecordEo.setRemark(org.springframework.util.StringUtils.isEmpty((Object)creditAccountUpdateQuotaReqDto.getRemark()) ? "\u5360\u7528\u989d\u5ea6-\u8c03\u6574\u989d\u5ea6" : creditAccountUpdateQuotaReqDto.getRemark());
                creditUsageRecordEo.setRemainingQuota(creditAccountEo.getAccountQuota().subtract(creditAccountUpdateQuotaReqDto.getGrantQuota()));
                creditUsageRecordEo.setUsageType(CreditUsageTypeEnum.CONTROL.getType());
            }
            creditUsageRecordEo.setCreditAccountId(creditAccountUpdateQuotaReqDto.getCreditAccountId());
            creditUsageRecordEo.setCreditUsageStatus(CreditUsageStatusEnum.GOOD.getCode());
            creditUsageRecordEo.setCustomerId(creditAccountUpdateQuotaReqDto.getCreditEntityId());
            creditUsageRecordEo.setFormCode(org.springframework.util.StringUtils.isEmpty((Object)creditAccountUpdateQuotaReqDto.getFormCode()) ? "\u7a7a" : creditAccountUpdateQuotaReqDto.getFormCode());
            creditUsageRecordEo.setUsageRecordNo(this.generateCode.createCode(GeneralRuleCodeType.USAGE_RECORD));
            creditUsageRecordEo.setQuota(creditAccountUpdateQuotaReqDto.getGrantQuota());
            this.creditUsageRecordDas.insert((BaseEo)creditUsageRecordEo);
        }
        catch (Exception e) {
            this.logger.info("\u8f6c\u5316\u5931\u8d25,data----:" + JSON.toJSONString((Object)creditAccountUpdateQuotaReqDto));
            this.logger.info("\u5931\u8d25\u539f\u56e0" + e.getMessage());
        }
        finally {
            this.logger.info("\u65b0\u589e\u8bb0\u5f55\u6210\u529f,data----:" + JSON.toJSONString((Object)creditUsageRecordEo));
            this.lockService.unlock(lock);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String useAndReleaseQuota(CreditAccountUpdateQuotaReqDto creditAccountUpdateQuotaReqDto) {
        this.logger.info("\u5f53\u524d\u7c7b=CreditAccountServiceImpl.useAndReleaseQuota()" + JSON.toJSONString((Object)creditAccountUpdateQuotaReqDto));
        CreditAccountUpdateDataReqDto creditAccountUpdateDataReqDto = new CreditAccountUpdateDataReqDto();
        creditAccountUpdateDataReqDto.setCreditAccountId(creditAccountUpdateQuotaReqDto.getCreditAccountId());
        creditAccountUpdateDataReqDto.setCreditAccountUpdateTypeEnum(creditAccountUpdateQuotaReqDto.getCreditAccountUpdateTypeEnum());
        creditAccountUpdateDataReqDto.setCreditEntityId(creditAccountUpdateQuotaReqDto.getCreditEntityId());
        creditAccountUpdateDataReqDto.setGrantQuota(creditAccountUpdateQuotaReqDto.getGrantQuota());
        creditAccountUpdateDataReqDto.setRemark(creditAccountUpdateQuotaReqDto.getRemark());
        creditAccountUpdateDataReqDto.setFormCode(creditAccountUpdateQuotaReqDto.getFormCode());
        creditAccountUpdateDataReqDto.setCreditUsageStatus(creditAccountUpdateQuotaReqDto.getCreditUsageStatus());
        Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), "credit_account_use_quota:" + creditAccountUpdateQuotaReqDto.getCreditAccountId(), 2000, 1000, TimeUnit.MILLISECONDS);
        try {
            String s = this.updateCreditAccountQuota(creditAccountUpdateDataReqDto);
            this.lockService.unlock(lock);
            return s;
        }
        catch (Exception e) {
            this.logger.info("\u8d26\u53f7" + creditAccountUpdateQuotaReqDto.getCreditAccountId() + "\u5904\u7406\u989d\u5ea6\u6570\u636e\u5f02\u5e38,data----:" + JSON.toJSONString((Object)creditAccountUpdateQuotaReqDto));
            this.logger.info("\u5931\u8d25\u539f\u56e0" + e.toString());
            this.lockService.unlock(lock);
            return "";
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long preUseQuota(CreditAccountUpdateQuotaReqDto creditAccountUpdateQuotaReqDto) {
        CreditUsageRecordEo creditUsageRecordEo = new CreditUsageRecordEo();
        CreditAccountUpdateDataReqDto creditAccountUpdateDataReqDto = new CreditAccountUpdateDataReqDto();
        creditAccountUpdateDataReqDto.setCreditAccountId(creditAccountUpdateQuotaReqDto.getCreditAccountId());
        creditAccountUpdateDataReqDto.setCreditAccountUpdateTypeEnum(creditAccountUpdateQuotaReqDto.getCreditAccountUpdateTypeEnum());
        creditAccountUpdateDataReqDto.setCreditEntityId(creditAccountUpdateQuotaReqDto.getCreditEntityId());
        creditAccountUpdateDataReqDto.setGrantQuota(creditAccountUpdateQuotaReqDto.getGrantQuota());
        this.updateCreditAccountQuota(creditAccountUpdateDataReqDto);
        return creditUsageRecordEo.getId();
    }

    @Override
    public String updateCreditAccountQuota(CreditAccountUpdateDataReqDto creditAccountUpdateQuotaReqDto) {
        CreditAccountEo creditAccountEo = null;
        Assert.notNull((Object)creditAccountUpdateQuotaReqDto.getCreditAccountId(), (String)" \u8d26\u53f7id\u4e0d\u80fd\u4e3a\u7a7a");
        CreditAccountEo selectItemCreditAccount = new CreditAccountEo();
        selectItemCreditAccount.setId(creditAccountUpdateQuotaReqDto.getCreditAccountId());
        selectItemCreditAccount.setCreditEntityId(creditAccountUpdateQuotaReqDto.getCreditEntityId());
        List creditAccountEos = this.creditAccountDas.selectList((BaseEo)selectItemCreditAccount);
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)creditAccountEos) ? 1 : 0) != 0, (String)(" \u4fe1\u7528\u8d26\u53f7\u627e\u4e0d\u5230,id" + creditAccountUpdateQuotaReqDto.getCreditAccountId()));
        creditAccountEo = (CreditAccountEo)creditAccountEos.get(0);
        BigDecimal accountUsedQuota = creditAccountEo.getAccountUsedQuota();
        BigDecimal accountQuota = creditAccountEo.getAccountQuota();
        BigDecimal grantQuota = creditAccountUpdateQuotaReqDto.getGrantQuota();
        grantQuota = BigDecimal.ZERO.compareTo(grantQuota) > 0 ? BigDecimal.ZERO.subtract(grantQuota) : grantQuota;
        CreditUsageRecordEo creditUsageRecordEo = new CreditUsageRecordEo();
        if (creditAccountUpdateQuotaReqDto.getCreditAccountUpdateTypeEnum() == CreditAccountUpdateTypeEnum.ADD) {
            creditAccountEo.setAccountQuota(accountQuota.add(grantQuota));
            this.creditAccountDas.addQuota(creditAccountUpdateQuotaReqDto.getCreditAccountId(), grantQuota);
        } else if (creditAccountUpdateQuotaReqDto.getCreditAccountUpdateTypeEnum() == CreditAccountUpdateTypeEnum.RELEASE) {
            creditAccountEo.setAccountUsedQuota(accountUsedQuota.subtract(grantQuota));
            this.creditAccountDas.releaseUseQuota(creditAccountUpdateQuotaReqDto.getCreditAccountId(), grantQuota);
        } else if (creditAccountUpdateQuotaReqDto.getCreditAccountUpdateTypeEnum() == CreditAccountUpdateTypeEnum.SUB) {
            creditAccountEo.setAccountUsedQuota(accountUsedQuota.add(grantQuota));
            this.creditAccountDas.useQuota(creditAccountUpdateQuotaReqDto.getCreditAccountId(), grantQuota);
        } else if (creditAccountUpdateQuotaReqDto.getCreditAccountUpdateTypeEnum() == CreditAccountUpdateTypeEnum.NOT_EFFECT) {
            creditAccountEo.setAccountQuota(accountQuota.subtract(grantQuota));
            this.creditAccountDas.subQuota(creditAccountUpdateQuotaReqDto.getCreditAccountId(), grantQuota);
        }
        creditUsageRecordEo.setRemainingQuota(creditAccountEo.getAccountQuota().subtract(creditAccountEo.getAccountUsedQuota()));
        creditUsageRecordEo.setCreatePerson(creditAccountEo.getCreatePerson());
        creditUsageRecordEo.setUpdatePerson(creditAccountEo.getCreatePerson());
        creditUsageRecordEo.setTenantId(creditAccountEo.getTenantId());
        creditUsageRecordEo.setInstanceId(creditAccountEo.getInstanceId());
        creditUsageRecordEo.setRemark(creditAccountUpdateQuotaReqDto.getRemark());
        creditUsageRecordEo.setUsageType(creditAccountUpdateQuotaReqDto.getCreditAccountUpdateTypeEnum() == CreditAccountUpdateTypeEnum.ADD || creditAccountUpdateQuotaReqDto.getCreditAccountUpdateTypeEnum() == CreditAccountUpdateTypeEnum.RELEASE ? CreditUsageTypeEnum.REMIND.getType() : CreditUsageTypeEnum.CONTROL.getType());
        creditUsageRecordEo.setCreditAccountId(creditAccountUpdateQuotaReqDto.getCreditAccountId());
        creditUsageRecordEo.setCreditUsageStatus(null == creditAccountUpdateQuotaReqDto.getCreditUsageStatus() ? CreditUsageStatusEnum.GOOD.getCode() : creditAccountUpdateQuotaReqDto.getCreditUsageStatus());
        creditUsageRecordEo.setCustomerId(creditAccountEo.getCreditEntityId());
        creditUsageRecordEo.setFormCode(org.springframework.util.StringUtils.isEmpty((Object)creditAccountUpdateQuotaReqDto.getFormCode()) ? "\u7a7a" : creditAccountUpdateQuotaReqDto.getFormCode());
        creditUsageRecordEo.setUsageRecordNo(this.generateCode.createCode(GeneralRuleCodeType.USAGE_RECORD));
        creditUsageRecordEo.setQuota(creditAccountUpdateQuotaReqDto.getGrantQuota());
        creditUsageRecordEo.setOrgInfoId(creditAccountEo.getOrgInfoId());
        this.logger.info("\u989d\u5ea6\u5904\u7406\u63d2\u5165\u6570\u636e,creditUsageRecordEo----:" + JSONObject.toJSONString((Object)creditUsageRecordEo));
        this.creditUsageRecordDas.insert((BaseEo)creditUsageRecordEo);
        return creditUsageRecordEo.getUsageRecordNo();
    }

    @Override
    public CreditCustomerAccountDetailRespDto findCustomerAccount(CreditCustomerAccountReqDto creditCustomerAccountReqDto) {
        CreditCustomerAccountDetailRespDto creditCustomerAccountDetailRespDto = new CreditCustomerAccountDetailRespDto();
        CreditEntityEo selectItemCreditEntityDetail = new CreditEntityEo();
        selectItemCreditEntityDetail.setId(creditCustomerAccountReqDto.getCustomerId());
        selectItemCreditEntityDetail.setEntityStatus(EntityStatusEnum.ENABLED.getCode());
        selectItemCreditEntityDetail.setDr(0);
        CreditEntityEo creditEntityEo = (CreditEntityEo)this.creditEntityDas.selectOne((BaseEo)selectItemCreditEntityDetail);
        if (creditEntityEo == null) {
            this.logger.info("------------------------------------------------\u67e5\u627e\u7528\u6237\u8d26\u53f7\u6570\u636e,\u8be5\u5ba2\u6237[{}]\u627e\u4e0d\u5230\u4e3b\u4f53\u76f4\u63a5\u8fd4\u56de", (Object)creditCustomerAccountReqDto.getCustomerId());
            creditCustomerAccountDetailRespDto.setMessage("\u8be5\u5ba2\u6237\u672a\u5f00\u901a\u4fe1\u7528\u8d26\u6237");
            return creditCustomerAccountDetailRespDto;
        }
        List creditAccountEos = this.creditAccountDas.getCreditAccountEos(creditEntityEo.getId());
        this.logger.info("------------------------------------------------\u67e5\u627e\u7528\u6237\u8d26\u53f7\u6570\u636e,\u8be5\u4e3b\u4f53[{}]\u627e\u5230[{}\u4e2a\u4fe1\u7528\u8d26\u53f7", (Object)creditEntityEo.getId(), (Object)creditAccountEos.size());
        if (CollectionUtils.isEmpty((Collection)creditAccountEos)) {
            this.logger.info("------------------------------------------------\u67e5\u627e\u7528\u6237\u8d26\u53f7\u6570\u636e,\u8be5\u4e3b\u4f53[{}]\u627e\u4e0d\u5230\u4efb\u4f55\u4fe1\u7528\u8d26\u53f7\u76f4\u63a5\u8fd4\u56de", (Object)creditEntityEo.getId());
            creditCustomerAccountDetailRespDto.setMessage("\u8be5\u5ba2\u6237\u672a\u5f00\u901a\u4fe1\u7528\u8d26\u6237");
            return creditCustomerAccountDetailRespDto;
        }
        ArrayList<CreditCustomerAccountRespDto> accountResps = new ArrayList<CreditCustomerAccountRespDto>();
        List dirIdsFromReq = creditCustomerAccountReqDto.getCreditCustomerAccountItemReqDtoList().stream().map(CreditCustomerAccountItemReqDto::getDim2IdValue).collect(Collectors.toList());
        this.logger.info("------------------------------------------------\u67e5\u627e\u7528\u6237\u8d26\u53f7\u6570\u636e,\u627e\u5230\u540e\u7aef\u5206\u7c7b\u7f16\u7801[{}]\u4e2a", (Object)JSON.toJSONString(dirIdsFromReq));
        boolean includeNotEffect = false;
        for (CreditAccountEo creditAccountEo : creditAccountEos) {
            if (CreditAccountStatusEnum.NOT_EFFECT.getCode().equals(creditAccountEo.getCreditAccountStatus())) {
                this.logger.info("------------------------------------------------\u67e5\u627e\u7528\u6237\u8d26\u53f7\u6570\u636e,\u627e\u5230\u5df2\u6ce8\u9500\u7684\u8d26\u53f7,\u7f16\u7801[{}]", (Object)creditAccountEo.getCreditAccountCode());
                includeNotEffect = true;
                continue;
            }
            CreditCustomerAccountRespDto creditCustomerAccountRespDto = new CreditCustomerAccountRespDto();
            creditCustomerAccountRespDto.setAccountQuota(creditAccountEo.getAccountQuota());
            creditCustomerAccountRespDto.setAccountUsedQuota(creditAccountEo.getAccountUsedQuota());
            creditCustomerAccountRespDto.setCreditAccountCode(creditAccountEo.getCreditAccountCode());
            creditCustomerAccountRespDto.setId(creditAccountEo.getId());
            creditCustomerAccountRespDto.setValidCreditQuota(creditAccountEo.getAccountQuota().subtract(creditAccountEo.getAccountUsedQuota()));
            creditCustomerAccountRespDto.setAllowAdd(AllowAddEnum.YES.getCode());
            accountResps.add(creditCustomerAccountRespDto);
            if (!creditAccountEo.getCreditAccountStatus().equals(CreditAccountStatusEnum.GOOD.getCode())) {
                creditCustomerAccountRespDto.setReason(CreditAccountStatusEnum.toName((Integer)creditAccountEo.getCreditAccountStatus()));
                creditCustomerAccountRespDto.setAllowAdd(AllowAddEnum.NO.getCode());
                continue;
            }
            RefCreditDimPropEo selectItemRefCreditDimProp = new RefCreditDimPropEo();
            selectItemRefCreditDimProp.setDimValueId(creditAccountEo.getDim2Id());
            List refCreditDimPropEos = creditAccountEo.getDim2Id() == null ? new ArrayList() : this.refCreditDimPropDas.selectList((BaseEo)selectItemRefCreditDimProp);
            List dirIdsFromAccount = refCreditDimPropEos.stream().map(StdRefCreditDimPropEo::getRelateProp).collect(Collectors.toList());
            if (creditAccountEo.getDim2Id() != null && !dirIdsFromAccount.containsAll(dirIdsFromReq)) {
                List collect = refCreditDimPropEos.stream().map(StdRefCreditDimPropEo::getRelatePropDesc).collect(Collectors.toList());
                creditCustomerAccountRespDto.setReason("\u8be5\u8d26\u53f7\u4ec5\u652f\u6301\u4ea7\u54c1\u7ebf:" + StringUtils.join((Object[])new List[]{collect}));
                creditCustomerAccountRespDto.setAllowAdd(AllowAddEnum.NO.getCode());
                continue;
            }
            if (creditCustomerAccountRespDto.getValidCreditQuota().compareTo(creditCustomerAccountReqDto.getOrderTotal()) >= 0) continue;
            creditCustomerAccountRespDto.setReason("\u4f59\u989d\u4e0d\u8db3");
        }
        this.logger.info("------------------------------------------------\u67e5\u627e\u7528\u6237\u8d26\u53f7\u6570\u636e,\u6709\u6548\u8d26\u53f7[{}]\u4e2a,\u540c\u65f6[{}]", (Object)accountResps.size(), (Object)(includeNotEffect ? "\u5b58\u5728\u5df2\u6ce8\u9500\u8d26\u53f7" : "\u4e0d\u5b58\u5728\u5df2\u6ce8\u9500\u8d26\u53f7"));
        if (CollectionUtils.isEmpty(accountResps) && includeNotEffect) {
            this.logger.info("------------------------------------------------\u67e5\u627e\u7528\u6237\u8d26\u53f7\u6570\u636e,\u8be5\u4e3b\u4f53[{}]\u8be5\u5ba2\u6237\u7684\u4fe1\u7528\u8d26\u6237\u5df2\u6ce8\u9500", (Object)creditEntityEo.getId());
            creditCustomerAccountDetailRespDto.setMessage("\u8be5\u5ba2\u6237\u7684\u4fe1\u7528\u8d26\u6237\u5df2\u6ce8\u9500");
        }
        if (CollectionUtils.isEmpty(accountResps) && !includeNotEffect) {
            this.logger.info("------------------------------------------------\u67e5\u627e\u7528\u6237\u8d26\u53f7\u6570\u636e,\u8be5\u4e3b\u4f53[{}]\u8be5\u5ba2\u6237\u672a\u5f00\u901a\u4fe1\u7528\u8d26\u6237", (Object)creditEntityEo.getId());
            creditCustomerAccountDetailRespDto.setMessage("\u8be5\u5ba2\u6237\u672a\u5f00\u901a\u4fe1\u7528\u8d26\u6237");
        }
        creditCustomerAccountDetailRespDto.setCreditCustomerAccountRespDtos(accountResps);
        return creditCustomerAccountDetailRespDto;
    }

    @Override
    public CreditCustomerAccountTotalRespDto findTotalCustomerAccount() {
        ArrayList<CreditCustomerAccountItemRespDto> list = new ArrayList<CreditCustomerAccountItemRespDto>();
        List customerIds = (List)RestResponseCreditHelper.extractData((RestResponse)this.iCustomerExtQueryApi.queryCustomerIdsByUserId(this.iContext.userId()));
        List creditEntityEos = this.creditEntityDas.queryEntityByIds(customerIds);
        Map<Long, CreditEntityEo> creditEntityEoMap = creditEntityEos.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
        BigDecimal totalAccountQuota = BigDecimal.ZERO;
        BigDecimal totalValidCreditQuota = BigDecimal.ZERO;
        List creditAccountEos = this.creditAccountDas.queryAccountByEntityIds(customerIds);
        for (CreditAccountEo creditAccountEo : creditAccountEos) {
            if (!creditEntityEoMap.containsKey(creditAccountEo.getCreditEntityId())) continue;
            CreditEntityEo eo = creditEntityEoMap.get(creditAccountEo.getCreditEntityId());
            BigDecimal validCreditQuota = creditAccountEo.getAccountQuota().subtract(creditAccountEo.getAccountUsedQuota());
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseCreditHelper.extractData((RestResponse)this.iCustomerExtQueryApi.queryOneByOrgId(eo.getOrgInfoId()));
            String customerName = customerRespDto != null ? customerRespDto.getName() : "";
            list.add(new CreditCustomerAccountItemRespDto(creditAccountEo.getId(), creditAccountEo.getCreditAccountCode(), creditAccountEo.getAccountQuota(), validCreditQuota, customerName));
            totalAccountQuota = totalAccountQuota.add(creditAccountEo.getAccountQuota());
            totalValidCreditQuota = totalValidCreditQuota.add(validCreditQuota);
        }
        CreditCustomerAccountTotalRespDto creditCustomerAccountTotalRespDto = new CreditCustomerAccountTotalRespDto();
        creditCustomerAccountTotalRespDto.setUserId(this.iContext.userId());
        creditCustomerAccountTotalRespDto.setAccountQuota(totalAccountQuota);
        creditCustomerAccountTotalRespDto.setValidCreditQuota(totalValidCreditQuota);
        creditCustomerAccountTotalRespDto.setItems(list);
        return creditCustomerAccountTotalRespDto;
    }

    private void addAccountRecord(CreditApplyQuotaSaveReqDto creditApplyQuotaSaveReqDto, CreditApplyQuotaItemSaveReqDto applyQuotaItem, CreditApplyDetailEo byApplyIdAndEntityCode, CreditAccountEo creditAccountEo, CreditRecordEo creditRecordEo, int creditRecordStatus) {
        creditRecordEo.setCreditRecordStatus(Integer.valueOf(creditRecordStatus));
        creditRecordEo.setCreditAccountId(creditAccountEo.getId());
        creditRecordEo.setEndDate(applyQuotaItem.getEndDay());
        creditRecordEo.setStartDate(applyQuotaItem.getStartDay());
        creditRecordEo.setExtension(applyQuotaItem.getExtension());
        creditRecordEo.setCreditRecordCode(CreditNoUtil.generateTradeNo((String)CreditApplyTypeEnum.toName((Integer)creditApplyQuotaSaveReqDto.getApplyType())));
        creditRecordEo.setGrantQuota(applyQuotaItem.getAccountQuota());
        creditRecordEo.setApplyQuota(null != applyQuotaItem.getApplyQuota() ? applyQuotaItem.getApplyQuota() : byApplyIdAndEntityCode.getQuota());
        creditRecordEo.setCreditApplyId(creditApplyQuotaSaveReqDto.getApplyId());
        creditRecordEo.setQuotaType(applyQuotaItem.getQuotaType());
        creditRecordEo.setDr(0);
        creditRecordEo.setCreditEntityId(applyQuotaItem.getCreditEntityId());
        creditRecordEo.setOrgInfoId(creditApplyQuotaSaveReqDto.getOrgInfoId());
        this.creditRecordDas.insert((BaseEo)creditRecordEo);
    }

    private void addUseRecord(CreditEntityEo creditEntityEo, CreditAccountEo creditAccountEo) {
        if (creditAccountEo.getAccountQuota() == null || creditAccountEo.getAccountQuota().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        CreditUsageRecordEo creditUsageRecordEo = new CreditUsageRecordEo();
        creditUsageRecordEo.setCreditAccountId(creditAccountEo.getId());
        creditUsageRecordEo.setCreditUsageStatus(CreditUsageStatusEnum.GOOD.getCode());
        creditUsageRecordEo.setCustomerId(creditEntityEo.getId());
        creditUsageRecordEo.setRemark(CreditUsageRecordType.RULE_QUOTA.getDesc());
        creditUsageRecordEo.setFormCode("\u7a7a");
        if (creditAccountEo.getAccountQuota().compareTo(BigDecimal.ZERO) < 0) {
            creditUsageRecordEo.setQuota(BigDecimal.ZERO.subtract(creditAccountEo.getAccountQuota()));
            creditUsageRecordEo.setUsageType(CreditUsageTypeEnum.CONTROL.getType());
        } else {
            creditUsageRecordEo.setQuota(creditAccountEo.getAccountQuota());
            creditUsageRecordEo.setUsageType(CreditUsageTypeEnum.REMIND.getType());
        }
        creditUsageRecordEo.setRemainingQuota(creditAccountEo.getAccountQuota());
        creditUsageRecordEo.setUsageRecordNo(this.generateCode.createCode(GeneralRuleCodeType.USAGE_RECORD));
        creditUsageRecordEo.setOrgInfoId(creditEntityEo.getOrgInfoId());
        this.creditUsageRecordDas.insert((BaseEo)creditUsageRecordEo);
    }

    private void checkDim(CreditApplyQuotaItemSaveReqDto applyQuotaItem) {
        ArrayList entityIds = Lists.newArrayList((Object[])new Long[]{applyQuotaItem.getCreditEntityId()});
        List accountEoList = this.creditAccountDas.queryAccountByEntityIds((List)entityIds);
        for (CreditAccountEo creditAccountEo : accountEoList) {
            StringBuilder creditAccountEoStringBuilder = new StringBuilder();
            creditAccountEoStringBuilder.append(creditAccountEo.getDim1Id()).append(creditAccountEo.getDim2Id()).append(creditAccountEo.getDim3Id());
            StringBuilder applyQuotaItemStringBuilder = new StringBuilder();
            applyQuotaItemStringBuilder.append(applyQuotaItem.getDim1Id()).append(applyQuotaItem.getDim2Id()).append(applyQuotaItem.getDim3Id());
            if (!creditAccountEoStringBuilder.toString().equals(applyQuotaItemStringBuilder.toString())) continue;
            throw new BizException("\u5b58\u5728\u7ef4\u5ea6\u91cd\u590d\u7684\u8d26\u53f7,\u8bf7\u68c0\u67e5\u8d26\u53f7\u7ef4\u5ea6,\u4e3b\u4f53\u7f16\u7801\u4e3a" + applyQuotaItem.getCreditEntityCode());
        }
    }

    @Override
    @Transactional
    public Integer addQuota(Long accountId, BigDecimal money) {
        this.creditAccountDas.addQuota(accountId, money);
        return null;
    }

    private CreditAccountEo buildAccount(CreditApplyQuotaItemSaveReqDto applyQuotaItem, CreditEntityEo creditEntityEo) {
        CreditAccountEo creditAccountEo = new CreditAccountEo();
        creditAccountEo.setDim1Id(applyQuotaItem.getDim1Id());
        creditAccountEo.setDim2Id(applyQuotaItem.getDim2Id());
        Map<Long, String> dimNameMap = this.getLongStringMap(creditAccountEo);
        creditAccountEo.setCreditAccountCode(this.generateCode.createCode(GeneralRuleCodeType.XYZH));
        creditAccountEo.setCreditEntityId(creditEntityEo.getId());
        creditAccountEo.setCreditEntityName(creditEntityEo.getName());
        creditAccountEo.setAccountQuota(applyQuotaItem.getAccountQuota());
        creditAccountEo.setCreditAccountName(applyQuotaItem.getCreditAccountName());
        creditAccountEo.setCreditAccountStatus(CreditAccountStatusEnum.fromCode((Integer)applyQuotaItem.getCreditAccountStatus()) != null ? applyQuotaItem.getCreditAccountStatus() : CreditAccountStatusEnum.GOOD.getCode());
        creditAccountEo.setCreditTermModelId(applyQuotaItem.getCreditTermModelId());
        creditAccountEo.setDim1Value(dimNameMap.get(creditAccountEo.getDim1Id()));
        creditAccountEo.setDim2Value(dimNameMap.get(creditAccountEo.getDim2Id()));
        creditAccountEo.setExtension(applyQuotaItem.getExtension());
        creditAccountEo.setOverdueStrategyId(applyQuotaItem.getOverdueStrategyId());
        creditAccountEo.setQuotaStrategyId(applyQuotaItem.getQuotaStrategyId());
        creditAccountEo.setAccountUsedQuota(BigDecimal.ZERO);
        creditAccountEo.setDr(0);
        return creditAccountEo;
    }

    private Map<Long, String> getLongStringMap(CreditAccountEo creditAccountEo) {
        ArrayList<Long> dimIds = new ArrayList<Long>();
        if (creditAccountEo.getDim1Id() != null) {
            dimIds.add(creditAccountEo.getDim1Id());
        }
        if (creditAccountEo.getDim2Id() != null) {
            dimIds.add(creditAccountEo.getDim2Id());
        }
        return this.getDimNameMap(new ArrayList<Long>(dimIds));
    }

    @Override
    public boolean checkIsRepeat(CreditApplyQuotaItemSaveReqDto applyQuotaItem, Long entityId) {
        Assert.notNull((Object)entityId, (String)" \u4e3b\u4f53id\u4e0d\u80fd\u4e3a\u7a7a");
        CreditAccountSearchReqDto creditAccountSearchReqDto = new CreditAccountSearchReqDto();
        creditAccountSearchReqDto.setCreditEntityIds((List)Lists.newArrayList((Object[])new Long[]{entityId}));
        creditAccountSearchReqDto.setDim1Id(applyQuotaItem.getDim1Id());
        creditAccountSearchReqDto.setDim2Id(applyQuotaItem.getDim2Id());
        creditAccountSearchReqDto.setDim3Id(applyQuotaItem.getDim3Id());
        List creditAccountEos1 = this.creditAccountDas.queryByList(creditAccountSearchReqDto);
        return CollectionUtils.isEmpty((Collection)creditAccountEos1);
    }

    @Override
    public void updateAccountStatus(Long id, Integer status) {
        CreditAccountEo creditAccountEo = (CreditAccountEo)this.creditAccountDas.selectByPrimaryKey(id);
        if (null == creditAccountEo) {
            throw new BizException("\u4fe1\u7528\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        CreditAccountStatusEnum thisStatusEnum = CreditAccountStatusEnum.fromCode((Integer)status);
        CreditAccountStatusEnum lastStatusEnum = CreditAccountStatusEnum.fromCode((Integer)creditAccountEo.getCreditAccountStatus());
        if (null == thisStatusEnum || null == lastStatusEnum) {
            throw new BizException("\u53d8\u66f4\u72b6\u6001\u4e0d\u5b58\u5728");
        }
        Helmsman helmsman = new Helmsman();
        Boolean aBoolean = helmsman.validChangeStatus(lastStatusEnum, thisStatusEnum);
        if (!aBoolean.booleanValue()) {
            throw new BizException("\u72b6\u6001\u53d8\u66f4\u4e0d\u5408\u7406:" + lastStatusEnum.getName() + "\u72b6\u6001\u4e0d\u80fd\u53d8\u4e3a\u66f4\u4e3a" + thisStatusEnum.getName());
        }
        if (thisStatusEnum == CreditAccountStatusEnum.NOT_EFFECT && creditAccountEo.getAccountUsedQuota().compareTo(BigDecimal.ZERO) > 0) {
            throw new BizException("\u8be5\u8d26\u53f7\u5c1a\u6709\u91d1\u989d:" + creditAccountEo.getAccountUsedQuota() + "\u672a\u8fd8,\u8bf7\u5b8c\u6210\u8fd8\u6b3e\u518d\u8fdb\u884c\u6ce8\u9500");
        }
        CreditAccountEo creditAccountEo1 = new CreditAccountEo();
        creditAccountEo1.setId(creditAccountEo.getId());
        creditAccountEo1.setCreditAccountStatus(status);
        this.creditAccountDas.updateSelective((BaseEo)creditAccountEo1);
    }

    @Override
    public CreditAccountRecordDetailRespDto findAccountRecordDetail(Long id) {
        Assert.notNull((Object)id, (String)" id\u4e0d\u80fd\u4e3a\u7a7a");
        CreditAccountEo creditAccountEo = (CreditAccountEo)this.creditAccountDas.getMapper().selectById((Serializable)id);
        Assert.notNull((Object)creditAccountEo, (String)(" \u627e\u4e0d\u5230\u4fe1\u7528\u8d26\u53f7,id" + id));
        Map<Long, String> dimNameMap = this.getLongStringMap(creditAccountEo);
        CreditAccountRecordDetailRespDto creditAccountRecordDetailRespDto = new CreditAccountRecordDetailRespDto();
        creditAccountRecordDetailRespDto.setId(id);
        creditAccountRecordDetailRespDto.setCreditAccountCode(creditAccountEo.getCreditAccountCode());
        creditAccountRecordDetailRespDto.setDim2Id(creditAccountEo.getDim2Id());
        creditAccountRecordDetailRespDto.setDim2Value(creditAccountEo.getDim2Value());
        creditAccountRecordDetailRespDto.setDim2Desc(StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dimNameMap.get(creditAccountEo.getDim2Id())}) ? "\u4e0d\u9650" : dimNameMap.get(creditAccountEo.getDim2Id()));
        creditAccountRecordDetailRespDto.setDim1Desc(StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dimNameMap.get(creditAccountEo.getDim1Id())}) ? "\u4e0d\u9650" : dimNameMap.get(creditAccountEo.getDim1Id()));
        creditAccountRecordDetailRespDto.setDim1Id(creditAccountEo.getDim1Id());
        creditAccountRecordDetailRespDto.setDim1Value(creditAccountEo.getDim1Value());
        creditAccountRecordDetailRespDto.setAccountUsedQuota(null != creditAccountEo.getAccountUsedQuota() ? creditAccountEo.getAccountUsedQuota() : BigDecimal.ZERO);
        CreditRecordEo selectItemCreditRecord = new CreditRecordEo();
        selectItemCreditRecord.setCreditAccountId(id);
        selectItemCreditRecord.setDr(0);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.ne((String)"credit_record_status", (Object)CreditRecordStatusEnum.BAD.getCode()));
        selectItemCreditRecord.setSqlFilters(sqlFilterList);
        List creditRecordEos = this.creditRecordDas.selectList((BaseEo)selectItemCreditRecord);
        BigDecimal creditSumQuota = creditRecordEos.stream().map(item -> item.getGrantQuota() == null ? BigDecimal.ZERO : item.getGrantQuota()).reduce(BigDecimal.ZERO, BigDecimal::add);
        Date date = new Date();
        BigDecimal creditOverdueQuota = creditRecordEos.stream().filter(data -> DateTimeUtils.getDayEndTime((Date)data.getEndDate()).before(date)).map(item -> item.getGrantQuota() == null ? BigDecimal.ZERO : item.getGrantQuota()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal creditWaitEffectQuota = creditRecordEos.stream().filter(data -> CreditRecordStatusEnum.fromCode((Integer)data.getCreditRecordStatus()) == CreditRecordStatusEnum.NOT_EFFECT).map(item -> item.getGrantQuota() == null ? BigDecimal.ZERO : item.getGrantQuota()).reduce(BigDecimal.ZERO, BigDecimal::add);
        creditAccountRecordDetailRespDto.setCreditSumQuota(creditSumQuota);
        creditAccountRecordDetailRespDto.setCreditOverdueQuota(creditOverdueQuota);
        creditAccountRecordDetailRespDto.setCreditEffectQuota(creditSumQuota.subtract(creditOverdueQuota).subtract(creditWaitEffectQuota));
        BigDecimal accountQuota = null != creditAccountEo.getAccountQuota() ? creditAccountEo.getAccountQuota() : BigDecimal.ZERO;
        BigDecimal accountUsedQuota = null != creditAccountEo.getAccountUsedQuota() ? creditAccountEo.getAccountUsedQuota() : BigDecimal.ZERO;
        creditAccountRecordDetailRespDto.setValidCreditQuota(accountQuota.subtract(accountUsedQuota));
        BigDecimal waitRefundAmount = this.creditRepayPlanDas.countWaitRefundAmount(id);
        creditAccountRecordDetailRespDto.setAccountQuotaNotReturn(waitRefundAmount.subtract(creditAccountRecordDetailRespDto.getAccountUsedQuota()));
        return creditAccountRecordDetailRespDto;
    }

    @Override
    public List<CreditAccountPageRespDto> findAccount(CreditAccountSearchReqDto creditAccountSearchReqDto) {
        List creditAccountEos = this.creditAccountDas.queryByList(creditAccountSearchReqDto);
        List creditAccountPageRespDtos = EoUtil.eoListToDtoList((Collection)creditAccountEos, CreditAccountPageRespDto.class);
        return creditAccountPageRespDtos;
    }

    @Override
    public List<CreditAccountPageRespDto> queryAccountByEntityIds(CreditAccountSearchReqDto creditAccountSearchReqDto) {
        List creditAccountEos = this.creditAccountDas.queryAccountByEntityIds(creditAccountSearchReqDto);
        List creditAccountPageRespDtos = EoUtil.eoListToDtoList((Collection)creditAccountEos, CreditAccountPageRespDto.class);
        return creditAccountPageRespDtos;
    }
}

