/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityCustomerReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityCustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityDetailReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityDetailSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntityReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditEntitySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityCustomerPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditEntityPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.AllowAddEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditAccountStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.EntityStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.EntityTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.GeneralRuleCodeType;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditEntityService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.GenerateCode;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditApplyDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditEntityDetailDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditEntityDetailEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditEntityEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdCreditEntityEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="creditEntity")
public class CreditEntityServiceImpl
implements ICreditEntityService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICustomerQueryApi iCustomerQueryApi;
    @Resource
    private CreditEntityDas creditEntityDas;
    @Resource
    private CreditEntityDetailDas creditEntityDetailDas;
    @Autowired
    private IContext iContext;
    @Autowired
    private CreditAccountDas creditAccountDas;
    @Resource
    private GenerateCode generateCode;
    @Value(value="${dtyunxi.cube.credit.entity.allow.add:1}")
    private Integer allowAdd;
    @Resource
    private CreditApplyDas creditApplyDas;
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICreditAccountService creditAccountService;

    @Override
    public PageInfo<CreditEntityPageRespDto> pageCreditEntity(CreditEntitySearchReqDto creditEntitySearchReqDto, Integer pageNum, Integer pageSize) {
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        creditEntitySearchReqDto.setOrgInfoId(orgId);
        return this.creditEntityDas.pageCreditEntity(creditEntitySearchReqDto, pageNum, pageSize);
    }

    @Override
    public PageInfo<CreditEntityCustomerPageRespDto> pageCreditEntityCustomer(CreditEntityCustomerSearchReqDto pageRequest, Integer pageNum, Integer pageSize) {
        RestResponse pageInfoRestResponse;
        PageInfo data;
        List creditEntityEos;
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        if (orgId == null) {
            return new PageInfo();
        }
        CreditEntityEo creditEntityEo = new CreditEntityEo();
        DtoHelper.dto2Eo((BaseVo)pageRequest, (BaseEo)creditEntityEo);
        creditEntityEo.setOrgInfoId(orgId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)creditEntityEo);
        queryWrapper.ne(StdCreditEntityEo::getEntityStatus, (Object)4);
        if (CollUtil.isNotEmpty((Collection)pageRequest.getEntityIds())) {
            queryWrapper.in(BaseEo::getId, (Collection)pageRequest.getEntityIds());
        }
        if (CollUtil.isNotEmpty((Collection)pageRequest.getIds())) {
            queryWrapper.in(BaseEo::getId, (Collection)pageRequest.getIds());
        }
        if (CollUtil.isEmpty((Collection)(creditEntityEos = this.creditEntityDas.getMapper().selectList((Wrapper)queryWrapper)))) {
            return new PageInfo();
        }
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setMerchantIds((List)Lists.newArrayList((Object[])new Long[]{orgId}));
        if (StrUtil.isNotBlank((CharSequence)pageRequest.getKeyword())) {
            searchReqDto.setKeyword(pageRequest.getKeyword());
        }
        if (CollUtil.isNotEmpty((Collection)pageRequest.getRegionCodes())) {
            searchReqDto.setRegionCodes(pageRequest.getRegionCodes());
        }
        if (CollUtil.isNotEmpty((Collection)pageRequest.getCustomerTypeIds())) {
            searchReqDto.setCustomerTypeIds(pageRequest.getCustomerTypeIds());
        }
        if (CollUtil.isNotEmpty((Collection)pageRequest.getCustomerGroupIds())) {
            searchReqDto.setCustomerGroupIds(pageRequest.getCustomerGroupIds());
        }
        if (Objects.nonNull(pageRequest.getStatusId())) {
            searchReqDto.setStatusId(pageRequest.getStatusId());
        }
        if (Objects.isNull(data = (PageInfo)(pageInfoRestResponse = this.customerQueryApi.queryByPageOnPost(searchReqDto, pageNum, pageSize)).getData()) || CollUtil.isEmpty((Collection)data.getList())) {
            return new PageInfo();
        }
        Map creditEntityMap = creditEntityEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (o1, o2) -> o2));
        CreditAccountEo creditAccountEo = new CreditAccountEo();
        creditAccountEo.setDr(0);
        QueryWrapper queryGroupWrapper = new QueryWrapper((Object)creditAccountEo);
        List customerIds = data.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList());
        queryGroupWrapper.in((Object)"credit_entity_id", customerIds);
        queryGroupWrapper.groupBy((Object)"credit_entity_id");
        queryGroupWrapper.select(new String[]{"credit_entity_id AS creditEntityId, COUNT(1) AS creditAccountStatus"});
        List creditAccountEos = this.creditAccountDas.getMapper().selectList((Wrapper)queryGroupWrapper);
        Map<Long, Integer> creditAccountMap = creditAccountEos.stream().collect(Collectors.toMap(StdCreditAccountEo::getCreditEntityId, StdCreditAccountEo::getCreditAccountStatus));
        List pageRespDtos = data.getList().stream().map(item -> {
            CreditEntityCustomerPageRespDto creditEntityCustomerPageRespDto = new CreditEntityCustomerPageRespDto();
            creditEntityCustomerPageRespDto.setId(item.getId());
            if (creditEntityMap.containsKey(item.getId())) {
                CreditEntityEo entityEo = (CreditEntityEo)creditEntityMap.get(item.getId());
                creditEntityCustomerPageRespDto.setCode(entityEo.getCode());
                creditEntityCustomerPageRespDto.setType(entityEo.getType());
                creditEntityCustomerPageRespDto.setRemark(entityEo.getRemark());
                creditEntityCustomerPageRespDto.setStatus(entityEo.getEntityStatus());
            }
            creditEntityCustomerPageRespDto.setCustomerName(item.getName());
            creditEntityCustomerPageRespDto.setName(item.getName());
            creditEntityCustomerPageRespDto.setCustomerId(item.getId());
            creditEntityCustomerPageRespDto.setCustomerCode(item.getCode());
            creditEntityCustomerPageRespDto.setRegionCode(item.getRegionCodes());
            creditEntityCustomerPageRespDto.setRegion(item.getRegionNames());
            creditEntityCustomerPageRespDto.setCustomerTypeId(item.getCustomerTypeId());
            creditEntityCustomerPageRespDto.setCustomerTypeName(item.getCustomerTypeName());
            creditEntityCustomerPageRespDto.setCustomerStatusName(item.getStatusName());
            creditEntityCustomerPageRespDto.setCustomerGroupId(item.getCustomerGroupId());
            creditEntityCustomerPageRespDto.setCustomerGroupName(item.getCustomerGroupName());
            creditEntityCustomerPageRespDto.setAccountNum(Integer.valueOf(0));
            if (creditAccountMap.containsKey(item.getId())) {
                creditEntityCustomerPageRespDto.setAccountNum((Integer)creditAccountMap.get(item.getId()));
            }
            return creditEntityCustomerPageRespDto;
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo(pageRespDtos);
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setPages(data.getPages());
        pageInfo.setTotal(data.getTotal());
        return pageInfo;
    }

    @Override
    public PageInfo<CreditEntityCustomerPageRespDto> pageCreditEntityGroup(CreditEntityCustomerSearchReqDto pageRequest, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List creditEntityEos = this.creditEntityDetailDas.pageCreditEntityGroup(pageRequest);
        for (CreditEntityCustomerPageRespDto creditEntityEo : creditEntityEos) {
            creditEntityEo.setQuotaCanUse(BigDecimal.valueOf(12L));
            creditEntityEo.setQuotaPlan(BigDecimal.valueOf(12L));
        }
        return new PageInfo(creditEntityEos);
    }

    @Override
    public List<CreditEntityCustomerPageRespDto> findBaseInfosByIds(List<Long> entityIds) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return Lists.newArrayList();
        }
        return this.creditEntityDetailDas.findCodesByIds(entityIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCreditCustomerEntity(CreditEntitySaveReqDto creditEntitySaveReqDto) {
        CreditEntityDetailSaveReqDto creditEntityDetailSaveReqDto = (CreditEntityDetailSaveReqDto)creditEntitySaveReqDto.getCreditList().get(0);
        CreditEntityEo creditEntityDate = this.getCreditEntityDate(creditEntitySaveReqDto);
        CreditEntityEo creditEntityEo1 = creditEntityDate.getId() == null ? null : this.checkData(creditEntitySaveReqDto, creditEntityDate);
        creditEntityDate.setAllowAdd(Integer.valueOf(2));
        if (creditEntityEo1 != null) {
            creditEntityDate.setEntityStatus(StringUtils.isEmpty((Object)creditEntityDate.getCode()) ? EntityStatusEnum.ENABLED.getCode() : EntityStatusEnum.ENABLED.getCode());
            this.creditEntityDas.updateSelective((BaseEo)creditEntityDate);
        } else {
            Long orgId = creditEntitySaveReqDto.getOrgInfoId();
            if (orgId == null) {
                orgId = this.creditAccountService.queryOrgIdByUserId();
            }
            String code = this.generateCode.createCode(GeneralRuleCodeType.SXZT);
            creditEntityDate.setCode(code);
            creditEntityDate.setOrgInfoId(orgId);
            if (creditEntitySaveReqDto.getInstanceId() != null) {
                creditEntityDate.setInstanceId(creditEntitySaveReqDto.getInstanceId());
            }
            if (creditEntitySaveReqDto.getTenantId() != null) {
                creditEntityDate.setTenantId(creditEntitySaveReqDto.getTenantId());
            }
            this.creditEntityDas.insert((BaseEo)creditEntityDate);
        }
        if (creditEntityDetailSaveReqDto != null) {
            CreditEntityDetailEo creditEntityDetailEo = new CreditEntityDetailEo();
            creditEntityDetailEo.setCreditEntityId(creditEntityDate.getId());
            List select = this.creditEntityDetailDas.select((BaseEo)creditEntityDetailEo);
            CreditEntityDetailEo newEo = this.getCreditEntityDetailEo(creditEntityDetailSaveReqDto, creditEntityDate.getId());
            newEo.setId(CollectionUtils.isEmpty((Collection)select) ? null : ((CreditEntityDetailEo)select.get(0)).getId());
            if (newEo.getId() == null) {
                this.creditEntityDetailDas.insert((BaseEo)newEo);
            } else {
                this.creditEntityDetailDas.updateSelective((BaseEo)newEo);
            }
        }
        return creditEntityDate.getId();
    }

    private CreditEntityEo checkData(CreditEntitySaveReqDto creditEntitySaveReqDto, CreditEntityEo creditEntityDate) {
        CreditEntityEo creditEntityEo = new CreditEntityEo();
        creditEntityEo.setId(creditEntitySaveReqDto.getId());
        CreditEntityEo creditEntityEo1 = creditEntityDate.getId() == null ? null : (CreditEntityEo)this.creditEntityDas.selectOne((BaseEo)creditEntityEo);
        Assert.isTrue((creditEntityEo1 == null || creditEntityEo1.getEntityStatus() == 4 || creditEntityEo1.getAllowAdd() == 1 ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u91cd\u590d\u52a0\u5165");
        return creditEntityEo1;
    }

    private void checkData(CreditEntitySaveReqDto creditEntitySaveReqDto) {
        Iterator iterator = creditEntitySaveReqDto.getCreditList().iterator();
        if (iterator.hasNext()) {
            CreditEntityDetailSaveReqDto creditEntityDetailSaveReqDto = (CreditEntityDetailSaveReqDto)iterator.next();
            CreditEntityCustomerReqDto creditEntityCustomerReqDto = new CreditEntityCustomerReqDto();
            creditEntityCustomerReqDto.setCustomerId(creditEntityDetailSaveReqDto.getCustomerId());
            creditEntityCustomerReqDto.setEntityType(creditEntitySaveReqDto.getType());
            creditEntityCustomerReqDto.setInstanceId(this.iContext.instanceId());
            creditEntityCustomerReqDto.setTenantId(this.iContext.tenantId());
            Integer integer = this.creditEntityDas.countByCustomerIdAndDrAndEntityType(creditEntityCustomerReqDto);
            Assert.isTrue((integer <= 0 ? 1 : 0) != 0, (String)("\u5ba2\u6237:" + creditEntitySaveReqDto.getName() + " \u5df2\u52a0\u5165:" + EntityTypeEnum.toName((Integer)creditEntitySaveReqDto.getType()) + "\u4e3b\u4f53,\u65e0\u6cd5\u91cd\u590d\u52a0\u5165"));
            return;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long id) {
        Assert.notNull((Object)id, (String)" id\u4e0d\u80fd\u4e3a\u7a7a");
        CreditEntityEo creditEntityEo1 = (CreditEntityEo)this.creditEntityDas.selectByPrimaryKey(id);
        Assert.notNull((Object)creditEntityEo1, (String)(" \u627e\u4e0d\u5230\u4fe1\u7528\u7ec4/\u5206\u7ec4id:" + id));
        if (!EntityTypeEnum.CUSTOMER.getCode().equals(creditEntityEo1.getType())) {
            this.creditEntityDas.logicDeleteById(id);
        }
        CreditEntityEo creditEntityEo = new CreditEntityEo();
        creditEntityEo.setAllowAdd(AllowAddEnum.YES.getCode());
        creditEntityEo.setId(id);
        this.creditEntityDas.updateSelective((BaseEo)creditEntityEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disable(Long type, Long id) {
        CreditEntityEo creditEntityEo = (CreditEntityEo)this.creditEntityDas.selectByPrimaryKey(id);
        Assert.notNull((Object)creditEntityEo, (String)("\u4e3b\u4f53\u4e0d\u5b58\u5728.\u4e3b\u4f53id:" + id));
        creditEntityEo.setEntityStatus(type == 1L ? EntityStatusEnum.DISABLED.getCode() : EntityStatusEnum.ENABLED.getCode());
        this.creditEntityDas.update((BaseEo)creditEntityEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCreditEntityName(CreditEntityReqDto creditEntitySaveReqDto) {
        Assert.isTrue((!StringUtils.isEmpty((Object)creditEntitySaveReqDto.getName()) ? 1 : 0) != 0, (String)("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.\u4e3b\u4f53id:" + creditEntitySaveReqDto.getId()));
        CreditEntityEo selectItemCreditEntity = new CreditEntityEo();
        selectItemCreditEntity.setName(creditEntitySaveReqDto.getName());
        selectItemCreditEntity.setType(creditEntitySaveReqDto.getType());
        List creditEntityEos = this.creditEntityDas.selectList((BaseEo)selectItemCreditEntity);
        if (!CollectionUtils.isEmpty((Collection)creditEntityEos) && !((CreditEntityEo)creditEntityEos.get(0)).getId().equals(creditEntitySaveReqDto.getId())) {
            throw new BizException(creditEntitySaveReqDto.getName() + "\u540d\u79f0\u91cd\u590d,\u8bf7\u66f4\u6362");
        }
        CreditEntityEo selectItemCreditEntity1 = new CreditEntityEo();
        selectItemCreditEntity1.setId(creditEntitySaveReqDto.getId());
        selectItemCreditEntity1.setInstanceId(this.iContext.instanceId());
        selectItemCreditEntity1.setTenantId(this.iContext.tenantId());
        CreditEntityEo creditEntityEo = (CreditEntityEo)this.creditEntityDas.selectOne((BaseEo)selectItemCreditEntity1);
        Assert.notNull((Object)creditEntityEo, (String)("\u4e3b\u4f53\u4e0d\u5b58\u5728.\u4e3b\u4f53id:" + creditEntitySaveReqDto.getId()));
        creditEntityEo.setName(creditEntitySaveReqDto.getName());
        this.creditEntityDas.updateSelective((BaseEo)creditEntityEo);
    }

    @Override
    public List<Long> getEnableCustomerIds(String entityType) {
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        return this.creditEntityDas.getEnableCustomerIds(orgId, entityType, this.iContext.tenantId(), this.iContext.instanceId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCreditGroupEntity(Integer type, String name) {
        CreditEntityEo selectItemCreditEntity = new CreditEntityEo();
        selectItemCreditEntity.setType(EntityTypeEnum.toCode((Integer)type));
        selectItemCreditEntity.setName(name);
        List creditEntityEos = this.creditEntityDas.selectList((BaseEo)selectItemCreditEntity);
        if (!CollectionUtils.isEmpty((Collection)creditEntityEos) && ((CreditEntityEo)creditEntityEos.get(0)).getEntityStatus() == 4) {
            CreditEntityEo creditEntityEo;
            creditEntityEo.setEntityStatus(StringUtils.isEmpty((Object)(creditEntityEo = (CreditEntityEo)creditEntityEos.get(0)).getCode()) ? EntityStatusEnum.WAIT_ENABLED.getCode() : EntityStatusEnum.ENABLED.getCode());
            this.creditEntityDas.updateSelective((BaseEo)creditEntityEo);
            return creditEntityEo.getId();
        }
        if (!CollectionUtils.isEmpty((Collection)creditEntityEos)) {
            throw new BizException("\u4e3b\u4f53\u540d\u79f0\u91cd\u590d");
        }
        CreditEntityEo creditEntityEo = new CreditEntityEo();
        creditEntityEo.setName(name);
        creditEntityEo.setType(EntityTypeEnum.toCode((Integer)type));
        creditEntityEo.setEntityStatus(EntityStatusEnum.ENABLED.getCode());
        String code = this.generateCode.createCode(EntityTypeEnum.CREDIT_GROUP == EntityTypeEnum.fromCode((Integer)type) ? GeneralRuleCodeType.XYZ : GeneralRuleCodeType.GXZ);
        creditEntityEo.setCode(code);
        this.creditEntityDas.insert((BaseEo)creditEntityEo);
        return creditEntityEo.getId();
    }

    @Override
    public CreditEntityDetailReqDto getEntityGroupDetail(Long id) {
        CreditEntityDetailReqDto creditEntityDetailReqDto = new CreditEntityDetailReqDto();
        Assert.notNull((Object)id, (String)" \u4e3b\u4f53id\u4e0d\u80fd\u4e3a\u7a7a");
        CreditEntityEo creditEntityEo = (CreditEntityEo)this.creditEntityDas.selectByPrimaryKey(id);
        creditEntityDetailReqDto.setId(id);
        creditEntityDetailReqDto.setCode(creditEntityEo.getCode());
        creditEntityDetailReqDto.setName(creditEntityEo.getName());
        creditEntityDetailReqDto.setType(creditEntityEo.getType());
        creditEntityDetailReqDto.setStatus(creditEntityEo.getEntityStatus());
        creditEntityDetailReqDto.setAccountUsedQuota(BigDecimal.ZERO);
        creditEntityDetailReqDto.setQuotaUpper(BigDecimal.ZERO);
        creditEntityDetailReqDto.setQuotaShare(BigDecimal.ZERO);
        return creditEntityDetailReqDto;
    }

    @Override
    public Set<Long> getFilterEntityIds(Long entityGroupId) {
        Integer limitAdd = 1;
        Set ids = this.creditEntityDas.getFilterEntityIds(limitAdd);
        Set idsds = this.creditEntityDetailDas.getCustomerId(entityGroupId);
        ids.removeAll(idsds);
        return ids;
    }

    @Override
    public CreditEntityDetailReqDto getEntityDetail(Long id) {
        Assert.notNull((Object)id, (String)" \u4e3b\u4f53id\u4e0d\u80fd\u4e3a\u7a7a");
        CreditEntityDetailReqDto creditEntityDetailReqDto = new CreditEntityDetailReqDto();
        CreditEntityEo creditEntityEo = (CreditEntityEo)this.creditEntityDas.selectByPrimaryKey(id);
        creditEntityEo = creditEntityEo == null ? new CreditEntityEo() : creditEntityEo;
        DtoHelper.eo2Dto((BaseEo)creditEntityEo, (BaseVo)creditEntityDetailReqDto);
        CreditEntityDetailEo selectItemCreditEntityDetail = new CreditEntityDetailEo();
        selectItemCreditEntityDetail.setCreditEntityId(id);
        List creditEntityDetailEos = this.creditEntityDetailDas.selectList((BaseEo)selectItemCreditEntityDetail);
        CreditEntityDetailEo creditEntityDetailEo = !CollectionUtils.isEmpty((Collection)creditEntityDetailEos) ? (CreditEntityDetailEo)creditEntityDetailEos.get(0) : new CreditEntityDetailEo();
        DtoHelper.eo2Dto((BaseEo)creditEntityDetailEo, (BaseVo)creditEntityDetailReqDto);
        CreditAccountEo selectItemCreditAccount = new CreditAccountEo();
        selectItemCreditAccount.setCreditEntityId(id);
        selectItemCreditAccount.setCreditAccountStatus(CreditAccountStatusEnum.GOOD.getCode());
        List creditAccountEos = this.creditAccountDas.selectList((BaseEo)selectItemCreditAccount, Integer.valueOf(1), Integer.valueOf(999999));
        BigDecimal accountQuota = BigDecimal.ZERO;
        BigDecimal accountUsedQuota = BigDecimal.ZERO;
        this.buildRegionName(creditEntityDetailReqDto);
        if (!CollectionUtils.isEmpty((Collection)creditAccountEos)) {
            for (CreditAccountEo creditAccountEo : creditAccountEos) {
                accountQuota = accountQuota.add(creditAccountEo.getAccountQuota() == null ? BigDecimal.ZERO : creditAccountEo.getAccountQuota());
                accountUsedQuota = accountUsedQuota.add(creditAccountEo.getAccountUsedQuota() == null ? BigDecimal.ZERO : creditAccountEo.getAccountUsedQuota());
            }
        }
        creditEntityDetailReqDto.setAccountQuota(accountQuota);
        creditEntityDetailReqDto.setAccountUsedQuota(accountUsedQuota);
        creditEntityDetailReqDto.setValidCreditQuota(accountQuota.subtract(accountUsedQuota).max(BigDecimal.ZERO));
        return creditEntityDetailReqDto;
    }

    private void buildRegionName(CreditEntityDetailReqDto creditEntityDetailReqDto) {
        try {
            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
            searchReqDto.setId(creditEntityDetailReqDto.getCustomerId());
            PageInfo data = (PageInfo)this.iCustomerQueryApi.queryByPage(JSONObject.toJSONString((Object)searchReqDto), Integer.valueOf(1), Integer.valueOf(10)).getData();
            creditEntityDetailReqDto.setRegionName(((CustomerRespDto)data.getList().get(0)).getRegionNames());
        }
        catch (Exception e) {
            creditEntityDetailReqDto.setRegionName("\u7a7a");
        }
    }

    private CreditEntityDetailEo getCreditEntityDetailEo(CreditEntityDetailSaveReqDto creditEntityDetailSaveReqDto, Long entityId) {
        CreditEntityDetailEo creditEntityDetailEo = new CreditEntityDetailEo();
        creditEntityDetailEo.setCreditEntityId(entityId);
        creditEntityDetailEo.setCustomerId(creditEntityDetailSaveReqDto.getCustomerId());
        creditEntityDetailEo.setCustomerCode(creditEntityDetailSaveReqDto.getCustomerCode());
        creditEntityDetailEo.setCustomerName(creditEntityDetailSaveReqDto.getCustomerName());
        creditEntityDetailEo.setExtension(creditEntityDetailSaveReqDto.getExtension());
        creditEntityDetailEo.setId(creditEntityDetailSaveReqDto.getId());
        creditEntityDetailEo.setTenantId(creditEntityDetailSaveReqDto.getTenantId());
        creditEntityDetailEo.setInstanceId(creditEntityDetailSaveReqDto.getInstanceId());
        creditEntityDetailEo.setCreatePerson(creditEntityDetailSaveReqDto.getCreatePerson());
        creditEntityDetailEo.setCustomerTypeName(creditEntityDetailSaveReqDto.getCustomerTypeName());
        creditEntityDetailEo.setCustomerTypeId(creditEntityDetailSaveReqDto.getCustomerTypeId());
        creditEntityDetailEo.setRegionCode(creditEntityDetailSaveReqDto.getRegionCode());
        creditEntityDetailEo.setRegion(creditEntityDetailSaveReqDto.getRegion());
        creditEntityDetailEo.setStatusId(creditEntityDetailSaveReqDto.getStatusId());
        creditEntityDetailEo.setStatusName(creditEntityDetailSaveReqDto.getStatusName());
        creditEntityDetailEo.setCustomerId(creditEntityDetailSaveReqDto.getCustomerId());
        creditEntityDetailEo.setIsCustomer(Integer.valueOf(1));
        creditEntityDetailEo.setCustomerGroupId(creditEntityDetailSaveReqDto.getCustomerGroupId());
        creditEntityDetailEo.setCustomerGroupName(creditEntityDetailSaveReqDto.getCustomerGroupName());
        return creditEntityDetailEo;
    }

    private CreditEntityEo getCreditEntityDate(CreditEntitySaveReqDto creditEntitySaveReqDto) {
        CreditEntityEo creditEntityEo = new CreditEntityEo();
        creditEntityEo.setCode(creditEntitySaveReqDto.getCode());
        creditEntityEo.setName(creditEntitySaveReqDto.getName());
        creditEntityEo.setType(creditEntitySaveReqDto.getType());
        creditEntityEo.setEntityStatus(creditEntitySaveReqDto.getEntityStatus());
        creditEntityEo.setRemark(creditEntitySaveReqDto.getRemark());
        creditEntityEo.setExtension(creditEntitySaveReqDto.getExtension());
        creditEntityEo.setId(creditEntitySaveReqDto.getId());
        creditEntityEo.setDr(0);
        return creditEntityEo;
    }
}

