/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.OccupyConfigReqDto;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditOccupyConfigService;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditNodeDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditOccupyConfigDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditOrderBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditOccupyConfigEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="creditOccupyConfig")
public class CreditOccupyConfigServiceImpl
implements ICreditOccupyConfigService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IContext iContext;
    @Resource
    private CreditOccupyConfigDas creditOccupyConfigDas;
    @Resource
    private CreditOrderBillDas creditOrderBillDas;
    @Resource
    private CreditNodeDas creditNodeDas;
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private ICreditAccountService creditAccountService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(OccupyConfigReqDto occupyConfigReqDto) {
        if (null == occupyConfigReqDto.getCreditNodeId() || CollectionUtils.isEmpty((Collection)occupyConfigReqDto.getReleaseCreditNodeIds())) {
            throw new BizException("\u5360\u7528\u65f6\u70b9\u3001\u91ca\u653e\u65f6\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CreditOccupyConfigEo selectItemCreditOccupyConfig = new CreditOccupyConfigEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.isNull((String)"is_backup"));
        selectItemCreditOccupyConfig.setSqlFilters(sqlFilterList);
        selectItemCreditOccupyConfig.setDr(0);
        selectItemCreditOccupyConfig.setInstanceId(this.iContext.instanceId());
        selectItemCreditOccupyConfig.setTenantId(this.iContext.tenantId());
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        selectItemCreditOccupyConfig.setOrgInfoId(orgId);
        List list = this.creditOccupyConfigDas.selectList((BaseEo)selectItemCreditOccupyConfig);
        if (CollectionUtils.isEmpty((Collection)list)) {
            CreditOccupyConfigEo newOccupyConfigEo = new CreditOccupyConfigEo();
            newOccupyConfigEo.setOrgInfoId(orgId);
            newOccupyConfigEo.setTenantId(this.iContext.tenantId());
            newOccupyConfigEo.setInstanceId(this.iContext.instanceId());
            newOccupyConfigEo.setIsBackup(null);
            newOccupyConfigEo.setCreditNode(occupyConfigReqDto.getCreditNodeId().toString());
            String releaseNodeIds = StringUtils.join((Iterable)occupyConfigReqDto.getReleaseCreditNodeIds(), (String)",");
            newOccupyConfigEo.setReleaseCreditNode(releaseNodeIds);
            this.creditOccupyConfigDas.insert((BaseEo)newOccupyConfigEo);
            return newOccupyConfigEo.getId();
        }
        CreditOccupyConfigEo occupyConfigEo = (CreditOccupyConfigEo)list.get(0);
        this.backData(occupyConfigEo);
        occupyConfigEo.setCreditNode(occupyConfigReqDto.getCreditNodeId().toString());
        String releaseNodeIds = StringUtils.join((Iterable)occupyConfigReqDto.getReleaseCreditNodeIds(), (String)",");
        occupyConfigEo.setReleaseCreditNode(releaseNodeIds);
        this.creditOccupyConfigDas.updateSelective((BaseEo)occupyConfigEo);
        return occupyConfigEo.getId();
    }

    private void backData(CreditOccupyConfigEo oldOccupyConfigEo) {
        CreditOccupyConfigEo newOccupyConfigEo = new CreditOccupyConfigEo();
        BeanUtils.copyProperties((Object)oldOccupyConfigEo, (Object)newOccupyConfigEo, (String[])new String[]{"id"});
        newOccupyConfigEo.setIsBackup(Integer.valueOf(1));
        newOccupyConfigEo.setSourceId(oldOccupyConfigEo.getId());
        this.creditOccupyConfigDas.insert((BaseEo)newOccupyConfigEo);
        this.creditOrderBillDas.updatePointValue("credit_occupy_config_id", newOccupyConfigEo.getId(), oldOccupyConfigEo.getId());
    }

    @Override
    public OccupyConfigReqDto getOccupyConfigByOrgId(Long orgId) {
        CreditOccupyConfigEo occupyConfigEo;
        OccupyConfigReqDto dto = new OccupyConfigReqDto();
        List list = this.creditOccupyConfigDas.getCreditOccupyConfigEos(orgId);
        CreditOccupyConfigEo creditOccupyConfigEo = occupyConfigEo = CollectionUtils.isNotEmpty((Collection)list) ? (CreditOccupyConfigEo)list.get(0) : this.creditOccupyConfigDas.findEffectConfig();
        if (occupyConfigEo != null) {
            dto.setCreditNodeId(Long.valueOf(occupyConfigEo.getCreditNode()));
            List idsList = Arrays.stream(occupyConfigEo.getReleaseCreditNode().split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            dto.setId(occupyConfigEo.getId());
            dto.setReleaseCreditNodeIds(idsList);
        }
        return dto;
    }
}

