/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountUpdateQuotaReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRecordBatchSaveReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRecordReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRecordSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditAccountRecordUseDetailRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditRecordPageRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditAccountUpdateTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditApplyTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRecordStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditUsageRecordType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.QuotaTypeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.CreditNoUtil;
import com.dtyunxi.yundt.cube.center.credit.api.credit.utils.DateTimeUtils;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditRecordService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.GenerateCode;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditUsageRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditAccountEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRecordEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service(value="creditRecord")
public class CreditRecordServiceImpl
implements ICreditRecordService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CreditAccountDas creditAccountDas;
    @Resource
    private CreditRecordDas creditRecordDas;
    @Resource
    private GenerateCode generateCode;
    @Autowired
    private CreditUsageRecordDas creditUsageRecordDas;
    @Autowired
    private ICreditAccountService iCreditAccountService;

    @Override
    public List<CreditRecordEo> findCreditRecordList(CreditRecordEo creditRecordEo) {
        creditRecordEo = creditRecordEo == null ? new CreditRecordEo() : creditRecordEo;
        ArrayList sqlFilterList = new ArrayList();
        creditRecordEo.setEndDate(null);
        creditRecordEo.setSqlFilters(sqlFilterList);
        creditRecordEo.setDr(0);
        creditRecordEo.setOrderByDesc("updateTime");
        List creditRecordEos = this.creditRecordDas.selectList((BaseEo)creditRecordEo);
        return CollectionUtils.isNotEmpty((Collection)creditRecordEos) ? creditRecordEos : new ArrayList();
    }

    @Override
    public List<CreditRecordEo> findEffectCreditRecordList(CreditRecordEo creditRecordEo) {
        creditRecordEo = creditRecordEo == null ? new CreditRecordEo() : creditRecordEo;
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.ge((String)"end_date", (Object)new Date()));
        creditRecordEo.setEndDate(null);
        creditRecordEo.setSqlFilters(sqlFilterList);
        creditRecordEo.setCreditRecordStatus(CreditRecordStatusEnum.GOOD.getCode());
        creditRecordEo.setDr(0);
        creditRecordEo.setOrderByDesc("updateTime");
        List creditRecordEos = this.creditRecordDas.selectList((BaseEo)creditRecordEo);
        return CollectionUtils.isNotEmpty((Collection)creditRecordEos) ? creditRecordEos : new ArrayList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddOrUpdateQuota(List<CreditRecordBatchSaveReqDto> creditRecordSaveReqDto) {
        Date date = new Date();
        this.logger.info("\u6279\u91cf\u4fee\u6539[{}]", (Object)date);
        List supplierReturnList = creditRecordSaveReqDto.stream().map(data -> this.buildCreditRecordBatchSaveReqDto((CreditRecordBatchSaveReqDto)data, date)).collect(Collectors.toList());
        CreditUsageRecordType creditUsageRecordType = null;
        for (CreditRecordBatchSaveReqDto creditRecordBatchSaveReqDto : supplierReturnList) {
            if (creditRecordBatchSaveReqDto.getId() == null) {
                Assert.notNull((Object)creditRecordBatchSaveReqDto.getCreditEntityId(), (String)"\u8be5\u503c\u4e3a\u7a7a:\u4fe1\u7528\u4e3b\u4f53ID");
                this.logger.info("\u5224\u65ad\u8bb0\u5f55\u5bf9\u8d26\u53f7\u7684\u989d\u5ea6\u5f71\u54cd,\u65b0\u589e\u989d\u5ea6[{}]", (Object)creditRecordBatchSaveReqDto.getAccountQuota());
                if (!DateTimeUtils.getDayEndTime((Date)creditRecordBatchSaveReqDto.getEndDate()).before(date) && !DateTimeUtils.getDayStartTime((Date)creditRecordBatchSaveReqDto.getStartDate()).after(date) && CreditRecordStatusEnum.GOOD == CreditRecordStatusEnum.fromCode((Integer)creditRecordBatchSaveReqDto.getCreditRecordStatus())) {
                    creditRecordBatchSaveReqDto.setEffectAccountQuota(creditRecordBatchSaveReqDto.getAccountQuota());
                    creditUsageRecordType = QuotaTypeEnum.NORMAL.getCode().equals(creditRecordBatchSaveReqDto.getQuotaType()) ? CreditUsageRecordType.RULE_QUOTA : CreditUsageRecordType.TEMP_QUOTA;
                }
            } else {
                CreditRecordEo creditRecordEo = (CreditRecordEo)this.creditRecordDas.selectByPrimaryKey(creditRecordBatchSaveReqDto.getId());
                Assert.isTrue((creditRecordEo != null ? 1 : 0) != 0, (String)("\u627e\u4e0d\u5230\u989d\u5ea6\u8bb0\u5f55,\u989d\u5ea6id:" + creditRecordBatchSaveReqDto.getId()));
                creditRecordBatchSaveReqDto.setOrgInfoId(creditRecordEo.getOrgInfoId());
                creditRecordBatchSaveReqDto.setCreditEntityId(creditRecordEo.getCreditEntityId());
                creditRecordBatchSaveReqDto.setCreditAccountId(creditRecordEo.getCreditAccountId());
                boolean recordBeforeIsEffect = !DateTimeUtils.getDayEndTime((Date)creditRecordEo.getEndDate()).before(date) && !DateTimeUtils.getDayStartTime((Date)creditRecordEo.getStartDate()).after(date);
                boolean recordNowIsEffect = !DateTimeUtils.getDayEndTime((Date)creditRecordBatchSaveReqDto.getEndDate()).before(date) && !DateTimeUtils.getDayStartTime((Date)creditRecordBatchSaveReqDto.getStartDate()).after(date);
                this.logger.info("\u5224\u65ad\u8bb0\u5f55\u5bf9\u8d26\u53f7\u7684\u989d\u5ea6\u5f71\u54cd,\u8c03\u6574\u989d\u5ea6[{}],\u4e0b\u53d1\u8bb0\u5f55\u4e4b\u524d\u6709\u6548\u6027[{}],\u5f53\u524d\u4e4b\u540e\u6709\u6548\u6027[{}]", new Object[]{creditRecordBatchSaveReqDto.getAccountQuota(), recordBeforeIsEffect, recordNowIsEffect});
                if (recordBeforeIsEffect != recordNowIsEffect && !recordBeforeIsEffect) {
                    this.logger.info("\u901a\u8fc7\u8c03\u6574\u6709\u6548\u671f\u9700\u8981\u52a0\u989d\u5ea6,\u4e0a\u6b21\u4e0b\u53d1\u91d1\u989d[{}]", (Object)creditRecordEo.getGrantQuota());
                    creditUsageRecordType = QuotaTypeEnum.NORMAL.getCode().equals(creditRecordEo.getQuotaType()) ? CreditUsageRecordType.RULE_QUOTA : CreditUsageRecordType.TEMP_QUOTA;
                    creditRecordBatchSaveReqDto.setEffectAccountQuota(creditRecordBatchSaveReqDto.getAccountQuota() != null ? creditRecordBatchSaveReqDto.getAccountQuota() : creditRecordEo.getGrantQuota());
                }
                if (recordBeforeIsEffect != recordNowIsEffect && recordBeforeIsEffect) {
                    this.logger.info("\u901a\u8fc7\u8c03\u6574\u6709\u6548\u671f\u9700\u8981\u51cf\u989d\u5ea6,\u4e0a\u6b21\u4e0b\u53d1\u91d1\u989d[{}]", (Object)creditRecordEo.getGrantQuota());
                    creditUsageRecordType = QuotaTypeEnum.NORMAL.getCode().equals(creditRecordEo.getQuotaType()) ? CreditUsageRecordType.RULE_QUOTA_LOSE : CreditUsageRecordType.TEMP_QUOTA_LOSE;
                    creditRecordBatchSaveReqDto.setEffectAccountQuota(BigDecimal.ZERO.subtract(creditRecordEo.getGrantQuota()));
                }
                if (recordNowIsEffect && recordBeforeIsEffect) {
                    BigDecimal newAmount = creditRecordBatchSaveReqDto.getAccountQuota() != null ? creditRecordBatchSaveReqDto.getAccountQuota() : creditRecordEo.getGrantQuota();
                    BigDecimal lastAmount = creditRecordEo.getGrantQuota() != null ? creditRecordEo.getGrantQuota() : BigDecimal.ZERO;
                    this.logger.info("\u76f4\u63a5\u53d8\u52a8\u989d\u5ea6\u989d\u5ea6,\u524d\u7aef\u53d8\u52a8\u91d1\u989d[{}],\u4e0a\u6b21\u4e0b\u53d1\u91d1\u989d[{}]", (Object)newAmount, (Object)lastAmount);
                    boolean isAdd = newAmount.subtract(lastAmount).compareTo(BigDecimal.ZERO) > 0;
                    this.logger.info("\u662f\u5426\u65b0\u589e\u989d\u5ea6[{}]", (Object)isAdd);
                    creditUsageRecordType = isAdd ? (QuotaTypeEnum.NORMAL.getCode().equals(creditRecordEo.getQuotaType()) ? CreditUsageRecordType.RULE_QUOTA : CreditUsageRecordType.TEMP_QUOTA) : (QuotaTypeEnum.NORMAL.getCode().equals(creditRecordEo.getQuotaType()) ? CreditUsageRecordType.RULE_QUOTA_LOSE : CreditUsageRecordType.TEMP_QUOTA_LOSE);
                    creditRecordBatchSaveReqDto.setEffectAccountQuota(newAmount.subtract(lastAmount));
                    this.logger.info("\u6700\u7ec8\u53d8\u52a8\u91d1\u989d[{}]", (Object)newAmount.subtract(lastAmount));
                }
            }
            if (creditRecordBatchSaveReqDto.getEffectAccountQuota() != null && creditRecordBatchSaveReqDto.getEffectAccountQuota().compareTo(BigDecimal.ZERO) != 0) {
                CreditAccountUpdateQuotaReqDto creditAccountUpdateQuotaReqDto = new CreditAccountUpdateQuotaReqDto();
                creditAccountUpdateQuotaReqDto.setCreditAccountId(creditRecordBatchSaveReqDto.getCreditAccountId());
                creditAccountUpdateQuotaReqDto.setGrantQuota(creditRecordBatchSaveReqDto.getEffectAccountQuota());
                creditAccountUpdateQuotaReqDto.setCreditEntityId(creditRecordBatchSaveReqDto.getCreditEntityId());
                creditAccountUpdateQuotaReqDto.setFormCode(creditRecordBatchSaveReqDto.getCreditRecordCode());
                creditAccountUpdateQuotaReqDto.setRemark(creditUsageRecordType.getDesc());
                creditAccountUpdateQuotaReqDto.setCreditAccountUpdateTypeEnum(BigDecimal.ZERO.compareTo(creditRecordBatchSaveReqDto.getEffectAccountQuota()) > 0 ? CreditAccountUpdateTypeEnum.SUB : CreditAccountUpdateTypeEnum.ADD);
                this.iCreditAccountService.useAndReleaseQuota(creditAccountUpdateQuotaReqDto);
            }
            this.logger.info("\u76f4\u63a5\u53d8\u52a8\u989d\u5ea6\u989d\u5ea6,\u4e0b\u53d1\u8bb0\u5f55id[{}],\u53d8\u52a8\u540e\u91d1\u989d[{}]", (Object)creditRecordBatchSaveReqDto.getId(), (Object)creditRecordBatchSaveReqDto.getAccountQuota());
            if (creditRecordBatchSaveReqDto.getCreditAccountStatus() == null) continue;
            CreditAccountEo newCreditAccountEo = new CreditAccountEo();
            newCreditAccountEo.setId(creditRecordBatchSaveReqDto.getCreditAccountId());
            newCreditAccountEo.setCreditAccountStatus(creditRecordBatchSaveReqDto.getCreditAccountStatus());
            this.logger.info("\u8c03\u6574\u8d26\u53f7\u72b6\u6001,\u8d26\u53f7ID[{}],\u53d8\u52a8\u540e\u72b6\u6001[{}]", (Object)creditRecordBatchSaveReqDto.getId(), (Object)creditRecordBatchSaveReqDto.getCreditAccountStatus());
            this.creditAccountDas.updateSelective((BaseEo)newCreditAccountEo);
        }
        List supplierReturnSaveList = supplierReturnList.stream().filter(data -> data.getId() == null).map(this::buildAddCreditRecordEo).collect(Collectors.toList());
        this.creditRecordDas.insertBatch(supplierReturnSaveList);
        List supplierReturnUpdateList = supplierReturnList.stream().filter(data -> data.getId() != null).map(this::buildUpdateCreditRecordEo).collect(Collectors.toList());
        for (CreditRecordEo creditRecordEo : supplierReturnUpdateList) {
            this.creditRecordDas.updateSelective((BaseEo)creditRecordEo);
        }
    }

    @Override
    public PageInfo<CreditRecordPageRespDto> pageCreditRecord(CreditRecordSearchReqDto creditRecordSearchReqDto, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List creditEntityEos = this.creditRecordDas.pageCreditRecord(creditRecordSearchReqDto);
        List supplierReturnList = creditEntityEos.stream().map(this::buildCreditRecordPageRespDto).collect(Collectors.toList());
        return new PageInfo(supplierReturnList);
    }

    @Override
    @Transactional
    public void dealQuotaOver(CreditRecordReqDto creditRecordReqDto) {
        boolean filter2;
        Date date = new Date();
        CreditRecordEo selectItemCreditRecord = new CreditRecordEo();
        selectItemCreditRecord.setId(creditRecordReqDto.getId());
        CreditRecordEo creditRecordEo = (CreditRecordEo)this.creditRecordDas.selectOne((BaseEo)selectItemCreditRecord);
        boolean filter1 = creditRecordEo.getCreditRecordStatus().equals(CreditRecordStatusEnum.GOOD.getCode()) && creditRecordEo.getEndDate().before(date);
        boolean bl = filter2 = creditRecordEo.getCreditRecordStatus().equals(CreditRecordStatusEnum.NOT_EFFECT.getCode()) && creditRecordEo.getStartDate().before(date);
        if (!filter1 && !filter2) {
            return;
        }
        Date endDate = DateTimeUtils.getDayEndTime((Date)creditRecordReqDto.getEndDate());
        CreditAccountUpdateQuotaReqDto creditAccountUpdateQuotaReqDto = new CreditAccountUpdateQuotaReqDto();
        creditAccountUpdateQuotaReqDto.setCreditAccountId(creditRecordReqDto.getCreditAccountId());
        creditAccountUpdateQuotaReqDto.setFormCode(creditRecordReqDto.getCreditRecordCode());
        creditAccountUpdateQuotaReqDto.setGrantQuota(creditRecordReqDto.getGrantQuota());
        creditAccountUpdateQuotaReqDto.setCreditEntityId(creditRecordReqDto.getCreditEntityId());
        creditAccountUpdateQuotaReqDto.setRemark(creditRecordReqDto.getRemark());
        if (endDate.before(date) && creditRecordReqDto.getCreditRecordStatus().equals(CreditRecordStatusEnum.GOOD.getCode())) {
            creditAccountUpdateQuotaReqDto.setCreditAccountUpdateTypeEnum(CreditAccountUpdateTypeEnum.NOT_EFFECT);
            creditAccountUpdateQuotaReqDto.setRemark(creditRecordReqDto.getQuotaType() != null && creditRecordReqDto.getQuotaType() == 1 ? CreditUsageRecordType.TEMP_QUOTA_LOSE.getDesc() : CreditUsageRecordType.RULE_QUOTA_LOSE.getDesc());
            creditAccountUpdateQuotaReqDto.setFormCode(creditRecordReqDto.getCreditRecordCode());
            this.logger.info("\u989d\u5ea6\u8fc7\u671f,data----:" + JSONObject.toJSONString((Object)creditAccountUpdateQuotaReqDto));
            this.iCreditAccountService.useAndReleaseQuota(creditAccountUpdateQuotaReqDto);
            selectItemCreditRecord.setCreditRecordStatus(CreditRecordStatusEnum.OVER_DUE.getCode());
        }
        if (creditRecordReqDto.getStartDate().before(date) && creditRecordReqDto.getCreditRecordStatus().equals(CreditRecordStatusEnum.NOT_EFFECT.getCode())) {
            creditAccountUpdateQuotaReqDto.setCreditAccountUpdateTypeEnum(CreditAccountUpdateTypeEnum.ADD);
            creditAccountUpdateQuotaReqDto.setRemark(creditRecordReqDto.getQuotaType() != null && creditRecordReqDto.getQuotaType() == 1 ? CreditUsageRecordType.TEMP_QUOTA.getDesc() : CreditUsageRecordType.RULE_QUOTA.getDesc());
            creditAccountUpdateQuotaReqDto.setFormCode(creditRecordReqDto.getCreditRecordCode());
            this.logger.info("\u989d\u5ea6\u751f\u6548,data----:" + JSONObject.toJSONString((Object)creditAccountUpdateQuotaReqDto));
            this.iCreditAccountService.useAndReleaseQuota(creditAccountUpdateQuotaReqDto);
            selectItemCreditRecord.setCreditRecordStatus(CreditRecordStatusEnum.GOOD.getCode());
        }
        this.creditRecordDas.updateSelective((BaseEo)selectItemCreditRecord);
    }

    private CreditRecordPageRespDto buildCreditRecordPageRespDto(CreditRecordEo creditRecordEo) {
        CreditRecordPageRespDto creditRecordPageRespDto = new CreditRecordPageRespDto();
        DtoHelper.eo2Dto((BaseEo)creditRecordEo, (BaseVo)creditRecordPageRespDto);
        return creditRecordPageRespDto;
    }

    private CreditRecordBatchSaveReqDto buildCreditRecordBatchSaveReqDto(CreditRecordBatchSaveReqDto creditRecordBatchSaveReqDto, Date date) {
        return creditRecordBatchSaveReqDto;
    }

    private CreditRecordEo buildAddCreditRecordEo(CreditRecordBatchSaveReqDto creditRecordSaveReqDto) {
        Date now = new Date();
        CreditRecordEo creditRecordEo = new CreditRecordEo();
        DtoHelper.dto2Eo((BaseVo)creditRecordSaveReqDto, (BaseEo)creditRecordEo);
        Assert.isTrue((creditRecordSaveReqDto.getCreditAccountId() != null ? 1 : 0) != 0, (String)"\u4fe1\u7528\u8d26\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((creditRecordSaveReqDto.getQuotaType() != null ? 1 : 0) != 0, (String)"quotaType\u4e0d\u80fd\u4e3a\u7a7a");
        if (DateTimeUtils.checkIsEffect((Date)creditRecordSaveReqDto.getStartDate(), (Date)creditRecordSaveReqDto.getEndDate())) {
            creditRecordEo.setCreditRecordStatus(CreditRecordStatusEnum.GOOD.getCode());
        }
        if (DateTimeUtils.getDayEndTime((Date)creditRecordSaveReqDto.getEndDate()).before(now)) {
            creditRecordEo.setCreditRecordStatus(CreditRecordStatusEnum.OVER_DUE.getCode());
        }
        if (creditRecordSaveReqDto.getStartDate().after(now)) {
            creditRecordEo.setCreditRecordStatus(CreditRecordStatusEnum.NOT_EFFECT.getCode());
        }
        creditRecordEo.setCreditRecordCode(CreditNoUtil.generateTradeNo((String)CreditApplyTypeEnum.toName((Integer)creditRecordSaveReqDto.getApplyType())));
        creditRecordEo.setGrantQuota(creditRecordSaveReqDto.getAccountQuota());
        creditRecordEo.setApplyQuota(creditRecordSaveReqDto.getAccountQuota());
        creditRecordEo.setCreditApplyId(creditRecordSaveReqDto.getApplyId());
        creditRecordEo.setRemark(creditRecordSaveReqDto.getRemark());
        creditRecordSaveReqDto.setCreditRecordCode(creditRecordEo.getCreditRecordCode());
        return creditRecordEo;
    }

    private CreditRecordEo buildUpdateCreditRecordEo(CreditRecordBatchSaveReqDto creditRecordSaveReqDto) {
        Date date = new Date();
        CreditRecordEo creditRecordEo = new CreditRecordEo();
        creditRecordEo.setId(creditRecordSaveReqDto.getId());
        CreditRecordEo creditRecordEo1 = (CreditRecordEo)this.creditRecordDas.selectOne((BaseEo)creditRecordEo);
        creditRecordSaveReqDto.setCreditRecordCode(creditRecordEo1.getCreditRecordCode());
        creditRecordEo.setRemark(creditRecordSaveReqDto.getRemark());
        creditRecordEo.setStartDate(creditRecordSaveReqDto.getStartDate());
        creditRecordEo.setEndDate(DateTimeUtils.getDayEndTime((Date)creditRecordSaveReqDto.getEndDate()));
        creditRecordEo.setCreditRecordStatus(CreditRecordStatusEnum.GOOD.getCode());
        if (DateTimeUtils.getDayEndTime((Date)creditRecordEo.getEndDate()).before(date)) {
            creditRecordEo.setCreditRecordStatus(CreditRecordStatusEnum.OVER_DUE.getCode());
        }
        if (creditRecordEo.getStartDate().after(date)) {
            creditRecordEo.setCreditRecordStatus(CreditRecordStatusEnum.NOT_EFFECT.getCode());
        }
        creditRecordEo.setGrantQuota(creditRecordSaveReqDto.getAccountQuota());
        return creditRecordEo;
    }

    @Override
    @Transactional
    public List<CreditAccountRecordUseDetailRespDto> updateCreditRecordUseQuota(BigDecimal quota, Long creditAccountId) {
        ArrayList<CreditAccountRecordUseDetailRespDto> list = new ArrayList<CreditAccountRecordUseDetailRespDto>();
        List<CreditAccountRecordUseDetailRespDto> effectRecordsToFitUseQuota = this.findEffectRecordsToFitUseQuota(quota, creditAccountId);
        for (CreditAccountRecordUseDetailRespDto recordUseDetail : effectRecordsToFitUseQuota) {
            CreditAccountRecordUseDetailRespDto creditAccountRecordUseDetailRespDto = new CreditAccountRecordUseDetailRespDto();
            creditAccountRecordUseDetailRespDto.setCreditAccountId(creditAccountId);
            creditAccountRecordUseDetailRespDto.setCreditRecordId(recordUseDetail.getCreditRecordId());
            creditAccountRecordUseDetailRespDto.setAccountUsedQuota(recordUseDetail.getAccountUsedQuota());
            creditAccountRecordUseDetailRespDto.setThisUserQuota(recordUseDetail.getThisUserQuota());
            list.add(creditAccountRecordUseDetailRespDto);
            this.creditRecordDas.addRecordQuota(recordUseDetail.getCreditRecordId(), recordUseDetail.getThisUserQuota());
        }
        return list;
    }

    @Override
    public List<CreditAccountRecordUseDetailRespDto> findEffectRecordsToFitUseQuota(BigDecimal quota, Long creditAccountId) {
        ArrayList<CreditAccountRecordUseDetailRespDto> list = new ArrayList<CreditAccountRecordUseDetailRespDto>();
        List creditRecordEos = this.creditRecordDas.findEffectRecordByAccount(creditAccountId);
        if (StringUtils.isEmpty((Object)creditRecordEos)) {
            this.logger.info("\u627e\u4e0d\u5230\u8d26\u53f7\u7684\u6388\u4fe1\u8bb0\u5f55:creditAccountId" + creditAccountId);
        }
        BigDecimal totalAmount = quota;
        for (int i = 0; i < creditRecordEos.size(); ++i) {
            CreditRecordEo creditRecordEo = (CreditRecordEo)creditRecordEos.get(i);
            BigDecimal accountUsedQuota = creditRecordEo.getAccountUsedQuota() == null ? BigDecimal.ZERO : creditRecordEo.getAccountUsedQuota();
            BigDecimal canUseQuota = creditRecordEo.getGrantQuota().subtract(accountUsedQuota);
            CreditAccountRecordUseDetailRespDto creditAccountRecordUseDetailRespDto = new CreditAccountRecordUseDetailRespDto();
            if (canUseQuota.compareTo(BigDecimal.ZERO) >= 0) {
                BigDecimal firstCanUserAmount = totalAmount.min(canUseQuota);
                creditAccountRecordUseDetailRespDto.setThisUserQuota(firstCanUserAmount);
                creditAccountRecordUseDetailRespDto.setCreditAccountId(creditRecordEo.getCreditAccountId());
                creditAccountRecordUseDetailRespDto.setCreditRecordId(creditRecordEo.getId());
                creditAccountRecordUseDetailRespDto.setAccountUsedQuota(accountUsedQuota);
                list.add(creditAccountRecordUseDetailRespDto);
                totalAmount = totalAmount.subtract(firstCanUserAmount);
            }
            if (i == creditRecordEos.size() - 1 && totalAmount.compareTo(BigDecimal.ZERO) >= 0) {
                BigDecimal secondCanUserAmount = totalAmount;
                creditAccountRecordUseDetailRespDto.setThisUserQuota(creditAccountRecordUseDetailRespDto.getThisUserQuota().add(secondCanUserAmount));
                totalAmount = totalAmount.subtract(secondCanUserAmount);
            }
            if (totalAmount.compareTo(BigDecimal.ZERO) <= 0) break;
        }
        return list;
    }
}

