/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.credit.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PolicyReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PolicyRuleReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.PolicySearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.PolicyInfoRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.PolicyRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.ConfigType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.GeneralRuleCodeType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.OrderNodeEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.OverdueAmountType;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.PolicyType;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.IPolicyService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.GenerateCode;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.untils.HelperUtils;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditAccountDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditNodeDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.CreditOrderBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.PolicyDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.PolicyRuleDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditNodeEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.PolicyEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.PolicyRuleEo;
import com.dtyunxi.yundt.cube.center.credit.dao.stdeo.credit.StdPolicyRuleEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="policy")
public class PolicyServiceImpl
implements IPolicyService {
    @Resource
    private IContext iContext;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private CreditOrderBillDas creditOrderBillDas;
    @Resource
    private PolicyDas policyDas;
    @Resource
    private ICustomerExtQueryApi iCustomerExtQueryApi;
    @Resource
    private GenerateCode generateCode;
    @Resource
    private CreditNodeDas creditNodeDas;
    @Resource
    private PolicyRuleDas policyRuleDas;
    @Resource
    private CreditAccountDas creditAccountDas;
    @Resource
    private HelperUtils helperUtils;
    @Resource
    private ICreditAccountService creditAccountService;

    @Transactional(rollbackFor={Exception.class})
    public Long add(PolicyReqDto dto) {
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        this.validPolicy(dto);
        PolicyEo policyEo = new PolicyEo();
        policyEo.setOrgInfoId(orgId);
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)policyEo);
        if (null == policyEo.getId()) {
            String code = StringUtils.isNotEmpty((CharSequence)dto.getCode()) ? dto.getCode() : this.generateCode.createCode(PolicyType.LIMIT.getType().equals(dto.getType()) ? GeneralRuleCodeType.LIMIT : GeneralRuleCodeType.OVERDUE);
            policyEo.setCode(code);
            policyEo.setOrgInfoId(orgId);
            this.policyDas.insert((BaseEo)policyEo);
        } else {
            this.policyDas.updateSelective((BaseEo)policyEo);
        }
        List ruleEoList = dto.getPolicyRuleReqDtoList().stream().map(obj -> {
            PolicyRuleEo policyRuleEo = new PolicyRuleEo();
            DtoHelper.dto2Eo((BaseVo)obj, (BaseEo)policyRuleEo, (String[])new String[]{"id"});
            if (OrderNodeEnum.getType((String)obj.getCreditNode()) == null) {
                throw new BizException("\u7f16\u7801\u9519\u8befcreditNode:" + obj.getCreditNode());
            }
            policyRuleEo.setOrgInfoId(orgId);
            policyRuleEo.setPolicyId(policyEo.getId());
            return policyRuleEo;
        }).collect(Collectors.toList());
        this.policyRuleDas.insertBatch(ruleEoList);
        return policyEo.getId();
    }

    private void validPolicy(PolicyReqDto dto) {
        PolicyType type = PolicyType.getType((Integer)dto.getType());
        if (null == type) {
            throw new BizException("\u7b56\u7565\u6307\u5b9a\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        Boolean aBoolean = this.policyDas.queryByNameId(dto.getId(), dto.getName(), dto.getType());
        if (!aBoolean.booleanValue()) {
            throw new BizException("\u7b56\u7565\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        switch (type) {
            case OVERDUE: {
                this.logger.info("--\u65b0\u5efa\u7b56\u7565\uff0c\u3010\u903e\u671f\u6821\u9a8c\u3011");
                if (null == dto.getOverdueDaysLimit()) {
                    throw new BizException("\u903e\u671f\u5929\u6570\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a");
                }
                OverdueAmountType overdueAmountType = OverdueAmountType.getType((Integer)dto.getOverdueAmountType());
                if (null == overdueAmountType) {
                    throw new BizException("\u903e\u671f\u9644\u52a0\u6761\u4ef6\u7c7b\u578b\u4e0d\u5b58\u5728");
                }
                switch (overdueAmountType) {
                    case AMOUNT_TYPE: {
                        if (null != dto.getOverdueAmountDays() && null != dto.getOverdueAmount()) break;
                        throw new BizException("\u903e\u671f\u5929\u6570\u548c\u5e94\u6536\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    case RATE_TYPE: {
                        if (null != dto.getOverdueAmountDays() && null != dto.getOverdueAmountRate()) break;
                        throw new BizException("\u903e\u671f\u5929\u6570\u548c\u903e\u671f\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                break;
            }
            case LIMIT: {
                this.logger.info("--\u65b0\u5efa\u7b56\u7565\uff0c\u3010\u989d\u5ea6\u6821\u9a8c\u3011");
                break;
            }
            default: {
                this.logger.info("--\u65b0\u5efa\u7b56\u7565\uff0c\u72b6\u6001\u4e0d\u9700\u5904\u7406");
            }
        }
        List nodeIds = dto.getPolicyRuleReqDtoList().stream().map(PolicyRuleReqDto::getCreditNodeId).collect(Collectors.toList());
        List nodeEoList = this.creditNodeDas.queryNodeListByIds(nodeIds);
        if (nodeIds.size() != nodeEoList.size()) {
            throw new BizException("\u4fe1\u63a7\u65f6\u70b9\u9009\u62e9\u9700\u552f\u4e00\u4e14\u5b58\u5728");
        }
    }

    public void enable(Long id) {
    }

    public void disable(Long id) {
    }

    public void delete(Long id) {
        PolicyEo policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(id);
        if (null == policyEo) {
            throw new BizException("\u7b56\u7565\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25");
        }
        ConfigType type = PolicyType.LIMIT.getType().equals(policyEo.getType()) ? ConfigType.LIMIT : ConfigType.OVERDUE;
        Map accountNumMap = this.creditAccountDas.queryConfigAccountNum(Collections.singletonList(id), type);
        if (!accountNumMap.isEmpty()) {
            throw new BizException("\u7b56\u7565\u5df2\u88ab\u4fe1\u7528\u8d26\u6237\u7ed1\u5b9a\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.policyDas.logicDeleteById(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void edit(Long id, PolicyReqDto dto) {
        PolicyEo policyEo;
        PolicyRuleEo policyRuleEo;
        if (id != null) {
            PolicyEo newDim = (PolicyEo)this.policyDas.selectByPrimaryKey(id);
            Assert.notNull((Object)newDim, (String)("id: " + id));
            newDim.setId(null);
            newDim.setIsBackup(Integer.valueOf(1));
            newDim.setSourceId(id);
            this.policyDas.insert((BaseEo)newDim);
            policyRuleEo = new PolicyRuleEo();
            policyRuleEo.setPolicyId(id);
            List refCreditDimPropEos = this.policyRuleDas.selectList((BaseEo)policyRuleEo);
            for (PolicyRuleEo refCreditDimPropEo : refCreditDimPropEos) {
                refCreditDimPropEo.setId(null);
                refCreditDimPropEo.setPolicyId(newDim.getId());
            }
            this.policyRuleDas.insertBatch(refCreditDimPropEos);
            this.creditOrderBillDas.updatePointValue(dto.getType() == 2 ? "overdue_strategy_id" : "quota_strategy_id", newDim.getId(), id);
        }
        if (null == (policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(id))) {
            throw new BizException("\u7b56\u7565\u4e0d\u5b58\u5728\uff0c\u7f16\u8f91\u5931\u8d25");
        }
        policyRuleEo = new PolicyRuleEo();
        policyRuleEo.setPolicyId(id);
        this.policyRuleDas.logicDelete((BaseEo)policyRuleEo);
        dto.setId(policyEo.getId());
        dto.setCode(policyEo.getCode());
        this.add(dto);
    }

    public PageInfo<PolicyRespDto> queryPage(PolicySearchReqDto searchReqDto) {
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        PageInfo pageInfo = new PageInfo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.isNull((String)"is_backup"));
        PolicyEo policyEo = new PolicyEo();
        if (null != searchReqDto.getCreditNodeId()) {
            PolicyRuleEo policyRuleEo = new PolicyRuleEo();
            policyRuleEo.setCreditNodeId(searchReqDto.getCreditNodeId());
            policyRuleEo.setOrgInfoId(orgId);
            List ruleEoList = this.policyRuleDas.select((BaseEo)policyRuleEo);
            if (CollectionUtils.isEmpty((Collection)ruleEoList)) {
                return pageInfo;
            }
            List policyId = ruleEoList.stream().map(StdPolicyRuleEo::getPolicyId).collect(Collectors.toList());
            sqlFilterList.add(SqlFilter.in((String)"id", policyId));
        }
        this.helperUtils.setBaseSearch(searchReqDto, searchReqDto.getName(), searchReqDto.getCreateTimeStart(), searchReqDto.getCreateTimeEnd(), sqlFilterList, policyEo);
        PageHelper.startPage((int)searchReqDto.getPageNum(), (int)searchReqDto.getPageSize());
        policyEo.setOrgInfoId(orgId);
        PageInfo select = new PageInfo(this.policyDas.select((BaseEo)policyEo));
        this.joinList(searchReqDto, (PageInfo<PolicyRespDto>)pageInfo, (PageInfo<PolicyEo>)select);
        return pageInfo;
    }

    private void joinList(PolicySearchReqDto searchReqDto, PageInfo<PolicyRespDto> pageInfo, PageInfo<PolicyEo> select) {
        if (CollectionUtils.isNotEmpty((Collection)select.getList())) {
            ArrayList list = Lists.newArrayList();
            BeanUtils.copyProperties(select, pageInfo, (String[])new String[]{"list"});
            CubeBeanUtils.copyCollection((Collection)list, (Collection)select.getList(), PolicyRespDto.class);
            List ids = select.getList().stream().map(BaseEo::getId).collect(Collectors.toList());
            PolicyRuleEo policyRuleEo = new PolicyRuleEo();
            policyRuleEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"policy_id", ids)));
            List ruleEoList = this.policyRuleDas.select((BaseEo)policyRuleEo);
            HashMap<Long, String> nameMap = new HashMap<Long, String>(ruleEoList.size());
            List creditNodeIds = ruleEoList.stream().map(StdPolicyRuleEo::getCreditNodeId).collect(Collectors.toList());
            Map creditNameCode = this.creditNodeDas.findCreditNameCode(creditNodeIds);
            for (PolicyRuleEo ruleEo : ruleEoList) {
                String creditRecordName;
                String creditNodes = (String)nameMap.get(ruleEo.getPolicyId());
                String string = creditRecordName = CollectionUtils.isEmpty((Collection)((Collection)creditNameCode.get(ruleEo.getCreditNodeId()))) ? "" : ((CreditNodeEo)((List)creditNameCode.get(ruleEo.getCreditNodeId())).get(0)).getName();
                if (StringUtils.isEmpty((CharSequence)creditNodes)) {
                    nameMap.put(ruleEo.getPolicyId(), creditRecordName + "");
                    continue;
                }
                nameMap.put(ruleEo.getPolicyId(), creditNodes + "," + creditRecordName);
            }
            ConfigType type = PolicyType.LIMIT.getType().equals(searchReqDto.getType()) ? ConfigType.LIMIT : ConfigType.OVERDUE;
            Map accountNumMap = this.creditAccountDas.queryConfigAccountNum(ids, type);
            for (PolicyRespDto policyRespDto : list) {
                policyRespDto.setCreditNodes((String)nameMap.get(policyRespDto.getId()));
                if (!accountNumMap.containsKey(policyRespDto.getId())) continue;
                policyRespDto.setAccountNum((Integer)accountNumMap.get(policyRespDto.getId()));
            }
            pageInfo.setList((List)list);
        }
    }

    public PolicyInfoRespDto getDetail(Long id) {
        PolicyEo policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(id);
        if (null == policyEo || null == policyEo.getId()) {
            throw new BizException("\u7b56\u7565\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u5931\u8d25");
        }
        PolicyRuleEo policyRuleEo = new PolicyRuleEo();
        policyRuleEo.setPolicyId(id);
        policyRuleEo.setOrderBy("sort");
        List ruleEoList = this.policyRuleDas.select((BaseEo)policyRuleEo);
        if (CollectionUtils.isEmpty((Collection)ruleEoList)) {
            throw new BizException("\u7b56\u7565\u89c4\u5219\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u5931\u8d25");
        }
        PolicyInfoRespDto dto = new PolicyInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)policyEo, (BaseVo)dto);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)ruleEoList, PolicyRuleReqDto.class);
        List creditNodeIds = ruleEoList.stream().map(StdPolicyRuleEo::getCreditNodeId).collect(Collectors.toList());
        Map creditNameCode = this.creditNodeDas.findCreditNameCode(creditNodeIds);
        for (PolicyRuleReqDto ruleEo : list) {
            String creditRecordCode = CollectionUtils.isEmpty((Collection)((Collection)creditNameCode.get(ruleEo.getCreditNodeId()))) ? "" : ((CreditNodeEo)((List)creditNameCode.get(ruleEo.getCreditNodeId())).get(0)).getCode();
            String creditRecordName = CollectionUtils.isEmpty((Collection)((Collection)creditNameCode.get(ruleEo.getCreditNodeId()))) ? "" : ((CreditNodeEo)((List)creditNameCode.get(ruleEo.getCreditNodeId())).get(0)).getName();
            ruleEo.setCreditNode(creditRecordCode);
            ruleEo.setCreditName(creditRecordName);
        }
        dto.setPolicyRuleReqDtoList((List)list);
        return dto;
    }

    @Override
    public PageInfo<PolicyInfoRespDto> queryPageDetail(PolicySearchReqDto searchReqDto) {
        PageInfo pageInfo = new PageInfo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        PolicyEo policyEo = new PolicyEo();
        if (null != searchReqDto.getCreditNodeId()) {
            PolicyRuleEo policyRuleEo = new PolicyRuleEo();
            policyRuleEo.setCreditNodeId(searchReqDto.getCreditNodeId());
            List ruleEoList = this.policyRuleDas.select((BaseEo)policyRuleEo);
            if (CollectionUtils.isEmpty((Collection)ruleEoList)) {
                return pageInfo;
            }
            List policyId = ruleEoList.stream().map(StdPolicyRuleEo::getPolicyId).collect(Collectors.toList());
            sqlFilterList.add(SqlFilter.in((String)"id", policyId));
        }
        this.helperUtils.setBaseSearch(searchReqDto, searchReqDto.getName(), searchReqDto.getCreateTimeStart(), searchReqDto.getCreateTimeEnd(), sqlFilterList, policyEo);
        sqlFilterList.add(SqlFilter.isNull((String)"is_backup"));
        policyEo.setSqlFilters(sqlFilterList);
        SortOrder sortOrder = SortOrder.getSortOrder((String)searchReqDto.getSortType());
        if (SortOrder.ASC.equals((Object)sortOrder)) {
            this.logger.info("\u989d\u5ea6\u6821\u9a8c\u3001\u903e\u671f\u6821\u9a8c\u6309\u65f6\u95f4\u5347\u5e8f\u6392\u5e8f\uff01");
            ArrayList sqlOrderByList = Lists.newArrayList();
            sqlOrderByList.add(new SqlOrderBy("create_time", sortOrder));
            policyEo.setSqlOrderBys((List)sqlOrderByList);
        }
        PageHelper.startPage((int)searchReqDto.getPageNum(), (int)searchReqDto.getPageSize());
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        policyEo.setOrgInfoId(orgId);
        PageInfo select = new PageInfo(this.policyDas.select((BaseEo)policyEo));
        this.joinDetailList((PageInfo<PolicyInfoRespDto>)pageInfo, (PageInfo<PolicyEo>)select);
        return pageInfo;
    }

    private void joinDetailList(PageInfo<PolicyInfoRespDto> pageInfo, PageInfo<PolicyEo> select) {
        if (CollectionUtils.isNotEmpty((Collection)select.getList())) {
            ArrayList list = Lists.newArrayList();
            BeanUtils.copyProperties(select, pageInfo, (String[])new String[]{"list"});
            CubeBeanUtils.copyCollection((Collection)list, (Collection)select.getList(), PolicyInfoRespDto.class);
            List ids = select.getList().stream().map(BaseEo::getId).collect(Collectors.toList());
            List ruleEoList = this.policyRuleDas.queryByPolicyIds(ids);
            HashMap<Long, List> listMap = new HashMap<Long, List>(ruleEoList.size());
            HashMap<Long, String> nameMap = new HashMap<Long, String>(ruleEoList.size());
            List creditNodeIds = ruleEoList.stream().map(StdPolicyRuleEo::getCreditNodeId).collect(Collectors.toList());
            Map creditNameCode = this.creditNodeDas.findCreditNameCode(creditNodeIds);
            for (PolicyRuleEo ruleEo : ruleEoList) {
                String creditRecordName;
                String creditNodes = (String)nameMap.get(ruleEo.getPolicyId());
                List ruleReqDtoList = (List)listMap.get(ruleEo.getPolicyId());
                String string = creditRecordName = CollectionUtils.isEmpty((Collection)((Collection)creditNameCode.get(ruleEo.getCreditNodeId()))) ? "" : ((CreditNodeEo)((List)creditNameCode.get(ruleEo.getCreditNodeId())).get(0)).getName();
                if (CollectionUtils.isEmpty((Collection)ruleReqDtoList)) {
                    ruleReqDtoList = Lists.newArrayList();
                    nameMap.put(ruleEo.getPolicyId(), ruleEo.getCreditNode() + ":" + CreditType.getType((Integer)ruleEo.getCreditType()));
                } else {
                    nameMap.put(ruleEo.getPolicyId(), creditNodes + ";\n" + ruleEo.getCreditNode() + ":" + CreditType.getType((Integer)ruleEo.getCreditType()));
                }
                PolicyRuleReqDto policyRuleReqDto = new PolicyRuleReqDto();
                DtoHelper.eo2Dto((BaseEo)ruleEo, (BaseVo)policyRuleReqDto);
                policyRuleReqDto.setCreditNode(creditRecordName);
                ruleReqDtoList.add(policyRuleReqDto);
                listMap.put(ruleEo.getPolicyId(), ruleReqDtoList);
            }
            for (PolicyInfoRespDto policyInfoRespDto : list) {
                policyInfoRespDto.setPolicyRuleReqDtoList((List)listMap.get(policyInfoRespDto.getId()));
                policyInfoRespDto.setCreditNodes((String)nameMap.get(policyInfoRespDto.getId()));
            }
            pageInfo.setList((List)list);
        }
    }
}

