/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.dao.credit.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayPlanSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRepayPlanStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.mapper.CreditRepayPlanMapper;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditRepayPlanEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class CreditRepayPlanDas
extends AbstractBaseDas<CreditRepayPlanEo, String> {
    @Resource
    private CreditRepayPlanMapper creditRepayPlanMapper;

    public BigDecimal countWaitRefundAmount(Long id) {
        CreditRepayPlanEo selectItemCreditRepayPlan = new CreditRepayPlanEo();
        selectItemCreditRepayPlan.setCreditAccountId(id);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.ne((String)"credit_repay_plan_status", (Object)3));
        selectItemCreditRepayPlan.setSqlFilters(sqlFilterList);
        selectItemCreditRepayPlan.setDr(0);
        List creditRepayPlanEos = this.selectList((BaseEo)selectItemCreditRepayPlan);
        if (CollectionUtils.isEmpty((Collection)creditRepayPlanEos)) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalAmount = creditRepayPlanEos.stream().map(item -> item.getOccupyQuota() == null ? BigDecimal.ZERO : item.getOccupyQuota()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal receivedAmount = creditRepayPlanEos.stream().map(item -> item.getReceivedAmount() == null ? BigDecimal.ZERO : item.getReceivedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal subtract = totalAmount.subtract(receivedAmount);
        return subtract;
    }

    public List<CreditRepayPlanEo> searchPage(List<Long> accountIds, CreditRepayPlanSearchReqDto dto, String startTime, String endTime) {
        return this.creditRepayPlanMapper.searchPage(accountIds, dto, startTime, endTime);
    }

    public List<CreditRepayPlanEo> queryNotRefundRecord(Long customerId, String nowTime) {
        List<Integer> status = Arrays.asList(CreditRepayPlanStatusEnum.NOT_RECEIVABLE.getCode(), CreditRepayPlanStatusEnum.PART_RECEIVABLE.getCode());
        return this.creditRepayPlanMapper.queryNotRefundRecord(customerId, status, nowTime);
    }
}

