/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ClueTypeEnum {
    WAREHOUSE("WAREHOUSE", "\u4ed3\u5e93\u5bfb\u6e90"),
    REQUISITION("REQUISITION", "\u95e8\u5e97\u8981\u8d27\u5bfb\u6e90"),
    SHIPMENT("SHIPMENT", "\u7269\u6d41\u5bfb\u6e90"),
    INVENTORY_SHIPMENT("INVENTORY_SHIPMENT", "\u4ed3\u5e93\u7269\u6d41\u5bfb\u6e90");

    public final String code;
    public final String desc;
    public static final Map<String, ClueTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private ClueTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ClueTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(ClueTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(ClueTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

